!= Module HeatFlux
!
! Authors::   ODAKA Masatsugu 
! Version::   $Id: surfaceflux_bulk.f90,v 1.8 2011-06-17 19:07:27 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! Υեåˤ벹٤ȶŷʬѲΨХ륯ˡ
! ŤƷ׻⥸塼.  (1994) Ѥ줿ˡǤ.
!
! Ǯեå Fh ȶŷʪΥեå Fq Ȥ, ٤ȶŷʪ
! ѲΨ H, Q 
!
!   H = Fh/z_1  
!   Q = Fq/z_1  
!
! ɽ.  z_1 ϺǲؤγʻҴֳ֤Ǥ.  
!
! Ǯեå Fh ȶŷʪΥեå Fq ϰʲμˤä
! ׻.
!
!   Fh = - Cd|V| * (_1_1 - T_sfc)
!   Fh = - Cd|V| * (Q_1 - Q*(T_sfc))
!
!  _1, Q_1, _1 Ϻǲؤβ٤ȶŷʪκ椪̵
! ϴؿ, T_sfc ϲβ, Q*(T_sfc)  T_sfc Ƿޤ˰º
! Ǥ. 
!
! Х륯 Cd ϰȤ. ̵ϴؿ _1 ϴܾͤѤ.
! ® |V| 
!
!   V = ( V^2 + V_0^2 )^(1/2)
!
! ȷ׻. 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module Surfaceflux_bulk
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use gridset,  only: imin,         & !x β
    &                 imax,         & !x ξ
    &                 jmin,         & !y β
    &                 jmax,         & !y ξ
    &                 kmin,         & !z β
    &                 kmax,         & !z ξ
    &                 nx, ny, nz, ncmax
  use axesset, only:  z_dz,         & !z γʻֳ
    &                 xyz_avr_pyz,  &
    &                 xyz_avr_xqz
  use basicset, only: xyz_ExnerBZ,  & !ʡؿδܾ
    &                 xyz_PressBZ,  & !
    &                 xyz_PTempBZ,  & !̤δܾ
    &                 xyz_TempBZ,   & !
    &                 xyzf_QMixBZ     !̤δܾ
  use constants,only: MolWtDry
  use composition,only : IdxCC, IdxCG, SpcWetID, CondNum, MolWtWet, SpcWetSymbol
  use chemcalc,only : SvapPress
  use namelist_util, only: namelist_filename
  use timeset, only:  TimeN


  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public surfaceflux_bulk_init
  public surfaceflux_bulk_forcing

  !ѿ
  real(DP), save  :: Bulk = 1.5d-3    !Ǯư̥եåΥХ륯
  real(DP), save  :: VelX0 = 0.0d0    !ؤǤοʿ®ٿ夲
  real(DP), save  :: VelY0 = 0.0d0    !ؤǤοʿ®ٿ夲


contains
!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Bulk_init
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer    :: l, unit

    !---------------------------------------------------------------    
    ! NAMELIST 
    !
    NAMELIST /surfaceflux_bulk_nml/ Bulk, VelX0, VelY0
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=surfaceflux_bulk_nml)
    close(unit)  

    if (myrank == 0) then 
      call MessageNotify( "M", "SurfaceSfc", "Bulk = %f", d=(/Bulk/))
      call MessageNotify( "M", "SurfaceSfc", "VelX0 = %f", d=(/VelX0/))
      call MessageNotify( "M", "SurfaceSfc", "VelY0 = %f", d=(/VelY0/))
    end if

    call HistoryAutoAddVariable(  &
      & varname='PTempSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='surface flux of potential temperature', &
      & units='kg.kg-1.s-1',            &
      & xtype='double')

    call HistoryAutoAddVariable(  &
      & varname='VelXSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='flux of heating from surface', &
      & units='kg.m.s-1',            &
      & xtype='double')

    call HistoryAutoAddVariable(  &
      & varname='VelYSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='flux of momentum from surface', &
      & units='kg.m.s-1',            &
      & xtype='double')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Sfc', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Surface Flux term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double')
    end do

  end subroutine Surfaceflux_Bulk_init


!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Bulk_forcing( &
    &   pyz_VelX, xqz_VelY, xyz_PTemp, xyz_Exner, xyzf_QMix, &
    &   pyz_DVelXDt, xqz_DVelYDt, xyz_DPTempDt, xyzf_DQMixDt &
    & )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)   :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
                                           !ʿ®
    real(DP), intent(in)   :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)
                                           !ʿ®
    real(DP), intent(in)   :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
                                           !̤ξʬ    
    real(DP), intent(in)   :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
                                           !̤ξʬ    
    real(DP), intent(in)   :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                           !̤ξʬ    
    real(DP), intent(inout):: pyz_DVelXDt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout):: xqz_DVelYDt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout):: xyz_DPTempDt(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout):: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)               :: pyz_DVelXDt0(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xqz_DVelYDt0(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_DPTempDt0(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyzf_DQMixDt0(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)               :: pyz_Momflux(imin:imax,jmin:jmax,kmin:kmax)
                                           !ư̥եå
    real(DP)               :: xqz_Momflux(imin:imax,jmin:jmax,kmin:kmax)
                                           !ư̥եå
    real(DP)               :: xyz_Heatflux(imin:imax,jmin:jmax,kmin:kmax)
                                           !ɽǮեå
    real(DP)               :: xyzf_QMixflux(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                           !ʪŪեå
    real(DP)               :: pyz_VelXSfc(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xqz_VelYSfc(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyz_VelXSfc(imin:imax,jmin:jmax,kmin:kmax)
                                           !ʿ® (xyz ʻ)
    real(DP)               :: xyz_VelYSfc(imin:imax,jmin:jmax,kmin:kmax)
                                           !ʿ® (xyz ʻ)
    real(DP)               :: TempSfc 
    real(DP)               :: PressSfc 
    real(DP)               :: xyz_VelSfc(imin:imax,jmin:jmax,kmin:kmax)
                                           !ʿ® (xyz ʻ)
    real(DP)               :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)               :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    integer                :: kz            !ź
    integer                :: s             !롼ѿ

    ! 
    !
    kz = 1
    xyz_Heatflux = 0.0d0
    xyzf_QMixflux = 0.0d0
    pyz_Momflux = 0.0d0
    xqz_Momflux = 0.0d0

    pyz_DVelXDt0  = pyz_DVelXDt
    xqz_DVelYDt0  = xqz_DVelYDt
    xyz_DPTempDt0 = xyz_DPTempDt
    xyzf_DQMixDt0 = xyzf_DQMixDt

    xyz_TempAll  = (xyz_Exner + xyz_ExnerBZ) * (xyz_PTemp + xyz_PTempBZ)
    xyzf_QMixAll = xyzf_QMix + xyzf_QMixBZ
    
    pyz_VelXSfc = pyz_VelX + VelX0
    xqz_VelYSfc = xqz_VelY + VelY0    

    ! ɽ̤Ǥ
    ! 
    TempSfc = xyz_TempBZ(1,1,kz)  !ʿͤʤΤ, i=j=1 ɽ
    PressSfc= xyz_PressBZ(1,1,kz) !ʿͤʤΤ, i=j=1 ɽ
    
    !ɽǮեåˤǮΨ׻
    !  * ñ̤ K/s
    !  * ʡؿϴܾͤɽ.     
    !  * ʻ xz Ǥ, ʪΰκǲüź kz = 1
    xyz_VelXSfc = xyz_avr_pyz(pyz_VelXSfc)
    xyz_VelYSfc = xyz_avr_xqz(xqz_VelYSfc)    
    
    xyz_VelSfc = SQRT(  xyz_VelXSfc ** 2.0 + xyz_VelYSfc ** 2.0 )

    xyz_Heatflux(:,:,kz) =                                        &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk * xyz_VelSfc(:,:,kz)                           &
      &       * ( xyz_TempAll(:,:,kz) - TempSfc )                 &
      &       / ( z_dz(kz) * 5.0d-1 )                             &
      &    )

    do s = 1, CondNum
      xyzf_QMixflux(:,:,kz,IdxCG(s)) =                            &
        & MAX(                                                    &
        &       0.0d0,                                            & 
        &     - Bulk * xyz_VelSfc(:,:,kz)                         & 
        &       * (  xyzf_QMixAll(:,:,kz,s)                       &  
        &          - SvapPress( SpcWetID(IdxCC(s)), TempSfc )     &
        &             / PressSfc * (MolWtWet(IdxCG(s)) / MolWtDry)&
        &         ) / ( z_dz(kz) * 5.0d-1 )                       &
        &    )
    end do

    !ɽ̱ư̥եåˤѲΨ׻
    !  * ñ̤ m/s^2
    !  * ʻ xz Ǥ, ʪΰκǲüź kz = 1
    pyz_MomFlux(:,:,kz) =                                         &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk * abs(pyz_VelXSfc(:,:,kz)) * pyz_VelX(:,:,kz)  &
      &       / ( z_dz(kz) * 5.0d-1 )                             &
      &   )

    xqz_MomFlux(:,:,kz) =                                         &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk * abs(xyz_VelYSfc(:,:,kz)) * xqz_VelY(:,:,kz) &
      &       / ( z_dz(kz) * 5.0d-1 )                             &
      &   )

    xyz_DPTempDt = xyz_DPTempDt0 + xyz_Heatflux
    xyzf_DQMixDt = xyzf_DQMixDt0 + xyzf_Qmixflux
    pyz_DVelXDt  = pyz_DVelXDt0  + pyz_MomFlux
    xqz_DVelYDt  = xqz_DVelYDt0  + xqz_MomFlux

    call HistoryAutoPut(TimeN, 'PTempSfc', xyz_HeatFlux(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSfc',  pyz_MomFlux(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSfc',  xqz_MomFlux(1:nx,1:ny,1:nz))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_Sfc', xyzf_Qmixflux(1:nx,1:ny,1:nz,s))
    end do
  end subroutine Surfaceflux_Bulk_forcing
  
end module Surfaceflux_bulk
