!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Module DisturbEnv
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatsugu
!   * Version: $Id: initialdata_disturb.f90,v 1.10 2011-06-23 05:22:22 sugiyama Exp $ 
!   * Tag Name: $Name: arare5-20110623-2 $
!   * Change History: 
!
!== Overview 
!
! ΥǥեͤͿ뤿δܴؿ. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module initialdata_disturb
  !
  !ΥǥեͤͿ뤿Υ롼. 
  !
  
  !⥸塼ɤ߹
  use dc_types,   only: STRING, DP
  use dc_message, only: MessageNotify
  use mpi_wrapper,only: myrank, nprocs
  use axesset,   only: &
    &                  x_X,             &! X ɸ(顼ʻ)
    &                  y_Y,             &! X ɸ(顼ʻ)
    &                  z_Z               ! Z ɸ(顼ʻ)
  use gridset,   only: &
    &                  imin,         &!  X β
    &                  imax,         &!  X ξ
    &                  jmin,         &!  Y β
    &                  jmax,         &!  Y ξ
    &                  kmin,         &!  Z β
    &                  kmax,         &!  Z ξ
    &                  nx,           &!  Z β
    &                  ny,           &!  Z ξ
    &                  nz,           &! ׻ΰΥޡ
    &                  ncmax             ! ׻ΰΥޡ

  !ۤηػ
  implicit none

  !°
  private

  public initialdata_disturb_random
  public initialdata_disturb_gaussXZ
  public initialdata_disturb_gaussXY
  public initialdata_disturb_gaussXYZ
  public initialdata_disturb_dryreg
  public initialdata_disturb_moist

contains
    
  subroutine initialdata_disturb_random( DelMax, Zpos, xyz_Var )
    
    implicit none
    
    real(DP), intent(in)  :: DelMax, Zpos
    real(DP), intent(out) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)              :: Random           !ե뤫
    real(DP)              :: Random1(imin:imax, jmin:jmax)
    integer :: i, j, k, kpos, ix, jy

    ! 
    xyz_Var = 0.0d0

    ! 0.0--1.0 εȯ
    !  mpi ξ,  CPU λۤʤ褦ĴƤ.  
    !
    do j = jmin, jmax + ( ny * nprocs )
      do i = imin, imax * ( nx * nprocs )
        call random_number(random)
        if (imin + nx * myrank <= i .AND. i <= imax + nx * myrank) then 
          if (jmin + ny * myrank <= j .AND. j <= jmax + ny * myrank) then 
            ix = i - nx * myrank
            jy = j - ny * myrank
            Random1(ix,jy) = random
          end if
        end if
      end do
    end do

    ! ꤵ줿٤źѰ
    do k = kmin, kmax
      if ( z_Z(k) >= Zpos ) then 
        kpos = k
        exit
      end if
    end do

    ! ΤȤƤϥȤʤ褦Ĵ. ʿѤκˤ. 
    do j = 1, ny
      do i = 1, nx
        xyz_Var(i, j, kpos) = &
          & DelMax * (Random1(i,j) - sum( Random1(1:nx,1:ny) ) / real((nx * ny),8))
      end do
    end do
    
  end subroutine initialdata_disturb_random
  
  
  subroutine initialdata_disturb_gaussXZ(DelMax, Xc, Xr, Zc, Zr, xyz_Var)

    implicit none

    real(DP), intent(in)  :: DelMax, Xc, Xr, Zc, Zr
    real(DP), intent(out) :: xyz_Var(imin:imax, jmin:jmax, kmin:kmax)
    integer               :: i, j, k

    do k = kmin, kmax
      do j = jmin, jmax
        do i = imin, imax
          xyz_Var(i,j,k) = &
            & DelMax * dexp( - ( (x_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
            &                - ( (z_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) 
        end do
      end do
    end do

!    where ( xyz_Var < DelMax * 1.0d-2) 
!      xyz_Var = 0.0d0
!    end where
    
  end subroutine initialdata_disturb_gaussXZ
  

  subroutine initialdata_disturb_gaussXY(DelMax, Xc, Xr, Yc, Yr, xyz_Var)
    
    implicit none

    real(DP), intent(in)  :: DelMax, Xc, Xr, Yc, Yr
    real(DP), intent(out) :: xyz_Var(imin:imax, jmin:jmax, kmin:kmax)
    integer         :: i, j, k
    
    do k = kmin, kmax
      do j = jmin, jmax
        do i = imin, imax
          xyz_Var(i,j,k) = &
            & DelMax * dexp( - ( (x_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
            &                - ( (y_Y(j) - Yc) / Yr )**2.0d0 * 5.0d-1 )
        end do
      end do
    end do

!    where ( xyz_Var < DelMax * 1.0d-2) 
!      xyz_Var = 0.0d0
!    end where
    
  end subroutine initialdata_disturb_gaussXY


  subroutine initialdata_disturb_gaussXYZ(DelMax, Xc, Xr, Yc, Yr, Zc, Zr, xyz_Var)
    
    implicit none

    real(DP), intent(in)  :: DelMax, Xc, Xr, Yc, Yr, Zc, Zr
    real(DP), intent(out) :: xyz_Var(imin:imax, jmin:jmax, kmin:kmax)
    integer         :: i, j, k
    
    do k = kmin, kmax
      do j = jmin, jmax
        do i = imin, imax
          xyz_Var(i,j,k) = &
            & DelMax * dexp( - ( (x_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
            &                - ( (y_Y(j) - Yc) / Yr )**2.0d0 * 5.0d-1   &
            &                - ( (z_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) 
        end do
      end do
    end do
    
!    where ( xyz_Var < DelMax * 1.0d-2) 
!      xyz_Var = 0.0d0
!    end where

  end subroutine initialdata_disturb_gaussXYZ


  subroutine initialdata_disturb_dryreg( &
    & XposMin, XposMax, YposMin, YposMax, ZposMin, ZposMax, &
    & xyzf_QMix)

    use basicset, only: xyzf_QMixBZ
    
    implicit none

    real(DP), intent(in)  ::XposMin, XposMax, YposMin, YposMax, ZposMin, ZposMax
    real(DP), intent(out) :: xyzf_QMix(imin:imax, jmin:jmax, kmin:kmax, 1:ncmax)
    integer         :: i, j, k, s
    
    ! XposMin:XposMax,ZposMin:ZposMax ǰϤޤ줿ΰνμ٤򥼥ˤ뤿
    ! ܾȵοͿ
    do s = 1, ncmax
      do k = kmin,kmax  
        do j = jmin, jmax
          do i = imin,imax
            if (z_Z(k) >= ZposMin .AND. z_Z(k) < ZposMax &
              & .AND. y_Y(j) >= YposMin .AND. y_Y(j) < YposMax &
              & .AND. x_X(i) >= XposMin .AND. x_X(i) < XposMax) then
              xyzf_QMix(i,j,k,s) = - xyzf_QMixBZ(i,j,k,s)
            end if
          end do
        end do
      end do
    end do
    
  end subroutine initialdata_disturb_dryreg
  
  
  subroutine initialdata_disturb_moist(Hum, xyzf_QMix)
    
    use basicset,   only:              &
      &                  xyz_TempBZ,   &! ܾβ
      &                  xyz_PressBZ,  &! ܾΰ
      &                  xyzf_QMixBZ    ! ܾκ
    use composition,   only:           &
      &                  MolWtWet,     &!Žʬʬ
      &                  SpcWetMolFr    !Žʬν
    use constants, only: MolWtDry       !ʬʬ
    use eccm,       only: eccm_molfr
       
    implicit none

    real(DP), intent(in)  :: Hum
    real(DP), intent(out) :: xyzf_QMix(imin:imax, jmin:jmax, kmin:kmax, 1:ncmax)
    real(DP)              :: zf_MolFr(kmin:kmax, 1:ncmax)
    integer               :: i, j, k, s
  
    ! ٥ʤ鲿⤷ʤ
    if ( Hum == 0.0d0 ) return

    ! ʿͤʤΤ, i=0 ׻. 
    i = 1
    j = 1
    call eccm_molfr( SpcWetMolFr(1:ncmax), Hum, xyz_TempBZ(i,j,:), &
      &              xyz_PressBZ(i,j,:), zf_MolFr )
    
    !Υ򺮹Ѵ
    do s = 1, ncmax
      do k = 1, nz
        do j = 1, ny
          do i = 1, nx
            xyzf_QMix(i,j,k,s) = zf_MolFr(k,s) * MolWtWet(s) / MolWtDry - xyzf_QMixBZ(i,j,k,s)
          end do
        end do
      end do
    end do
    
  end subroutine initialdata_disturb_moist
  
end module initialdata_disturb
