#= Makefile for deepconv/arare reference mannual.
#
# Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
# Version::   $Id: code_reference.rd,v 1.1 2011-06-21 15:42:00 sugiyama Exp $
# Tag Name::  $Name: arare5-20110623-2 $
# Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
# License::   See COPYRIGHT[link:../../COPYRIGHT]
#
#
########################################################################
#

=begin JA

= deepconv/arare ɥե

#* 
#  * 2008/06/19(ã) 
#  * 2007/10/19() 
#  * 2006/11/10() 
#  * 2006/11/09() 

=end JA
=begin EN

= Deepconv/arare source code reference

#* History
#  * 2008/06/19 (Tatsuya Yamashita) Update
#  * 2007/10/19 (Masatsugu Odaka) Update
#  * 2006/11/10 (Masatsugu Odaka) Update
#  * 2006/11/09 (Masatsugu Odaka) Initial release

=end EN


=begin JA

== ¹ԥץΰ

((<ץ(main)|URL:../src/main>)):
* ((<arare.f90|URL:code_reference/files/main/arare_f90.html>)): 
  ץ(ϵ絤)
* ((<arare_jupiter.f90|URL:code_reference/files/main/arare_jupiter_f90.html>)): 
  ץ(絤)
* ((<arareanal.f90|URL:code_reference/files/main/arareanal_f90.html>)): 
  ̷׻ץ
* ((<randomset.f90|URL:code_reference/files/main/randomset_f90.html>)): 
  եץ


=end JA
=begin EN

== Execute programs

((<Main program (main)|URL:../src/main>)):
* ((<arare.f90|URL:code_reference/files/main/arare_f90.html>)): 
  Main program(for terrestrial condition)
* ((<arare_jupiter.f90|URL:code_reference/files/main/arare_jupiter_f90.html>)): 
  Main program(for Jovian condition)
* ((<arareanal.f90|URL:code_reference/files/main/arareanal_f90.html>)): 
  Main Program for calculating prognostic variables
* ((<randomset.f90|URL:code_reference/files/main/randomset_f90.html>)): 
  Main Program for generation random number

=end EN


=begin JA
== ֥롼ȥ⥸塼ΰ

((<ز(chemdat)|URL:../src/chemdat>))
* ((<ChemData|URL:code_reference/classes/ChemData.html>)):
  ؼǡݴɥ⥸塼
* ((<ChemCalc|URL:code_reference/classes/ChemCalc.html>)):
  شϢ̷׻⥸塼


((<ϳز(dynamic)|URL:../src/dynamic>))
* ((<DynFunc|URL:code_reference/classes/DynFunc.html>)):
  ϳز׻⥸塼


((<(env)|URL:../src/env/>))
* ((<basicenv|URL:code_reference/files/env/basicenv_f90.html>)):
  ܾԤ֥롼
* ((<disturbenv|URL:code_reference/files/env/disturbenv_f90.html>)):
  Ԥ֥롼


((<(io)|URL:../src/io/>))
* ((<basicfileio|URL:code_reference/files/io/basicfileio_f90.html>)):
  ܾνͤե뤫Ϥ륵֥롼
* ((<getdisturbvar|URL:code_reference/files/io/getdisturbvar_f90.html>)):
  νͤե뤫Ϥ륵֥롼
* ((<HistoryFileIO|URL:code_reference/classes/HistoryFileIO.html>)):
  ҥȥեؤνϥ⥸塼
* ((<ReStartFileIO|URL:code_reference/classes/ReStartFileIO.html>)):
  ꥹȥեؤνϥ⥸塼


((<(moist)|URL:../src/moist/>))
* ((<ECCM|URL:code_reference/classes/ECCM.html>)):
  徺ǮβٸΨ, ξʿ絤¤׻⥸塼
* ((<MoistAdjust|URL:code_reference/classes/MoistAdjust.html>)):
  ˰Ĵˡ⥸塼
* ((<MoistBuoyancy|URL:code_reference/classes/MoistBuoyancy.html>)):
  ŷʬˤϤؤδͿ׻⥸塼
* ((<MoistFunc|URL:code_reference/classes/MoistFunc.html>)):
  ޤޤѴؿޤȤ᤿⥸塼
* ((<WarmRainPrm|URL:code_reference/classes/WarmRainPrm.html>)):
  ȤΥѥ᥿ꥼ⥸塼


((<ʪ(physics)|URL:../src/physics/>))
* ((<HeatFlux|URL:code_reference/classes/HeatFlux.html>)):
  Υեå׻⥸塼
* ((<HeatFlux_N1994|URL:code_reference/classes/HeatFlux_N1994.html>)):
  Υեå׻⥸塼 (Nakajima 1994)
* ((<Radiation|URL:code_reference/classes/Radiation.html>)):
  Ͷ⥸塼
* ((<Turbulence|URL:code_reference/classes/Turbulence.html>)):
  ήѥ᥿ꥼ⥸塼


((<(setup)|URL:../src/setup/>))
* ((<basicset|URL:code_reference/classes/BasicSet.html>)):
  ܾ⥸塼
* ((<dataset|URL:code_reference/classes/dataset.html>)):
  ʪ⥸塼
* ((<fileset|URL:code_reference/classes/fileset.html>)):
  ϥե̾⥸塼
* ((<gridset|URL:code_reference/classes/gridset.html>)):
  ʻ⥸塼
* ((<storeset|URL:code_reference/classes/storeset.html>)):
  ѻ⥸塼
* ((<timeset|URL:code_reference/classes/timeset.html>)):
  ʬ⥸塼



((<⥸塼(util)|URL:../src/util/>))
* ((<average|URL:code_reference/classes/average.html>)):
  ʿ⥸塼
* ((<boundary|URL:code_reference/classes/boundary.html>)):
  ⥸塼
* ((<cflcheck|URL:code_reference/classes/CFLCheck.html>)):
  CFL ǧ⥸塼
* ((<damping|URL:code_reference/classes/Damping.html>)):
  ȸȥݥؤǤ໤η׻⥸塼
* ((<differentiate_center2|URL:code_reference/classes/differentiate_center2.html>)):
  2 濴ʬ׻⥸塼
* ((<differentiate_center4|URL:code_reference/classes/differentiate_center4.html>)):
  4 濴ʬ׻⥸塼
* ((<FillNegative|URL:code_reference/classes/FillNegative.html>)):
  ̤ʤɤ̤η׻⥸塼
* ((<NumDiffusion|URL:code_reference/classes/NumDiffusion.html>)):
  Ǵ׻⥸塼
* ((<TimeFilter|URL:code_reference/classes/TimeFilter.html>)):
  ֥ե륿׻⥸塼

=end JA
=begin EN

== Subroutines and modules

((<Chemical process (chemdat)|URL:../src/chemdat>))
* ((<ChemData|URL:code_reference/classes/ChemData.html>)):
  Chemical data module
* ((<ChemCalc|URL:code_reference/classes/ChemCalc.html>)):
  Chemical process module


((<Dynamics (dynamic)|URL:../src/dynamic>))
* ((<DynFunc|URL:code_reference/classes/DynFunc.html>)):
  Dynamical process module


((<Initial environment setup (env)|URL:../src/env/>))
* ((<basicenv|URL:code_reference/files/env/basicenv_f90.html>)):
  Basic state set up module
* ((<disturbenv|URL:code_reference/files/env/disturbenv_f90.html>)):
  Initial disturbance set up module


((<"Input/Output (io)"|URL:../src/io/>))
* ((<basicfileio|URL:code_reference/files/io/basicfileio_f90.html>)):
  I/O module of initial basic state variable
* ((<getdisturbvar|URL:code_reference/files/io/getdisturbvar_f90.html>)):
  I/O module of initial perturbation variables
* ((<HistoryFileIO|URL:code_reference/classes/HistoryFileIO.html>)):
  I/O module of history files
* ((<ReStartFileIO|URL:code_reference/classes/ReStartFileIO.html>)):
  I/O module of restart file


((<Moist process (moist)|URL:../src/moist/>))
* ((<ECCM|URL:code_reference/classes/ECCM.html>)):
  ECCM (Ensemble Cloud Condensation Model) module
* ((<MoistAdjust|URL:code_reference/classes/MoistAdjust.html>)):
  Moist adjustment module
* ((<MoistBuoyancy|URL:code_reference/classes/MoistBuoyancy.html>)):
  Buoyancy calculation module
* ((<MoistFunc|URL:code_reference/classes/MoistFunc.html>)):
  Utility module for moist process
* ((<WarmRainPrm|URL:code_reference/classes/WarmRainPrm.html>)):
  Warm rain parameterization module


((<Physics (physics)|URL:../src/physics/>))
* ((<HeatFlux|URL:code_reference/classes/HeatFlux.html>)):
  Heat flux on lower boundary 
* ((<HeatFlux_N1994|URL:code_reference/classes/HeatFlux_N1994.html>)):
  Heat flux on lower boundary (Nakajima 1994)
* ((<Radiation|URL:code_reference/classes/Radiation.html>)):
  Radiative forcing module
* ((<Turbulence|URL:code_reference/classes/Turbulence.html>)):
  Turbulent parameterization module


((<Set up (setup)|URL:../src/setup/>))
* ((<basicset|URL:code_reference/classes/BasicSet.html>)):
  Basic state set up module
* ((<dataset|URL:code_reference/classes/dataset.html>)):
  Physical parameters set up module
* ((<fileset|URL:code_reference/classes/fileset.html>)):
  I/O file names set up module
* ((<gridset|URL:code_reference/classes/gridset.html>)):
  Grid arrangement set up module
* ((<storeset|URL:code_reference/classes/storeset.html>)):
  Integrated values set up module
* ((<timeset|URL:code_reference/classes/timeset.html>)):
  Time integration set up module


((<Utility (util)|URL:../src/util/>))
* ((<average|URL:code_reference/classes/average.html>)):
  Average functions  
* ((<boundary|URL:code_reference/classes/boundary.html>)):
  Adapting boundary condition 
* ((<cflcheck|URL:code_reference/classes/CFLCheck.html>)):
  CFL condition check 
* ((<damping|URL:code_reference/classes/Damping.html>)):
  Sound wave damping term and Rayleigh damping near the upper boundary
* ((<differentiate_center2|URL:code_reference/classes/differentiate_center2.html>)):
  2'nd order centered differentiate scheme 
* ((<differentiate_center4|URL:code_reference/classes/differentiate_center4.html>)):
  4th order centered differentiate scheme
* ((<FillNegative|URL:code_reference/classes/FillNegative.html>)):
  Fulfill negative value of positive definite variables
* ((<NumDiffusion|URL:code_reference/classes/NumDiffusion.html>)):
  Numerical diffusion 
* ((<TimeFilter|URL:code_reference/classes/TimeFilter.html>)):
  Time filter for time integration


=end EN
