!= Module Moistset
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistset.f90,v 1.1 2010-02-25 15:14:39 yamasita Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ǥѤʪŪ뤿ѿȷ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module moistset
  !
  ! ǥѤʪŪ뤿ѿȷ⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_message, only: MessageNotify
  use xyz_base_module,    only: SpcNum
!  use gridset,    only: SpcNum
  use basicset_3d,   only: SpcWetSymbol
!  use basicset,   only: SpcWetSymbol

  !ۤηػ
  implicit none
  
  !°
  public

  !ѿ
  integer      :: GasNum       = 0   ! ο
  integer      :: CloudNum     = 0   ! ο  
  integer      :: RainNum      = 0   ! ο
  integer      :: IdxG(10)     = 0   ! Τź
  integer      :: IdxC(10)     = 0   ! ź
  integer      :: IdxR(10)     = 0   ! ź  
  integer      :: CondNum      = 0   ! ŷο
  integer      :: IdxCG(10)    = 0   ! ŷ()ź
  integer      :: IdxCC(10)    = 0   ! ŷ()ź
  integer      :: IdxCR(10)    = 0   ! ŷ()ź
  integer      :: RactNum      = 0   ! ȿο
  integer      :: IdxNH3       = 0   ! NH3 ()ź
  integer      :: IdxH2S       = 0   ! H2S ()ź
  integer      :: IdxNH4SHc    = 0   ! NH4SH ()ź
  integer      :: IdxNH4SHr    = 0   ! NH4SH ()ź

  !save °  
  save GasNum, CloudNum, RainNum, CondNum, RactNum
  save IdxG,   IdxC,   IdxR
  save IdxCG,  IdxCC,  IdxCR
  save IdxNH3, IdxH2S, IdxNH4SHc, IdxNH4SHr

contains
  
  subroutine moistset_init( )
    !=
    !
    !NameList ե뤫.
    !Υ֥롼, ؾνԤäƤ
    !
    !=Žʬμ갷ˤĤ
    !
    !׻ѤŽʬξ basicset.f90 
    !SpcWetSymbol  SpcWetID ݴɤƤ
    ! 
    ! Symbol:  H2O-g, NH3-g, H2S-g, H2O-l-Cloud, H2O-l-Rain, NH4SH-s-Cloud, NH4SH-s-Rain
    ! ID:      5,     8,     10,    7,           7,          11,            11
    !
    !ID ֹ(ChemData_SpcID) ChemData.f90 Ƥ
    !
    !嵭ξ򸵤, Υ롼Ǥϰʲξ.  
    !
    !  * ƥƥ꡼˴ޤޤʪο
    !
    !    GasNum = 3,  CloudNum = 2, RainNum = 2
    !  
    !  * ƥƥ꡼ź. ΤѤ.
    !
    !    IdxG = 1, 2, 3, 0, 0, 0, ...
    !    IdxC = 4, 6, 0, 0, 0, 0, ...
    !    IdxR = 5, 7, 0, 0, 0, 0, ...
    !
    !  * ŷ(Condensation)ʪο, ź. 
    !    嵭Ǥ H2O ζŷΤߤ
    !
    !    CondNum = 1
    !    IdxCG = 1, 0, 0, 0, 0, 0, ...
    !    IdxCC = 4, 0, 0, 0, 0, 0, ...
    !    IdxCR = 5, 0, 0, 0, 0, 0, ...
    !
    !  * NH4SH ȿ˴Ϳʪź
    !
    !    IdxNH3    = 2
    !    IdxH2S    = 3
    !    IdxNH4SHc = 6
    !    IdxNH4SHr = 7
    !
    !ѤʤʬˤϥƤ. 
    !
    
    !ۤηػ
    implicit none
      
    !ѿ
    integer                  :: s, s1, s2
    integer                  :: n1, n2, n3
    
    !-----------------------------------------------------------
    ! 
    !-----------------------------------------------------------
    GasNum    = 0 
    CloudNum  = 0 
    RainNum   = 0 
    IdxG       = 0 
    IdxC     = 0 
    IdxR      = 0 
    CondNum   = 0 
    IdxCG     = 0 
    IdxCC     = 0 
    IdxCR     = 0 
    RactNum   = 0 
    IdxNH3       = 0 
    IdxH2S       = 0 
    IdxNH4SHc    = 0 
    IdxNH4SHr    = 0 


    !-----------------------------------------------------------
    ! γȵΤ ID Ȥ
    !-----------------------------------------------------------      

    !, , ȤʬΥ. 
    SelectCloud: do s = 1, SpcNum
      
      !'-g' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-g' )
      if (n1 /= 0) then
        GasNum        = GasNum + 1
        IdxG(GasNum)   = s
      end if
      
      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n2 = index(SpcWetSymbol(s), '-Cloud' )
      if (n2 /= 0) then
        CloudNum         = CloudNum + 1
        IdxC(CloudNum)  = s
      end if

      !'Rain' Ȥʸ󤬴ޤޤΤθĿ
      n3 = index(SpcWetSymbol(s), '-Rain' )
      if (n3 /= 0) then
        RainNum         = RainNum + 1
        IdxR(RainNum)   = s
      end if

    end do SelectCloud


    !ŷФ, ȱȤФ. 
    SelectCond: do s = 1, SpcNum
      
      ! NH4SH ¸ߤ
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 
        RactNum           = 1
        cycle SelectCond
      end if
      
      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n2 = index(SpcWetSymbol(s), '-Cloud' )
      if (n2 /= 0) then
        CondNum          = CondNum  + 1
        IdxCC(CondNum)   = s

        do s1 = 1, SpcNum
          if ( trim(SpcWetSymbol(s1)) == trim(SpcWetSymbol(s)(1:n2-3)//'-g') ) then 
            IdxCG(CondNum)   = s1
          end if
        end do
        
        do s2 = 1, SpcNum
          if ( trim(SpcWetSymbol(s2)) == trim(SpcWetSymbol(s)(1:n2-1)//'-Rain') ) then 
            IdxCR(CondNum)   = s2
          end if
        end do
      end if
      
    end do SelectCond
    
    !-----------------------------------------------------------
    ! β˥, ӥ˥βǤ ID 
    !-----------------------------------------------------------
    do s = 1, SpcNum
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 

        IdxNH4SHc = s

        do s1 = 1, SpcNum
          if ( trim(SpcWetSymbol(s1)) == 'NH3-g' ) then 
            IdxNH3 = s1
          end if
        end do

        do s2 = 1, SpcNum
          if ( trim(SpcWetSymbol(s2)) == 'H2S-g' ) then 
            IdxH2S = s2
          end if
        end do

      end if
      
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Rain' ) then 
        IdxNH4SHr = s
      end if

    end do
    
    !-----------------------------------------------------------
    ! ǧ
    !-----------------------------------------------------------
    call MessageNotify( "M", &
      &  "MoistSet_Init","GasNum   = %d", i=(/GasNum/)   )
    call MessageNotify( "M", &
      & "MoistSet_Init", "CloudNum = %d", i=(/CloudNum/) )    
    call MessageNotify( "M", &
      & "MoistSet_Init", "RainNum  = %d", i=(/RainNum/)  ) 
    call MessageNotify( "M", &
      & "MoistSet_Init", "CondNum  = %d", i=(/CondNum/)  )    
    call MessageNotify( "M", &
      & "MoistSet_Init", "RactNum  = %d", i=(/RactNum/)  ) 
    call MessageNotify( "M", &
      & "MoistSet_Init", "IdxNH3 = %d",   i=(/IdxNH3/)   )
    call MessageNotify( "M", &
      & "MoistSet_Init", "IdxH2S = %d",   i=(/IdxH2S/)   )
    call MessageNotify( "M", &
      & "MoistSet_Init", "IdxNH4SHc = %d", i=(/IdxNH4SHc/) )
    call MessageNotify( "M", &
      & "MoistSet_Init", "IdxNH4SHr = %d", i=(/IdxNH4SHr/) )
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxG  = ", IdxG
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxC  = ", IdxC
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxR  = ", IdxR
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxCG = ", IdxCG
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxCC = ", IdxCC
    write(*,*) "*** MESSAGE [MoistSet_Init] ***  IdxCR = ", IdxCR
    
  end subroutine moistset_init

end module moistset
