!= Module FileSet_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: fileset_3d.f90,v 1.1 2010-02-25 15:14:39 yamasita Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ե̾ɽξ
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module fileset_3d
  !
  !Ϳ줿 NAMELIST ե뤫, I/O ե̾, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_iounit,   only : FileOpen
  use dc_message,  only : MessageNotify
  use gtool_history, only : gt_history

  use gridset_3d,     only: SpcNum       !Žʬο
  use basicset_3d,    only: SpcWetSymbol !ʬβؼ̾

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  character(80) :: InitFile          !ͥե
  character(80) :: HistoryFilePrefix !ҥȥ꡼եƬ
  character(80) :: ReStartFile       !ꥹȥե
  character(80) :: RandomFile        !ե
  character(80) :: ExpTitle          !ǡɽ
  character(80) :: ExpSrc            !ǡ
  character(80) :: ExpInst           !ǽѹԡȿ

  character(100), allocatable :: HistoryFile(:) !ϥե̾
  integer                         :: FileNum        !ϥե
  type(gt_history),allocatable    :: gt_hist(:)     !gt_history ¤

contains

  subroutine fileset_init(cfgfile)
    !
    !NAMELIST ե̾դ륿, ϥե̾. 
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    integer                  :: unit     !ֹ
    integer                  :: s        !롼ź

    !NAMELIST 
    NAMELIST /fileset/                                  &
      & InitFile, HistoryFilePrefix, ReStartFile, RandomFile, &
      & ExpTitle, ExpSrc           , ExpInst

    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=fileset)
    close(unit)

    !ǧ
    call MessageNotify( "M", &
      & "fileset_init", "InitFile=%c",    c1=trim(InitFile))
    call MessageNotify( "M", &
      & "fileset_init", "HistoryFilePrefix=%c", c1=trim(HistoryFilePrefix) )
    call MessageNotify( "M", &
      & "fileset_init", "ReStartFile=%c", c1=trim(ReStartFile) )
    call MessageNotify( "M", &
      & "fileset_init", "RandomFile=%c",  c1=trim(RandomFile) )
    call MessageNotify( "M", &
      & "fileset_init", "ExpTitle=%c",    c1=trim(ExpTitle) )
    call MessageNotify( "M", &
      & "fileset_init", "ExpSrc=%c",      c1=trim(ExpSrc) )
    call MessageNotify( "M", &
      & "fileset_init", "ExpInst=%c",     c1=trim(ExpInst) )


    !ե̾Ǽγդ
    !  
    !    PotTemp, Exner, VelX, VelY, VelZ, MixRt(SpcNum), Km, Kh
    !    VorX, VorY, VorZ
    !    *BasicZ, *Zprof
    !  ι 12 + SpcNum
    
    FileNum = 12 + SpcNum
    write(*,*) FileNum
!    if allocated(HistoryFile) then 
!       write(*,*) "already allocated HistoryFile(FileNum)"
!    else
       allocate(HistoryFile(FileNum))
!    end if
    allocate(gt_hist(FileNum))

    HistoryFile(1) = trim(HistoryFilePrefix)//"_Exner.nc" 
    HistoryFile(2) = trim(HistoryFilePrefix)//"_PotTemp.nc" 
    HistoryFile(3) = trim(HistoryFilePrefix)//"_VelX.nc" 
    HistoryFile(4) = trim(HistoryFilePrefix)//"_VelY.nc" 
    HistoryFile(5) = trim(HistoryFilePrefix)//"_VelZ.nc" 
    HistoryFile(6) = trim(HistoryFilePrefix)//"_Km.nc" 
    HistoryFile(7) = trim(HistoryFilePrefix)//"_Kh.nc" 
    HistoryFile(8) = trim(HistoryFilePrefix)//"_BasicZ.nc" 
    HistoryFile(9) = trim(HistoryFilePrefix)//"_Zprof.nc" 

    HistoryFile(10) = trim(HistoryFilePrefix)//"_VorX.nc" 
    HistoryFile(11) = trim(HistoryFilePrefix)//"_VorY.nc" 
    HistoryFile(12) = trim(HistoryFilePrefix)//"_VorZ.nc" 

    do s = 1, SpcNum
      HistoryFile(12+s) = trim(HistoryFilePrefix)//"_"//trim(SpcWetSymbol(s))//".nc"
    end do


    !ǧ
    do s = 1, Filenum
      call MessageNotify( "M", &
        & "fileset_init", "HistoryFile=%c", c1=trim(HistoryFile(s)) )
    end do
    
  end subroutine fileset_init
end module fileset_3d
