!= Module WarmRainPrm
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: warmrainprm.f90,v 1.21 2007/04/19 10:46:03 sugiyama Exp $
! Tag Name::  $Name: arare4-20070424 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
!   *  (1994) Ѥ꼰򤽤Τޤ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module WarmRainPrm
  !
  !ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
  !   *  (1994) Ѥ꼰򤽤Τޤ. 
  ! 
  
  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum              !ؼο
  use basicset, only: PressBasis,        &!̤δవ 
    &                 CpDry,             &!ʬǮ
    &                 MolWtWet,          &!
    &                 MolWtDry,          &!
    &                 SpcWetID,          &!
    &                 xz_DensBasicZ,     &!ܾ̩
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_ExnerBasicZ,    &!̵ܾ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̤δͿ
    &                 xza_MixRtBasicZ,   &!ܾκ
    &                 GasRDry             !ʬε 
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 IdxCR,            &!ŷ()ź
    &                 CloudNum,         &!ο
    &                 RainNum,          &!ο
    &                 IdxC,             &!ź
    &                 IdxR,             &!ź
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S,           &!H2S()ź
    &                 IdxNH4SHr          !NH4SH()ź
  use average,  only: xz_avr_xr        
  use differentiate_center2, only: xr_dz_xz
  use ChemCalc, only: xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use MoistFunc,only: xz_DelMixRtNH4SH
  use StoreSet2, only: Store2Rain
  
  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public WarmRainPrm_Init
  public xz_Rain2GasHeat
  public xz_Rain2GasHeatNH4SH
  public xza_Rain2Gas
  public xza_Rain2GasNH4SH
  public xza_Cloud2Rain
  public xza_FallRain

  real(8)      :: FactorJ      = 1.0d0 !ʪΥѥ᡼
                                       !Ǥ 3.0d0
                                       !ϵǤ 1.0d0 Ȥ
  real(8)      :: AutoConvTime = 1.0d3 !ʻĹλ [sec]
  real(8)      :: MixRt_AutoConvCr = 1.0d-3 
                                       !ʻĹ׳ [kg/kg]

  save FactorJ, AutoConvTime, MixRt_AutoConvCr

contains  

!!!=================================================================================!!!
  subroutine WarmRainPrm_Init( cfgfile )

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !-----------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------
    !
    NAMELIST /warmrainprm/                              &
      & FactorJ, AutoConvTime, MixRt_AutoConvCr

    open (10, FILE=cfgfile)
    read(10, NML=warmrainprm)
    close(10)

    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "FactorJ = %f",  d=(/FactorJ/) )
    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "AutoConvTime = %f",  d=(/AutoConvTime/) )
    call MessageNotify( "M", &
      &  "WarmRainPrm_Init", "MixRt_AutoConvCr = %f",  d=(/MixRt_AutoConvCr/) )
    
  end subroutine WarmRainPrm_Init


!!!=================================================================================!!!  
  function xza_Rain2Gas(xz_Exner, xz_PotTemp, xza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
    ! ξ, FactorJ Ѵ̤®. 
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8)             :: DelTime        !ֹ
    real(8)             :: xza_Rain2Gas(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(8)             :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_NonSaturate(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xz_TempAll   = ( xz_PotTemp + xz_PotTempBasicZ ) * ( xz_Exner + xz_ExnerBasicZ )
    xz_PressAll  = PressBasis * ((xz_Exner + xz_ExnerBasicZ) ** (CpDry / GasRDry))
    xza_Rain2Gas = 0.0d0
 
    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )
    
    do s = 1, CondNum
          
      !˰¾Ⱥκ(˰)׻. 
      !  ؤѴ̤˰٤㤹.
      xz_NonSaturate =                                       &
        & max(                                               &
        &   0.0d0,                                           &
        &   xz_SvapPress(SpcWetID(IdxCC(s)), xz_TempAll)     &
        &     * MolWtWet(IdxCG(s))                           &
        &     / ( MolWtDry * xz_PressAll)                    &
        &     - xza_MixRtAll(:,:,IdxCG(s))                   &
        &    )
      
      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      xza_Rain2Gas(:,:,IdxCR(s)) =                                       &
        & - min(                                                         &
        &    DelTime * 4.85d-2 * FactorJ * xz_NonSaturate                &
        &     * ( xza_MixRtAll(:,:,IdxCR(s)) * xz_DensBasicZ )** 0.65d0, &
        &    xza_MixRtAll(:,:,IdxCR(s))                                  &
        &   ) 
      
      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      xza_Rain2Gas(:,:,IdxCG(s)) = - xza_Rain2Gas(:,:,IdxCR(s)) 
    end do
    
  end function xza_Rain2Gas
  

!!!=================================================================================!!!  
  function xza_Rain2GasNH4SH(xz_Exner, xz_PotTemp, xza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8), intent(in) :: DelTime        !ֹ
    real(8)             :: xza_Rain2GasNH4SH(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(8)             :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !Ϥξʬ + ʿʬ
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_NonSaturate(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)

    !, , ̤
    !ʬʿʬ­
    xz_TempAll   = ( xz_PotTemp + xz_PotTempBasicZ ) *  ( xz_Exner + xz_ExnerBasicZ )
    xz_PressAll  = PressBasis * ((xz_Exner + xz_ExnerBasicZ) ** (CpDry / GasRDry))    
    xza_Rain2GasNH4SH = 0.0d0

    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )
        
    !˰¾Ⱥκ(˰)׻. 
    !  ؤѴ̤˰٤㤹.
    !  ̤˰٤᤿Τ, ޥʥ򤫤Ƥ
    !  (DelMixRtNH4SH , NH4SH ä, ʤ˰٤ȤƤ)
    xz_NonSaturate =                                           &
      & max(                                                   &
      &  0.0d0,                                                &
      &   - xz_DelMixRtNH4SH(                                  &
      &       xz_TempAll, xz_PressAll,                         &
      &       xza_MixRtAll(:,:,IdxNH3), xza_MixRtAll(:,:,IdxH2S),    &
      &       MolWtWet(IdxNH3), MolWtWet(IdxH2S)                     &
      &     )                                                  &
      &  )
        
    !Ѵ
    !  αγκʾ˾ȯʤ褦˾ͤ
    xza_Rain2GasNH4SH(:,:,IdxNH4SHr) =                         &
      & - min(                                              &
      &     DelTime * 4.85d-2 * FactorJ * xz_NonSaturate    &
      &      * (                                            &
      &          xza_MixRtAll(:,:,IdxNH4SHr) * xz_DensBasicZ   &
      &         ) ** 0.65d0,                                &
      &     xza_MixRtAll(:,:,IdxNH4SHr)                        &
      &    ) 
        
    !Ѵ
    !  γѴ̤Ȥ椬դȤʤ
    xza_Rain2GasNH4SH(:,:,IdxNH3) =                              &
      & - xza_Rain2GasNH4SH(:,:,IdxNH4SHr) * MolWtWet(IdxNH3) &
      &   / MolWtWet(IdxNH4SHr)
    xza_Rain2GasNH4SH(:,:,IdxH2S) =                              &
      & - xza_Rain2GasNH4SH(:,:,IdxNH4SHr) * MolWtWet(IdxH2S) &
      &   / MolWtWet(IdxNH4SHr)
    
  end function xza_Rain2GasNH4SH
    

!!!=================================================================================!!!  
  function xz_Rain2GasHeatNH4SH(xz_Exner, xza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8)             :: xz_Rain2GasHeatNH4SH(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !
    real(8)             :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax)

    !Ϥ̤
    !ʬʿʬ­
    xz_ExnerAll    = xz_Exner + xz_ExnerBasicZ

    !ؤѲȼȯǮ
    xz_Rain2GasHeatNH4SH =                                             &
      & ReactHeatNH4SH * xza_DelMixRt(:,:,IdxNH4SHr) * xz_EffMolWtBasicZ  &
      &  / (xz_ExnerAll * CpDry)

  end function xz_Rain2GasHeatNH4SH
  

!!!=================================================================================!!!  
  function xz_Rain2GasHeat(xz_PotTemp, xz_Exner, xza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(8)             :: xz_Rain2GasHeat(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xza_LatentHeat(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xz_ExnerAll    = xz_Exner + xz_ExnerBasicZ
    xz_TempAll     = ( xz_PotTemp + xz_PotTempBasicZ ) *  ( xz_Exner + xz_ExnerBasicZ )
    xza_LatentHeat = 0.0d0
    
    !ؤѲȼȯǮ    
    do s = 1, CondNum
      xza_LatentHeat(:,:,s) =                              &
        & xz_LatentHeat( SpcWetID(IdxCR(s)), xz_TempAll )  &
        &  * xza_DelMixRt(:,:,IdxCR(s))                    &
        &  * xz_EffMolWtBasicZ                             &
        &  / (xz_ExnerAll * CpDry) 
    end do
    xz_Rain2GasHeat = sum( xza_LatentHeat, 3 )

  end function xz_Rain2GasHeat
  

!!!=================================================================================!!!  
  function xza_Cloud2Rain( xza_MixRt, DelTime )
    !
    ! γ鱫γؤѴ̤׻뤿Υ롼
    ! ʻĹ Berry (1968) Υѥ᥿ꥼѤ, 
    ! ͹Ĺ Kessler (1969) Υѥ᥿ꥼѤ. 
    !
    ! Ѵ̤, γȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! γѴʤ褦, αγѴ̤ξ¤ȤƤ.
    ! ͤݾڤ뤿, ȤƻֹߤɬפȤʤ. 
    ! (AutoConv, Collect ϻֹǤʬͤ׻)
    !
    ! Υ롼Ǥ, ŽʪȿʪȤ̤ɬפʤΤ, 
    ! 롼פ󤹲 LoopNum2 ȤƤ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8)             :: DelTime        !ֹ
    real(8)             :: xza_Cloud2Rain(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !鱫ؤѴ
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_AutoConv(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !˰º
    real(8)             :: xz_Collect(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !ʲ줿Ǯ
    real(8), parameter  :: N0 = 5.0d7 
    real(8), parameter  :: D0 = 3.66d-1
    integer             :: s


    xza_Cloud2Rain  = 0.0d0

    !ͤݾ
    !ήȻˤʤ뤳Ȥ⤢Τ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )


    do s = 1, CloudNum
      xz_AutoConv = 0.0d0
      xz_Collect  = 0.0d0
      
      !ʻĹ
      !  Kessler (1969) Υѥ᥿ꥼ        
      xz_AutoConv =                                                 &
        & DelTime / AutoConvTime                                    &
        & * max( 0.0d0, ( xza_MixRtAll(:,:,IdxC(s)) - MixRt_AutoConvCr) )

!      !  Berry (1968) Υѥ᥿ꥼ      
!      xz_AutoConv =                                                   &
!        & DelTime                                                     &
!        & * xz_DensBasicZ                                             &
!        & * ( xza_MixRtAll(:,:,IdxC(s)) ** 3.0d0  ) * 1.0d6       &
!        & / ( 60.0d0                                                &
!        &     * (                                                     &
!        &         2.0d0 * xza_MixRtAll(:,:,IdxC(s))               &
!        &       + 2.66d-8 * N0 / ( xz_DensBasicZ * D0 )               &
!        &      )                                                      &
!        &   )

      !͹Ĺ
      !  Kessler (1969) Υѥ᥿ꥼ    
      xz_Collect =                                            &
        &  DelTime                                            &
        &  * 2.2d0 * FactorJ * xza_MixRtAll(:,:,IdxC(s))     &
        &  * (                                                &
        &       xza_MixRtAll(:,:,IdxR(s)) * xz_DensBasicZ     &
        &     ) ** 0.875d0  
      
      !Ѵ: ʻĹȹξͤ
      !  Ѳ̤ͤȤꤹ. ͤȤʤ.
      xza_Cloud2Rain(:,:,IdxC(s)) =                         &
        & - min(                                             &
        &         xza_MixRtAll(:,:,IdxC(s)),                &
        &         ( xz_AutoConv + xz_Collect )               &
        &       )
      
      !Ѵ. ϱѴ̤Ȥȿ. 
      xza_Cloud2Rain(:,:,IdxR(s)) = - xza_Cloud2Rain(:,:,IdxC(s)) 
          
    end do

!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,1)), maxval(xza_Cloud2Rain(:,:,1))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,2)), maxval(xza_Cloud2Rain(:,:,2))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,3)), maxval(xza_Cloud2Rain(:,:,3))
    
  end function xza_Cloud2Rain
  

!!!=================================================================================!!!
  function xza_FallRain( xza_MixRt )
    !
    ! γˤή. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum) 
                                                 !()
    real(8)  :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                 !( + ʿѾ)
    real(8)  :: xza_FallRain(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                 !γ
    real(8)  :: xz_VelZRain(DimXMin:DimXMax, DimZMin:DimZMax)
                                                 !γ®
    integer  :: s

    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )
    xza_FallRain = 0.0d0
    xz_VelZRain = 0.0d0
    
    !ˤή
    !  Dens  avr äƤ, 䤬Τ
    do s = 1, RainNum
      !γü®
      xz_VelZRain = 12.2d0 * FactorJ * ( xza_MixRtAll(:,:,IdxR(s)) ** 0.125d0 )
      
      xza_FallRain(:,:,IdxR(s)) =                     &
        &  xz_avr_xr(                                 &
        &     xr_dz_xz(xz_DensBasicZ                  &
        &               * xz_VelZRain                 &
        &               * xza_MixRtAll(:,:,IdxR(s))   &
        &              )                              &
        &      ) / xz_DensBasicZ                      
    end do

    call Store2Rain( xza_FallRain )

  end function xza_FallRain
  
  
end module WarmRainPrm
