#!/usr/bin/env ruby

##################################################
=begin
=dcmodel-fig-make

  Ǿ gpview Υåѡ. 
  ꤷֳִ, Υ󥿡ֳ֤, 
    + ޤΥץå
    + ps, png ե뤪ӥ˥᡼ gif κ. 
      - ǥեȤǤ ps  gzip ǰ̤. ɬפʤ --notgz


== USAGE
 
  㤨, ʲΤ褦Ѥ. 

    % ./dcmodel-fig-make.rb  --delt time --num num  gturl

  󥿡ֳ֤ưǻꤹˤ --range ץդ. 

    % ./dcmodel-fig-make.rb  --delt time --num num  --range [min:max] gturl

  եϤˤ --dump ץꤹ

    % ./dcmodel-fig-make.rb --delt time --num num --dump gturl

  ¾ gpview ˤΤޤϤץ, --opt ǻꤹ

    % ./dcmodel-fig-make.rb  --delt time --num num  --opt "--itr 4 --noannotate" gturl 


== OPTION

    --delt            : ϻֳִ [ɬ]

    --num             : 
                        ǥեȤ 1 

    --range [min:max] : ץåȤǾ/ͤ
                        ꤵƤʤˤ, Ū gturl 
                        ǾͤȺͤ׻. 

    --aspect          : ޤΥڥ

    --int             : ϳϻ

    --opt             : gpview ˤΤޤϤ٤ץλ. 

    --delay           : ˥᡼ gif ݤ delay. 
                        ǥեȤ 40 

    --notgz           : ps  tar ǸǤ zip ʤ. 

    --dump            : ޤΥե

    --nocont          : 2 ץåȤ, 󥿡ʤ


== References

  + http://www.gfd-dennou.org/arch/dcl/dcl-5.3.1/README_pslib
  + http://www.gfd-dennou.org/arch/dcl/dcl-tips/dclpsedit.html


== HISTORY

  2005/12/29   K Sugiyama (created)

=end
##################################################
require "numru/ggraph"
require "getoptlong"
include NumRu

###
### 
###
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--num',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--delt',        GetoptLong::REQUIRED_ARGUMENT],
                   ['--range',       GetoptLong::REQUIRED_ARGUMENT],
                   ['--aspect',      GetoptLong::REQUIRED_ARGUMENT],
                   ['--int',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--delay',       GetoptLong::REQUIRED_ARGUMENT],
                   ['--opt',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--dump',        GetoptLong::NO_ARGUMENT],
                   ['--nocont',      GetoptLong::NO_ARGUMENT],
                   ['--notgz',       GetoptLong::NO_ARGUMENT]
                   )
begin
  parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'" 
  end
rescue
  exit(1)
end


###
### 顼. delt ꤵƤʤȥ. 
###
p "ERROR: --num is not set"    unless $OPT_num
p "ERORR: --delt is not set"   unless $OPT_delt
exit!                          unless $OPT_delt


###
### Ѥ륳ޥɤӥץ
###
# μ̾
tunit  = "t"   

#gp ޥ
gpview   = "/usr/bin/gpview"
gpmaxmin = "| /usr/bin/gpmaxmin"  # ե륿Ȥ

#dcl Ϣ 
dclpsrmcm   = "/usr/bin/dclpsrmcm"
dclpsrot    = "/usr/bin/dclpsrot"
dclpsfont   = "/usr/bin/dclpsfont f=H lcntl=1 fact=7000"
dclpsmargin = "/usr/bin/dclpsmargin"
psout       = "dcl.ps"                # dcl νϤ ps ե̾

# gs Ϣ. ǲ٤ȥ
gsresolv = "90"
gssize   = "900x600"
gs  = "/usr/bin/gs -sDEVICE=pnmraw -q -dNOPAUSE -dSAFER  -sOutputFile=-" \
      +" -r"+gsresolv+" -g"+gssize

# imagemagic
pnmtopng = "/usr/bin/pnmtopng"
convert  = "/usr/bin/convert"

# tar
tar    = "/bin/tar zcf"
taropt = "--remove-files"

# rm
rm = "/bin/rm"


###
### ѿ
###

# ͤν
num   = 1
delt  = 0
range = ""
aspect= ""
wsn   = "--wsn 1"
int   = 0.0
opt   = "" 
delay = "-delay 40"  
sint  = ""
cint  = ""
del   = 0.0
maxmin= []
fname = ARGV[0].sub(/\.nc@/,"_").sub(/=/,"").sub(/\,/,"_")

#ֳ
delt = $OPT_delt.to_i               if $OPT_delt

#
num = $OPT_num.to_i                 if $OPT_num

# ڥ
aspect = "--aspect"+" "+$OPT_aspect if $OPT_aspect

# ޤΥե
wsn = "--wsn 2"                     if $OPT_dump

# 賫ϻ 
int = $OPT_int.to_i                 if $OPT_int

# ¾ץ
opt = $OPT_opt                      if $OPT_opt

# delay
delay = "-delay"+" "+$OPT_delay     if $OPT_delay

# ϰϤλ. 
if ($OPT_range) 
  range = "--range"+" "+$OPT_range 
else
  # gpmaxmin ѤƺǾͤȺͤ
  gpmaxmin = gpmaxmin+" "+ARGV[0]+","+tunit+"="+int.to_s+":"+(delt*num).to_s
  p gpmaxmin
  fil = open(gpmaxmin)
  fil.each { |line| 
    /["min"|"max"]=(\S+),\s+/ =~ line  # Ϸ̤ͤȺǾͤõ
    maxmin << $1.to_f if $1
  }
  p maxmin
  range = "--range"+" "+maxmin[1].to_s+":"+maxmin[0].to_s
end

# ɤ, 󥿡饤
## ǾͤȺͤκ
if ($OPT_range) 
  /(.*):(.*)/ =~ $OPT_range
  del = $2.to_f - $1.to_f
else
  # gpmaxmin η̤ǾͤȺͤ
  del = maxmin[0] - maxmin[1]
end

## ʬ, 󥿡δֳ֤. ʬϺ 100 Ѥ. 
sdel = del / 99.0
cdel = del / 10.0

## sint, cint 
sint = "--sint"+" "+sdel.to_s 
if ($OPT_nocont) 
  cint = "--nocont"
else
  cint = " "
end


# 狼, ϻΥեޥåȤ
order = Math::log10(delt * num).to_i + 1
fmt = "%0"+(order.to_i).to_s+"d"


###
### ޤν, ե
###
for i in 0..num 
  
  # 
  time = sprintf(fmt, int+delt*i)

  # ¹ԥޥɤκ, ¹
  gturl = ARGV[0]+","+tunit+"="+time.to_s   
  p gpview, gturl, range, aspect, wsn, sint, cint, opt
  view = gpview+" "+gturl+" "+range+" "+aspect+" "+wsn+" " \
         +sint+" "+cint+" "+opt
  p view
  system (view)
  
  # ps --> png Ѵ
  if ($OPT_dump)
    psfile  = fname+"_"+tunit+time.to_s+".ps"
    pngfile = fname+"_"+tunit+time.to_s+".png"
    
    # dcl °ޥɤѤѴ
    dclps = dclpsrmcm+" "+psout+" | "+dclpsrot+" | "+dclpsfont+" | " \
            +dclpsmargin+" > "+psfile
    p dclps
    system (dclps)
    
    # ps ե png եѴ
    pspng = gs+" "+psfile+" -c quit| "+pnmtopng+" > "+pngfile
    p pspng
    system (pspng)

    #ݽ
    psrm = rm+" dcl.ps"
    system( psrm )
  end  
end


# ˥᡼, ps ե밵
if ($OPT_dump)
  giffile  = fname+"_anim.gif"
  pngfiles = fname+"*.png"
  psfiles  = fname+"*.ps"
  tgzfile  = fname+".tar.gz"

  mkanim = convert+" "+delay+" "+pngfiles+" "+giffile
  p mkanim
  system (mkanim)

  unless ($OPT_notgz)
    # tar ե˸Ǥ
    pstar = tar+" "+tgzfile+" "+psfiles+" "+taropt
    p pstar
    system (pstar)
  end
end
