!= Module BasicSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: basicset.f90,v 1.11 2006/11/10 05:54:51 odakker Exp $
! Tag Name::  $Name: arare4-20070424 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ǥեȤδܾꤹ뤿ѿȷ⥸塼
! * BasicEnvFile_init: ܾͤ netCDF ե뤫
! * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module BasicSet
  !
  !ǥեȤδܾꤹ뤿ѿȷ⥸塼
  !, hogeBasicZ Ȥʤ, ͤϤ뤳Ȥ
  !Ԥ. 
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify   !å
  use ChemData,   only: GasRUniv,        &!
    &                   ChemData_Init,   &!
    &                   ChemData_OneSpcID !ؼ ID
  use ChemCalc,   only: ChemCalc_init, &!
    &                   CpRef,  &!
    &                   CpPerMolRef,   &!
    &                   CvRef,  &!
    &                   MolWt           !
  use gridset,    only: DimXMin,       &!  X β
    &                   DimXMax,       &!  X ξ
    &                   DimZMin,       &!  Z β
    &                   DimZMax,       &!  Z ξ
    &                   SpcNum          ! ؼο

  !ۤηػ
  implicit none

  !save °
  save

  !Public Interface
  real(8)               :: Grav                  ! [m/s^2]
  real(8)               :: TempSfc               !ɽ̲ [K]
  real(8)               :: PressSfc              !ɽ̰ [Pa]
  real(8)               :: PressBasis            !̤δవ [Pa]
  real(8)               :: CpDry                 !ʬ갵Ǯ [J/K kg]
  real(8)               :: CpDryMol              !ʬ갵Ǯ [J/K kg]
  real(8)               :: CvDry                 !ʬǮ [J/K kg]
  real(8)               :: MolWtDry              !ʬʬ   [kg/mol]
  real(8)               :: GasRDry               !ʬε [J/K kg]
  integer, allocatable  :: SpcWetID(:)           !ʬβؼID
  real(8), allocatable  :: MolWtWet(:)           !ʬʬ  
  real(8), allocatable  :: xz_DensBasicZ(:,:)    !̩
  real(8), allocatable  :: xz_PressBasicZ(:,:)   !̵
  real(8), allocatable  :: xz_ExnerBasicZ(:,:)   !̵
  real(8), allocatable  :: xz_TempBasicZ(:,:)    !
  real(8), allocatable  :: xz_PotTempBasicZ(:,:) !
  real(8), allocatable  :: xz_VelSoundBasicZ(:,:)!®
  real(8), allocatable  :: xza_MixRtBasicZ(:,:,:)!Žʬ
  real(8), allocatable  :: xz_EffMolWtBasicZ(:,:)!ʬ̸
  real(8)               :: SpcWetMolFr(10)       !ʬβؼ¸
  character(20)         :: SpcWetSymbol(10)      !ʬβؼ̾
  real(8)               :: Tropopause            !ή̹
  real(8)               :: Humidity              !м 
  character(20)         :: EnvType               !ܾβ, 'Dry' or 'Moist'   
  real(8)               :: TempStrat             !طβ [k]
  real(8)               :: Dhight                !ŤߴؿΥѥ᡼ [m]


contains

!!!-----------------------------------------------------------------!!!
  subroutine BasicSetArray_Init(                         &
    & xz_Press, xz_Exner, xz_Temp, xz_PotTemp, xz_Dens,  &
    & xz_VelSound, xza_MixRt, xz_EffMolWt )
    !
    !ܾͤ. 
    !
    
    !ѿ
    real(8), intent(in) :: xz_Press(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Temp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Dens(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_VelSound(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8), intent(in) :: xz_EffMolWt(DimXMin:DimXMax, DimZMin:DimZMax)
   
    !---------------------------------------------------------------
    ! *BasicZ ν
    !---------------------------------------------------------------
    !γ
    allocate( & 
      & xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),            &
      & xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),            &
      & xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),         &
      & xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)         )
    
    !ͤ
    xz_PressBasicZ    = xz_Press
    xz_ExnerBasicZ    = xz_Exner
    xz_TempBasicZ     = xz_Temp
    xz_PotTempBasicZ  = xz_PotTemp
    xz_DensBasicZ     = xz_Dens
    xz_VelSoundBasicZ = xz_VelSound
    xza_MixRtBasicZ   = xza_MixRt
    xz_EffMolWtBasicZ = xz_EffMolWt
    
  end subroutine BasicSetArray_Init

!!!-----------------------------------------------------------------!!!
  subroutine BasicSet_Init(cfgfile)
    !
    !ܾξ Namelist ͤ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ
    character(*), intent(in) :: cfgfile         !NAMELIST ե
!    real(8)                   :: Tropopause      !ή̹
!    real(8)                   :: CpDryMol        !ʬ갵Ǯ [J/K mol]
    integer                   :: SpcDryNum       !ʬβؼο
    integer                   :: SpcWetNum       !ʬβؼο
    character(20)             :: SpcDrySymbol(5)!ʬβؼ̾
!    character(15)             :: SpcWetSymbol(10)!ʬβؼ̾
    real(8)                   :: SpcDryMolFr(5) !ʬβؼ¸
!    real(8)                   :: SpcWetMolFr(10) !ʬβؼ¸
    integer, allocatable      :: SpcDryID(:)     !ʬβؼID
!    real(8)                   :: Humidity        !м
!    character(20)             :: EnvType         !ܾβ, 'Dry' or 'Moist'
    real(8), allocatable      :: PropertyDry(:)  !
    character(20), allocatable:: Symbol(:)       !
    integer                   :: s, n1, n2, n3   !ѿ

    !NAMELIST 
    NAMELIST /basicset/ &
      & Grav, TempSfc, PressSfc,   PressBasis, Tropopause,  & 
      & SpcDrySymbol, SpcDryMolFr,                          &
      & SpcWetSymbol, SpcWetMolFr,                          &
      & EnvType, Humidity, TempStrat, Dhight

    SpcDrySymbol = '' 
    SpcDryMolFr  = 0.0d0
    SpcWetSymbol = '' 
    SpcWetMolFr  = 0.0d0
    
    !ե륪ץ. . 
    open (10, FILE=cfgfile)
    read(10, NML=basicset)
    close(10)

    !----------------------------------------------------------
    ! ؼʪͤν
    !----------------------------------------------------------
    !ǡ١ν
    call ChemData_Init
    
    !----------------------------------------------------------
    ! ʬʪͤν
    !----------------------------------------------------------
    !ʬθĿ
    SpcDryNum = count(SpcDrySymbol /= "")
    
    !ؼ ID     
    allocate(SpcDryID(SpcDryNum))    
    do s = 1, SpcDryNum
      SpcDryID(s) = ChemData_OneSpcID( SpcDrySymbol(s) )
    end do

    !ط׻⥸塼ν
    call ChemCalc_Init(DimXMin, DimXMax, DimZMin, DimZMax, SpcDryNum, SpcDryID)
    
    !ν
    allocate(PropertyDry(SpcDryNum))

    !ʬ
    do s = 1, SpcDryNum
      PropertyDry(s) = MolWt(SpcDryID(s))
    end do
    MolWtDry = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
    
    !갵Ǯ()
    do s = 1, SpcDryNum    
      PropertyDry(s) = CpPerMolRef(SpcDryID(s))
    end do
    CpDryMol = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
    
    !갵Ǯ
    CpDry    = CpDryMol / MolWtDry
    
    !
    GasRDry = GasRUniv / MolWtDry
    
    !Ǯ
    CvDry    = CpDry - GasRDry
    
    
    !----------------------------------------------------------
    ! ʬ ID 
    !----------------------------------------------------------
    !ʬθĿ
    SpcWetNum = count(SpcWetSymbol /= "")
    if (SpcWetNum /= SpcNum) then 
      call MessageNotify( "E", &
        &  "basicset: ", "SpcWetNum is not equal to SpcNum." )
!      write(*,*) "SpcWetNum /= SpcNum"
!      stop
    end if
    
    !γ
    allocate(SpcWetID(SpcWetNum), Symbol(SpcWetNum), MolWtWet(SpcWetNum))

    !SpcWetSymbol ʸ󤫤, -Rain, -Cloud Τ Symbol Ȥݴ
    do s = 1, SpcWetNum
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      n2 = index(SpcWetSymbol(s), '-Rain' )
      n3 = max(n1, n2)
      if (n3 == 0) then
        Symbol(s) = SpcWetSymbol(s)
      else
        Symbol(s) = SpcWetSymbol(s)(1:n3-1)
      end if
    end do
    
    !ؼ ID 
!    SpcWetID = ChemData_SpcID(SpcWetNum, Symbol(1:SpcWetNum))
    do s =1, SpcWetNum
      SpcWetID(s) = ChemData_OneSpcID( Symbol(s) )
    end do
    
    !ط׻⥸塼ν
    call ChemCalc_Init(DimXMin, DimXMax, DimZMin, DimZMax, SpcWetNum, SpcWetID(:))
    
    !ʬ̤ݴ
    do s = 1, SpcWetNum
      MolWtWet(s) = MolWt(SpcWetID(s))
    end do
    

    !----------------------------------------------------------
    ! ǧ
    !----------------------------------------------------------
    call MessageNotify( "M", &
      & "basicset_init", "Grav = %f",     d=(/Grav/) )
    call MessageNotify( "M", &
      & "basicset_init", "TempSfc = %f",  d=(/TempSfc/) )
    call MessageNotify( "M", &
      & "basicset_init", "PressSfc = %f", d=(/PressSfc/) )
    call MessageNotify( "M", &
      & "basicset_init", "PressBasis = %f", d=(/PressBasis/))

    do s = 1, SpcDryNum
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDryID = %d",      i=(/SpcDryID(s)/))
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDrySymbol = %c", c1=trim(SpcDrySymbol(s)))
      call MessageNotify( "M", &
        &  "basicset_init", "SpcDryMolFr = %f",   d=(/SpcDryMolFr(s)/))
    end do

    call MessageNotify( "M", "basicset_init", "CpDry = %f",    d=(/CpDry/) )
    call MessageNotify( "M", "basicset_init", "CpDryMol = %f", d=(/CpDryMol/) )
    call MessageNotify( "M", "basicset_init", "CvDry = %f",    d=(/CvDry/) )
    call MessageNotify( "M", "basicset_init", "GasRDry = %f",  d=(/GasRDry/) )
    call MessageNotify( "M", "basicset_init", "MolWtDry = %f", d=(/MolWtDry/) )

    do s = 1, SpcWetNum
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetID = %d",     i=(/SpcWetID(s)/) )
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetSymbol = %c", c1=trim(SpcWetSymbol(s)) )
      call MessageNotify( "M", &
        & "basicset_init", "SpcWetMolFr = %f",  d=(/SpcWetMolFr(s)/) )
      call MessageNotify( "M", &
        & "basicset_init", "MolWtWet = %f",     d=(/MolWtWet(s)/) )
    end do

    call MessageNotify( "M", &
      & "basicset_init", "Tropopause = %f ", d=(/Tropopause/) )
    call MessageNotify( "M", &
      & "basicset_init", "EnvType = %c", c1=trim(EnvType) )
    call MessageNotify( "M", & 
      & "basicset_init", "Humidity = %f", d=(/Humidity/)  )

  end subroutine BasicSet_Init

end module BasicSet
