!= Subroutine CFLCheck
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: cflcheck.f90,v 1.3 2006/09/21 02:35:16 odakker Exp $ 
! Tag Name::  $Name: arare4-20060928a $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!CFL Υå򤹤뤿Υѥå⥸塼
!  * ȤФ CFL å
!  * Ϥ줿®٤Ф CFL å
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!Error Handling  gt4f90io Ѥ褦ѹ
!

module CFLCheck
  !
  !CFL Υå򤹤뤿Υѥå⥸塼
  !  * ȤФ CFL å
  !  * Ϥ줿®٤Ф CFL å
  !

  !⥸塼ɤ߹
  use gridset, only: DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                DelX,          &! X γʻֳ
    &                DelZ            ! Z γʻֳ
  use timeset, only: DelTimeShort,  &!û֥ƥå
    &                DelTimeLong     !Ĺ֥ƥå
  
  !ۤηػ
  implicit none

  !private °λ
  private

  !ؿ public °
  public CFLCheckTimeShort
  public CFLCheckTimeLongVelX
  public CFLCheckTimeLongVelZ
  
contains  

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeShort( xz_VelSound )
    !
    !ȤФ CFL å
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xz_VelSound(DimXMin:DimXMax, DimZMin:DimZMax)
                                        !®
    real(8)             :: CFL          !
    
    !® CFL 
    CFL = DelTimeShort * maxval(xz_VelSound) / DelX  

    !å
    write(*,*) "CFL Condition for DelTimeSort: ", CFL

    !ٹå
    if ( CFL >= 1.0) then 
      write(*,*) "CFL Condition is broken, DelTimeShort * VelSound > Del"
      write(*,*) "sound wave velocity ", maxval(xz_VelSound)
      write(*,*) "Del                 ", min(DelX, DelZ)
      write(*,*) "DelTimeShort        ", DelTimeShort
      stop
    end if
  
  end subroutine CFLCheckTimeShort


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelX( pz_VelX )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: CFL
    
    !® CFL 
    CFL = DelTimeLong/ max(DelX / maxval(pz_VelX), - DelX / minval(pz_VelX)) 
  
    !å
    write(*,*) "CFL Condition of VelX for DelTimeLong: ", CFL

  end subroutine CFLCheckTimeLongVelX
    

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelZ( xr_VelZ )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: CFL
    
    !® CFL 
    CFL = DelTimeLong / max(DelZ / maxval(xr_VelZ), - DelZ / minval(xr_VelZ)) 
    
    !å
    write(*,*) "CFL Condition of VelZ for DelTimeLong: ", CFL
    
  end subroutine CFLCheckTimeLongVelZ
  
end module CFLCheck
