!= Module StoreSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storeset.f90,v 1.5 2006/09/21 02:41:52 odakker Exp $ 
! Tag Name::  $Name: arare4-20060928a $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module storeset
  !
  !ѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  real(8), allocatable :: z_Adv(:)
  real(8), allocatable :: z_Turb(:)
  real(8), allocatable :: z_Disp(:)
  real(8), allocatable :: z_Diff(:)
  real(8), allocatable :: z_Rad(:)
  real(8), allocatable :: z_Damp(:)
  real(8), allocatable :: z_Cond(:)
  real(8), allocatable :: xz_Adv(:,:)
  real(8), allocatable :: xz_Turb(:,:)
  real(8), allocatable :: xz_Disp(:,:)
  real(8), allocatable :: xz_Diff(:,:)
  real(8), allocatable :: xz_Rad(:,:)
  real(8), allocatable :: xz_Damp(:,:)
  real(8), allocatable :: xz_Cond(:,:)
  real(8), allocatable :: z_Stab(:)
  real(8), allocatable :: z_StabTemp(:)
  real(8), allocatable :: z_StabMolWt(:)
  real(8), allocatable :: xz_Stab1(:,:)
  real(8), allocatable :: xz_Stab2(:,:)
  real(8), allocatable :: xz_Stab3(:,:)
  
contains

  subroutine StoreSet_Init( )
    !롼

    allocate(     &
      & z_Adv(DimZMin:DimZMax),  & 
      & z_Turb(DimZMin:DimZMax), &
      & z_Disp(DimZMin:DimZMax), &
      & z_Diff(DimZMin:DimZMax), &
      & z_Rad(DimZMin:DimZMax),  &
      & z_Damp(DimZMin:DimZMax), &
      & z_Cond(DimZMin:DimZMax), &
      & xz_Adv(DimXMin:DimXMax, DimZMin:DimZMax),  & 
      & xz_Turb(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Disp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Diff(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Rad(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_Damp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax), &
      !
      & z_Stab(DimZMin:DimZMax),      &
      & z_StabTemp(DimZMin:DimZMax),  &
      & z_StabMolWt(DimZMin:DimZMax), &
      & xz_Stab1(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Stab2(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Stab3(DimXMin:DimXMax, DimZMin:DimZMax)  &
      &  )
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
   
    z_Stab      = 0.0d0
    z_StabTemp  = 0.0d0
    z_StabMolWt = 0.0d0

    xz_Stab1 = 0.0d0
    xz_Stab2 = 0.0d0
    xz_Stab3 = 0.0d0

  end subroutine StoreSet_Init


  subroutine StoreClean( )
    !ݴɤͤΥꥢ
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
   
    z_Stab      = 0.0d0
    z_StabTemp  = 0.0d0
    z_StabMolWt = 0.0d0

    xz_Stab1 = 0.0d0
    xz_Stab2 = 0.0d0
    xz_Stab3 = 0.0d0

  end subroutine StoreClean


  subroutine StoreMeanX( )
    !ݴɤͤοʿʿ
    
    z_Adv  = a_MeanX_aa( xz_Adv )  * DelTimeLong * 2.0d0 / TimeDisp
    z_Turb = a_MeanX_aa( xz_Turb ) * DelTimeLong * 2.0d0 / TimeDisp
    z_Diff = a_MeanX_aa( xz_Diff ) * DelTimeLong * 2.0d0 / TimeDisp
    z_Disp = a_MeanX_aa( xz_Disp ) * DelTimeLong * 2.0d0 / TimeDisp
    z_Rad  = a_MeanX_aa( xz_Rad  ) * DelTimeLong * 2.0d0 / TimeDisp
    z_Damp = a_MeanX_aa( xz_Damp ) * DelTimeLong * 2.0d0 / TimeDisp
    z_Cond = a_MeanX_aa( xz_Cond ) / TimeDisp  !ʬѤ

    z_Stab      = a_MeanX_aa( xz_Stab1 ) * DelTimeLong * 2.0d0 / TimeDisp
    z_StabTemp  = a_MeanX_aa( xz_Stab2 ) * DelTimeLong * 2.0d0 / TimeDisp
    z_StabMolWt = a_MeanX_aa( xz_Stab3 ) * DelTimeLong * 2.0d0 / TimeDisp
    
  end subroutine StoreMeanX


  subroutine StoreAdv( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Adv + Work
    xz_Adv = Work2

  end subroutine StoreAdv


  subroutine StoreTurb( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Turb + Work
    xz_Turb = Work2

  end subroutine StoreTurb


  subroutine StoreDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Diff + Work
    xz_Diff = Work2

  end subroutine StoreDiff


  subroutine StoreDisp( Work )
    !Ǯݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Disp + Work
    xz_Disp = Work2

  end subroutine StoreDisp


  subroutine StoreRad( Work )
    !ѹݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Rad + Work
    xz_Rad = Work2

  end subroutine StoreRad


  subroutine StoreDamp( Work )
    !ԥ󥰹ݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Damp + Work
    xz_Damp = Work2

  end subroutine StoreDamp


  subroutine StoreCond( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Cond + Work
    xz_Cond = Work2

  end subroutine StoreCond


  subroutine StoreStab( Work1, Work2, Work3 )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work1(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: Work3(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: WorkC(DimXMin:DimXMax, DimZMin:DimZMax)

    WorkA    = Work1 + xz_Stab1 
    xz_Stab1 = WorkA

    WorkB    =  Work2 + xz_Stab2
    xz_Stab2 = WorkB

    WorkC    = Work3 + xz_Stab3
    xz_Stab3 = WorkC

  end subroutine StoreStab


  function a_MeanX_aa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: a_MeanX_aa(DimZMin:DimZMax)
                                     !ʿʿ

    a_MeanX_aa = sum( var(RegXMin+1:RegXMax, :), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 

  end function a_MeanX_aa
  

  
end module storeset
