!= Module MoistBuoyancy
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistbuoyancy.f90,v 1.13 2006/09/21 02:35:11 odakker Exp $
! Tag Name::  $Name: arare4-20060928a $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module MoistBuoyancy
  !
  !
  !

  !⥸塼ɤ߹ 
  use gridset, only:  SpcNum,            &! ؼο
    &                 DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 DelX,              &! x γʻֳ
    &                 DelZ                ! z γʻֳ
  use basicset, only: MolWtDry,          &!ʬʬ
    &                 Grav,              &!ϲ®
    &                 SpcWetID,          &!ŽʬID
    &                 SpcWetSymbol,      &!Žʬ̾
    &                 MolWtWet,          &!Žʬʬ
    &                 CpDry,             &!ʬʿ갵Ǯ [J/K kg]
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̸
    &                 xz_ExnerBasicZ,    &!̵ܾ
    &                 xza_MixRtBasicZ     !ܾκ
  use ChemCalc, only: xz_LatentHeat       !Ǯ
  use ChemData, only: ChemData_OneSpcID
  use average,  only: xr_avr_xz, xz_avr_xr
  use differentiate_center2, only: xr_dz_xz

  !ۤηػ
  implicit none
  
  !°λ
  private
  
  !ؿ public 
  public MoistBuoy_Init
  public xz_BuoyMoistKm
  public xr_BuoyMolWt
  public xr_BuoyDrag

  !ѿ
  integer     :: LoopNum      = 0
  integer     :: GasCount     = 0
  integer     :: GasNum(10)   = 0
  integer     :: CloudNum(10) = 0
  real(8)     :: Cm           = 2.0d-1
  real(8)     :: MixLen       = 0.0d0
  real(8), allocatable :: xz_MixRtBasicZPerMolWt(:,:)
                              !ܾκ / ʬ 
  real(8), allocatable :: xr_MixRtBasicZPerMolWt(:,:)
                              !ܾκ / ʬ 
  real(8), allocatable :: xz_MixRtBasicZ(:,:)
                              !ܾκ
  real(8), allocatable :: xr_MixRtBasicZ(:,:)
                              !ܾκ
  
  save GasNum, CloudNum, LoopNum
  save Cm, MixLen
  save xz_MixRtBasicZPerMolWt
  save xr_MixRtBasicZPerMolWt
  save xz_MixRtBasicZ
  save xr_MixRtBasicZ 

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistBuoy_Init( )

    use ChemData, only: ChemData_OneSpcID

    !ۤηػ
    implicit none

    !ѿ
    integer              :: s
    integer              :: n1, n2
    real(8), allocatable :: xza_MixRtBasicZPerMolWt(:,:,:)
                                  !ܾκ / ʬ

    !-----------------------------------------------------------
    ! Υ
    !-----------------------------------------------------------
    MixLen = sqrt(DelX * DelZ) 
    
    !-----------------------------------------------------------
    ! γȵΤ ID Ȥ
    !-----------------------------------------------------------
    !ؼ椫γΤ, źʬ̤ݴ.
    LoopNum  = 0
    GasCount = 0

    SelectCloud: do s = 1, SpcNum

      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      if (n1 /= 0) then
        LoopNum          = LoopNum + 1
        CloudNum(LoopNum)= s
      end if
      
      n2 = index(SpcWetSymbol(s), '-g' )
      if (n2 /= 0) then
        GasCount = GasCount + 1
        GasNum(GasCount)= s
      end if
      
    end do SelectCloud

    !-----------------------------------------------------------
    ! ǧ
    !-----------------------------------------------------------
    write(*,*) "MoistBuoy_Init, LoopNum:  ", LoopNum
    write(*,*) "MoistBuoy_Init, GasCount: ", GasCount
    write(*,*) "MoistBuoy_Init, GasNum:   ", GasNum    
    write(*,*) "MoistBuoy_Init, CloudNum: ", CloudNum    

    if ( LoopNum /= GasCount ) then 
      write(*,*) "GasCount /= LoopNum" 
      stop
    end if

    !-----------------------------------------------------------
    ! ν. 
    !-----------------------------------------------------------
    allocate( &
      & xza_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, LoopNum), &
      & xr_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),                   &
      & xz_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)                    &
      & )

    xza_MixRtBasicZPerMolWt = 0.0d0
    xr_MixRtBasicZPerMolWt = 0.0d0
    xz_MixRtBasicZPerMolWt = 0.0d0
    xr_MixRtBasicZ = 0.0d0
    xz_MixRtBasicZ = 0.0d0

    write(*,*) MolWtWet

    do s = 1, LoopNum
      xza_MixRtBasicZPerMolWt(:,:,GasNum(s)) = &
        & xza_MixRtBasicZ(:,:,GasNum(s)) / MolWtWet(GasNum(s))
    end do
    xz_MixRtBasicZPerMolWt = sum(xza_MixRtBasicZPerMolWt, 3) 
    xr_MixRtBasicZPerMolWt = xr_avr_xz( sum(xza_MixRtBasicZPerMolWt, 3) )
    xz_MixRtBasicZ         =  sum(xza_MixRtBasicZ, 3) 
    xr_MixRtBasicZ         = xr_avr_xz( sum(xza_MixRtBasicZ, 3) )     
    
  end subroutine MoistBuoy_Init


!!!------------------------------------------------------------------------!!!
  function xz_BuoyMoistKm(xz_PotTemp, xz_Exner, xza_MixRt)
    !
    ! NH4SH ζŷǮθʤȤʤʤΤ, Ǥ
    !Ȥꤢ̵뤹. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !̵
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xz_BuoyMoistKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xza_LatentHeat(DimXMin:DimXMax, DimZMin:DimZMax, LoopNum)
                                               !Ǯ
    real(8)              :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xz_EffHeat(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xz_EffPotTemp(DimXMin:DimXMax, DimZMin:DimZMax)    
    real(8)              :: xz_EffMolWt(DimXMin:DimXMax, DimZMin:DimZMax)    
                                               !
    real(8)              :: xza_MixRtPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, LoopNum)
                                               !/ʬ
    integer              :: s
    
    
    !, , ̤
    !ʬʿʬ­
    xz_TempAll = ( xz_PotTemp + xz_PotTempBasicZ ) * ( xz_Exner + xz_ExnerBasicZ )
    xza_MixRtAll = xza_MixRtBasicZ + xza_MixRt
    xza_LatentHeat = 0.0d0
    
    !ν. ΤΤ
    do s = 1, LoopNum
      xza_MixRtPerMolWt(:,:,GasNum(s)) =                 &
        & xza_MixRt(:,:,GasNum(s)) / MolWtWet(GasNum(s))
    end do
    
    !٤θ
    xz_EffPotTemp = xz_PotTemp / xz_PotTempBasicZ 
    
    !ʬ̸ + Ťθ
    xz_EffMolWt =                                           &
      & + sum(xza_MixRtPerMolWt, 3)                         &
      &    / ( 1.0d0 / MolWtDry + xz_MixRtBasicZPerMolWt )  &
      & - sum(xza_MixRt, 3) / ( 1.0d0 + xz_MixRtBasicZ )
    
    !ȯǮ׻
    !  ʬ̤ʬϤĤǤǮ˰¤ƤʤȸʤΤ, 
    !  κ椬λˤ, ǮδͿϥȤʤ褦ĴᤷƤ
    do s = 1, LoopNum
      xza_LatentHeat(:,:,s) =                                 &
        & xz_LatentHeat( SpcWetID(CloudNum(s)), xz_TempAll )  &
        &  * xza_MixRtAll(:,:,GasNum(s))                      &
        &  * ( 5.0d-1 + sign( 5.0d-1, (xza_MixRtAll(:,:,CloudNum(s)) - 1.0d-4) ) )
    end do
    xz_EffHeat = sum( xza_LatentHeat, 3 ) / ( CpDry * xz_ExnerBasicZ ) 
    
    !ήȻλȯŸϹ
    xz_BuoyMoistKm = &
      &  - 3.0d0 * Grav * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 )     &
      &    * xz_avr_xr(                                             &
      &        xr_dz_xz(                                            &
      &           xz_EffHeat                                        &
      &         + xz_PotTempBasicZ / xz_EffMolWtBasicZ              &
      &           * ( 1.0d0 + xz_EffPotTemp + xz_EffMolWt )         &
      &         )                                                   &
      &      )                                                      &
      &    / ( 2.0d0 * xz_PotTempBasicZ / xz_EffMolWtBasicZ)                   

  end function xz_BuoyMoistKm
    

!!!------------------------------------------------------------------------!!!
  function xr_BuoyMolWt(xza_MixRt)
    !
    ! ľαư˸ϹΤ, 
    ! ʬ̤θ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xr_BuoyMolWt(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    real(8)              :: xza_MixRtPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, LoopNum)
                                               !/ʬ
    integer              :: s
    
    !
    xr_BuoyMolWt           = 0.0d0

    !ν. ΤΤ
    do s = 1, LoopNum
      xza_MixRtPerMolWt(:,:,GasNum(s)) =                 &
        & xza_MixRt(:,:,GasNum(s)) / MolWtWet(GasNum(s))
    end do
    
    !Ϲη׻
    xr_BuoyMolWt =                                             &
      & + Grav * xr_avr_xz( sum(xza_MixRtPerMolWt, 3) )        &
      &    / ( 1.0d0 / MolWtDry + xr_MixRtBasicZPerMolWt )     &
      & - Grav * xr_avr_xz( sum(xza_MixRt(:,:,1:LoopNum), 3) ) &
      &    / ( 1.0d0 + xr_MixRtBasicZ )

  end function xr_BuoyMolWt


!!!------------------------------------------------------------------------!!!
  function xr_BuoyDrag(xza_MixRt) 
    !
    ! ľαư˸ϹΤ, 
    ! ŤΤθ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xr_BuoyDrag(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    !
    xr_BuoyDrag           = 0.0d0

    !Ϲη׻
    xr_BuoyDrag =                                                     &
      & - Grav * xr_avr_xz( sum(xza_MixRt(:,:,LoopNum+1:SpcNum), 3) ) &
      &    / ( 1.0d0 + xr_MixRtBasicZ )

  end function xr_BuoyDrag

end module MoistBuoyancy
