!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Module NumDiffusion
!
!   * Developer: SUGIYAMA Ko-ichiro
!   * Version: $Id: numdiffusion.f90,v 1.7 2006/09/03 12:36:48 sugiyama Exp $
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview
!
!ͳȻη׻⥸塼
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module NumDiffusion
  !
  !ͳȻη׻⥸塼
  !ߤ 2 濴ʬ
  !

  !⥸塼ɤ߹
  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 DelX,              &! X γʻֳ
    &                 DelZ                ! Z γʻֳ
  use timeset, only:  DelTimeLong         !Ĺ֥ƥå
  use differentiate_center2, only: xz_dx_pz, xz_dz_xr, &
    &                              xr_dx_pr, xr_dz_xz, &
    &                              pz_dx_xz, pz_dz_pr, &
    &                              pr_dx_xr, pr_dz_pz
  use StoreSet, only: StoreDiff

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public NumDiffusion_Init
  public xz_NumDiffScalar
  public xz_NumDiffScalar2
  public pz_NumDiffVelX
  public xr_NumDiffVelZ

  !ѿ
  real(8)  :: NuH   = 0.0d0   !Ǵη (ʿ)
  real(8)  :: NuV   = 0.0d0   !Ǵη (ľ)
  real(8)  :: Alpha = 1.0d-4
 
  save NuH, NuV, Alpha

contains

!!!-------------------------------------------------------------------!!!
  subroutine NumDiffusion_init()
    !
    ! NumDiffusion ⥸塼ν롼
    !

    !ۤηػ
    implicit none
    
    ! CReSS ޥ˥奢Ǥ, 2 濴ʬξ, Alpha < 1/8 餤ŬȽҤ٤Ƥ. 
    ! deepconv Ǥ NuH Ȥ 500 ʾͤäƤ,
    NuH  = Alpha * ( DelX ** 2.0d0 ) / DelTimeLong
    NuV  = Alpha * ( DelZ ** 2.0d0 ) / DelTimeLong
    
    !ǧ
    write(*,*) "NumDiffusion_init, NuH: ", NuH
    write(*,*) "NumDiffusion_init, NuV: ", NuV

  end subroutine NumDiffusion_init

!!!-------------------------------------------------------------------!!!
  function xz_NumDiffScalar(xz_Scalar)
    !
    ! x, z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_Scalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼
    real(8)             :: xz_NumDiffScalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿοͳȻ
    
    xz_NumDiffScalar = 0.0d0  !
    xz_NumDiffScalar =   &
      &    NuH * (xz_dx_pz(pz_dx_xz( xz_Scalar ))) &
      &  + NuV * (xz_dz_xr(xr_dz_xz( xz_Scalar ))) 
    
  end function xz_NumDiffScalar


!!!-------------------------------------------------------------------!!!
  function xz_NumDiffScalar2(xz_Scalar)
    !
    ! x, z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_Scalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼
    real(8)             :: xz_NumDiffScalar2(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿοͳȻ
    
    xz_NumDiffScalar2 = 0.0d0  !
    xz_NumDiffScalar2 =   &
      &    NuH * (xz_dx_pz(pz_dx_xz( xz_Scalar ))) &
      &  + NuV * (xz_dz_xr(xr_dz_xz( xz_Scalar ))) 
    
  end function xz_NumDiffScalar2


!!!-------------------------------------------------------------------!!!
  function pz_NumDiffVelX(pz_VarX)
    !
    ! z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VarX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʪ
    real(8)             :: pz_NumDiffVelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ͳȻ
    
    pz_NumDiffVelX = 0.0d0  !
    pz_NumDiffVelX = &
      &   NuH * ( pz_dx_xz( xz_dx_pz( pz_VarX ) ) ) &
      & + NuV * ( pz_dz_pr( pr_dz_pz( pz_VarX ) ) )
    
  end function pz_NumDiffVelX
  

!!!-------------------------------------------------------------------!!!  
  function xr_NumDiffVelZ(xr_VarZ)
    !
    ! x ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xr_VarZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʪ
    real(8)             :: xr_NumDiffVelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ͳȻ

    xr_NumDiffVelZ = 0.0d0 
    xr_NumDiffVelZ = &
      &   NuH * ( xr_dx_pr( pr_dx_xr( xr_VarZ ) ) ) &
      & + NuV * ( xr_dz_xz( xz_dz_xr( xr_VarZ ) ) )
    
  end function xr_NumDiffVelZ

end module NumDiffusion
