!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2006. All rights reserved.
!---------------------------------------------------------------------
!= Module Differentiate_Center4
!
!   * Developer: KITAMORI Taichi, SUGIYAMA Ko-ichiro
!   * Version: $Id: differentiate_center4.f90,v 1.2 2006/06/17 10:21:45 sugiyama Exp $ 
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview 
!
!4 ʬ黻ԤδؿޤȤ᤿ѥå⥸塼
!ʿ Arakawa-C, ľ Lorentz åɤǤʬ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!ܥ⥸塼Ƥؿ, ⥸塼 differentiate_center2 
!줿ؿƱǤ. 
!
!== Future Plans
!

module differentiate_center4
  !
  !4 ٤ʬ黻ԤδؿޤȤ᤿ѥå⥸塼
  !ʿ Arakawa-C, ľ Lorentz åɤǤʬ׻
  !

  !⥸塼ɤ߹
  use gridset,    only: DimXMin,  &!  X β
    &                   DimXMax,  &!  X ξ
    &                   DimZMin,  &!  Z β
    &                   DimZMax,  &!  Z ξ
    &                   DelX,     &! X γʻֳ
    &                   DelZ       ! Z γʻֳ

  !ۤηػ
  implicit none

  !ޤ private °
  private 
  
  !ؿ public ˤ
  public xz_dx_pz
  public xz_dz_xr
  public pz_dx_xz
  public pz_dz_pr
  public xr_dz_xz
  public xr_dx_pr
  public pr_dx_xr
  public pr_dz_pz


contains 

!!!--------------------------------------------------------------------------
  function xz_dx_pz( pz_var ) 
    !
    ! x, z ȾʻҤ줿Ǥ x  4 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xz_dx_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ

    xz_dx_pz = 1.0d-16 
    xz_dx_pz(DimXMin+2:DimXMax-1,DimZMin:DimZMax) =         &
      &   (                                                 &
      &       pz_var(DimXMin+2:DimXMax-1,DimZMin:DimZMax)   &
      &     - pz_var(DimXMin+1:DimXMax-2,DimZMin:DimZMax)   &
      &    ) * 9.0d0 / (8.0d0 * DelX )                      &
      & -                                                   &
      &   (                                                 &
      &       pz_var(DimXMin+3:DimXMax,DimZMin:DimZMax)     &
      &     - pz_var(DimXMin:DimXMax-3,DimZMin:DimZMax)     &
      &    ) / ( 24.0d0 * DelX )

  end function xz_dx_pz


!!!--------------------------------------------------------------------------
  function xz_dz_xr( xr_var ) 
    !
    ! x, z ȾʻҤ줿Ǥ z  4 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xz_dz_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    xz_dz_xr = 1.0d-16 
    xz_dz_xr(DimXMin:DimXMax,DimZMin+2:DimZMax-1) =           &
      &   (                                                   &
      &        xr_var(DimXMin:DimXMax,DimZMin+2:DimZMax-1)    &
      &      - xr_var(DimXMin:DimXMax,DimZMin+1:DimZMax-2)    &
      &    ) * 9.0d0 / ( 8.0d0 * DelZ )                       &
      & -                                                     &
      &   (                                                   &
      &       xr_var(DimXMin:DimXMax,DimZMin+3:DimZMax)       &
      &     - xr_var(DimXMin:DimXMax,DimZMin:DimZMax-3)       &
      &    ) / ( 24.0d0 * DelZ )

  end function xz_dz_xr


!!!--------------------------------------------------------------------------
  function pz_dx_xz( xz_var ) 
    !
    ! z ȾʻҤ줿Ǥ x  4 ʬ黻
    !
   
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pz_dx_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ

    pz_dx_xz = 1.0d-16
    pz_dx_xz(DimXMin+1:DimXMax-2,DimZMin:DimZMax) =          &
      &   (                                                  &
      &       xz_var(DimXMin+2:DimXMax-1,DimZMin:DimZMax)    &
      &     - xz_var(DimXMin+1:DimXMax-2,DimZMin:DimZMax)    &
      &    ) * 9.0d0 / ( 8.0d0 * DelX )                      &
      & -                                                    &
      &   (                                                  &
      &       xz_var(DimXMin+3:DimXMax,DimZMin:DimZMax)      &
      &     - xz_var(DimXMin:DimXMax-3,DimZMin:DimZMax)      &
      &    ) / ( 24.0d0 * DelX )
  end function pz_dx_xz
  

!!!--------------------------------------------------------------------------  
  function pz_dz_pr( pr_var )
    !
    ! z ȾʻҤ줿Ǥ z  4 ʬ黻
    !

    !ۤηػ
    implicit none
    
    real(8), intent(in) :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pz_dz_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    pz_dz_pr = 1.0d-16
    pz_dz_pr(DimXMin:DimXMax, DimZMin+2:DimZMax-1) =        &
      &   (                                                 &
      &       pr_var(DimXMin:DimXMax,DimZMin+2:DimZMax-1)   &
      &     - pr_var(DimXMin:DimXMax,DimZMin+1:DimZMax-2)   &
      &    ) * 9.0d0 / ( 8.0d0 * DelZ )                     &
      & -                                                   &
      &   (                                                 &
      &       pr_var(DimXMin:DimXMax,DimZMin+3:DimZMax)     &
      &     - pr_var(DimXMin:DimXMax,DimZMin:DimZMax-3)     &
      &    ) / ( 24.0d0 * DelZ )
    
  end function pz_dz_pr
  

!!!--------------------------------------------------------------------------
  function xr_dx_pr( pr_var ) 
    !
    ! x ȾʻҤ줿Ǥ x  4 ʬ黻
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: xr_dx_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    xr_dx_pr = 1.0d-16
    xr_dx_pr(DimXMin+2:DimXMax-1, DimZMin:DimZMax) =        &
      &   (                                                 &
      &       pr_var(DimXMin+2:DimXMax-1,DimZMin:DimZMax)   &
      &     - pr_var(DimXMin+1:DimXMax-2,DimZMin:DimZMax)   &
      &    ) * 9.0d0 / ( 8.0d0 * DelX )                     &
      & -                                                   &   
      &   (                                                 &
      &       pr_var(DimXMin+3:DimXMax,DimZMin:DimZMax)     &
      &     - pr_var(DimXMin:DimXMax-3,DimZMin:DimZMax)     &
      &     ) / ( 24.0d0 * DelX )
    
  end function xr_dx_pr


!!!--------------------------------------------------------------------------
  function xr_dz_xz( xz_var ) 
    !
    ! x ȾʻҤ줿Ǥ z  4 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ    
    real(8)             :: xr_dz_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    xr_dz_xz = 1.0d-16 
    xr_dz_xz(DimXMin:DimXMax,DimZMin+1:DimZMax-2) =         &
      &   (                                                 &
      &       xz_var(DimXMin:DimXMax,DimZMin+2:DimZMax-1)   &
      &     - xz_var(DimXMin:DimXMax,DimZMin+1:DimZMax-2)   &
      &    ) * 9.0d0 / ( 8.0d0 * DelZ )                     &
      & -                                                   &
      &   (                                                 &
      &       xz_var(DimXMin:DimXMax,DimZMin+3:DimZMax)     &
      &     - xz_var(DimXMin:DimXMax,DimZMin:DimZMax-3)     &
      &    ) / ( 24.0d0 * DelZ )
    
  end function xr_dz_xz


!!!--------------------------------------------------------------------------
  function pr_dx_xr( xr_var )
    !
    !ʻǤ x  4 ʬ黻
    !

    !ۤηػ
    implicit none

    !ѿ    
    real(8), intent(in) :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pr_dx_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ
    
    pr_dx_xr = 1.0d-16
    pr_dx_xr(DimXMin+1:DimXMax-2, DimZMin:DimZMax) =        &
      &   (                                                 &
      &       xr_var(DimXMin+2:DimXMax-1,DimZMin:DimZMax)   &
      &     - xr_var(DimXMin+1:DimXMax-2,DimZMin:DimZMax)   &
      &    ) * 9.0d0 / ( 8.0d0 * DelX )                     &
      & -                                                   &
      &   (                                                 &
      &       xr_var(DimXMin+3:DimXMax,DimZMin:DimZMax)     &
      &     - xr_var(DimXMin:DimXMax-3,DimZMin:DimZMax)     &
      &    ) / ( 24.0d0 * DelX)
    
  end function pr_dx_xr
  
  
!!!-------------------------------------------------------------------------
  function pr_dz_pz( pz_var )
    !
    !ʻǤ x  4 ʬ黻
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ黻оݤȤʤѿ
    real(8)             :: pr_dz_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʬ    

    pr_dz_pz = 1.0d-16
    pr_dz_pz(DimXMin:DimXMax, DimZMin+1:DimZMax-2) =        &
      &   (                                                 &
      &       pz_var(DimXMin:DimXMax,DimZMin+2:DimZMax-1)   &
      &     - pz_var(DimXMin:DimXMax,DimZMin+1:DimZMax-2)   &
      &    ) * 9.0d0 / ( 8.0d0 * DelZ )                     &
      & -                                                   &
      &   (                                                 &
      &       pz_var(DimXMin:DimXMax,DimZMin+3:DimZMax)     &
      &     - pz_var(DimXMin:DimXMax,DimZMin:DimZMax-3)     &
      &    ) / ( 24.0d0 * DelZ )
    
  end function pr_dz_pz
  
end module differentiate_center4
