!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2006. All rights reserved.
!---------------------------------------------------------------------
!= Module StoreSet
!
!   * Developer: SUGIYAMA Ko-ichiro 
!   * Version: $Id: storeset.f90,v 1.2 2006/09/03 12:36:48 sugiyama Exp $ 
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview 
!
!ѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module storeset
  !
  !ѻͤݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax,     & ! x ʪΰξ
    &                  RegZMin,     & ! z ʪΰβ
    &                  RegZMax        ! z ʪΰξ
  use TimeSet, only:   TimeDisp, DelTimeLong

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  real(8), allocatable :: z_Adv(:)
  real(8), allocatable :: z_Turb(:)
  real(8), allocatable :: z_Disp(:)
  real(8), allocatable :: z_Diff(:)
  real(8), allocatable :: z_Rad(:)
  real(8), allocatable :: z_Damp(:)
  real(8), allocatable :: z_Cond(:)
  real(8), allocatable :: xz_Adv(:,:)
  real(8), allocatable :: xz_Turb(:,:)
  real(8), allocatable :: xz_Disp(:,:)
  real(8), allocatable :: xz_Diff(:,:)
  real(8), allocatable :: xz_Rad(:,:)
  real(8), allocatable :: xz_Damp(:,:)
  real(8), allocatable :: xz_Cond(:,:)

contains

  subroutine StoreSet_Init( )
    !롼

    allocate(     &
      & z_Adv(DimZMin:DimZMax),  & 
      & z_Turb(DimZMin:DimZMax), &
      & z_Disp(DimZMin:DimZMax), &
      & z_Diff(DimZMin:DimZMax), &
      & z_Rad(DimZMin:DimZMax),  &
      & z_Damp(DimZMin:DimZMax), &
      & z_Cond(DimZMin:DimZMax), &
      & xz_Adv(DimXMin:DimXMax, DimZMin:DimZMax),  & 
      & xz_Turb(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Disp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Diff(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Rad(DimXMin:DimXMax, DimZMin:DimZMax),  &
      & xz_Damp(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_Cond(DimXMin:DimXMax, DimZMin:DimZMax)  &
      &  )
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
   
  end subroutine StoreSet_Init


  subroutine StoreClean( )
    !ݴɤͤΥꥢ
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0

    xz_Adv  = 0.0d0
    xz_Turb = 0.0d0
    xz_Diff = 0.0d0
    xz_Disp = 0.0d0
    xz_Rad  = 0.0d0
    xz_Damp = 0.0d0
    xz_Cond = 0.0d0
   
  end subroutine StoreClean


  subroutine StoreMeanX( )
    !ݴɤͤοʿʿ
    
    z_Adv  = sum( xz_Adv(RegXMin:RegXMax, :), 1 )  / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Turb = sum( xz_Turb(RegXMin:RegXMax, :), 1 ) / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Diff = sum( xz_Diff(RegXMin:RegXMax, :), 1 ) / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Disp = sum( xz_Disp(RegXMin:RegXMax, :), 1 ) / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Rad  = sum( xz_Rad(RegXMin:RegXMax, :), 1 )  / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Damp = sum( xz_Damp(RegXMin:RegXMax, :), 1 ) / (RegXMax - RegXMin + 1) &
      &      * DelTimeLong * 2.0d0 / TimeDisp
    z_Cond = sum( xz_Cond(RegXMin:RegXMax, :), 1 ) / (RegXMax - RegXMin + 1) &
      &      / TimeDisp
    
  end subroutine StoreMeanX


  subroutine StoreAdv( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Adv + Work
    xz_Adv = Work2

  end subroutine StoreAdv


  subroutine StoreTurb( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Turb + Work
    xz_Turb = Work2

  end subroutine StoreTurb


  subroutine StoreDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Diff + Work
    xz_Diff = Work2

  end subroutine StoreDiff


  subroutine StoreDisp( Work )
    !Ǯݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Disp + Work
    xz_Disp = Work2

  end subroutine StoreDisp


  subroutine StoreRad( Work )
    !ѹݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2  = xz_Rad + Work
    xz_Rad = Work2

  end subroutine StoreRad


  subroutine StoreDamp( Work )
    !ԥ󥰹ݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Damp + Work
    xz_Damp = Work2

  end subroutine StoreDamp


  subroutine StoreCond( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax)

    Work2   = xz_Cond + Work
    xz_Cond = Work2

  end subroutine StoreCond


end module storeset
