!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Module HeatFlux
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatugu
!   * Version: $Id: heatflux.f90,v 1.9 2006/09/14 14:10:29 odakker Exp $
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview
!
!ǤΥեåη׻⥸塼
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * 1.5 Υ㡼Ѥ
!  * 꼰 CReSS Υޥ˥奢򻲾Ȥ
!
!== Future Plans
!
!

module HeatFlux
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use gridset,  only: DimXMin,         & !x β
    &                 DimXMax,         & !x ξ
    &                 DimZMin,         & !z β
    &                 DimZMax,         & !z ξ
    &                 RegZMin,         & !z ʪΰβ
    &                 DelZ               !z γʻֳ
  use basicset, only: xz_ExnerBasicZ,  & !ʡؿδܾ
    &                 xz_PotTempBasicZ,& !̤δܾ
    &                 TempSfc            !ɽ̲


  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public xz_HeatFluxBulk
  public xz_MixRtFluxBulk

  !ѿ
  real(8)  :: Bulk = 1.5d-3        !Ǯư̥եåΥХ륯

  !ͤ¸
  save Bulk

contains


!!!------------------------------------------------------------------------!!!
  function xz_HeatFluxBulk( xz_PotTemp )
    !
    !ɽǮեå(ñ̤ W/m^2)Х륯ˡǷ׻. 
    !絤β٤ϴܾβ٤˸ꤷ, 
    !ޤʿ®٤ 100 m/s ˸ꤹ. 
    !
    !Ǯեå Cp \bar{ w} = Cm Cp V (Ta-TG)
    !ѷ, \bar{ w} = Cm V (a-G)
    !\DP{\bar{ w}}{z} = Cm V (a-G) /dz
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8)               :: xz_HeatFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)  :: VelX = 10.0d0              !ؤǤοʿ®٤ᤦ

    !
    !  * Ƥͤ򥼥˸
    xz_HeatFluxBulk = 0.0d0
    
    !ɽǮեå׻
    !  * ñ̤ K/s
    !  * ʡؿϴܾͤɽ.     
    !  * ʻ xz Ǥ, ʪΰκǲüź RegZMin+1
    !    եå, RegZMin+1, RegZMin+2 Ǥͤκ㤵.
    !  * ಹ(ɽ̲) TempSfc ˤ.    
    !
    xz_HeatFluxBulk(:,RegZMin+1) =                        &
      & max(                                              &
      &         0.0d0,                                    &
      &       - Bulk * VelX * xz_ExnerBasicZ(:,RegZMin+1) &
      &          * xz_PotTemp(:,RegZMin+1) / DelZ         &
      &    )
    
  end function xz_HeatFluxBulk
  
!!!------------------------------------------------------------------------!!!
  function xz_MixRtFluxBulk( xz_MixRt )
    !
    !ɽ MixRt եåХ륯ˡǷ׻. 
    !絤β٤ϴܾβ٤˸ꤷ, 
    !ޤʿ®٤ 100 m/s ˸ꤹ. 
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_MixRt(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8)               :: xz_MixRtFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)  :: VelX = 100.0d0             !ؤǤοʿ®٤ᤦ

    !
    !  * Ƥͤ򥼥˸
    xz_MixRtFluxBulk = 0.0d0
    
    xz_MixRtFluxBulk(:,RegZMin+1) =                        &
      & max(                                               &         
      &         0.0d0,                                     &
      &       - Bulk * VelX * xz_MixRt(:,RegZMin+1) / DelZ &
      &    )
    
  end function xz_MixRtFluxBulk
  
end module HeatFlux
