#!/usr/bin/env ruby

require "numru/ggraph"
require "getoptlong" 
include NumRu


basic1   = "PotTempBasicZ"
disturb1 = "PotTemp"
gphys_b1 = GPhys::IO.open( ARGV[0], basic1 ) 
gphys_d1 = GPhys::IO.open( ARGV[0], disturb1 )

basic2   = "MixRtVBasicZ"
disturb2 = "MixRtV"
gphys_b2 = GPhys::IO.open( ARGV[0], basic2 ) 
gphys_d2 = GPhys::IO.open( ARGV[0], disturb2 )


DCL::swpset('IHEIGHT', 600 )
DCL::swpset('IWIDTH',  600 )

DCL.gropn( 2 )
DCL.sgpset('lfull',true) 
DCL.sglset('lclip',true)
DCL.sgpset('lcntl', false) 

DCL.uzfact(0.7)
GGraph.line( gphys_b1.cut(12000,0.0..15000,false) + gphys_d1.cut(12000,0.0..15000,false), true, 'index'=>43, 'exchange'=>true )
GGraph.line( gphys_b1.cut(12000,false), false, 'index'=>23, 'exchange'=>true )

GGraph.line( gphys_b2.cut(12000,0.0..15000,false) + gphys_d2.cut(12000,0.0..15000,false), true, 'index'=>43, 'exchange'=>true )
GGraph.line( gphys_b2.cut(12000,false), false, 'index'=>23, 'exchange'=>true )

DCL.grcls

