!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005, 2006. All rights reserved.
!---------------------------------------------------------------------
!= Subroutine WarmRainPrm
!
!   * Developer: SUGIYAMA Ko-ichiro
!   * Version: $Id: warmrainprm.f90,v 1.13 2006/09/14 14:10:19 odakker Exp $
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview
!
!ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
!   *  (1994) Ѥ꼰򤽤Τޤ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module WarmRainPrm
  !
  !ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
  !   *  (1994) Ѥ꼰򤽤Τޤ. 
  ! 
  
  !⥸塼ɤ߹
  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum              !ؼο
  use basicset, only: PressBasis,        &!̤δవ 
    &                 CpDry,             &!ʬǮ
    &                 MolWtWet,          &!
    &                 MolWtDry,          &!
    &                 SpcWetID,          &!
    &                 SpcWetSymbol,      &!
    &                 xz_DensBasicZ,     &!ܾ̩
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_ExnerBasicZ,    &!̵ܾ
    &                 xza_MixRtBasicZ,   &!ܾκ
    &                 GasRDry             !ʬε 
  use average,  only: xz_avr_xr        
  use differentiate_center2, only: xr_dz_xz
  use ChemData, only: ChemData_OneSpcID
  use ChemCalc, only: xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use MoistFunc,only: xz_DelMixRtNH4SH
  use StoreSet, only: StoreCond
  
  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public WarmRainPrm_Init
  public WarmRainPrm_prm
  public xz_Rain2GasHeat
  public xz_Rain2GasHeatNH4SH
  public xza_Rain2Gas
  public xza_Rain2GasNH4SH
  public xza_Cloud2Rain
  public xz_FallRain

  real(8)      :: FactorJ  = 3.0d0    ! 絤ѤΥѥ᡼
                                      ! ϵѤˤ 1.0d0 Ȥ
  integer      :: LoopNum      = 0
  integer      :: LoopNum2     = 0
  integer      :: GasNum(10)   = 0
  integer      :: CloudNum(10) = 0
  integer      :: RainNum(10)  = 0
  integer      :: NH3Num   = 0
  integer      :: H2SNum   = 0
  integer      :: NH4SHCloudNum = 0
  integer      :: NH4SHRainNum = 0
  real(8), allocatable :: RainSW(:)

  save FactorJ
  save LoopNum, LoopNum2, RainNum, CloudNum, GasNum
  save NH3Num, H2SNum, NH4SHCloudNum, NH4SHRainNum
  save RainSW

contains  

!!!=================================================================================!!!
  subroutine WarmRainPrm_Init()

    !ۤηػ
    implicit none

    !ѿ
    integer                  :: s
    integer                  :: n1, n2    

    !-----------------------------------------------------------
    ! γȱγȵΤ ID Ȥ
    !-----------------------------------------------------------
    !
    allocate( RainSW(SpcNum) )
    LoopNum  = 0
    LoopNum2 = 0
    RainSW   = 0.0d0

    !ؼ椫鱫γΤ, źʬ̤ݴ.
    SelectCloud: do s = 1, SpcNum

      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      if (n1 /= 0) then
        LoopNum           = LoopNum + 1
        GasNum(LoopNum)   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID(SpcWetSymbol(s)(1:n1-3) // '-g'))
        CloudNum(LoopNum) = s
      end if

      !'Rain' Ȥʸ󤬴ޤޤΤθĿ
      n2 = index(SpcWetSymbol(s), '-Rain' )
      if (n2 /= 0) then
        LoopNum2          = LoopNum2 + 1
        RainNum(LoopNum2) = s
        RainSW(s)         = 1.0d0
      end if

      ! NH4SH ¸ߤ LoopNum  1 ĸ餹
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 
        LoopNum = LoopNum - 1
      end if

    end do SelectCloud
    
    !-----------------------------------------------------------
    ! β˥, ӥ˥βǤ ID 
    !   'Cloud'  'Rain' ¸ߤȲꤷƤ
    !-----------------------------------------------------------
    NH3Num   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('NH3-g'))
    H2SNum   = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('H2S-g'))
    NH4SHCloudNum = minloc(SpcWetID, 1, SpcWetID == ChemData_OneSpcID('NH4SH-s'))
    NH4SHRainNum  = NH4SHCloudNum + 1

    !-----------------------------------------------------------
    ! ǧ
    !-----------------------------------------------------------
    if ( LoopNum == 0 ) then 
      write(*,*) "WarmRainPrm: CloudNum = 0, please comment out of WarmRainPrm"
!      stop
    end if

    write(*,*) "WarmRainPrm_Init, LoopNum:  ", LoopNum
    write(*,*) "WarmRainPrm_Init, LoopNum2: ", LoopNum2
    write(*,*) "WarmRainPrm_Init, GasNum:   ", GasNum    
    write(*,*) "WarmRainPrm_Init, CloudNum: ", CloudNum
    write(*,*) "WarmRainPrm_Init, RainNum:  ", RainNum    
    write(*,*) "WarmRainPrm_Init, RainSW:   ", RainSW
    write(*,*) "WarmRainPrm_Init, NH3Num:   ", NH3Num
    write(*,*) "WarmRainPrm_Init, H2SNum:   ", H2SNum
    write(*,*) "WarmRainPrm_Init, NH4SHNum: ", NH4SHCloudNum
    write(*,*) "WarmRainPrm_Init, NH4SHNum: ", NH4SHRainNum

  end subroutine WarmRainPrm_Init


  subroutine WarmRainPrm_prm( M1, MA, MB, M2, M3, M4, M5, M6 )
    
    implicit none
    integer, intent(out) ::  M1, MA, MB(10), M2(10), M3(10), M4, M5, M6

    M1 = LoopNum
    MA = LoopNum2
    MB = RainNum
    M2 = CloudNum
    M3 = GasNum    
    M4 = NH3Num
    M5 = H2SNum
    M6 = NH4SHCloudNum

    write(*,*) M1, MA, MB, M2, M3, M4, M5, M6 
  end subroutine WarmRainPrm_prm

!!!=================================================================================!!!  
  function xza_Rain2Gas(xz_Exner, xz_PotTemp, xza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
    ! ξ, FactorJ Ѵ̤®. 
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8)             :: DelTime        !ֹ
    real(8)             :: xza_Rain2Gas(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(8)             :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_NonSaturate(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xz_TempAll   = ( xz_PotTemp + xz_PotTempBasicZ ) * ( xz_Exner + xz_ExnerBasicZ )
    xz_PressAll  = PressBasis * ((xz_Exner + xz_ExnerBasicZ) ** (CpDry / GasRDry))
    xza_Rain2Gas = 0.0d0
 
    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )
    
    do s = 1, LoopNum
          
      !˰¾Ⱥκ(˰)׻. 
      !  ؤѴ̤˰٤㤹.
      xz_NonSaturate =                                       &
        & max(                                               &
        &   0.0d0,                                           &
        &   xz_SvapPress(SpcWetID(CloudNum(s)), xz_TempAll)  &
        &     * MolWtWet(CloudNum(s))                        &
        &     / ( MolWtDry * xz_PressAll)                    &
        &     - xza_MixRtAll(:,:,GasNum(s))                  &
        &    )
      
      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      xza_Rain2Gas(:,:,RainNum(s)) =                                       &
        & - min(                                                           &
        &    DelTime * 4.85d-2 * FactorJ * xz_NonSaturate                  &
        &     * ( xza_MixRtAll(:,:,RainNum(s)) * xz_DensBasicZ )** 0.65d0, &
        &    xza_MixRtAll(:,:,RainNum(s))                                  &
        &   ) 
      
      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      xza_Rain2Gas(:,:,GasNum(s)) = - xza_Rain2Gas(:,:,RainNum(s)) 
    end do
    
  end function xza_Rain2Gas
  

!!!=================================================================================!!!  
  function xza_Rain2GasNH4SH(xz_Exner, xz_PotTemp, xza_MixRt, DelTime)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8), intent(in) :: DelTime        !ֹ
    real(8)             :: xza_Rain2GasNH4SH(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ + ʿʬ
    real(8)             :: xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !Ϥξʬ + ʿʬ
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_NonSaturate(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤˰(˰ºȾκκ)

    !, , ̤
    !ʬʿʬ­
    xz_TempAll   = ( xz_PotTemp + xz_PotTempBasicZ ) *  ( xz_Exner + xz_ExnerBasicZ )
    xz_PressAll  = PressBasis * ((xz_Exner + xz_ExnerBasicZ) ** (CpDry / GasRDry))    
    xza_Rain2GasNH4SH = 0.0d0

    !ͤǤ뤳Ȥݾ
    !ήȻ׻ˤʤ뤳ȤΤ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )
        
    !˰¾Ⱥκ(˰)׻. 
    !  ؤѴ̤˰٤㤹.
    !  ̤˰٤᤿Τ, ޥʥ򤫤Ƥ
    !  (DelMixRtNH4SH , NH4SH ä, ʤ˰٤ȤƤ)
    xz_NonSaturate =                                                 &
      & max(                                                         &
      &  0.0d0,                                                      &
      &   - xz_DelMixRtNH4SH(                                        &
      &       xz_TempAll, xz_PressAll,                               &
      &       xza_MixRtAll(:,:,NH3Num), xza_MixRtAll(:,:,H2SNum),    &
      &       MolWtWet(NH3Num), MolWtWet(H2SNum)                     &
      &     )                                                        &
      &  )
        
    !Ѵ
    !  αγκʾ˾ȯʤ褦˾ͤ
    xza_Rain2GasNH4SH(:,:,NH4SHRainNum) =                         &
      & - min(                                                    &
      &     DelTime * 4.85d-2 * FactorJ * xz_NonSaturate          &
      &      * (                                                  &
      &          xza_MixRtAll(:,:,NH4SHRainNum) * xz_DensBasicZ   &
      &         ) ** 0.65d0,                                      &
      &     xza_MixRtAll(:,:,NH4SHRainNum)                        &
      &    ) 
        
    !Ѵ
    !  γѴ̤Ȥ椬դȤʤ
    xza_Rain2GasNH4SH(:,:,NH3Num) =                              &
      & - xza_Rain2GasNH4SH(:,:,NH4SHRainNum) * MolWtWet(NH3Num) &
      &   / MolWtWet(NH4SHRainNum)
    xza_Rain2GasNH4SH(:,:,H2SNum) =                              &
      & - xza_Rain2GasNH4SH(:,:,NH4SHRainNum) * MolWtWet(H2SNum) &
      &   / MolWtWet(NH4SHRainNum)
    
  end function xza_Rain2GasNH4SH
    

!!!=================================================================================!!!  
  function xz_Rain2GasHeatNH4SH(xz_Exner, xza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8)             :: xz_Rain2GasHeatNH4SH(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !
    real(8)             :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax)

    !Ϥ̤
    !ʬʿʬ­
    xz_ExnerAll    = xz_Exner + xz_ExnerBasicZ

    !ؤѲȼȯǮ
    xz_Rain2GasHeatNH4SH =                                &
      & ReactHeatNH4SH * xza_DelMixRt(:,:,NH4SHRainNum)   &
      &  / (xz_ExnerAll * CpDry)

    !ͤݴ
    call StoreCond( xz_Rain2GasHeatNH4SH ) 

  end function xz_Rain2GasHeatNH4SH
  

!!!=================================================================================!!!  
  function xz_Rain2GasHeat(xz_PotTemp, xz_Exner, xza_DelMixRt)
    !
    ! γؤѴ̤׻뤿Υ롼
    !
    ! Ѵ̤, ȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! Ѵʤ褦, αγѴ̤ξ¤ȤƤ.
    !
        
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !̤ξʬ
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !٤ξʬ 
    real(8), intent(in) :: xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !Ѳ
    real(8)             :: xz_Rain2GasHeat(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xza_LatentHeat(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)             :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xz_ExnerAll(DimXMin:DimXMax, DimZMin:DimZMax)
    integer             :: s

    !, , ̤
    !ʬʿʬ­
    xz_ExnerAll    = xz_Exner + xz_ExnerBasicZ
    xz_TempAll     = ( xz_PotTemp + xz_PotTempBasicZ ) *  ( xz_Exner + xz_ExnerBasicZ )
    xza_LatentHeat = 0.0d0

    !ؤѲȼȯǮ    
    do s = 1, LoopNum
      xza_LatentHeat(:,:,s) =                                &
        & xz_LatentHeat( SpcWetID(RainNum(s)), xz_TempAll )  &
        &  * xza_DelMixRt(:,:,RainNum(s))                    &
        &  / (xz_ExnerAll * CpDry) 
    end do
    xz_Rain2GasHeat = sum( xza_LatentHeat, 3 )

    !ͤݴ
    call StoreCond( xz_Rain2GasHeat ) 
    
  end function xz_Rain2GasHeat
  

!!!=================================================================================!!!  
  function xza_Cloud2Rain( xza_MixRt, DelTime )
    !
    ! γ鱫γؤѴ̤׻뤿Υ롼
    ! ʻĹ Berry (1968) Υѥ᥿ꥼѤ, 
    ! ͹Ĺ Kessler (1969) Υѥ᥿ꥼѤ. 
    !
    ! Ѵ̤, γȱγκ̤ʤΤ, ׻
    ! ͤˤʤ뤳ȤݾڤƤ. ޤ, ¸ߤʾαγ
    ! γѴʤ褦, αγѴ̤ξ¤ȤƤ.
    ! ͤݾڤ뤿, ȤƻֹߤɬפȤʤ. 
    ! (AutoConv, Collect ϻֹǤʬͤ׻)
    !
    ! Υ롼Ǥ, ŽʪȿʪȤ̤ɬפʤΤ, 
    ! 롼פ󤹲 LoopNum2 ȤƤ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ
    real(8)             :: DelTime        !ֹ
    real(8)             :: xza_Cloud2Rain(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !鱫ؤѴ
    real(8)             :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                          !ξʬ + ʿʬ
    real(8)             :: xz_AutoConv(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !˰º
    real(8)             :: xz_Collect(DimXMin:DimXMax, DimZMin:DimZMax)
                                          !ʲ줿Ǯ
    real(8), parameter  :: N0 = 5.0d7 
    real(8), parameter  :: D0 = 3.66d-1
    integer             :: s


    xza_Cloud2Rain  = 0.0d0

    !ͤݾ
    !ήȻˤʤ뤳Ȥ⤢Τ. 
    xza_MixRtAll = max( 0.0d0, xza_MixRt + xza_MixRtBasicZ )


    do s = 1, LoopNum2
      xz_AutoConv = 0.0d0
      xz_Collect  = 0.0d0
      
      !ʻĹ
!     !  Kessler (1969) Υѥ᥿ꥼ        
!      xz_AutoConv =                                                 &
!        & 1.0d-3 * DelTime                                          &
!        & * max( 0.0d0, ( xza_MixRtAll(:,:,CloudNum(s)) - 1.0d-3) )
     !  Kessler (1969) Υѥ᥿ꥼ        
      xz_AutoConv =                                                  &
        & 1.0d-2 * DelTime                                           &
        & * max( 0.0d0,  xza_MixRtAll(:,:,CloudNum(s))  )
!          
!      !  Berry (1968) Υѥ᥿ꥼ      
!      xz_AutoConv =                                                   &
!        & DelTime                                                     &
!        & * xz_DensBasicZ                                             &
!        & * ( xza_MixRtAll(:,:,CloudNum(s)) ** 3.0d0  ) * 1.0d6       &
!        & / ( 60.0d0                                                  &
!        &     * (                                                     &
!        &         2.0d0 * xza_MixRtAll(:,:,CloudNum(s))               &
!        &       + 2.66d-8 * N0 / ( xz_DensBasicZ * D0 )               &
!        &      )                                                      &
!        &   )

      !͹Ĺ
      !  Kessler (1969) Υѥ᥿ꥼ    
      xz_Collect =                                               &
        &  DelTime                                               &
        &  * 2.2d0 * FactorJ * xza_MixRtAll(:,:,CloudNum(s))     &
        &  * (                                                   &
        &       xza_MixRtAll(:,:,RainNum(s)) * xz_DensBasicZ     &
        &     ) ** 0.875d0  
      
      !Ѵ: ʻĹȹξͤ
      !  Ѳ̤ͤȤꤹ. ͤȤʤ.
      xza_Cloud2Rain(:,:,CloudNum(s)) =                         &
        & - min(                                                &
        &         xza_MixRtAll(:,:,CloudNum(s)),                &
        &         ( xz_AutoConv + xz_Collect )                  &
        &       )
      
      !Ѵ. ϱѴ̤Ȥȿ. 
      xza_Cloud2Rain(:,:,RainNum(s)) = - xza_Cloud2Rain(:,:,CloudNum(s)) 
          
    end do

!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,1)), maxval(xza_Cloud2Rain(:,:,1))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,2)), maxval(xza_Cloud2Rain(:,:,2))
!    write(*,*) 'C2R: ', minval(xza_Cloud2Rain(:,:,3)), maxval(xza_Cloud2Rain(:,:,3))
    
  end function xza_Cloud2Rain
  

!!!=================================================================================!!!
  function xz_FallRain( xz_MixRt, num )
    !
    ! γˤή. 
    ! 
    ! Υ롼ΰ xz_MixRt  2 Ǥ. 
    ! Ϳ줿Ф, ή׻. 
    ! ⤷, xza_MixRt γκɽʤ(RainSW = 1)ʤ
    ! ͤϤ. 
    ! ⤷, xza_MixRt ⤷ϱγκɽʤ(RainSW = 0)
    ! ʤ, ˤήϥȤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    integer, intent(in) :: num
    real(8), intent(in) :: xz_MixRt(DimXMin:DimXMax, DimZMin:DimZMax)  
                                                 !()
    real(8)             :: xz_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax)  
                                                 !( + ʿѾ)
    real(8)             :: xz_FallRain(DimXMin:DimXMax, DimZMin:DimZMax)
                                                 !γ
    real(8)             :: xz_VelZRain(DimXMin:DimXMax, DimZMin:DimZMax)
                                                 !γ®

    xz_MixRtAll = max( 0.0d0, xz_MixRt + xza_MixRtBasicZ(:,:,num) )
    xz_FallRain = 0.0d0
    xz_VelZRain = 0.0d0

    
    !γü®
    xz_VelZRain = 12.2d0 * FactorJ * ( xz_MixRtAll ** 0.125d0 )
      
    !ˤή
    !  Dens  avr äƤ, 䤬Τ
    xz_FallRain =                                                     &
      &  xz_avr_xr(                                                   &
      &         xr_dz_xz(xz_DensBasicZ * xz_VelZRain * xz_MixRtAll)  &
      &      ) / xz_DensBasicZ                                        &
      &        * RainSW(num)

!    write(*,*) 'MixRt: ', minval( xz_MixRt    ),  maxval( xz_MixRt    )
!    write(*,*) 'Fall:  ', minval( xz_FallRain ),  maxval( xz_FallRain )

  end function xz_FallRain
  
end module WarmRainPrm
