program ArareAnal

  !⥸塼ɤ߹
  use gt4_history
  use fileset
  use gridset 
  use debugset
  use timeset
  use dc_trace
  use dc_string

  use MoistAdjust
  use WarmRainPrm 
  use MoistBuoyancy
  use MoistFunc

  use Average
  use DynFunc
  use basicset
  use boundary
  use Turbulence
  use NumDiffusion

  use radiation
  
  use chemcalc
  use Boundary
  use ECCM

  use StoreSet
  use Damping

  implicit none
  
  !ѿ
  real(8), allocatable :: xz_PotTemp(:,:)
  real(8), allocatable :: xz_PotTempAll(:,:)
  real(8), allocatable :: xz_Exner(:,:)
  real(8), allocatable :: pz_VelX(:,:)
  real(8), allocatable :: xr_VelZ(:,:)
  real(8), allocatable :: xza_MixRt(:,:,:)
  real(8), allocatable :: xza_MixRtAll(:,:,:)
  real(8), allocatable :: xza_MixRtSat(:,:,:)
  real(8), allocatable :: xz_Temp(:,:)
  real(8), allocatable :: xz_VPotTemp(:,:)
  real(8), allocatable :: xz_VPotTempAll(:,:)
  real(8), allocatable :: xza_Rho(:,:,:)
  real(8), allocatable :: xza_CloudPhys1(:,:,:)
  real(8), allocatable :: xza_CloudPhys2(:,:,:)
  real(8), allocatable :: xza_CloudPhys3(:,:,:)
  real(8), allocatable :: xz_BuoyAll(:,:)
  real(8), allocatable :: xz_BuoyTemp(:,:)
  real(8), allocatable :: xz_BuoyMolWt(:,:)
  real(8), allocatable :: xz_BuoyDrag(:,:)
  real(8), allocatable :: xz_Stab(:,:)
  real(8), allocatable :: xz_StabTemp(:,:)
  real(8), allocatable :: xz_StabMolWt(:,:)
  real(8)              :: AnalTime

  real(8), allocatable :: xz_Km(:,:)
  real(8), allocatable :: xz_Km1(:,:)
  real(8), allocatable :: xz_Km2(:,:)
  real(8), allocatable :: xz_Km3(:,:)
  real(8), allocatable :: xz_Km4(:,:)
  real(8), allocatable :: xz_Km5(:,:)

  real(8), allocatable :: xz_TempAll(:,:)
  real(8), allocatable :: xz_PressAll(:,:)
  real(8), allocatable :: xz_DelNH4SH(:,:)
  real(8), allocatable :: xz_EquivConst(:,:)
  real(8), allocatable :: xza_DelMixRt(:,:,:)

  real(8), allocatable :: xz_Cloud(:,:)
  real(8), allocatable :: xz_Rain(:,:)

  integer      :: LoopNum, LoopNum2
  integer      :: GasNum(10)
  integer      :: CloudNum(10)
  integer      :: RainNum(10)
  integer      :: NH3Num  
  integer      :: H2SNum  
  integer      :: NH4SHNum

  integer             :: spc, t, s
  character(50)       :: cfgfile
  character(50)       :: AnalFile

!  call setdebug
    
  !----------------------------------------------------------------------
  ! ѿȷ⥸塼ν
  !----------------------------------------------------------------------
  !NAMELIST եμ
  call getarg( 1, cfgfile )
  write(*,*) "Input NAMELIST file: ", cfgfile
  
  !I/O ե̾ν
  !  NAMELIST ե̾ꤷ, deepconv/arare 
  !  ϥե̾ NAMELIST 
  call fileset_init(cfgfile)
  
  !ǥХν
  !  NAMELIST , ǥХåϥåؤԤ.  
  call debugset_init(cfgfile)
  
  !˴ؤν
  !  NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
  call timeset_init(cfgfile)

  !ʻν
  !  NAMELIST , ʻ׻
  call gridset_init(cfgfile)
  
  !ܾξν
  !  NAMELIST , ܾꤹ.
  call basicset_init(cfgfile)
  
  !ѻͤݴɤ뤿Υ⥸塼ν
  !  NAMELIST , ܾꤹ.
  call storeset_init( )
  
  !ѿν. ȤꤢͤꤵƤ. 
  call ArareAlloc
  
    
  !----------------------------------------------------------------------
  ! ѥå⥸塼ν
  !   ǥեȤͤѹɬפΤ롼Τ߽
  !----------------------------------------------------------------------
  AnalFile = HistoryFile(1:len_trim(HistoryFile)-3) // '_anal.nc'
  call AnalFile_Open( )
  call AnalFile_BasicZ_Get( )

  call Damping_Init( cfgfile )      !Ȥθ그ν
  call NumDiffusion_Init()          !ͳȻν
  call Turbulence_Init()            !ή׻ν
  call MoistAdjust_Init()           !˰Ĵˡν
  call WarmRainPrm_Init()           !ȤΥѥ᥿ꥼν
!  call FillNegative_Init( xza_MixRtBasicZ, xz_DensBasicZ) 
!                                    !ήˤ̤ν
  call Radiation_Init( cfgfile )    !Ͷν
  call MoistBuoy_Init()             !ʬ̤ФϷ׻롼ν
!  call xz_Exner_Init()              !ˡν  

  call WarmRainPrm_prm( LoopNum, LoopNum2, RainNum, CloudNum, GasNum, NH3Num, H2SNum, NH4SHNum )


!!!
!!!ʤʤ, եͤ
!!!
  do t = 1, int( TimeInt / TimeDisp ) + 1, 10

    !----------------------------------------------------------------
    ! ҥȥե򳫤ͤ. 
    !----------------------------------------------------------------
    call AnalFile_Get(                                           &
      &       t,  AnalTime,                                      &
      &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )
    write(*,*) t, AnalTime
    

    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    xz_Cloud = 0.0d0
    xz_Rain  = 0.0d0
    xza_MixRtAll = xza_MixRt + xza_MixRtBasicZ
    
    !----------------------------------------------------------------
    ! ̩, , ̤η׻
    !----------------------------------------------------------------
    do spc = 1, SpcNum
      xza_Rho(:,:, spc) =                                                   &
        &  xz_DensBasicZ * ( xza_MixRtBasicZ(:,:,spc) + xza_MixRt(:,:,spc) )
    end do

    xz_PotTempAll  = xz_PotTemp + xz_PotTempBasicZ
    
    xz_VPotTemp    = xz_PotTemp / xz_EffMolWtBasicZ
    xz_VPotTempAll = xz_PotTempAll / xz_EffMolWtBasicZ

    xz_TempAll = &
      &   ( xz_Exner + xz_ExnerBasicZ ) * xz_PotTempAll
    xz_Temp = xz_TempAll - xz_ExnerBasicZ * xz_PotTempBasicZ 
    
    !----------------------------------------------------------------
    ! Ϥη׻
    !----------------------------------------------------------------
    xz_PressAll = PressBasis * ((xz_Exner + xz_ExnerBasicZ ) ** (CpDry / GasRDry))
    
    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    xz_BuoyTemp  =  xz_avr_xr( xr_Buoy( xz_PotTemp ) )
    xz_BuoyMolWt =  xz_avr_xr( xr_BuoyMolWt( xza_MixRt ) )
    xz_BuoyDrag  =  xz_avr_xr( xr_BuoyDrag( xza_MixRt ) )
    xz_BuoyAll   =  xz_BuoyTemp + xz_BuoyMolWt + xz_BuoyDrag
    
    !----------------------------------------------------------------
    ! ʪ̤׻
    !----------------------------------------------------------------
    xza_CloudPhys1 = xza_Cloud2Rain( xza_MixRt, 2.0d0 * DelTimeLong )

    if ( LoopNum /= 0 ) then 
      xza_CloudPhys2 =                                         &
        &   xza_Rain2Gas(xz_Exner, xz_PotTemp, xza_MixRt, 2.0d0 * DelTimeLong )    
    end if
    if ( NH4SHNum /= 0 ) then     
      xza_CloudPhys2 =                                          &
        &   xza_CloudPhys2                                      &
        & + xza_CloudPhys2 + xza_Rain2GasNH4SH(xz_Exner, xz_PotTemp, xza_MixRt, 2.0d0 * DelTimeLong )
    end if

    do spc = 1, SpcNum      
      xza_CloudPhys3(:,:,spc) = xz_FallRain(xza_MixRt(:,:,spc), spc)
    end do
    
    !----------------------------------------------------------------
    ! ήȻη׻
    !----------------------------------------------------------------
    xz_Km1 = xz_AdvScalar(xz_Km, pz_VelX, xr_VelZ)           
    xz_Km2 = xz_BuoyMoistKm(xz_PotTemp, xz_Exner, xza_MixRt)
    xz_Km3 = xz_ShearKm(xz_Km, pz_VelX, xr_VelZ)         
    xz_Km4 = xz_NumDiffScalar(xz_Km)                             
    xz_Km5 = xz_DispKm(xz_Km)                                    

    !----------------------------------------------------------------
    ! , ޤȤ
    !----------------------------------------------------------------
    do s = 1, LoopNum2
      xz_Cloud = xz_Cloud + xza_MixRt(:,:,CloudNum(s))
      xz_Rain  = xz_Rain  + xza_MixRt(:,:,RainNum(s))
    end do
    
    !----------------------------------------------------------------
    ! ˰¾Υå
    !----------------------------------------------------------------
    xza_MixRtSat = 1.0d0
    if (LoopNum /= 0 ) then 
      do s = 1, LoopNum
        xza_MixRtSat(:,:,GasNum(s)) =                      &
          & xz_SvapPress(SpcWetID(CloudNum(s)), xz_TempAll) &
          &  * MolWtWet(CloudNum(s))                        &
          &  / (MolWtDry * xz_PressAll)                     
      end do

      xza_DelMixRt = 0.0d0
      xza_DelMixRt = ( - xza_MixRtSat + xza_MixRtAll ) / xza_MixRtSat
    end if
    
    !----------------------------------------------------------------
    ! ٤η׻
    !----------------------------------------------------------------
    call ECCM_Stab( xz_PotTemp, xz_Exner, xza_MixRt, &
      &             xz_Stab, xz_StabTemp, xz_StabMolWt)

    !----------------------------------------------------------------    
    ! ե
    !----------------------------------------------------------------
    call AnalFile_OutPut( AnalTime )
    
  end do
  
  !----------------------------------------------------------------    
  ! եĤ
  !----------------------------------------------------------------    
  call HistoryClose

    
contains

  subroutine AnalFile_Open( )
    !
    !ϥե
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(4)        :: SpcID(SpcNum)
!    character(50)  :: AnalFile
    integer        :: s
    
    do s = 1, SpcNum
      SpcID(s) = real( s, 4 )
    end do


    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    call HistoryCreate(                              &
      & file = AnalFile,                             &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','z','s','t'/),                    &
      & dimsizes=(/FileNX, FileNZ, SpcNum, 0/),      &
      & longnames=(/'X-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Species Num ',                  &
      &             'Time        '/),                &
      & units=(/'m','m','1','s'/), origin=0.0,       &
      & interval=0.0 )
!      & units=(/'m','m','1','s'/) )
    
    !-----------------------------------------------------------  
    ! ν
    !-----------------------------------------------------------
    call HistoryPut('x', s_X( FileXMin: FileXMax ) )
    call HistoryPut('z', s_Z( FileZMin: FileZMax ) )
    call HistoryPut('s', real(SpcID, 4))

    !-----------------------------------------------------------  
    ! Ѥѿν
    !-----------------------------------------------------------  
    !̤ξ
    call HistoryAddVariable(                                     &
      & varname='VPotTemp', dims=(/'x','z','t'/),                &
      & longname='disturbunce of virtual potential temperature', &
      & units='K', xtype='double' )

    !
    call HistoryAddVariable(                         &
      & varname='VPotTempAll', dims=(/'x','z','t'/), &
      & longname='virtual potential temperature',    &
      & units='K', xtype='double' )

    !̤ξ
    call HistoryAddVariable(                         &
      & varname='PotTempAll', dims=(/'x','z','t'/),  &
      & longname='potential temperature',            &
      & units='K', xtype='double' )

    !پ
    call HistoryAddVariable(                         &
      & varname='Temp', dims=(/'x','z','t'/),        &
      & longname='disturbunce of temperature',       &
      & units='K', xtype='double' )

    !
    call HistoryAddVariable(                          &
      & varname='TempAll', dims=(/'x','z','t'/),      &
      & longname='temperature',                       &
      & units='K', xtype='double' )

    !
    call HistoryAddVariable(                          &
      & varname='PressAll', dims=(/'x','z','t'/),     &
      & longname='Pressure',                          &
      & units='Pa', xtype='double' )

    !̩
    call HistoryAddVariable(                          &
      & varname='Rho', dims=(/'x','z','s','t'/),      &
      & longname='Density of condensable components', &
      & units='kg m|-2"', xtype='double' )

    !˰¾
    call HistoryAddVariable(                                         &
      & varname='MixRtSat', dims=(/'x','z','s','t'/),                &
      & longname='Saturated Mixing ratio of condensable components', &
      & units='kg kg|-1"', xtype='double' )

    call HistoryAddVariable(                                         &
      & varname='Cloud2Rain', dims=(/'x','z','s','t'/),              &
      & longname='WarmRainPrm Cloud2Rain of condensable components', &
      & units='kg kg|-1"', xtype='double' ) 
 
    call HistoryAddVariable(                                       &
      & varname='Rain2Gas', dims=(/'x','z','s','t'/),              &
      & longname='WarmRainPrm Rain2Gas of condensable components', &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='FallRain', dims=(/'x','z','s','t'/),               &
      & longname='WarmRainPrm FallRain of condensable components',  &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='BuoyAll', dims=(/'x','z','t'/),                    &
      & longname='Buoyancy',                                        &
      & units=' ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='BuoyTemp', dims=(/'x','z','t'/),                   &
      & longname='Buoyancy',                                        &
      & units=' ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='BuoyMolWt', dims=(/'x','z','t'/),                  &
      & longname='Buoyancy',                                        &
      & units=' ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='BuoyDrag', dims=(/'x','z','t'/),                   &
      & longname='Buoyancy',                                        &
      & units=' ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='Stab', dims=(/'x','z','t'/),                       &
      & longname='Static Stability',                                &
      & units='s|-2" ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='StabTemp', dims=(/'x','z','t'/),                   &
      & longname='Static Stability (Temp)',                         &
      & units='s|-2" ', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='StabMolWt', dims=(/'x','z','t'/),                  &
      & longname='Static Stability (MolWt)',                        &
      & units='s|-2" ', xtype='double' ) 

    !----------------------------------------------------------------
    ! ήȻϢ
    !----------------------------------------------------------------
    call HistoryAddVariable(                                        &
      & varname='AdvKm', dims=(/'x','z','t'/),                      &
      & longname='Advection term of Km',                            &
      & units='1', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='BuoyKm', dims=(/'x','z','t'/),                     &
      & longname='Buoyancy term of Km',                             &
      & units='1', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='ShearKm', dims=(/'x','z','t'/),                    &
      & longname='Shear term of Km',                                &
      & units='1', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='NumDiffKm', dims=(/'x','z','t'/),                  &
      & longname='Numerical Diffusion term of Km',                  &
      & units='1', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='DispKm', dims=(/'x','z','t'/),                     &
      & longname='Dissipation term of Km',                          &
      & units='1', xtype='double' ) 


    !----------------------------------------------------------------
    ! ˰ĴˡϢ
    !----------------------------------------------------------------

    call HistoryAddVariable(                                       &
      & varname='DelMixRt', dims=(/'x','z','s','t'/),              &
      & longname='Difference between MixRtAll and MixRtSat',       &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                                       &
      & varname='DelNH4SH', dims=(/'x','z','t'/),                  &
      & longname='Difference between Equiv-Const',                 &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                                       &
      & varname='EquivConst', dims=(/'x','z','t'/),                &
      & longname='Difference between Equiv-Const',                 &
      & units='kg kg|-1"', xtype='double' ) 

    !----------------------------------------------------------------
    ! ȱ
    !----------------------------------------------------------------
    call HistoryAddVariable(                                       &
      & varname='Cloud', dims=(/'x','z','t'/),                     &
      & longname='All Clouds Mixing Ratio',                        &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                                       &
      & varname='Rain', dims=(/'x','z','t'/),                      &
      & longname='All Rains Mixing Ratio',                         &
      & units='kg kg|-1"', xtype='double' ) 

    call HistoryAddVariable(                            &
      & varname='MixRtAll', dims=(/'x','z','s','t'/),   &
      & longname='Mixing Ratio',                        &
      & units='kg kg|-1"', xtype='double' ) 

  end subroutine AnalFile_Open



  subroutine AnalFile_OutPut( Time )

    real(8), intent(in) :: Time    

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call HistoryPut( 't', Time )
    
    call HistoryPut( 'Temp',     xz_Temp(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'TempAll',  xz_TempAll(FileXMin:FileXMax, FileZMin:FileZMax))
    
    call HistoryPut( 'VPotTemp',    xz_VPotTemp(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'VPotTempAll', xz_VPotTempAll(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'PotTempAll', xz_PotTempAll(FileXMin:FileXMax, FileZMin:FileZMax))
    
    call HistoryPut( 'PressAll', xz_PressAll(FileXMin:FileXMax, FileZMin:FileZMax))
    
    call HistoryPut( 'Rho', xza_Rho(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))
    
    call HistoryPut( 'Cloud2Rain', xza_CloudPhys1(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))

    call HistoryPut( 'Rain2Gas', xza_CloudPhys2(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))
    
    call HistoryPut( 'FallRain', xza_CloudPhys3(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))

    call HistoryPut( 'BuoyAll', xz_BuoyAll(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'BuoyTemp', xz_BuoyTemp(FileXMin:FileXMax, FileZMin:FileZMax))    
    
    call HistoryPut( 'BuoyMolWt', xz_BuoyMolWt(FileXMin:FileXMax, FileZMin:FileZMax))
    
    call HistoryPut( 'BuoyDrag', xz_BuoyDrag(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'DelMixRt',   abs(xza_DelMixRt(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum)) )

    call HistoryPut( 'MixRtAll',   xza_MixRtAll(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))

    call HistoryPut( 'MixRtSat',   xza_MixRtSat(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))

    call HistoryPut( 'DelNH4SH',   xz_DelNH4SH(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'EquivConst',   xz_EquivConst(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'Cloud',   xz_Cloud(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'Rain',    xz_Rain(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'Stab',   xz_Stab(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'StabTemp',   xz_StabTemp(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'StabMolWt',   xz_StabMolWt(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'AdvKm',   xz_Km1(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'BuoyKm',   xz_Km2(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'ShearKm',   xz_Km3(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'NumDiffKm',   xz_Km4(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'DispKm',   xz_Km5(FileXMin:FileXMax, FileZMin:FileZMax))
    
  end subroutine AnalFile_OutPut


!!!------------------------------------------------------------------------------!!!
  subroutine AnalFile_Get(                                      &
    &       i, AnalTime,                                        &
    &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )

    !ۤηػ
    implicit none

    !ѿ
    integer, intent(in)  :: i    
    real(8), intent(out) :: AnalTime
    real(8), intent(out) :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xr_VelZ(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax,1:SpcNum)
    character(30)        :: name               !ѿ̾
    character(10)       :: step
    

    step = '^' // adjustl(toChar(i))

    !-------------------------------------------------------------
    !Get a Value from netCDF File
    !-------------------------------------------------------------
    name = "t"
    call HistoryGet( HistoryFile, name, AnalTime, step )

    !-------------------------------------------------------------    
    ! Get a Value from netCDF File 
    !-------------------------------------------------------------
    name = "VelX"
    call HistoryGet( HistoryFile, name, pz_VelX(FileXMin:FileXMax, FileZMin:FileZMax), range=step )    
    pz_VelX = pz_BoundaryXCyc_pz( pz_VelX )
    pz_VelX = pz_BoundaryZSym_pz( pz_VelX )
    
    name = "VelZ"
    call HistoryGet( HistoryFile, name, xr_VelZ(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    xr_VelZ = xr_BoundaryXCyc_xr( xr_VelZ )
    xr_VelZ = xr_BoundaryZAntiSym_xr( xr_VelZ )
    
    name = "Exner"
    call HistoryGet( HistoryFile, name, xz_Exner(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    xz_Exner = xz_BoundaryXCyc_xz( xz_Exner )
    xz_Exner = xz_BoundaryZSym_xz( xz_Exner )
    
    name = "PotTemp"
    call HistoryGet( HistoryFile, name, xz_PotTemp(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    xz_PotTemp = xz_BoundaryXCyc_xz( xz_PotTemp )
    xz_PotTemp = xz_BoundaryZSym_xz( xz_PotTemp )

    name = "MixRt"
    call HistoryGet( HistoryFile, name, xza_MixRt(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum), range=step )
    xza_MixRt = xza_BoundaryXCyc_xza( xza_MixRt )
    xza_MixRt = xza_BoundaryZSym_xza( xza_MixRt )

    name = "Km"
    call HistoryGet( HistoryFile, name, xz_Km(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    xz_Km = xz_BoundaryXCyc_xz( xz_Km )
    xz_Km = xz_BoundaryZSym_xz( xz_Km )

  end subroutine AnalFile_Get



  subroutine AnalFile_BasicZ_Get( )

    !ۤηػ
    implicit none

    !ѿ
    real(8) :: xz_DensBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PotTempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_ExnerBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xza_MixRtBZ(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum)
    real(8) :: xz_EffMolWtBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PressBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_TempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_VelSoundBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    character(30)        :: name               !ѿ̾
    
    !-------------------------------------------------------------
    ! ܾμ
    !-------------------------------------------------------------
    name = "TempBasicZ"
    call HistoryGet( HistoryFile, name, xz_TempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_TempBZ  = xz_BoundaryXCyc_xz( xz_TempBZ )
    xz_TempBZ  = xz_BoundaryZSym_xz( xz_TempBZ )

    name = "PressBasicZ"
    call HistoryGet( HistoryFile, name, xz_PressBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_PressBZ = xz_BoundaryXCyc_xz( xz_PressBZ )
    xz_PressBZ = xz_BoundaryZSym_xz( xz_PressBZ )

    name = "ExnerBasicZ"
    call HistoryGet( HistoryFile, name, xz_ExnerBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_ExnerBZ = xz_BoundaryXCyc_xz( xz_ExnerBZ )
    xz_ExnerBZ = xz_BoundaryZSym_xz( xz_ExnerBZ )

    name = "PotTempBasicZ"
    call HistoryGet( HistoryFile, name, xz_PotTempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_PotTempBZ = xz_BoundaryXCyc_xz( xz_PotTempBZ )
    xz_PotTempBZ = xz_BoundaryZSym_xz( xz_PotTempBZ )

    name = "DensBasicZ"
    call HistoryGet( HistoryFile, name, xz_DensBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_DensBZ = xz_BoundaryXCyc_xz( xz_DensBZ )
    xz_DensBZ = xz_BoundaryZSym_xz( xz_DensBZ )

    name = "VelSoundBasicZ"
    call HistoryGet( HistoryFile, name, xz_VelSoundBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_VelSoundBZ = xz_BoundaryXCyc_xz( xz_VelSoundBZ )
    xz_VelSoundBZ = xz_BoundaryZSym_xz( xz_VelSoundBZ )

    name = "EffMolWtBasicZ"
    call HistoryGet( HistoryFile, name, xz_EffMolWtBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    xz_EffMolWtBZ = xz_BoundaryXCyc_xz( xz_EffMolWtBZ )
    xz_EffMolWtBZ = xz_BoundaryZSym_xz( xz_EffMolWtBZ )

    name = "MixRtBasicZ"
    call HistoryGet( HistoryFile, name, xza_MixRtBZ(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum) )
    xza_MixRtBZ = xza_BoundaryXCyc_xza( xza_MixRtBZ )
    xza_MixRtBZ = xza_BoundaryZSym_xza( xza_MixRtBZ )


    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSetArray_Init(                       &
      & xz_PressBZ,   xz_ExnerBZ,   xz_TempBZ,     &
      & xz_PotTempBZ, xz_DensBZ,    xz_VelSoundBZ, &
      & xza_MixRtBZ,  xz_EffMolWtBZ )

  end subroutine AnalFile_BasicZ_Get


  subroutine ArareAlloc

    !ܾ, μ.
    allocate( &
      &       xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax ),             &
      &       xz_PotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),          &
      &       xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax ),               &
      &       pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),    &
      &       xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtSat(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xz_Temp(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xz_VPotTemp(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_VPotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),         &
      &       xza_Rho(DimXMin:DimXMax, DimZMin:DimZMax,SpcNum ),         &
      &       xza_CloudPhys1(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum ),&
      &       xza_CloudPhys2(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum ),&
      &       xza_CloudPhys3(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum ),&
      !
      &       xz_Km(DimXMin:DimXMax, DimZMin:DimZMax ),                  &
      &       xz_Km1(DimXMin:DimXMax, DimZMin:DimZMax ),                 &
      &       xz_Km2(DimXMin:DimXMax, DimZMin:DimZMax ),                 &
      &       xz_Km3(DimXMin:DimXMax, DimZMin:DimZMax ),                 &
      &       xz_Km4(DimXMin:DimXMax, DimZMin:DimZMax ),                 &
      &       xz_Km5(DimXMin:DimXMax, DimZMin:DimZMax ),                 &
      !
      &       xz_Stab(DimXMin:DimXMax, DimZMin:DimZMax ),               &
      &       xz_StabTemp(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xz_StabMolWt(DimXMin:DimXMax, DimZMin:DimZMax ),          &
      &       xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xz_DelNH4SH(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xz_EquivConst(DimXMin:DimXMax, DimZMin:DimZMax ),         &
      &       xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),&
      !
      &       xz_Cloud(DimXMin:DimXMax, DimZMin:DimZMax ),              &
      &       xz_Rain(DimXMin:DimXMax, DimZMin:DimZMax ),               &
      !
      &       xz_BuoyAll(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_BuoyTemp(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xz_BuoyMolWt(DimXMin:DimXMax, DimZMin:DimZMax ),          &
      &       xz_BuoyDrag(DimXMin:DimXMax, DimZMin:DimZMax )          )

    LoopNum  = 0 
    LoopNum2 = 0
    RainNum = 0
    CloudNum = 0
    GasNum   = 0
    NH3Num   = 0
    H2SNum   = 0
    NH4SHNum = 0

  end subroutine ArareAlloc



end program ArareAnal
