!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005, 2006. All rights reserved.
!---------------------------------------------------------------------
!= Module ReStartFileIO
!
!   * Developer: SUGIYAMA Ko-ichiro (sugiyama@gfd-dennou.org)
!   * Version: $Id: restartfileio.f90,v 1.5 2006/08/17 09:49:53 sugiyama Exp $ 
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview 
!
!ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!®٤ɾʻҰ֤, ȤϤƤɸͤŪǤʤȤ
!
!== Future Plans
!

module ReStartFileIO
  !
  !ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
  !

  !⥸塼ɤ߹
  use gt4_history
  use dc_message,only:MessageNotify
  use dc_string
  use gridset,  only: s_X,               &!X ɸ(顼ʻ)
    &                 s_Z,               &!Z ɸ(顼ʻ)
    &                 DimXMin,           &!X β
    &                 DimXMax,           &!X ξ
    &                 DimZMin,           &!Z β
    &                 DimZMax,           &!Z ξ
    &                 SpcNum              !Žʬο
  use fileset,  only: RestartFile,       &!ꥹȥե̾
    &                 InitFile,          &!ե̾
    &                 exptitle,          &!ǡɽ
    &                 expsrc,            &!ǡ
    &                 expinst             !ǽѹԡȿ
  use basicset, only: xz_ExnerBasicZ,    &!ܾΥʡؿ
    &                 xz_DensBasicZ,     &!ܾ̩
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_VelSoundBasicZ, &!ܾβ®
    &                 xz_PressBasicZ,    &!ܾΰ
    &                 xz_TempBasicZ,     &!ܾβ
    &                 xza_MixRtBasicZ,   &!ܾκ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̸
    &                 BasicSetArray_Init  !ܾ̤ν
  use timeset,    only: DelTimeLong

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ public ˻
  public ReStartFile_Open
  public ReStartFile_OutPut
  public ReStartFile_Close
  public ReStartFile_Get

contains

  subroutine ReStartFile_Open(  )
    !
    !ꥹȥեν񤭽Ф
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    integer        :: N, M
    real(4)        :: SpcID(SpcNum)
    integer        :: s
    
    SpcID = 0.0d0
    do s = 1, SpcNum
      SpcID(s) = real( s, 4 )
    end do
    
    N = size(s_X, 1)
    M = size(s_Z, 1)
    
    !-------------------------------------------------------------    
    ! ҥȥ꡼
    !-------------------------------------------------------------  
    call HistoryCreate(                              &
      & file = ReStartFile,                          &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','z','s','t'/),                    &
      & dimsizes=(/N, M, SpcNum, 0/),                &
      & longnames=(/'X-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Species Num ',                  &
      &             'Time        '/),                &
      & units=(/'m','m','1','t'/), origin=0.0,       &
      & interval=0.0 )
    
    !-------------------------------------------------------------  
    ! ѿ
    !-------------------------------------------------------------
    call HistoryPut('x', s_X )
    call HistoryPut('z', s_Z )
    call HistoryPut('s', real(SpcID, 4) )
    
    !̵Ϥδܾ
    call HistoryAddVariable(                             &
      & varname='ExnerBasicZ', dims=(/'x','z'/),      &
      & longname='nondimensional pressure', units='1',&
      & xtype='double' )
    
    !̤δܾ
    call HistoryAddVariable(                            &
      & varname='PotTempBasicZ', dims=(/'x','z'/),    &
      & longname='potential temperature',            &
      & units='K', xtype='double' )
    
    !̩٤δܾ
    call HistoryAddVariable(                            &
      & varname='DensBasicZ', dims=(/'x','z'/),      &
      & longname='density',                          &
      & units='Kg/m^3', xtype='double' )
    
    !®٤δܾ
    call HistoryAddVariable(                            &
      & varname='VelSoundBasicZ', dims=(/'x','z'/),  &
      & longname='sound velocity',                   &
      & units='m/s|2', xtype='double' )
    
    !٤δܾ
    call HistoryAddVariable(                            &
      & varname='TempBasicZ', dims=(/'x','z'/),  &
      & longname='Temperature of basic state',       &
      & units='K', xtype='double' ) 
    
    !Ϥδܾ
    call HistoryAddVariable(                            &
      & varname='PressBasicZ', dims=(/'x','z'/),  &
      & longname='Pressure of basic state',             &
      & units='Pa', xtype='double' ) 
    
    !δܾ
    call HistoryAddVariable(                            &
      & varname='MixRtBasicZ', dims=(/'x','z','s'/),  &
      & longname='Mixing ratio of Condensible volatiles',        &
      & units='kg/kg', xtype='double' ) 
    
    !ʬ̸
    call HistoryAddVariable(                         &
      & varname='EffMolWtBasicZ', dims=(/'x','z'/),  &
      & longname='Effect of Mole Weight',            &
      & units='1', xtype='double' ) 
    
    !̵
    call HistoryAddVariable(                         &
      & varname='Exner', dims=(/'x','z','t'/),       &
      & longname='nondimensional pressure',          &
      & units='1',                                   &
      & xtype='double' )
    
    !̤ξ
    call HistoryAddVariable(                         &
      & varname='PotTemp', dims=(/'x','z','t'/),     &
      & longname='virtual potential temperature',    &
      & units='K',                                   &
      & xtype='double' )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelX', dims=(/'x','z','t'/),        &
      & longname='zonal velocity',                   &
      & units='m/s',                                 &
      & xtype='double' )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelZ', dims=(/'x','z','t'/),        &
      & longname='vertical velocity',                &
      & units='m/s',                                 &
      & xtype='double' )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Km', dims=(/'x','z','t'/),          &
      & longname='Km',                               &
      & units='1',                                   &
      & xtype='double' )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Kh', dims=(/'x','z','t'/),          &
      & longname='Kh',                               &
      & units='1',                                   &
      & xtype='double' )
    
    !
    call HistoryAddVariable(                         &
      & varname='MixRt', dims=(/'x','z','s','t'/),   &
      & longname='Mixing Ratio',                     &
      & units='kg kg|-1"',                           & 
      & xtype='double' )
    
    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------
    call HistoryPut( 'DensBasicZ',     xz_DensBasicZ     )
    call HistoryPut( 'ExnerBasicZ',    xz_ExnerBasicZ    )
    call HistoryPut( 'PotTempBasicZ',  xz_PotTempBasicZ  )
    call HistoryPut( 'VelSoundBasicZ', xz_VelSoundBasicZ )
    call HistoryPut( 'TempBasicZ',     xz_TempBasicZ     )
    call HistoryPut( 'PressBasicZ',    xz_PressBasicZ    )
    call HistoryPut( 'MixRtBasicZ',    xza_MixRtBasicZ   )
    call HistoryPut( 'EffMolWtBasicZ', xz_EffMolWtBasicZ )
    
  end subroutine ReStartFile_Open
  
  
  subroutine ReStartFile_OutPut(        &
    &   Time, xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, &
    &   xza_MixRt, xz_Km , xz_Kh &
    & )
    !
    !ꥹȥեͽѿ񤭽Ф
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: Time
    real(8), intent(in)  :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xz_Kh(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    
  
    !------------------------------------------------------------------
    ! ե
    !------------------------------------------------------------------
    call HistoryPut( 't',       Time       )
    call HistoryPut( 'VelX',    pz_VelX    )
    call HistoryPut( 'VelZ',    xr_VelZ    )
    call HistoryPut( 'Exner',   xz_Exner   ) 
    call HistoryPut( 'PotTemp', xz_PotTemp )
    call HistoryPut( 'Km',      xz_Km      )
    call HistoryPut( 'Kh',      xz_Kh      )
    call HistoryPut( 'MixRt',   xza_MixRt  )    
    
  end subroutine ReStartFile_OutPut
  
  
  subroutine ReStartFile_Close
    !
    !ꥹȥեΥ
    !
    
    !⥸塼ɤ߹
    use gt4_history
    
    !ۤηػ
    implicit none

    !եĤ
    call HistoryClose
    
  end subroutine ReStartFile_Close


  subroutine ReStartFile_Get(   &
    & ReStartTime,                            &
    & xz_PotTempB, xz_ExnerB, pz_VelXB, xr_VelZB, xza_MixRtB, xz_KmB, xz_KhB, &
    & xz_PotTempN, xz_ExnerN, pz_VelXN, xr_VelZN, xza_MixRtN, xz_KmN, xz_KhN  )
    !
    !ꥹȥե뤫
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(out) :: ReStartTime(2)
    real(8), intent(out) :: pz_VelXN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xr_VelZN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_ExnerN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_PotTempN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_KmN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_KhN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xza_MixRtN(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8), intent(out) :: pz_VelXB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xr_VelZB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_ExnerB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_PotTempB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_KmB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xz_KhB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(out) :: xza_MixRtB(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: DelTime
    real(8)              :: Var2D(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)              :: Var3D(DimXMin:DimXMax, DimZMin:DimZMax, 2)
    real(8)              :: Var3Ds(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Var4D(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum, 2)
    real(8)              :: xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾΥʡؿ
    real(8)              :: xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾ̩
    real(8)              :: xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾβ
    real(8)              :: xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾβ®
    real(8)              :: xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾΰ
    real(8)              :: xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾβ
    real(8)              :: xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !ܾκ
    real(8)              :: xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !ܾʬ̸
    character(30)        :: name               !ѿ̾
    character(10)        :: step(2)
    integer              :: t



    !-------------------------------------------------------------
    ! Get a Value from netCDF File
    !-------------------------------------------------------------    
    do t = 1, 2
      step(t) = '^' // adjustl(toChar(t))   
    end do

    do t = 1, 2
      name = "t"
      call HistoryGet( InitFile, name, ReStartTime(t), step(t) )
    end do

    do t = 1, 2
      name = "VelX"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    pz_VelXB = Var3D(:,:,1)
    pz_VelXN = Var3D(:,:,2)

    do t = 1, 2    
      name = "VelZ"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    xr_VelZB = Var3D(:,:,1)
    xr_VelZN = Var3D(:,:,2)

    do t = 1, 2    
      name = "Exner"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    xz_ExnerB = Var3D(:,:,1)
    xz_ExnerN = Var3D(:,:,2)

    do t = 1, 2    
      name = "PotTemp"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    xz_PotTempB = Var3D(:,:,1)
    xz_PotTempN = Var3D(:,:,2)
    
    do t = 1, 2  
      name = "Km"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    xz_KmB = Var3D(:,:,1)
    xz_KmN = Var3D(:,:,2)
    
    do t = 1, 2  
      name = "Kh"
      call HistoryGet( InitFile, name, Var3D(:,:,t), step(t) )    
    end do
    xz_KhB = Var3D(:,:,1)
    xz_KhN = Var3D(:,:,2)
      
    do t = 1, 2
      name = "MixRt"
      call HistoryGet( InitFile, name, Var4D(:,:,:,t), step(t) )    
    end do
    xza_MixRtB = Var4D(:,:,:,1)
    xza_MixRtN = Var4D(:,:,:,2)
    
        
    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------
    name = "DensBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_DensBasicZ = Var2D
    
    name = "ExnerBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_ExnerBasicZ = Var2D

    name = "PotTempBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_PotTempBasicZ = Var2D

    name = "VelSoundBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_VelSoundBasicZ = Var2D

    name = "TempBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_TempBasicZ = Var2D

    name = "PressBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_PressBasicZ = Var2D

    name = "MixRtBasicZ"
    call HistoryGet( InitFile, name, Var3Ds )
    xza_MixRtBasicZ = Var3Ds

    name = "EffMolWtBasicZ"
    call HistoryGet( InitFile, name, Var2D )
    xz_EffMolWtBasicZ = Var2D


    !----------------------------------------------------------
    ! ֹߤΥå
    !----------------------------------------------------------
    DelTime = ReStartTime(2) - ReStartTime(1)
    if ( DelTime /= real(DelTimeLong, 4) ) then 
      write(*,*) DelTime, DelTimeLong
!      call MessageNotify("Error", "getdistrbvar", &
!        &    "DelTime for InitFile is not the same as DelTimeLong")
!     stop
    end if
    
    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSetArray_Init(                                  &
      & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
      & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
      & xza_MixRtBasicZ, xz_EffMolWtBasicZ )
    
  end subroutine ReStartFile_Get

end module ReStartFileIO
