!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
!= Module HistoryFileIO
!
!   * Developer: SUGIYAMA Ko-ichiro (sugiyama@gfd-dennou.org)
!   * Version: $Id: historyfileio.f90,v 1.6 2006/09/01 08:24:32 sugiyama Exp $ 
!   * Tag Name: $Name: arare4-20060914 $
!   * Change History: 
!
!== Overview 
!
!ե. Ĺ֥ƥåפͤ.
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module HistoryFileIO
  !
  !ե. Ĺ֥ƥåפͤ.
  !

  !⥸塼ɤ߹
  use gt4_history
  use gridset,  only: s_X,               &!X ɸ(顼ʻ)
    &                 s_Z,               &!Z ɸ(顼ʻ)
    &                 FileNX,            &!X γʻ(ե)
    &                 FileNZ,            &!Z γʻ(ե)
    &                 FileXMin,          &!X β(ե)
    &                 FileXMax,          &!X ξ(ե)
    &                 FileZMin,          &!Z β(ե)
    &                 FileZMax,          &!Z ξ(ե)
    &                 DimXMin,           &!X β
    &                 DimXMax,           &!X ξ
    &                 DimZMin,           &!Z β
    &                 DimZMax,           &!Z ξ
    &                 SpcNum              !Žʬο
  use fileset,  only: HistoryFile,       &!ҥȥե̾
    &                 exptitle,          &!ǡɽ
    &                 expsrc,            &!ǡ
    &                 expinst             !ǽѹԡȿ
  use basicset, only: xz_ExnerBasicZ,    &!ܾΥʡؿ
    &                 xz_DensBasicZ,     &!ܾ̩
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_VelSoundBasicZ, &!ܾβ®
    &                 xz_PressBasicZ,    &!ܾΰ
    &                 xz_TempBasicZ,     &!ܾβ
    &                 xza_MixRtBasicZ,    &!ܾκ
    &                 xz_EffMolWtBasicZ   !ܾʬ̸
  use StoreSet, only:                    &
    &                 StoreMeanX, &!
    &                 z_Adv,     &!
    &                 z_Turb,    &!
    &                 z_Disp,    &!
    &                 z_Diff,    &!
    &                 z_Rad,     &!
    &                 z_Cond,    &!
    &                 z_Damp      !

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ public ˻
  public HistoryFile_Open
  public HistoryFile_OutPut
  public HistoryFile_Close

contains 

!!!------------------------------------------------------------------------------!!!
  subroutine HistoryFile_Open( )
    !
    !ҥȥե
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(4)        :: SpcID(SpcNum)
    integer        :: s
 
    SpcID = 0.0d0
    do s = 1, SpcNum
      SpcID(s) = real(s, 4)
    end do


    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    call HistoryCreate(                              &
      & file = HistoryFile,                          &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','z','s','t'/),                    &
      & dimsizes=(/FileNX, FileNZ, SpcNum, 0/),      &
      & longnames=(/'X-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Species Num ',                  &
      &             'Time        '/),                &
      & units=(/'m','m','1','s'/), origin=0.0,       &
      & interval=0.0 )
    
    !-----------------------------------------------------------  
    ! ν
    !-----------------------------------------------------------
    call HistoryPut('x', s_X( FileXMin: FileXMax ) )
    call HistoryPut('z', s_Z( FileZMin: FileZMax ) )
    call HistoryPut('s', real(SpcID, 4))

    !-----------------------------------------------------------  
    ! ͽѿν
    !-----------------------------------------------------------  
    !̵Ϥξ
    call HistoryAddVariable(                               &
      & varname='Exner', dims=(/'x','z','t'/),             &
      & longname='disturbunce of nondimensional pressure', &
      & units=' ', xtype='double' )
    
    !̤ξ
    call HistoryAddVariable(                              &
      & varname='PotTemp', dims=(/'x','z','t'/),          &
      & longname='disturbunce of potential temperature',  &
      & units='K', xtype='double' )

    !ʿ®
    call HistoryAddVariable(                         &
      & varname='VelX', dims=(/'x','z','t'/),        &
      & longname='zonal velocity',                   &
      & units='m s|-1"', xtype='double' )

    !ľ®
    call HistoryAddVariable(                         &
      & varname='VelZ', dims=(/'x','z','t'/),        &
      & longname='vertical velocity',                &
      & units='m s|-1"', xtype='double' )

    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Km', dims=(/'x','z','t'/),          &
      & longname='Km',                               &
      & units='1', xtype='double' )
  
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Kh', dims=(/'x','z','t'/),          &
      & longname='Kh',                               &
      & units='1', xtype='double' )
  
    !
    call HistoryAddVariable(                         &
      & varname='MixRt', dims=(/'x','z','s','t'/),   &
      & longname='Mixing Ratio',                     &
      & units='kg kg|-1"', xtype='double' )
    
    !----------------------------------------------------------------
    ! ̤λѲ
    !----------------------------------------------------------------
    call HistoryAddVariable(                                        &
      & varname='PotTempAdv', dims=(/'z','t'/),                     &
      & longname='Advection term of potential temperature',         &
      & units='K day|-1"', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='PotTempTurb', dims=(/'z','t'/),                    &
      & longname='Turbulence term of potential temperature',        &
      & units='K day|-1"', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='PotTempDisp', dims=(/'z','t'/),                    &
      & longname='Dissipation term of potential temperature',       &
      & units='K day|-1"', xtype='double' ) 

    call HistoryAddVariable(                                        &
      & varname='PotTempRad', dims=(/'z','t'/),                     &
      & longname='Radiation term of potential temperature',         &
      & units='K day|-1"', xtype='double' ) 
    
    call HistoryAddVariable(                                         &
      & varname='PotTempDiff', dims=(/'z','t'/),                     &
      & longname='Numerical diffusion term of potential temperature',&
      & units='K day|-1"', xtype='double' ) 
    
    call HistoryAddVariable(                                         &
      & varname='PotTempCond', dims=(/'z','t'/),                     &
      & longname='Latent heat term of potential temperature',        &
      & units='K day|-1"', xtype='double' ) 

    call HistoryAddVariable(                                         &
      & varname='PotTempDamp', dims=(/'z','t'/),                     &
      & longname='Newtonian Cooling term of potential temperature',  &
      & units='K day|-1"', xtype='double' ) 

    !-----------------------------------------------------------  
    ! ܾν
    !-----------------------------------------------------------  
    !̵Ϥδܾ
    call HistoryAddVariable(                          &
      & varname='ExnerBasicZ', dims=(/'x','z'/),      &
      & longname='nondimensional pressure', units='1',&
      & xtype='double' )
    
    !̤δܾ
    call HistoryAddVariable(                          &
      & varname='PotTempBasicZ', dims=(/'x','z'/),    &
      & longname='potential temperature',             &
      & units='K', xtype='double' )
    
    !̩٤δܾ
    call HistoryAddVariable(                         &
      & varname='DensBasicZ', dims=(/'x','z'/),      &
      & longname='density',                          &
      & units='Kg/m^3', xtype='double' )
    
    !®٤δܾ
    call HistoryAddVariable(                         &
      & varname='VelSoundBasicZ', dims=(/'x','z'/),  &
      & longname='sound velocity',                   &
      & units='m/s|2', xtype='double' )
    
    !٤δܾ
    call HistoryAddVariable(                         &
      & varname='TempBasicZ', dims=(/'x','z'/),      &
      & longname='Temperature of basic state',       &
      & units='K', xtype='double' ) 
    
    !Ϥδܾ
    call HistoryAddVariable(                         &
      & varname='PressBasicZ', dims=(/'x','z'/),     &
      & longname='Pressure of basic state',          &
      & units='Pa', xtype='double' ) 
    
    !δܾ
    call HistoryAddVariable(                               &
      & varname='MixRtBasicZ', dims=(/'x','z','s'/),      &
      & longname='Mixing ratio of Condensible volatiles',  &
      & units='kg/kg', xtype='double' ) 
    
    !ʬ̸
    call HistoryAddVariable(                         &
      & varname='EffMolWtBasicZ', dims=(/'x','z'/),  &
      & longname='Effect of Mole Weight',            &
      & units='1', xtype='double' ) 

    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------
    call HistoryPut( 'DensBasicZ',     xz_DensBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'ExnerBasicZ',    xz_ExnerBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'PotTempBasicZ',  xz_PotTempBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'VelSoundBasicZ', xz_VelSoundBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'TempBasicZ',     xz_TempBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'PressBasicZ',    xz_PressBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    call HistoryPut( 'MixRtBasicZ',    xza_MixRtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum))
    call HistoryPut( 'EffMolWtBasicZ', xz_EffMolWtBasicZ(FileXMin:FileXMax, FileZMin:FileZMax))
    
  end subroutine HistoryFile_Open


!!!------------------------------------------------------------------------------!!!
  subroutine HistoryFile_OutPut(   &
    & Time,                        &
    & xz_PotTemp,                  &
    & xz_Exner,                    &   
    & pz_VelX,                     &
    & xr_VelZ,                     &
    & xza_MixRt,                   &
    & xz_Km,                       &
    & xz_Kh                        )
    !
    !ͽѿΥҥȥեؤν. ϻˤȾʻΰ֤ǥץåȤ. 
    !
    
    !⥸塼ɤ߹
    use average,   only: xz_avr_pz, xz_avr_xr

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Time
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Km(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xz_Kh(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in) :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    real(8)             :: xz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: xz_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)

    !----------------------------------------------------------------
    ! ʻ֤Ѵ
    !----------------------------------------------------------------
    xz_VelX = xz_avr_pz( pz_VelX )
    xz_VelZ = xz_avr_xr( xr_VelZ )
    

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call HistoryPut( 't', Time )
    
    call HistoryPut('Exner',                                  &
      & xz_Exner(FileXMin:FileXMax, FileZMin:FileZMax) )
    
    call HistoryPut('PotTemp',                                &
      & xz_PotTemp(FileXMin:FileXMax, FileZMin:FileZMax) )
    
    call HistoryPut( 'VelX',                                  &
      & xz_VelX(FileXMin:FileXMax, FileZMin:FileZMax)    )
    
    call HistoryPut( 'VelZ',                                  &
      & xz_VelZ(FileXMin:FileXMax, FileZMin:FileZMax)    )

    call HistoryPut( 'Km',                                    &
      & xz_Km(FileXMin:FileXMax, FileZMin:FileZMax)      )
    
    call HistoryPut( 'Kh',                                    &
      & xz_Kh(FileXMin:FileXMax, FileZMin:FileZMax)      )
    
    call HistoryPut( 'MixRt',                                 &
      & xza_MixRt(FileXMin:FileXMax, FileZMin:FileZMax, 1:SpcNum)  )

    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call StoreMeanX()
    call HistoryPut( 'PotTempAdv',  z_Adv(FileZMin:FileZMax)  )
    call HistoryPut( 'PotTempTurb', z_Turb(FileZMin:FileZMax) )
    call HistoryPut( 'PotTempDisp', z_Disp(FileZMin:FileZMax) )
    call HistoryPut( 'PotTempDiff', z_Diff(FileZMin:FileZMax) )
    call HistoryPut( 'PotTempRad',  z_Rad(FileZMin:FileZMax)  )
    call HistoryPut( 'PotTempCond', z_Cond(FileZMin:FileZMax) )
    call HistoryPut( 'PotTempDamp', z_Damp(FileZMin:FileZMax) )
    
  end subroutine HistoryFile_OutPut



!!!------------------------------------------------------------------------------!!!
  subroutine HistoryFile_Close
    !
    !ҥȥեΥ
    !
    
    !ۤηػ
    implicit none

    !եĤ
    call HistoryClose
  
  end subroutine HistoryFile_Close


end module HistoryFileIO
