!c Description: 
!c   w ˴ؤήη׻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c   1.0        2003-12-04    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_adv_w
  interface

     subroutine adv_w(u, w, omg, w_adv)
       use gridset, only: bm
       real(8), intent(in)               :: u(-bm:,-bm:)
       real(8), intent(in)               :: w(-bm:,-bm:)
       real(8), intent(in)               :: omg(-bm:,-bm:)
       real(8), intent(out), allocatable :: w_adv(:,:)
     end subroutine adv_w

  end interface
end module if_adv_w



subroutine adv_w(u, w, omg, w_adv)

  !--- ⥸塼ƽ
  use gridset
  use physprm
  use if_heikin
  use if_bibun
  use if_bibun2

  !--- ۤηػ
  implicit none

  !--- ѿ
  real(8), intent(in)               :: u(-bm:,-bm:)
  real(8), intent(in)               :: w(-bm:,-bm:)
  real(8), intent(in)               :: omg(-bm:,-bm:)
  real(8), intent(out), allocatable :: w_adv(:,:)

  !--- ѿ
  real(8), allocatable              :: w_dif(:,:)
  real(8), allocatable              :: w_x(:,:)
  real(8), allocatable              :: w_xx(:,:)
  real(8), allocatable              :: w_z(:,:)
  real(8), allocatable              :: w_zz(:,:)
  real(8), allocatable              :: u_bxbz(:,:)
  
  !--- Ѱ
  if (allocated(w_adv)) deallocate(w_adv)
  if (allocated(w_dif)) deallocate(w_dif)
  allocate(w_adv(-bm:im+bm, -bm:km+bm), w_dif(-bm:im+bm, -bm:km+bm))
  w_adv = 0.0d0; w_dif = 0.0d0
  
  !--- ʿѲ
  call heikin(32, u, u_bxbz)
  
  !--- ʬ黻
  call bibun(331, w, w_x)
  call bibun(332, w, w_z)
  call bibun2(331, w, w_xx)
  call bibun2(332, w, w_zz)
  
  !--- ȸ
  w_dif = nuh * w_xx + nuv * w_zz
  
  !--- ή
  w_adv = u_bxbz * w_x + omg * w_z - w_dif 

  w_adv = 0.0d0

  !--- κ
  deallocate(w_dif, u_bxbz, w_x, w_z, w_xx, w_zz)
    
end subroutine adv_w
