program main

  use vtype_module
  use ni3_module
  use netcdf

  implicit none

  interface
    subroutine findfu( fn, ios, fu, mode )
      use vtype_module
      implicit none
      character(len=*), intent(in )           :: fn
      integer(i4b)    , intent(out)           :: ios, fu
      character(len=*), intent(in ), optional :: mode
    end subroutine findfu
  end interface

  character(len=extstr)            :: mode

  character(len=extstr)            :: ncfn_ps
  character(len=extstr)            :: ncfn
  character(len=extstr)            :: ncfn_out
  integer                          :: ncid_ps
  integer                          :: ncid
  integer                          :: ncid_out
  character(len=extstr)            :: varname_ps
  character(len=extstr)            :: varname
  character(len=extstr)            :: varname_out

  character(len=extstr)            :: name
!!$  character(len=extstr)            :: stdname
  character(len=extstr)            :: units

  integer(i4b)                       :: NDims
  character(len=extstr), allocatable :: a_DimNames(:)
  integer(i4b)                       :: NDims_out
  character(len=extstr), allocatable :: a_DimNames_out(:)

  integer                          :: imax
  integer                          :: jmax
  integer                          :: kmax
  integer                          :: tmax

  real(dp)                         :: FillValue

  real(dp)           , allocatable :: x_Lon(:)
  real(dp)           , allocatable :: y_Lat(:)
  real(dp)           , allocatable :: z_Sigma(:)
  real(dp)           , allocatable :: r_Sigma(:)
  real(dp)           , allocatable :: xy_Ps (:,:)
  real(dp)           , allocatable :: xyz_Array(:,:,:)
  real(dp)           , allocatable :: xyr_Press(:,:,:)
  real(dp)           , allocatable :: xy_Array(:,:)
  real(dp)           , allocatable :: a_Time(:)

  integer                          :: DimLength
  real(dp)           , allocatable :: a_Weight(:)

  logical :: FlagDensWeight

  logical                          :: ex
  integer                          :: ios

!!$  integer                          :: DayStart
!!$  integer                          :: DayEnd

  real(DP) :: Grav


  integer                          :: k
  integer                          :: l
  integer                          :: t


  character(extstr)                :: fn

  character(extstr)                :: ctlfn = "vi.cntl"
  integer                          :: ctlfu


  namelist /file/  ncfn_ps, varname_ps, ncfn, varname, ncfn_out, varname_out, FlagDensWeight
  namelist /const/  Grav



  ncfn_ps    = "q"
  varname_ps = "q"
  ncfn       = "t"
  varname    = "t"
  ncfn_out   = "out.nc"
  varname_out = varname
  FlagDensWeight = .true.

  Grav       = 9.80665

  fn = ctlfn
  inquire( file = fn, exist = ex )
  if( .not. ex ) then
    write( 6, * ) "Control file ", trim( ctlfn ), " does not exit."
    write( 6, * ) "Control file should contain namelists listed below."
    write( 6, * ) "    &input"
    write( 6, * ) "        dir       = '.'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &lander"
    write( 6, * ) "        LanderSym = 'VL1'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &output"
    write( 6, * ) "        outfn     = 'vl1_dmps.dat'"
    write( 6, * ) "    &end"
    write( 6, * ) "    &dayinfo"
    write( 6, * ) "        DayStart  =     1"
    write( 6, * ) "        DayEnd    = 10000"
    write( 6, * ) "    &end"
    stop
  end if
  call findfu( fn, ios, ctlfu )
  if( ios /= 0 ) then
    write( 6, * ) 'STOP: ', ios
    stop
  end if
  open( ctlfu, file = fn, status = 'unknown' )
  rewind( ctlfu )

  read( ctlfu, nml = const, iostat = ios )

  rewind( ctlfu )



  loop_namelist : do

    read( ctlfu, nml = file, iostat = ios )
    if ( ios /= 0 ) exit
    write( 6, * ) 'Read   ', trim( ncfn_ps  )
    write( 6, * ) 'Read   ', trim( ncfn     )
    write( 6, * ) 'Output ', trim( ncfn_out )


    !----------------------------------------------------------
    !
    ! Preparing for ps file
    !
    mode = 'read'
    call ni3_open( ncfn_ps, mode, ncid_ps )
    mode = 'read'
    call ni3_open( ncfn   , mode, ncid    )
    !
    !----------------------------------------------------------

    !
    ! Number of dimensions are checked.
    !
    call ni3_inq_var( ncid, varname, ndims = NDims )
    allocate( a_DimNames( NDims ) )
    call ni3_inq_vardimnames( ncid, varname, NDims, a_DimNames )

    call ni3_inq_dimlen( ncid, a_DimNames(1)    , imax )
    call ni3_inq_dimlen( ncid, a_DimNames(2)    , jmax )
    call ni3_inq_dimlen( ncid, a_DimNames(NDims), tmax )
    allocate( x_Lon (0:imax-1) )
    allocate( y_Lat (1:jmax  ) )
    allocate( a_Time(1:tmax  ) )
    call ni3_get_var( ncid, a_DimNames(1)    , x_Lon  )
    call ni3_get_var( ncid, a_DimNames(2)    , y_Lat  )
    call ni3_get_var( ncid, a_DimNames(NDims), a_Time )
    call ni3_inq_dimlen( ncid, a_DimNames(3), kmax )
    allocate( z_Sigma(1:kmax) )
    call ni3_get_var( ncid, a_DimNames(3), z_Sigma )
    allocate( r_Sigma(0:kmax) )
    call ni3_get_var( ncid, 'sigm', r_Sigma )

    allocate( xy_Ps (0:imax-1, 1:jmax) )
    allocate( xyz_Array(0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_Press(0:imax-1, 1:jmax, 0:kmax) )
    allocate( xy_Array(0:imax-1, 1:jmax) )

    !----------------------------------------------------------
    !
    ! Preparing for output file
    !
    mode = 'new'
    call ni3_open( ncfn_out, mode, ncid_out )

    name = a_DimNames(1)
    call ni3_set_dim( ncid_out, name, NF90_REAL, x_Lon )
    call ni3_cp_atts( ncid, ncid_out, name )

    name = a_DimNames(2)
    call ni3_set_dim( ncid_out, name, NF90_REAL, y_Lat )
    call ni3_cp_atts( ncid, ncid_out, name )

    name = a_DimNames(3)
    call ni3_set_dim( ncid_out, name, NF90_REAL, z_Sigma )
    call ni3_cp_atts( ncid, ncid_out, name )

    name = a_DimNames(NDims)
    call ni3_def_dim( ncid_out, name, NF90_REAL, NF90_UNLIMITED )
    call ni3_cp_atts( ncid, ncid_out, name )

    name = 'sigm'
    call ni3_set_dim( ncid_out, name, NF90_REAL, r_Sigma )
    call ni3_cp_atts( ncid, ncid_out, name )

    do l = 1, NDims
      name = trim( a_DimNames(l) ) // "_weight"
      if ( ni3_chk_var( ncid, name ) ) then
        write( 6, * ) trim( name ), ' is added.'
        call ni3_def_var( ncid_out, name, NF90_REAL, 1, a_DimNames(l:l) )
        call ni3_cp_atts( ncid, ncid_out, name )
        call ni3_inq_dimlen( ncid, a_DimNames(l), DimLength )
        allocate( a_Weight(DimLength) )
        call ni3_get_var( ncid    , name, a_Weight )
        call ni3_put_var( ncid_out, name, a_Weight )
        deallocate( a_Weight )
      end if
    end do

!!$  name    = "time"
!!$  stdname = "time"
!!$  units   = "days since 0000-01-01"
!!$  call ni3_def_dim( ncid_out, name, NF90_REAL, NF90_UNLIMITED, stdname = stdname, units  = units )
!!$  call ni3_cp_atts( ncid_ice, ncid_out, name )


    NDims_out = 3
    allocate( a_DimNames_out( NDims_out ) )
    a_DimNames_out(1) = a_DimNames(1)
    a_DimNames_out(2) = a_DimNames(2)
    a_DimNames_out(3) = a_DimNames(4)
    name = varname_out
    call ni3_def_var( ncid_out, name, NF90_REAL, NDims_out, a_DimNames_out )
    call ni3_cp_atts( ncid, ncid_out, varname, name )
    call ni3_get_att( ncid    , varname, 'units', units )
    units = trim(units) // ' kg m-2'
    call ni3_put_att( ncid_out, name, 'units', units )


    if ( ni3_chk_att( ncid, varname, "missing_value" ) ) then
      call ni3_get_att( ncid    , varname    , "missing_value", FillValue )
      call ni3_put_att( ncid_out, varname_out, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname_out, "_FillValue"   , real(FillValue) )
    else if ( ni3_chk_att( ncid, varname, "_FillValue" ) ) then
      call ni3_get_att( ncid    , varname    , "_FillValue"   , FillValue )
      call ni3_put_att( ncid_out, varname_out, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname_out, "_FillValue"   , real(FillValue) )
    else
      FillValue = -999.0
      call ni3_put_att( ncid_out, varname_out, "missing_value", real(FillValue) )
      call ni3_put_att( ncid_out, varname_out, "_FillValue"   , real(FillValue) )
    end if
    !
    !----------------------------------------------------------


    do t = 1, tmax

      if ( mod( t, tmax/100 ) == 0 ) &
        & print *, t, tmax

      call ni3_get_varss( ncid_ps, varname_ps, t, xy_Ps )
      call ni3_get_varss( ncid   , varname   , t, xyz_Array )

!!$      do k = 1, kmax
!!$        xyz_P(:,:,k) = z_VLev(k)
!!$      end do
      do k = 0, kmax
        xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
      end do
      xy_Array = 0.0_DP
      if ( FlagDensWeight ) then
        do k = kmax, 1, -1
          xy_Array = xy_Array &
            & + xyz_Array(:,:,k) &
            &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
        end do
      else
        do k = kmax, 1, -1
          xy_Array = xy_Array &
            & + xyz_Array(:,:,k) &
            &   * ( r_Sigma(k-1) - r_Sigma(k) )
        end do
      end if

      call ni3_put_varss( ncid_out, "time"     , t, a_Time(t) )
      call ni3_put_varss( ncid_out, varname_out, t, xy_Array  )

    end do


    deallocate( a_DimNames     )
    deallocate( a_DimNames_out )
    deallocate( x_Lon )
    deallocate( y_Lat )
    deallocate( z_Sigma )
    deallocate( a_Time )
    deallocate( r_Sigma )
    deallocate( xy_Ps )
    deallocate( xyz_Array )
    deallocate( xyr_Press )
    deallocate( xy_Array  )


    call ni3_close( ncid_ps  )
    call ni3_close( ncid     )
    call ni3_close( ncid_out )

  end do loop_namelist

  close( ctlfu )

end program main
