= 履歴

* 2015/07/01 yot


= 概要

DCPAM を用いて計算した空間 3 次元データを鉛直積分する. 


= 使い方

== 必要なライブラリ

* NetCDF

== コンパイル

* Makefile を編集
  * 以下を指定
    * Fortran コンパイラ
    * NetCDF ライブラリのディレクトリ
* make の実行
  % make

== 実行

* 設定ファイル vi.nml を用意
* 実行
  % a.out


= 設定ファイル

設定ファイル vi.nml には, 
* 重力加速度
* ファイル・変数情報
  * 入力ファイル名
  * 出力ファイル名 (のランク番号を除いたもの)
  * 変数名
を namelist によって設定する. 


== 重力加速度

密度の重みをかけて鉛直積分する際に用いる重力加速度は下のように設定する. 

  &const
    Grav = 9.80665
  /

ここで, 単位は m s-2 である.


== ファイル・変数情報

ファイル・変数情報は以下のように設定する

一つの変数ごとに下のように一項目設定する.

  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var1.nc',
    varname     = 'Var1',
    ncfn_out    = './out/VIVar1.nc'
    varname_out = 'VIVar1',
    FlagDensWeight = .true.
  &end
  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var2.nc',
    varname     = 'Var2',
    ncfn_out    = './out/VIVar2.nc'
    varname_out = 'VIVar2',
    FlagDensWeight = .true.
  &end

ここで, それぞれの変数の意味は下の通り.
* ncfn_ps
  鉛直積分のために使用する地表面気圧の NetCDF ファイル名.
* varname_ps
  鉛直積分のために使用する地表面気圧の変数名.
* ncfn
  鉛直積分する変数の入った NetCDF ファイル名.
* varname
  鉛直積分する変数名.
* ncfn_out
  鉛直積分した結果の NetCDF ファイル名.
* varname_out
  鉛直積分した結果の変数名.
* FlagDensWeight
  鉛直積分の際に密度重みをかけるかどうかの設定 (.true./.false.)
  物理量の単位を X とするとき, 
  * 密度重みをかけて鉛直積分した結果の単位は X kg m-2
  * 密度重みをかけずに鉛直積分した結果の単位は X (sigma で積分)
