= History

* 2015/07/01 yot


= Summary

Integrate a variable vertically. 


= Usage

== Required library

* NetCDF

== Compilation

* Edit Makefile
  * Change following items
    * Fortran compiler
    * path to NetCDF library
* make
  % make

== Execution

* Prepare a configuration file named merge.nml
* Execution
  % a.out


= Configuration file

== Gravitational acceleration

Gravitation acceleration used for vertical integration with a weight of density is specified as follows.

  &const
    Grav = 9.80665
  /

Here, a unit of Grav is m s-2. 


== Input/Output files and variables

Input/Output files and variables are specified as follows. 

One block includes one variable. 
Several lines are processed downward. 

  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var1.nc',
    varname     = 'Var1',
    ncfn_out    = './out/VIVar1.nc'
    varname_out = 'VIVar1',
    FlagDensWeight = .true.
  &end
  &file
    ncfn_ps     = '../Ps.nc',
    varname_ps  = 'Ps',
    ncfn        = '../Var2.nc',
    varname     = 'Var2',
    ncfn_out    = './out/VIVar2.nc'
    varname_out = 'VIVar2',
    FlagDensWeight = .true.
  &end

* Meaning of each variable is as follows. 
  * ncfn_ps
    Name of NetCDF file of surface pressure.
  * varname_ps
    Name of variable of surface pressure. 
  * ncfn
    Name of NetCDF file which include a variable to be integrated vertically. 
  * varname
    Name of variable to be integrated vertically. 
  * ncfn_out
    Name of output NetCDF file. 
  * varname_out
    Name of output vertically integrated variable.
  * FlagDensWeight
    Flag whether integration is performed with a weight of density or not.
    If unit of a variable is X, 
    * unit of an output is X kg m-2 for weighted integration
    * unit of an output is X for non-weighted integration
