# -*- coding: iso-2022-jp -*-
require 'gphys_const_v1.2'
require 'gphys_methods_v1.7'
require "numru/ggraph"
include NumRu
include NMath

dir = ARGV[0]
vname = ARGV[1]
plev = ARGV[2].to_f
iyrs = ARGV[3].to_i
iyre = ARGV[4].to_i
imon = ARGV[5].to_i

title = MonNames[imon-1]


if vname == 'msf_rmean'
  vnameinfile = 'v_rmean'
else
  vnameinfile = vname
end
gphys = GPhys::IO.open( dir+'/'+vnameinfile+'.nc', vnameinfile )


gphyszm = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )
#gphyszm = gphyszm.mean('lon')
if vname == 'msf_rmean'
  gphyszm = calc_msf( gphyszm )
end
rmiss = gphys.get_att('missing_value')[0]

gphyszm = gphyszm.cut('level'=>plev)


DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2$B$K2hLLJ,3d(B, 'y'=yoko: $B:8>e"*1&>e"*:82<(B...
DCL.sgpset('lcntl', false)   # $B@)8fJ8;z$r2r<a$7$J$$(B
DCL.sgpset('lfull',true)     # $BA42hLLI=<((B
DCL.uzfact(0.7)             # $B:BI8<4$NJ8;zNs%5%$%:$r(B 0.75 $BG\(B
DCL.sgpset('lfprop',true)    # $B%W%m%]!<%7%g%J%k%U%)%s%H$r;H$&(B

DCL.glpset('lmiss',true)
DCL.glpset('rmiss',rmiss)

#< GGraph $B$K$h$k(B $BIA2h(B >
# Earth
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e5,1e3]
# Mars
GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.15,0.6], 'window'=>[-90,90,-1.0,1.0]
GGraph.set_axes('xlabelint'=>30)

GGraph.line( gphyszm, true )

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
