# -*- coding: iso-2022-jp -*-
require 'gphys_const_v1.2'
require 'gphys_methods_v1.7'
require "numru/ggraph"
include NumRu
include NMath

dir = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
imon = ARGV[4].to_i

title = MonNames[imon-1]


if vname == 'msf_rmean'
  vnameinfile = 'v_rmean'
elsif vname == 'msf_rmeanlog'
  vnameinfile = 'v_rmean'
else
  vnameinfile = vname
end
gphys = GPhys::IO.open( dir+'/'+vnameinfile+'.nc', vnameinfile )


gphyszm = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )
#gphyszm = gphyszm.mean('lon')
if vname == 'msf_rmean'
  gphyszm = calc_msf( gphyszm )
elsif vname == 'msf_rmeanlog'
  gphyszm = calc_msf( gphyszm )
end
rmiss = gphys.get_att('missing_value')[0]

# $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
# $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
if vname == 'msf_rmean'
# Earth
  levels = [-20e2,-17.5e2,-15e2,-12.5e2,-10e2,-7.5e2,-5e2,-2.5e2,0,2.5e2,5e2,7.5e2,10e2,12.5e2,15e2,17.5e2,20e2]
# Mars
  levels = [-20e0,-17.5e0,-15e0,-12.5e0,-10e0,-7.5e0,-5e0,-2.5e0,0,2.5e0,5e0,7.5e0,10e0,12.5e0,15e0,17.5e0,20e0]
  levels = [-40e0,-35e0,-30e0,-25e0,-20e0,-15e0,-10e0,-5e0,0,5e0,10e0,15e0,20e0,25e0,30e0,35e0,40e0]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
  levels = [-100e0,-90e0,-80e0,-70e0,-60e0,-50e0,-40e0,-30e0,-20e0,-10e0,0,10e0,20e0,30e0,40e0,50e0,60e0,70e0,80e0,90e0,100e0]
  patterns = [10999,15999,20999,25999,30999,32999,35999,40999,42999,45999,50999,55999,60999,65999,70999,75999,80999,82999,85999,90999,92999,95999]
elsif vname == 'msf_rmeanlog'
# Mars
  levels = [-3e2,-1e2,-3e1,-1e1,-3e0,-1e0,-3e-1,-1e-1,-3e-2,-1e-2,0,1e-2,3e-2,1e-1,3e-1,1e0,3e0,1e1,3e1,1e2,3e2]
  patterns = [10999,12999,15999,17999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,87999,90999,92999,95999]
end

# Color map is changed for mass stream function.
if vname == 'U'
#  DCL.sgscmn(4)  # blue-cyan-white-yellow-red
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'msf_rmean'
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'msf_rmeanlog'
  DCL.sgscmn(14) # blue-white-red
end


DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2$B$K2hLLJ,3d(B, 'y'=yoko: $B:8>e"*1&>e"*:82<(B...
DCL.sgpset('lcntl', false)   # $B@)8fJ8;z$r2r<a$7$J$$(B
DCL.sgpset('lfull',true)     # $BA42hLLI=<((B
DCL.uzfact(0.7)             # $B:BI8<4$NJ8;zNs%5%$%:$r(B 0.75 $BG\(B
DCL.sgpset('lfprop',true)    # $B%W%m%]!<%7%g%J%k%U%)%s%H$r;H$&(B

DCL.glpset('lmiss',true)
DCL.glpset('rmiss',rmiss)

#< GGraph $B$K$h$k(B $BIA2h(B >
# Earth
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e5,1e3]
# Mars
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e3,1e-1]
GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e3,1e-2]
GGraph.set_axes('xlabelint'=>30)

GGraph.tone( gphyszm, true, 'lev'=>levels, 'pat'=>patterns, 'annotate'=>false )
#if vname == 'V' || vname =='U'
#  GGraph.contour( gphyszm, false, 'lev'=>[0], 'index'=>3, 'annotate'=>false )
#end
GGraph.contour( gphyszm, false, 'lev'=>levels, 'index'=>3, 'annotate'=>false )
GGraph.color_bar

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
