!= Chou et al (1998) ˤûѱǥ
!
!= Cloud model for short wave radiation model described by Chou et al (1998)
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_C1998
  !
  != Chou et al (1998) ˤûѱǥ
  !
  != Cloud model for short wave radiation model described by Chou et al (1998)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ûͥǥ.
  !
  ! This is a model of short wave radiation. 
  !
  !== References
  !
  !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee, 
  !    Parameterizations for cloud overlapping and shortwave single-scattering 
  !    properties for use in general circulation and cloud ensemble models, 
  !    J. Climate, 11, 202-214, 1998.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  ! 
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  !
  ! Grid points settings
  !
  use gridset, only: imax, & !
                             ! Number of grid points in longitude
    &                jmax, & !
                             ! Number of grid points in latitude
    &                kmax    !
                             ! Number of vertical level

  ! Declaration statements
  !
  implicit none
  private

  !
  ! Public procedure
  !
  public :: RadC1998CalcCloudOptProp
  public :: RadC1998Init


  integer , parameter :: nband1 = 8  ! * 14500 to 57143 cm-1 (0.175 to 0.70 micron)
  integer , parameter :: nband2 = 3  ! *  2600 to 14500 cm-1 (0.70-10 micron)

  real(DP), save      :: aa_WatCloudExtCoefParams(1:2, 1:nband1+nband2)
  real(DP), save      :: aa_WatCloudCoAlbParams  (1:3, 1:nband1+nband2)
  real(DP), save      :: aa_WatCloudAFParams     (1:3, 1:nband1+nband2)
  real(DP), save      :: aa_IceCloudExtCoefParams(1:2, 1:nband1+nband2)
  real(DP), save      :: aa_IceCloudCoAlbParams  (1:3, 1:nband1+nband2)
  real(DP), save      :: aa_IceCloudAFParams     (1:3, 1:nband1+nband2)


  logical , save     :: rad_c1998_inited

  data rad_c1998_inited /.false./



  ! Table 2.
  data aa_WatCloudExtCoefParams &
    & / &
    !   a0       a1
    &   -6.59d-3,  1.65d0, & ! 1(1)
    &   -6.59d-3,  1.65d0, & ! 2(1)
    &   -6.59d-3,  1.65d0, & ! 3(1)
    &   -6.59d-3,  1.65d0, & ! 4(1)
    &   -6.59d-3,  1.65d0, & ! 5(1)
    &   -6.59d-3,  1.65d0, & ! 6(1)
    &   -6.59d-3,  1.65d0, & ! 7(1)
    &   -6.59d-3,  1.65d0, & ! 8(1)
    &   -1.01d-2,  1.72d0, & ! 9
    &   -1.66d-2,  1.85d0, & !10
    &   -3.39d-2,  2.16d0  & !11
    & /


  ! Table 3.
  data aa_WatCloudCoAlbParams &
    & / &
    !    b0       b1        b2
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
    &    7.15d-8, 8.45d-6, -4.15d-8, & ! 1
    &   -1.99d-4, 8.88d-4, -6.50d-6, & !10
    &    1.21d-2, 1.79d-2, -3.69d-4  & !11
    & /

  ! Table 4.
  data aa_WatCloudAFParams &
    & / &
    !    c0       c1       c2
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 1
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 2
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 3
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 4
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 5
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 6
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 7
    &    8.26d-1, 5.29d-3, -1.49d-6, & ! 8
    &    7.94d-1, 8.32d-3, -2.33d-4, & ! 9
    &    7.45d-1, 1.37d-2, -3.82d-4, & !10
    &    8.35d-1, 2.57d-3,  5.52d-5  & !11
    & /


  data aa_IceCloudExtCoefParams &
    & / &
    !   a0       a1
    &   3.33d-3, 2.52d0, & ! 1
    &   3.33d-3, 2.52d0, & ! 2
    &   3.33d-3, 2.52d0, & ! 3
    &   3.33d-3, 2.52d0, & ! 4
    &   3.33d-3, 2.52d0, & ! 5
    &   3.33d-3, 2.52d0, & ! 6
    &   3.33d-3, 2.52d0, & ! 7
    &   3.33d-3, 2.52d0, & ! 8
    &   3.33d-3, 2.52d0, & ! 9
    &   3.33d-3, 2.52d0, & !10
    &   3.33d-3, 2.52d0  & !11
    & /

  ! Table 3.
  data aa_IceCloudCoAlbParams &
    & / &
    !    b0       b1        b2
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
    &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
    &   -2.60d-6, 7.46d-6,  0.0d0  , & ! 9
    &    2.15d-3, 7.37d-4, -1.34d-6, & !10
    &    8.94d-2, 2.99d-3, -1.04d-5  & !11
    & /

  ! Table 4.
  data aa_IceCloudAFParams &
    & / &
    !    c0       c1       c2
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 1
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 2
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 3
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 4
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 5
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 6
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 7
    &    7.46d-1, 1.05d-3, -2.64d-6, & ! 8
    &    7.49d-1, 1.20d-3, -3.67d-6, & ! 9
    &    7.61d-1, 1.42d-3, -3.96d-6, & !10
    &    8.41d-1, 1.26d-3, -3.85d-6  & !11
    & /


  character(*), parameter:: module_name = 'rad_C1998'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadC1998CalcCloudOptProp(               &
    & Spec, iband, xyz_REff,                         & ! (in )
    & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudAF  & ! (out)
    & )


    ! USE statements
    !

    character(len=*), intent(in ) :: SPEC
    integer         , intent(in ) :: iband
    real(DP)        , intent(in ) :: xyz_REff        (0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(out) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(out) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(out) :: xyz_CloudAF     (0:imax-1, 1:jmax, 1:kmax)



    !
    ! Work variables
    !
    integer :: l


    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_c1998_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    l = iband

    if ( Spec == 'Ice' ) then

      xyz_CloudExtCoef =                         &
        &   aa_IceCloudExtCoefParams(1,l)        &
        & + aa_IceCloudExtCoefParams(2,l) / xyz_REff

      xyz_CloudCoAlb  =                               &
        &   aa_IceCloudCoAlbParams(1,l)               &
        & + aa_IceCloudCoAlbParams(2,l) * xyz_REff    &
        & + aa_IceCloudCoAlbParams(3,l) * xyz_REff**2

      xyz_CloudAF =                                &
        &   aa_IceCloudAFParams(1,l)               &
        & + aa_IceCloudAFParams(2,l) * xyz_REff    &
        & + aa_IceCloudAFParams(3,l) * xyz_REff**2

    else if ( Spec == 'Liquid' ) then

      xyz_CloudExtCoef =                             &
        &   aa_WatCloudExtCoefParams(1,l)            &
        & + aa_WatCloudExtCoefParams(2,l) / xyz_REff

      xyz_CloudCoAlb  =                               &
        &   aa_WatCloudCoAlbParams(1,l)               &
        & + aa_WatCloudCoAlbParams(2,l) * xyz_REff    &
        & + aa_WatCloudCoAlbParams(3,l) * xyz_REff**2

      xyz_CloudAF =                                &
        &   aa_WatCloudAFParams(1,l)               &
        & + aa_WatCloudAFParams(2,l) * xyz_REff    &
        & + aa_WatCloudAFParams(3,l) * xyz_REff**2

    else
      call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
    end if


  end subroutine RadC1998CalcCloudOptProp

  !--------------------------------------------------------------------------------------

  subroutine RadC1998Init


!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

!!$    ! ҥȥǡ
!!$    ! History data output
!!$    !
!!$    use gtool_historyauto, only: HistoryAutoAddVariable


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read

    integer :: l


!!$    ! NAMELIST ѿ
!!$    ! NAMELIST group name
!!$    !
!!$    namelist /rad_C1998_nml/ !&
!!$      & ShortAtmosAlbedo
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "rad_C1998#RadC1998Init"
!!$          ! Υɤ򻲾ȤΤ.
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "rad_LH74#RadLH74Init" for the default values.
!!$          !


    if ( rad_c1998_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = rad_C1998_nml,      & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    do l = 1, nband1 + nband2
      ! from g-1 m2 to kg-1 m2
      aa_WatCloudExtCoefParams(1,l) = aa_WatCloudExtCoefParams(1,l) * 1.0d3
      aa_IceCloudExtCoefParams(1,l) = aa_IceCloudExtCoefParams(1,l) * 1.0d3
      ! from g-1 m2 micron to kg-1 m2 m
      aa_WatCloudExtCoefParams(2,l) = aa_WatCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6
      aa_IceCloudExtCoefParams(2,l) = aa_IceCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6

      ! from micron-1 to m-1
      aa_WatCloudCoAlbParams  (2,l) = aa_WatCloudCoAlbParams  (2,l) * 1.0d6
      aa_IceCloudCoAlbParams  (2,l) = aa_IceCloudCoAlbParams  (2,l) * 1.0d6
      ! from micron-2 to m-2
      aa_WatCloudCoAlbParams  (3,l) = aa_WatCloudCoAlbParams  (3,l) * 1.0d12
      aa_IceCloudCoAlbParams  (3,l) = aa_IceCloudCoAlbParams  (3,l) * 1.0d12

      ! from micron-1 to m-1
      aa_WatCloudAFParams     (2,l) = aa_WatCloudAFParams     (2,l) * 1.0d6
      aa_IceCloudAFParams     (2,l) = aa_IceCloudAFParams     (2,l) * 1.0d6
      ! from micron-2 to m-2
      aa_WatCloudAFParams     (3,l) = aa_WatCloudAFParams     (3,l) * 1.0d6
      aa_IceCloudAFParams     (3,l) = aa_IceCloudAFParams     (3,l) * 1.0d6
    end do


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'ShortAtmosAlbedo = %f', d = (/ ShortAtmosAlbedo /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_c1998_inited = .true.

  end subroutine RadC1998Init

  !--------------------------------------------------------------------------------------

end module rad_C1998
