!= û ()
!
!= Short wave (insolation) incoming
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: radiation_short_income.f90,v 1.3 2009-03-15 11:34:57 morikawa Exp $
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module radiation_short_income
  !
  != û ()
  !
  != Short wave (insolation) incoming
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! û () ׻ޤ.
  !
  ! Calculate short wave (insolation) incoming radiation. 
  !
  !== Procedures List
  !
  ! ShortIncoming      :: û () η׻
  ! ------------       :: ------------
  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
  !
  !== NAMELIST
  !
  ! NAMELIST#radiation_short_income_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: ShortIncoming

  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_short_income_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !

  real(DP), save:: SolarConst
                              ! . 
                              ! Solar constant
  real(DP), save:: AtmosAlbedo
                              ! 絤٥. 
                              ! Albedo of air

!!$  real(DP), save:: EpsOrb
!!$                              ! ƻг. 
!!$                              ! Inclination of equator to orbit
!!$  real(DP), save:: EqnOrb
!!$                              ! . 
!!$                              ! 
  real(DP), save:: IncomAIns
                              ! $ A_{ins} $ . ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
  real(DP), save:: IncomBIns
                              ! $ B_{ins} $ . ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomAZet
                              ! $ A_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomBZet
                              ! $ B_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 


  real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux
  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)


  character(*), parameter:: module_name = 'radiation_short_income'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: radiation_short_income.f90,v 1.3 2009-03-15 11:34:57 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface ShortIncoming
    module procedure ShortIncoming
  end interface

contains

  subroutine ShortIncoming( &
    & xy_IncomRadSFlux, xy_InAngle & ! (out)
    & )
    !
    ! û () ׻ޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: y_Lat  ! $ \varphi $ [rad.] . . Latitude

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xy_IncomRadSFlux (0:imax-1, 1:jmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(out):: xy_InAngle (0:imax-1, 1:jmax)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. radiation_short_income_inited ) call ShtIncomeInit

    ! ǯ, ʿͤη׻
    ! Calculate annual mean, daily mean insolation
    !
    do i = 0, imax - 1
      do j = 1, jmax
        xy_IncomRadSFlux(i,j) = &
          &  - SolarConst * (1.0_DP - AtmosAlbedo ) &
          &    * ( IncomAIns + IncomBIns * cos( y_Lat(j) )**2 )

        if ( xy_IncomRadSFlux(i,j) < 0.0_DP ) then
          xy_InAngle(i,j) = 1.0_DP / ( IncomAZet + IncomBZet * cos( y_Lat(j) )**2 )
        else
          xy_IncomRadSFlux(i,j) = 0.
          xy_InAngle(i,j) = 0.
        end if
      end do
    end do


    ! Ѳ, Ѳη׻
    ! Calculate with seasonal change and diurnal change
    !

    ! AGCM5 ܿͽ. 
    ! Importation from AGCM5 is planed

  end subroutine ShortIncoming

  !-------------------------------------------------------------------

  subroutine ShtIncomeInit
    !
    ! radiation_short_income ⥸塼νԤޤ. 
    ! NAMELIST#radiation_short_income_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "radiation_short_income" module is initialized. 
    ! "NAMELIST#radiation_short_income_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /radiation_short_income_nml/ &
      & SolarConst, AtmosAlbedo, &
!!!$      & EpsOrb, EqnOrb, &
      & IncomAIns, IncomBIns, IncomAZet, IncomBZet
          !
          ! ǥեͤˤĤƤϽ³ "radiation_short_income#ShtIncomeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_short_income#ShtIncomeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( radiation_short_income_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    SolarConst  = 1380.0_DP
    AtmosAlbedo = 0.2_DP
!!$    EpsOrb = 23.5_DP
!!$    EqnOrb = 110.0_DP
    IncomAIns   = 0.127_DP
    IncomBIns   = 0.183_DP
    IncomAZet   = 0.410_DP
    IncomBZet   = 0.590_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = radiation_short_income_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'xxxxx' , &
!!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
!!$      & 'xxxx', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'ShortIncomming:' )
    call MessageNotify( 'M', module_name, '  SolarConst  = %f', d = (/ SolarConst  /) )
    call MessageNotify( 'M', module_name, '  AtmosAlbedo = %f', d = (/ AtmosAlbedo /) )
!!$    call MessageNotify( 'M', module_name, '  EpsOrb      = %f', d = (/ EpsOrb      /) )
!!$    call MessageNotify( 'M', module_name, '  EqnOrb      = %f', d = (/ EqnOrb      /) )
    call MessageNotify( 'M', module_name, '  IncomAIns   = %f', d = (/ IncomAIns   /) )
    call MessageNotify( 'M', module_name, '  IncomBIns   = %f', d = (/ IncomBIns   /) )
    call MessageNotify( 'M', module_name, '  IncomAZet   = %f', d = (/ IncomAZet   /) )
    call MessageNotify( 'M', module_name, '  IncomBZet   = %f', d = (/ IncomBZet   /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    radiation_short_income_inited = .true.
  end subroutine ShtIncomeInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module radiation_short_income
