!= ʬʿѤ
!
!= Operation for integral and average
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: intavr_operate.F90,v 1.3 2011-06-19 10:56:27 yot Exp $ 
! Tag Name::  $Name: dcpam5-20120226 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module intavr_operate
  !
  != ʬʿѤ
  !
  != Operation for integral and average
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʬѤɸŤߤθʬʿΤδؿ󶡤ޤ. 
  ! {SPMODEL 饤֥}[http://www.gfd-dennou.org/library/spmodel]
  !  w_integral_module.f90 򻲹ͤ˺ޤ. 
  !
  ! Functions for integral or average operation with weight for integration
  ! are provided
  ! This program is created referring to 
  ! "w_integral_module.f90" in 
  ! {SPMODEL library}[http://www.gfd-dennou.org/library/spmodel]
  !
  !== Procedures List
  !
  ! IntLonLat_xy           :: ٷʬ
!!$  ! y_IntLon_xy, IntLon_x  :: ʬ
!!$  ! ya_IntLon_xya          :: ʬ (¿)
!!$  ! x_IntLat_xy, IntLat_y  :: ʬ
!!$  ! xa_IntLat_xya          :: ʬ (¿)
!!$  ! AvrLonLat_xy           :: ٷʿ
!!$  ! y_AvrLon_xy, AvrLon_x  :: ʿ
!!$  ! ya_AvrLon_xya          :: ʿ (¿)
!!$  ! x_AvrLat_xy, AvrLat_y  :: ʿ
!!$  ! xa_AvrLat_xya          :: ʿ (¿)
  ! ---------------------  :: ---------------------
  ! y_IntLon_xy, IntLon_x  :: Meridional integral
!!$  ! ya_IntLon_xya          :: Meridional integral (for multi layer)
!!$  ! x_IntLat_xy, IntLat_y  :: Zonal integral
!!$  ! xa_IntLat_xya          :: Zonal integral (for multi layer)
!!$  ! AvrLonLat_xy           :: Zonal and meridional average
!!$  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
!!$  ! ya_AvrLon_xya          :: Meridional average (for multi layer)
!!$  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
!!$  ! xa_AvrLat_xya          :: Zonal average (for multi layer)
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#intavr_operate_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ɸǡ
  ! Axes data settings
  !
  use axesset, only: &
    & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
    & y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: IntLonLat_xy
!!$  public:: y_IntLon_xy, ya_IntLon_xya, IntLon_x
!!$  public:: x_IntLat_xy, xa_IntLat_xya, IntLat_y
!!$  public:: IntLat_y
!!$  public:: AvrLonLat_xy
!!$  public:: y_AvrLon_xy, ya_AvrLon_xya, AvrLon_x
!!$  public:: x_AvrLat_xy, xa_AvrLat_xya, AvrLat_y

  ! ѿ
  ! Public variables
  !
  logical, save, public:: intavr_operate_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'intavr_operate'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20120226 $' // &
    & '$Id: intavr_operate.F90,v 1.3 2011-06-19 10:56:27 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  !-------------------------------------------------------------------

  function IntLonLat_xy( xy_Data )
    !
    ! 2 ٷٳʻǡΰʬ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight, y_Lat_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! Global integration of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
    !

    real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
    real(DP)             :: IntLonLat_xy

    ! ¹ʸ ; Executable statement
    !

    ! Old one to be deleted
!!$    IntLonLat_xy = IntLon_x( x_IntLat_xy( xy_Data ) )

    IntLonLat_xy = IntLat_y( y_IntLon_xy( xy_Data ) )

  end function IntLonLat_xy

  !-------------------------------------------------------------------

  function y_IntLon_xy( xy_Data )
    !
    ! 2 ٷٳʻǡηʬ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! Zonal integration of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight".
    !

    real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
    real(DP)             :: y_IntLon_xy (1:jmax)

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitudinal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitudinal direction

    ! ¹ʸ ; Executable statement
    !

    y_IntLon_xy = 0.0_DP
    do j = 1, jmax
      do i = 0, imax - 1
        y_IntLon_xy(j) = y_IntLon_xy(j) + xy_Data (i,j) * x_Lon_Weight(i)
      end do
    end do

  end function y_IntLon_xy

#ifdef LIB_MPI
  !-------------------------------------------------------------------

  function IntLat_y( y_Data )
    !
    ! 1 ٷٳʻǡΰʿ(1 ). 
    !
    ! Global mean of 2-dimensional (latitude and longitude)
    ! grid data.
    !

    ! MPI
    !
    use mpi_wrapper, only: nprocs, myrank, &
      & MPIWrapperISend, &
      & MPIWrapperIRecv, &
      & MPIWrapperWait

    ! ʻȿ
    ! Number of grid points and maximum truncated wavenumber settings
    !
    use gridset, only: a_jmax, jmax_max

    real(DP), intent(in) :: y_Data (1:jmax)
    real(DP)             :: IntLat_y


    ! Local variable
    !
    real(DP), allocatable :: a_SendBuf (:)
    real(DP), allocatable :: aa_RecvBuf(:,:)
    integer , allocatable :: a_iReqSend(:)
    integer , allocatable :: a_iReqRecv(:)

    integer               :: j
    integer               :: n


    ! ¹ʸ ; Executable statement
    !


    allocate( a_SendBuf (1:jmax_max) )
    allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
    allocate( a_iReqSend(0:nprocs-1) )
    allocate( a_iReqRecv(0:nprocs-1) )

    do j = 1, jmax
      a_SendBuf(j) = y_Data(j) * y_Lat_Weight(j)
    end do
    do j = jmax+1, jmax_max
      a_SendBuf(j) = -1.0d0
    end do

    do n = 0, nprocs-1
      if ( n == myrank ) then
        do j = 1, jmax
          aa_RecvBuf(:,n) = a_SendBuf
        end do
      else
        call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
        call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
      end if
    end do
    do n = 0, nprocs-1
      if ( n == myrank ) cycle
      call MPIWrapperWait( a_iReqSend(n) )
      call MPIWrapperWait( a_iReqRecv(n) )
    end do


    IntLat_y = 0.0d0
    do n = nprocs-1, 0, -1
      do j = 1, a_jmax(n) / 2
        IntLat_y = IntLat_y + aa_RecvBuf(j,n)
      end do
    end do
    do n = 0, nprocs-1
      do j = a_jmax(n) / 2 + 1, a_jmax(n)
        IntLat_y = IntLat_y + aa_RecvBuf(j,n)
      end do
    end do


    deallocate( a_SendBuf  )
    deallocate( aa_RecvBuf )
    deallocate( a_iReqSend )
    deallocate( a_iReqRecv )


  end function IntLat_y

#else
  !-------------------------------------------------------------------

  function IntLat_y( y_Data )
    !
    ! 1 ٳʻǡΰʬ(1 ). 
    !
    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! Meridonal integration of 1-dimensional (latitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "y_Lat_Weight".
    !
    real(DP), intent(in) :: y_Data (1:jmax)
    real(DP)             :: IntLat_y

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    IntLat_y = sum( y_Data * y_Lat_Weight )

  end function IntLat_y

#endif
  !-------------------------------------------------------------------
!!$
!!$  function AvrLonLat_xy( xy_Data )
!!$    !
!!$    ! 2 ٷٳʻǡΰʿ(1 ). 
!!$    !
!!$    ! Global mean of 2-dimensional (latitude and longitude)
!!$    ! grid data.
!!$    !
!!$
!!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
!!$
!!$
!!$    ! Local variable
!!$    !
!!$    real(DP)              :: AvrLonLat_xy
!!$
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! Old one to be deleted
!!$!    AvrLonLat_xy = AvrLon_x( x_AvrLat_xy( xy_Data ) )
!!$
!!$    AvrLonLat_xy = AvrLat_y( y_AvrLon_xy( xy_Data ) )
!!$
!!$
!!$  end function AvrLonLat_xy
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function x_IntLat_xy( xy_Data )
!!$    !
!!$    ! 2 ٷٳʻǡΰʬ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻Ƥ. 
!!$    !
!!$    ! Meridional integration of 2-dimensional (latitude and longitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight".
!!$    !
!!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
!!$    real(DP):: x_IntLat_xy (0:imax-1)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    x_IntLat_xy = 0.0_DP
!!$    do j = 1, jmax
!!$      x_IntLat_xy = x_IntLat_xy + xy_Data (:,j) * y_Lat_Weight(j)
!!$    enddo
!!$  end function x_IntLat_xy
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function xa_IntLat_xya( xya_Data )
!!$    !
!!$    ! 3 ٷٳʻǡΰʬ(¿). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻Ƥ. 
!!$    !
!!$    ! Meridional integration of 3-dimensional (latitude and longitude)
!!$    ! grid data. (for multi layer)
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight".
!!$    !
!!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: xa_IntLat_xya (0:imax-1, 1:kmax)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    do k = 1, kmax
!!$      xa_IntLat_xya(:,k) = x_IntLat_xy( xya_Data(:,:,k) )
!!$    end do
!!$  end function xa_IntLat_xya
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function ya_IntLon_xya( xya_Data )
!!$    !
!!$    ! 3 ٷٳʻǡηʬ(¿). 
!!$    !
!!$    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
!!$    ! ¤׻Ƥ. 
!!$    !
!!$    ! Zonal integration of 3-dimensional (latitude and longitude)
!!$    ! grid data. (for multi layer)
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "x_Lon_Weight".
!!$    !
!!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: ya_IntLon_xya (1:jmax,1:kmax)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    do k = 1, kmax
!!$      ya_IntLon_xya(:,k) = y_IntLon_xy( xya_Data(:,:,k) )
!!$    end do
!!$  end function ya_IntLon_xya
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function IntLon_x( x_Data )
!!$    !
!!$    ! 1 ٳʻǡηʬ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
!!$    ! ¤׻Ƥ. 
!!$    !
!!$    ! Zonal integration of 1-dimensional (longitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "x_Lon_Weight".
!!$    !
!!$    real(DP), intent(in):: x_Data (0:imax-1)
!!$    real(DP):: IntLon_x
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    IntLon_x = sum( x_Data * x_Lon_Weight )
!!$  end function IntLon_x
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function x_AvrLat_xy( xy_Data )
!!$    !
!!$    ! 2 ٷٳʻǡΰʿ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Meridional mean of 2-dimensional (latitude and longitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the mean grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight" 
!!$    ! and deviding by the sum total of "y_Lat_Weight".
!!$    !
!!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
!!$    real(DP):: x_AvrLat_xy (0:imax-1)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    x_AvrLat_xy = x_IntLat_xy ( xy_Data ) / sum( y_Lat_Weight )
!!$  end function x_AvrLat_xy
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function xa_AvrLat_xya( xya_Data )
!!$    !
!!$    ! 3 ٷٳʻǡΰʿ(¿). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Meridional mean of 3-dimensional (latitude and longitude)
!!$    ! grid data. (for multi layer)
!!$    !
!!$    ! Practically, the mean grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight" 
!!$    ! and deviding by the sum total of "y_Lat_Weight".
!!$    !
!!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: xa_AvrLat_xya (0:imax-1, 1:kmax)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    do k = 1, kmax
!!$      xa_AvrLat_xya(:,k) = x_AvrLat_xy( xya_Data(:,:,k) )
!!$    end do
!!$  end function xa_AvrLat_xya
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function y_AvrLon_xy( xy_Data )
!!$    !
!!$    ! 2 ٷٳʻǡηʿ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
!!$    ! ¤׻, x_Lon_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Zonal mean of 2-dimensional (latitude and longitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the mean grid data is calculated
!!$    ! by multiplying in each grid "x_Lon_Weight" 
!!$    ! and deviding by the sum total of "x_Lon_Weight".
!!$    !
!!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
!!$    real(DP):: y_AvrLon_xy (1:jmax)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    y_AvrLon_xy = y_IntLon_xy( xy_Data ) / sum( x_Lon_Weight )
!!$  end function y_AvrLon_xy
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  function ya_AvrLon_xya( xya_Data )
!!$    !
!!$    ! 3 ٷٳʻǡηʿ(¿). 
!!$    !
!!$    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
!!$    ! ¤׻, x_Lon_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Zonal mean of 3-dimensional (latitude and longitude)
!!$    ! grid data. (for multi layer)
!!$    !
!!$    ! Practically, the mean grid data is calculated
!!$    ! by multiplying in each grid "x_Lon_Weight" 
!!$    ! and deviding by the sum total of "x_Lon_Weight".
!!$    !
!!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: ya_AvrLon_xya (1:jmax, 1:kmax)
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    do k = 1, kmax
!!$      ya_AvrLon_xya(:,k) = y_AvrLon_xy( xya_Data(:,:,k) )
!!$    end do
!!$  end function ya_AvrLon_xya
!!$
!!$#ifdef LIB_MPI
!!$  !-------------------------------------------------------------------
!!$
!!$  function AvrLat_y( y_Data )
!!$    !
!!$    ! 1 ٳʻǡΰʿ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Meridonal mean of 1-dimensional (latitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight" 
!!$    ! and deviding by the sum total of "y_Lat_Weight".
!!$    !
!!$
!!$    ! MPI
!!$    !
!!$    use mpi_wrapper, only: nprocs, myrank, &
!!$      & MPIWrapperISend, &
!!$      & MPIWrapperIRecv, &
!!$      & MPIWrapperWait
!!$
!!$    ! ʻȿ
!!$    ! Number of grid points and maximum truncated wavenumber settings
!!$    !
!!$    use gridset, only: a_jmax, jmax_max
!!$
!!$    real(DP), intent(in):: y_Data (1:jmax)
!!$    real(DP):: AvrLat_y
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    real(DP), allocatable :: a_SendBuf (:)
!!$    real(DP), allocatable :: aa_RecvBuf(:,:)
!!$    integer , allocatable :: a_iReqSend(:)
!!$    integer , allocatable :: a_iReqRecv(:)
!!$
!!$    real(DP)              :: SumWeight
!!$
!!$    integer               :: j
!!$    integer               :: n
!!$
!!$    allocate( a_SendBuf (1:jmax_max) )
!!$    allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
!!$    allocate( a_iReqSend(0:nprocs-1) )
!!$    allocate( a_iReqRecv(0:nprocs-1) )
!!$
!!$    do j = 1, jmax
!!$      a_SendBuf(j) = y_Lat_Weight(j)
!!$    end do
!!$    do j = jmax+1, jmax_max
!!$      a_SendBuf(j) = -1.0d0
!!$    end do
!!$
!!$    do n = 0, nprocs-1
!!$      if ( n == myrank ) then
!!$        do j = 1, jmax
!!$          aa_RecvBuf(:,n) = a_SendBuf
!!$        end do
!!$      else
!!$        call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
!!$        call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
!!$      end if
!!$    end do
!!$    do n = 0, nprocs-1
!!$      if ( n == myrank ) cycle
!!$      call MPIWrapperWait( a_iReqSend(n) )
!!$      call MPIWrapperWait( a_iReqRecv(n) )
!!$    end do
!!$
!!$
!!$    if ( nprocs == 1 ) then
!!$      SumWeight = 0.0d0
!!$      do n = 0, nprocs-1
!!$        do j = 1, a_jmax(n)
!!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
!!$        end do
!!$      end do
!!$    else
!!$
!!$      write( 6, * ) 'THIS WOULD BE WRONG.'
!!$
!!$      SumWeight = 0.0d0
!!$      do n = nprocs-1, 0, -1
!!$        do j = a_jmax(n), a_jmax(n) / 2 + 1, -1
!!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
!!$        end do
!!$      end do
!!$      do n = 0, nprocs-1
!!$        do j = 1, a_jmax(n) / 2
!!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
!!$        end do
!!$      end do
!!$    end if
!!$
!!$    deallocate( a_SendBuf  )
!!$    deallocate( aa_RecvBuf )
!!$    deallocate( a_iReqSend )
!!$    deallocate( a_iReqRecv )
!!$
!!$
!!$    AvrLat_y = IntLat_y( y_Data ) / SumWeight
!!$
!!$  end function AvrLat_y
!!$
!!$#else
!!$  !-------------------------------------------------------------------
!!$
!!$  function AvrLat_y( y_Data )
!!$    !
!!$    ! 1 ٳʻǡΰʿ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
!!$    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Meridonal mean of 1-dimensional (latitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "y_Lat_Weight" 
!!$    ! and deviding by the sum total of "y_Lat_Weight".
!!$    !
!!$    real(DP), intent(in):: y_Data (1:jmax)
!!$    real(DP):: AvrLat_y
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    AvrLat_y = IntLat_y( y_Data ) / sum( y_Lat_Weight )
!!$
!!$  end function AvrLat_y
!!$
!!$#endif
!!$  !-------------------------------------------------------------------
!!$
!!$  function AvrLon_x( x_Data )
!!$    !
!!$    ! 1 ٳʻǡηʿ(1 ). 
!!$    !
!!$    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
!!$    ! ¤׻, x_Lon_Weight ¤ǳ뤳Ȥ
!!$    ! ʿѤƤ. 
!!$    !
!!$    ! Zonal mean of 1-dimensional (longitude)
!!$    ! grid data.
!!$    !
!!$    ! Practically, the sum total of grid data is calculated
!!$    ! by multiplying in each grid "x_Lon_Weight" 
!!$    ! and deviding by the sum total of "x_Lon_Weight".
!!$    !
!!$    real(DP), intent(in):: x_Data (0:imax-1)
!!$    real(DP):: AvrLon_x
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    AvrLon_x = IntLon_x( x_Data ) / sum( x_Lon_Weight )
!!$  end function AvrLon_x
!!$

  !--------------------------------------------------------------------------------------

  subroutine IntAvrOprInit
    !
    ! intavr_operate ⥸塼νԤޤ. 
    ! NAMELIST#intavr_operate_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "intavr_operate" module is initialized. 
    ! "NAMELIST#intavr_operate_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /intavr_operate_nml/
          !
          ! ǥեͤˤĤƤϽ³ "intavr_operate#IntAvrOprInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "intavr_operate#IntAvrOprInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( intavr_operate_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = intavr_operate_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
    intavr_operate_inited = .true.
  end subroutine IntAvrOprInit

  !--------------------------------------------------------------------------------------

end module intavr_operate
