!= ˴ؤ
!
!= Settings of array for atmospheric composition
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: composition.f90,v 1.4 2012-02-20 08:09:18 yot Exp $ 
! Tag Name::  $Name: dcpam5-20120226 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module composition
  !
  != ˴ؤ
  !
  != Settings of array for atmospheric composition
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ˴ؤ
  !
  ! Settings of array for atmospheric composition
  !
  !== Variables List
  !
  ! ncmax        :: ʬο
  ! ------------ :: ------------
  ! ncmax        :: Number of minor comstituents
  !
  !== Procedures List
  !
  ! CompositionInit :: ˴ؤ
  ! --------------  :: ------------
  ! CompositionInit :: Settings of parameters for array for composition
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#composition_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP,     & ! ټ¿. Double precision. 
                      STRING    ! ʸ. Strings.

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: CompositionInqIndex
  public :: CompositionInqFlagMassFix
  public :: CompositionInqFlagAdv
  public :: CompositionInqFlagVDiff
  public :: CompositionInit

  ! ѿ
  ! Public variables
  !
  logical          , save, public             :: composition_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  integer          , save, public             :: ncmax
                              ! ʬο
                              ! Number of composition
  character(STRING), save, public, allocatable:: a_QMixName(:)
                              ! ʬѿ̾
                              ! Name of variables for composition
  character(STRING), save, public, allocatable:: a_QMixLongName(:)
                              ! ʬĹѿ̾
                              ! Long name of variables for composition
  logical          , save,         allocatable:: a_FlagMassFix(:)
                              ! ¸Υե饰
                              ! Flag for mass fix
  logical          , save,         allocatable:: a_FlagAdv(:)
                              ! ʬΰή׻Υե饰
                              ! Flag for advection calculation
  logical          , save,         allocatable:: a_FlagVDiff(:)
                              ! ľΰή׻Υե饰
                              ! Flag for vertical diffusion
  integer          , save, public             :: IndexH2OVap
                              ! Υǥå
                              ! Index for water vapor

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'composition'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20120226 $' // &
    & '$Id: composition.f90,v 1.4 2012-02-20 08:09:18 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  function CompositionInqIndex( Name ) result( Index )
    !
    ! Name Ϳ줿̾ʬΥǥ֤ޤ. 
    !
    ! Inquiry of index of constituent
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    character(len=*), intent(in ) :: Name

    integer:: Index

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. composition_inited ) call CompositionInit


    Index = -1

    do n = 1, ncmax
      if ( a_QMixName(n) == trim( Name ) ) then
        Index = n
        exit
      end if
    end do

!!$    if ( Index == -1 ) then
!!$      call MessageNotify( 'E', module_name, &
!!$        & 'Cannot find %c in a list of constituents.', c1 = trim( Name ) )
!!$    end if


  end function CompositionInqIndex

  !-------------------------------------------------------------------

  function CompositionInqFlagMassFix( Index ) result( FlagMassFix )
    !
    ! Name Ϳ줿̾ʬΰήե饰֤ޤ.
    !
    ! Inquiry of flag for advection of constituent
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer, intent(in ) :: Index

    logical :: FlagMassFix


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. composition_inited ) call CompositionInit

    if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
      call MessageNotify( 'E', module_name, &
        & 'Index is inappropriate, Index = %d', i = (/ Index /) )
    end if

    FlagMassFix = a_FlagMassFix( Index )


  end function CompositionInqFlagMassFix

  !-------------------------------------------------------------------

  function CompositionInqFlagAdv( Index ) result( FlagAdv )
    !
    ! Name Ϳ줿̾ʬΰήե饰֤ޤ. 
    !
    ! Inquiry of flag for advection of constituent
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer, intent(in ) :: Index

    logical :: FlagAdv


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. composition_inited ) call CompositionInit

    if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
      call MessageNotify( 'E', module_name, &
        & 'Index is inappropriate, Index = %d', i = (/ Index /) )
    end if

    FlagAdv = a_FlagAdv( Index )


  end function CompositionInqFlagAdv

  !-------------------------------------------------------------------

  function CompositionInqFlagVDiff( Index ) result( FlagVDiff )
    !
    ! Name Ϳ줿̾ʬΰήե饰֤ޤ.
    !
    ! Inquiry of flag for advection of constituent
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer, intent(in ) :: Index

    logical :: FlagVDiff


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. composition_inited ) call CompositionInit

    if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
      call MessageNotify( 'E', module_name, &
        & 'Index is inappropriate, Index = %d', i = (/ Index /) )
    end if

    FlagVDiff = a_FlagVDiff( Index )


  end function CompositionInqFlagVDiff

  !-------------------------------------------------------------------

  subroutine CompositionInit
    !
    ! composition ⥸塼νԤޤ. 
    ! NAMELIST#composition_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "composition" module is initialized. 
    ! NAMELIST#composition_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, MaxNmlArySize

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    character(len=STRING) :: Names      (1:MaxNmlArySize)
    character(len=STRING) :: LongNames  (1:MaxNmlArySize)
    logical               :: FlagMassFix(1:MaxNmlArySize)
    logical               :: FlagAdv    (1:MaxNmlArySize)
    logical               :: FlagVDiff  (1:MaxNmlArySize)

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /composition_nml/ ncmax, Names, LongNames, FlagMassFix, FlagAdv, FlagVDiff
          !
          ! ǥեͤˤĤƤϽ³ "composition#CompositionInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "composition#CompositionInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( composition_inited ) return
!!$    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    ncmax        = 1

    Names    (1) = 'QVap'
    LongNames(1) = 'specific humidity'
    do n = 2, MaxNmlArySize
      Names    (n) = ''
      LongNames(n) = ''
    end do

    FlagMassFix = .true.

    FlagAdv     = .true.

    FlagVDiff   = .true.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,            & ! (in)
        & nml = composition_nml, & ! (out)
        & iostat = iostat_nml    & ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = composition_nml )
    end if

    ! 󥵥Υå
    ! Check number of array size
    !
    if ( ncmax < 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of composition has to be greater than 0. ' // &
        & 'ncmax=%d' , &
        & i = (/ ncmax /) )
    end if


    ! Set variable name of constituents for ouptut
    !
    allocate( a_QMixName    ( ncmax ) )
    allocate( a_QMixLongName( ncmax ) )
    if ( ncmax > 99 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of composition greater than 99 is inappropriate for current version. ' // &
        & 'ncmax=%d' , &
        & i = (/ ncmax /) )
    end if
    do n = 1, ncmax
      if ( Names(n) == '' ) then
        write( a_QMixName(n), '(a,i3.3)' ) "QMix", n
      else
        a_QMixName(n) = Names(n)
      end if
      if ( LongNames(n) == '' ) then
        a_QMixLongName(n) = a_QMixName(n)
      else
        a_QMixLongName(n) = LongNames(n)
      end if
    end do

    allocate( a_FlagMassFix( ncmax ) )
    do n = 1, ncmax
      a_FlagMassFix( n ) = FlagMassFix(n)
    end do

    allocate( a_FlagAdv( ncmax ) )
    do n = 1, ncmax
      a_FlagAdv( n ) = FlagAdv(n)
    end do

    allocate( a_FlagVDiff( ncmax ) )
    do n = 1, ncmax
      a_FlagVDiff( n ) = FlagVDiff(n)
    end do

    IndexH2OVap = -1
    do n = 1, ncmax
      if ( a_QMixName(n) == 'QVap' ) then
        IndexH2OVap = n
        exit
      end if
    end do


    ! ΥǥåΥå
    ! Check index for water vapor
    !
    if ( ( IndexH2OVap < 1 ) .or. ( IndexH2OVap > ncmax ) ) then
      call MessageNotify( 'E', module_name, &
        & 'IndexH2OVap has to be greater than or equal to 1 and less than or equal to ncmax. ' // &
        & 'IndexH2OVap=%d' , &
        & i = (/ IndexH2OVap /) )
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '    ncmax              = %d', i = (/ ncmax /) )
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    QMixName(%d)     = %c', i = (/ n /), c1 = trim(a_QMixName(n)) )
    end do
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    QMixLongName(%d) = %c', i = (/ n /), c1 = trim(a_QMixLongName(n)) )
    end do
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    FlagMassFix(%d)  = %b', i = (/ n /), l = (/ a_FlagMassFix(n) /) )
    end do
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    FlagAdv(%d)      = %b', i = (/ n /), l = (/ a_FlagAdv(n) /) )
    end do
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    FlagVDiff(%d)    = %b', i = (/ n /), l = (/ a_FlagVDiff(n) /) )
    end do
    call MessageNotify( 'M', module_name, '    IndexH2OVap        = %d', i = (/ IndexH2OVap /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    composition_inited = .true.
  end subroutine CompositionInit

  !-------------------------------------------------------------------

!!$  subroutine InitCheck
!!$    !
!!$    ! ¸⥸塼νå
!!$    !
!!$    ! Check initialization of dependency modules
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_util_inited
!!$
!!$    ! å
!!$    ! Message output
!!$    !
!!$    use dc_message, only: MessageNotify
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. namelist_util_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
!!$
!!$  end subroutine InitCheck

end module composition
