!= 
!
!= Dust distribution is set
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_Mars_dust.f90,v 1.1 2012-01-20 00:30:48 yot Exp $
! Tag Name::  $Name: dcpam5-20120226 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module set_Mars_dust
  !
  != 
  !
  != Dust distribution is set
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !
  !== References
  !
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ѿ
  ! Public variables
  !
  logical, save, public:: set_Mars_dust_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  ! Private variables
  !

  character(STRING), save :: DustSenario
  real(DP)         , save :: DOD067       ! Dust optical depth at 0.67 micron.
  real(DP)         , save :: DustVerDistCoef

  integer          , save      :: IDDustSenario
  integer          , parameter :: IDDustSenarioConst      = 1
  integer          , parameter :: IDDustSenarioVikingNoDS = 2
  integer          , parameter :: IDDustSenarioViking     = 3
  integer          , parameter :: IDDustSenarioMGS        = 4


  public :: SetMarsDustSetDOD067
  public :: SetMarsDustInit

  character(*), parameter:: module_name = 'set_Mars_dust'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20120226 $' // &
    & '$Id: set_Mars_dust.f90,v 1.1 2012-01-20 00:30:48 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SetMarsDustSetDOD067( &
    & Ls, xyr_Press, xyz_Press,    & ! (out) optional & ! (in)
    & xyr_DOD067                   & ! (out)
    & )
    !
    ! 
    !
    ! Set dust optical depth at 0.67 micron
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ):: Ls
                              ! Ls
    real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
                              ! Pressure
    real(DP), intent(in ):: xyz_Press    (0:imax-1, 1:jmax, 1:kmax)
                              ! Pressure
    real(DP), intent(out):: xyr_DOD067   (0:imax-1, 1:jmax, 0:kmax)
                              ! Optical depth

    ! ѿ
    ! Work variables
    !
    real(DP)            :: DOD
    real(DP)            :: xy_DOD067    (0:imax-1, 1:jmax)
                              ! Dust optical depth at 0.67 micron
    real(DP)            :: xyz_MixRtDust(0:imax-1, 1:jmax, 1:kmax)
    real(DP)            :: xy_DODFac    (0:imax-1, 1:jmax)

    real(DP), parameter :: DustOptDepRefPress  = 610.0_DP
    real(DP), parameter :: DustVerDistRefPress = 610.0_DP

    real(DP)            :: MixRtDust0

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. set_Mars_dust_inited ) call SetMarsDustInit


    select case ( IDDustSenario )
    case ( IDDustSenarioConst )
      xy_DOD067 = DOD067
    case ( IDDustSenarioVikingNoDS )

      call SetMarsDustDODVikingNoDS( &
        & Ls, & ! (in)
        & DOD & ! (out)
        & )
      xy_DOD067 = DOD

    case ( IDDustSenarioViking )

      call SetMarsDustDODViking( &
        & Ls, & ! (in)
        & DOD & ! (out)
        & )
      xy_DOD067 = DOD

    case ( IDDustSenarioMGS )
      call MessageNotify( 'E', module_name, 'DustSenario of %c is not supported.', c1 = trim( DustSenario ) )
    case default
      call MessageNotify( 'E', module_name, 'DustSenario of %c is not supported.', c1 = trim( DustSenario ) )
    end select


    MixRtDust0      =   1.0_DP

    xyz_MixRtDust = MixRtDust0 &
      & * exp( DustVerDistCoef * ( 1.0_DP - ( DustVerDistRefPress / xyz_Press ) ) )

    k = kmax
    xyr_DOD067(:,:,k) = 0.0_DP
    do k = kmax-1, 0, -1
      xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) &
        & + xyz_MixRtDust(:,:,k+1) * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do

    xy_DODFac = xy_DOD067 * xyr_Press(:,:,0) / DustOptDepRefPress / xyr_DOD067(:,:,0)
    do k = 0, kmax
      xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k) * xy_DODFac
    end do


  end subroutine SetMarsDustSetDOD067

  !--------------------------------------------------------------------------------------

  subroutine SetMarsDustDODViking( &
    & Ls, & ! (in)
    & DOD & ! (out)
    & )

    real(DP), intent(in ) :: Ls
    real(DP), intent(out) :: DOD


    !
    ! Local variables
    !
    real(DP) :: DODDS1
    real(DP) :: DODDS2
    real(DP) :: DSLs
    real(DP) :: MaxDOD
    real(DP) :: DSDTC


    call SetMarsDustDODVikingNoDS( &
      & Ls, & ! (in)
      & DOD & ! (out)
      & )

    ! Add two dust storms
    !
    DSLs   = 210.0_DP
    MaxDOD = 2.7_DP
    DSDTC  = 50.0_DP
    call SetMarsDustDSExp( &
      & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
      & DOD                      & ! (out)
      & )

    DSLs   = 280.0_DP
    MaxDOD = 4.0_DP
    DSDTC  = 50.0_DP
    call SetMarsDustDSExp( &
      & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
      & DOD                      & ! (out)
      & )

    DOD = max( DOD, DODDS1, DODDS2 )


  end subroutine SetMarsDustDODViking

  !--------------------------------------------------------------------------------------

  subroutine SetMarsDustDODVikingNoDS( &
    & Ls, & ! (in)
    & DOD & ! (out)
    & )

    ! ʪ
    ! Physical constants settings
    !
    use constants0, only: PI

    real(DP), intent(in ) :: Ls
    real(DP), intent(out) :: DOD


    ! This expression is obtained from Lewis et al. [1999].
    !
    DOD = 0.7_DP + 0.3_DP * cos( ( Ls + 80.0_DP ) * PI / 180.0_DP )


  end subroutine SetMarsDustDODVikingNoDS

  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine SetMarsDustDODMGS( &
!!$    & Ls, &
!!$    & Lat, &
!!$    & DOD  &
!!$    & )
!!$
!!$    real(DP), intent(in ) :: Ls
!!$    real(DP), intent(in ) :: Lat
!!$    real(DP), intent(out) :: DOD
!!$
!!$
!!$    ! Local variables
!!$    ! lat2     : Temporary variable for latitude
!!$    ! interc   : Intercept
!!$    ! amp      :
!!$    ! phase    : Phase (degree)
!!$
!!$    real(DP) :: lat2
!!$    real(DP) :: interc
!!$    real(DP) :: amp, phase
!!$
!!$
!!$
!!$    if( lat .lt. -40.0d0 ) then
!!$      lat2 = -40.0d0
!!$    else if( lat .gt. 40.0d0 ) then
!!$      lat2 = 40.0d0
!!$    else
!!$      lat2 = lat
!!$    endif
!!$
!!$    if( lat2 .gt. 0.0d0 ) then
!!$      interc = 0.16d0 - 1.8d-3 * lat2
!!$    else
!!$      interc = 0.16d0 + 1.3d-3 * lat2
!!$    endif
!!$    amp   = 0.0623d0 - 0.015d0 * atan( ( lat2 + 2.0d0 ) / 5.0d0 )
!!$    phase = 258.0d0 + 1.8d-1 * lat2
!!$    dod   = interc + amp * cos( ( ls - phase ) * d2r )
!!$
!!$
!!$    ! Dust optical depth at 9 micron is converted to that at 0.67 micron.
!!$
!!$    dod = dod * 2.0d0
!!$
!!$
!!$  end subroutine SetMarsDustDODMGS
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine dodMGS_1yr( ls, lat, dod )
!!$
!!$      use mars_const, only : d2r
!!$
!!$      real(dp), intent(in ) :: ls
!!$      real(dp), intent(in ) :: lat
!!$      real(dp), intent(out) :: dod
!!$
!!$
!!$      ! Local variables
!!$
!!$      real(dp) :: dodds
!!$      real(dp) :: dsls, maxdod, dsdtc
!!$
!!$
!!$      call dodMGS( ls, lat, dod )
!!$
!!$
!!$      !*****Add dust storms
!!$      !-----First year
!!$      dsls   = 227.0d0
!!$      maxdod = 0.475d0
!!$      dsdtc  = 35.0d0
!!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
!!$      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
!!$      dodds  = dodds * 2.0d0
!!$      dod    = max( dod, dodds )
!!$
!!$      dsls   = 235.0d0
!!$      maxdod = 0.5d0
!!$      dsdtc  = 50.0d0
!!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
!!$      dodds  = dodds * exp( -( lat - ( -60.0d0 ) )**2 / ( 60.0d0 )**2 )
!!$      dodds  = dodds * 2.0d0
!!$      dod    = max( dod, dodds )
!!$
!!$      dsls   = 259.0d0
!!$      maxdod = 0.4d0
!!$      dsdtc  = 70.0d0
!!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
!!$      dodds  = dodds * exp( -( lat - ( -80.0d0 ) )**2 / ( 30.0d0 )**2 )
!!$      dodds  = dodds * 2.0d0
!!$      dod    = max( dod, dodds )
!!$
!!$      !-----Second year
!!$!      dsls   = 360.0d0 + 190.0d0
!!$!      maxdod = 1.7d0
!!$!      dsdtc  = 40.0d0
!!$!      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
!!$!      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
!!$!      if( abs( lat ) .gt. 60.0d0 ) dodds = 0.0d0
!!$!      dod    = max( dod, dodds )
!!$
!!$
!!$    end subroutine dodMGS_1yr
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine duststormlin( ls, dod, ls0, x1, y1, x2, y2 )
!!$
!!$      real(dp), intent(in ) :: ls
!!$      real(dp), intent(out) :: dod
!!$      real(dp), intent(in ) :: ls0
!!$      real(dp), intent(in ) :: x1, y1, x2, y2
!!$
!!$
!!$      ! Local variables
!!$      !
!!$      real(dp) :: a, b
!!$      real(dp) :: tmpls
!!$
!!$
!!$      a = ( y2 - y1 ) / ( x2 - x1 )
!!$      b = y1 - ( y2 - y1 ) / ( x2 - x1 ) * x1
!!$
!!$      if( ls .lt. ls0 ) then
!!$         tmpls = ls + 360.0d0
!!$      else
!!$         tmpls = ls
!!$      endif
!!$
!!$      dod = a * tmpls + b
!!$
!!$      dod = max( dod, 0.0d0 )
!!$
!!$
!!$    end subroutine duststormlin

  !**************************************************************************
  ! dustsstormexp
  !**************************************************************************
  ! ls      : Areocentric solar longitude (degree)
  ! dod     : Derived dust optical depth at 0.67 micron
  ! dsls    : Areocentric solar longitude at the initiation of dust storm
  !         : (degree)
  ! maxdod  : Maximum value of dust optical depth at 0.67 micron
  ! dsdtc   : Decay time constant of dust storm in unit of areocentric
  !         : solar longitude (degree)
  !**************************************************************************

  subroutine SetMarsDustDSExp( &
    & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
    & DOD                      & ! (out)
    & )

    real(DP), intent(in ) :: Ls
    real(DP), intent(in ) :: DSLs
    real(DP), intent(in ) :: MaxDOD
    real(DP), intent(in ) :: DSDTC
    real(DP), intent(out) :: DOD


    ! Local variables
    !
    real(DP) :: TMPLs

    if( Ls < DSLs ) then
      TMPLs = Ls + 360.0_DP
    else
      TMPLs = Ls
    endif

    DOD = MaxDod * exp( -( TMPLs - DSLs ) / DSDTC )


  end subroutine SetMarsDustDSExp

    !**************************************************************************
!!$
!!$    subroutine mars_setdust_vdist( gph, gp, grho, dod610, qdust, ijs, ije )
!!$
!!$      use maparam   , only : im => imax, jm => jmax, km => kmax
!!$      use maconst   , only : grav
!!$      use mars_const, only : pi
!!$
!!$      real(dp)    , intent(in ) :: gph( im, jm, km+1 ), gp( im, jm, km ), &
!!$           grho( im, jm, km )
!!$      real(dp)    , intent(in ) :: dod610( im, jm )
!!$      real(dp)    , intent(out) :: qdust ( im, jm, km )
!!$      integer(i4b), intent(in ) :: ijs, ije
!!$
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      ! dod067   : Dust optical depth at 0.67 micron meter
!!$      !          : This is a local variable.
!!$      ! qdust0   : Constant for Use of Dust Mixing Ratio profile
!!$      !          : profile is obtained from Conrath [1975]
!!$      ! qdust1   : Constant for Use of Dust Mixing Ratio profile
!!$
!!$      real(dp) :: dod067( im, jm, km+1 )
!!$      real(dp) :: qdust0, qdust1
!!$
!!$      ! refp       : reference pressure (refp is set to 610 Pa)
!!$      ! p0         : reference pressure (p0 is set to 610 Pa)
!!$      !
!!$      real(dp)     :: refp = 610.0d0, p0 = 610.0d0
!!$
!!$      real(dp)     :: dodtmp
!!$
!!$      integer(i4b) :: ij, k
!!$
!!$
!!$      qdust0=1.0d0
!!$!      qdust1=0.007d0
!!$!      qdust1=0.03d0
!!$      qdust1 = dust_nu_coef
!!$
!!$      do k = 1, km
!!$         do ij = ijs, ije
!!$            qdust( ij, 1, k ) = qdust0 &
!!$                 * exp( qdust1 * ( 1.0d0 - ( p0 / gp( ij, 1, k ) ) ) )
!!$         end do
!!$      end do
!!$
!!$      call calcdod067( gph, grho, qdust, dod067, ijs, ije )
!!$
!!$      do ij = ijs, ije
!!$         dodtmp = dod067( ij, 1, km+1 ) * refp / gph( ij, 1, km+1 )
!!$         qdust0 = 1.0d0
!!$         qdust0 = qdust0 * dod610( ij, 1 ) / dodtmp
!!$         do k = 1, km
!!$            qdust( ij, 1, k ) = qdust( ij, 1, k ) * qdust0
!!$         end do
!!$         do k = 1, km+1
!!$            dod067( ij, 1, k ) = dod067( ij, 1, k ) * qdust0
!!$         end do
!!$      end do
!!$
!!$
!!$    end subroutine mars_setdust_vdist
!!$
  !--------------------------------------------------------------------------------------

  subroutine SetMarsDustInit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_Mars_dust_nml/ &
      & DustSenario,  &
      & DOD067,       &
      & DustVerDistCoef
          !
          ! ǥեͤˤĤƤϽ³ "rad_Mars_V1#RadMarsV1Init"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_Mars_V1#RadMarsV1Init" for the default values.
          !


    ! ǥեͤ
    ! Default values settings
    !
    DustSenario     = 'Const'
    DOD067          = 0.2_DP
    DustVerDistCoef = 0.01_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_Mars_dust_nml,        & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    if ( DustSenario == 'Const' ) then
      IDDustSenario = IDDustSenarioConst
    else if ( DustSenario == 'VikingNoDS' ) then
      IDDustSenario = IDDustSenarioVikingNoDS
    else if ( DustSenario == 'Viking' ) then
      IDDustSenario = IDDustSenarioViking
    else if ( DustSenario == 'MGS' ) then
      IDDustSenario = IDDustSenarioMGS
    else
      call MessageNotify( 'E', module_name, 'DustSenario of %c is not supported.', c1 = trim( DustSenario ) )
    end if


    ! Initialization of modules used in this module
    !


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'DustSenario     = %c', c1 = trim( DustSenario ) )
    call MessageNotify( 'M', module_name, 'DOD067          = %f', d  = (/ DOD067      /) )
    call MessageNotify( 'M', module_name, 'DustVerDistCoef = %f', d  = (/ DustVerDistCoef /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    set_Mars_dust_inited = .true.

  end subroutine SetMarsDustInit

  !--------------------------------------------------------------------------------------

end module set_Mars_dust
