!= û ()
!
!= Short wave (insolation) incoming
!
! Authors::   Satoshi NODA, Yasuhiro MORIKAWA, Yukiko YAMADA, Yoshiyuki O. TAKAHASHI
! Version::   $Id: rad_short_income.f90,v 1.5 2012-02-01 05:19:53 yot Exp $
! Tag Name::  $Name: dcpam5-20120226 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_short_income
  !
  != û ()
  !
  != Short wave (insolation) incoming
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! û () ׻ޤ.
  !
  ! Calculate short wave (insolation) incoming radiation. 
  !
  !== Procedures List
  !
  ! ShortIncoming      :: û () η׻
  ! ------------       :: ------------
  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_short_income_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI                    ! $ \pi $.
                            ! ߼Ψ. Circular constant

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! 
  ! Time control
  !
  use timeset, only: &
    & TimeN,                & !
    & InitialDate             ! ׻.
                              ! Start date of calculation

  ! ɸǡ
  ! Axes data settings
  !
  use axesset, only: &
    & y_Lat,   & ! $ \varphi $ [rad.] . . Latitude
    & x_Lon      ! $ \lambda $ [rad.] . . Longitude


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RadShortIncome
  public:: RadShortIncomeInit

  ! ѿ
  ! Public variables
  !
  logical, save :: rad_short_income_inited = .false.
                              ! ե饰. 
                              ! Initialization flag.


  ! ѿ
  ! Private variables
  !

  logical,  save:: FlagAnnualMean
                              ! ǯʿͥե饰.
                              ! Flag for annual mean incoming radiation. 
  logical,  save:: FlagDiurnalMean
                              ! ʿͥե饰.
                              ! Flag for diurnal mean incoming radiation. 
  logical,  save:: FlagPerpetual
                              ! Ѳʤͥե饰.
                              ! Flag for perpetual incoming radiation. 

  real(DP), save :: PerpSinDel
                              ! sine of declination angle for perpetual experiments
  real(DP), save :: PerpDistFromStarScld
                              ! distance between a planet and a central star for 
                              ! perpetual experiment


  ! NOTE:
  !   Distance between the central star and the planet, and the declination can be
  !   determined by specifying following three parameters: 
  !     PerLonFromVE     : the longitude of the perihelion measured from the vernal 
  !                        equinox, 
  !     LonFromVEAtEpoch : the longitude of the planet at epoch, 
  !     epoch            : date or time. 
  !
  real(DP), save:: PerLonFromVE
                              ! ʬ¬äη () (degree)
                              ! Longitude of the perihelion from vernal equinox (degree)
  real(DP), save:: LonFromVEAtEpoch
                              ! ˤη () (degree)
                              ! Longitude of the planet at epoch (degree)
  real(DP), save:: TimeAtEpoch
                              ! ˤ (sec)
                              ! Time at epoch (sec)

  real(DP), save:: EpsOrb
                              ! ƻг.
                              ! Inclination of equator to orbit.
  real(DP), save:: Eccentricity
                              ! ΥΨ.
                              ! Eccentricity.

  integer,  save:: MaxItrEccAnomaly
                              ! ΥѤ׻κ緫֤.
                              ! Maximum iteration number of times
                              ! to calculate eccentric anomaly.
  real(DP), save:: ThreEccAnomalyError
                              ! ΥѤ׻θεƤ.
                              ! Threshold of error
                              ! to calculate eccentric anomaly.

  real(DP), save:: IncomAIns
                              ! $ A_{ins} $ . ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
  real(DP), save:: IncomBIns
                              ! $ B_{ins} $ . ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomAZet
                              ! $ A_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomBZet
                              ! $ B_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 


  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)

  logical:: FlagRadSynchronous
                              ! ƱžͤΥե饰
                              ! Flag for synchronous rotation

  character(*), parameter:: module_name = 'rad_short_income'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20120226 $' // &
    & '$Id: rad_short_income.f90,v 1.5 2012-02-01 05:19:53 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadShortIncome(                    &
    & xy_InAngle, DistFromStarScld, xy_CosZet,  & ! (out) optional
    & DiurnalMeanFactor, PlanetLonFromVE,       & ! (out) optional
    & FlagOutput                                & ! (in)  optional
    & )
    !
    ! û () ׻ޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfDay

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out), optional :: xy_InAngle (0:imax-1, 1:jmax)
                              ! sec ( ͳ ). 
                              ! sec ( Incident angle )
    real(DP), intent(out), optional :: DistFromStarScld
                              ! ƻĹȾ¤ǥ󥰤εΥ
                              ! Distance from the star scaled
                              ! by semimajor axis of the planet's orbit
    real(DP), intent(out), optional :: xy_CosZet(0:imax-1, 1:jmax)
                              ! cos( ͳ )
                              ! cos( Incident angle )
    real(DP), intent(out), optional :: DiurnalMeanFactor
    real(DP), intent(out), optional :: PlanetLonFromVE
                              ! 濴濴Ȥɸˤʬ¬äη
                              ! Longitude of the planet measured from the vernal equinox
                              ! in the coordinate that the central star is located on 
                              ! the origin.
    logical , intent(in ), optional :: FlagOutput


    ! ѿ
    ! Work variables
    !
    integer:: i                ! ˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in longitude
    integer:: j                ! ˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in latitude
    real(DP):: SinDel          ! ְ
                               ! Declination
    real(DP):: CosZet          ! ͳ
                               ! Incidence angle
    real(DP):: AngleMaxLon     ! ͤȤʤ

    real(DP):: HourAngle       ! 
                               ! Hour angle
    real(DP):: ClockByDay      ! ɽ (0.0 - 1.0)
                               ! Clock expressed by day (0.0 - 1.0)


    real(DP) :: xy_InAngleLV       (0:imax-1, 1:jmax)
                               ! sec ( ͳ ). 
                               ! sec ( Incident angle )
                               ! (local variable)
    real(DP) :: DistFromStarScldLV
                               ! Distance between the central star and the planet
                               ! (local variable)
    real(DP) :: xy_CosZetLV        (0:imax-1, 1:jmax)
                               ! cos( ͳ )
                               ! cos( Incident angle )
                               ! (local variable)
    real(DP) :: PlanetLonFromVELV

    integer         :: hour_in_a_day, min_in_a_hour
    real(DP)        :: sec_in_a_min, sec_in_a_day


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_short_income_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Set flag for diurnally averaged insolation : This is temporary one.
    !
    if ( present( DiurnalMeanFactor ) ) then
      if ( ( .not. FlagAnnualMean ) .and. FlagDiurnalMean ) then
        DiurnalMeanFactor = 1.0_DP / PI
      else
        DiurnalMeanFactor = 1.0_DP
      end if
    end if


    ! ƱžͤΥե饰
    ! Flag for synchronous rotation
    if ( .not. FlagRadSynchronous ) then

      ! ǯ, ʿͤη׻
      ! Calculate annual mean, daily mean insolation
      !

      if ( FlagAnnualMean .and. FlagDiurnalMean ) then

        do i = 0, imax - 1
          do j = 1, jmax
            xy_CosZetLV(i,j) = IncomAIns + IncomBIns * cos( y_Lat(j) )**2

            if ( xy_CosZetLV(i,j) > 0.0_DP ) then
              xy_InAngleLV(i,j) = 1.0_DP / xy_CosZetLV(i,j)
            else
              xy_InAngleLV(i,j) = 0.
            end if

          end do
        end do

        DistFromStarScldLV = 1.0_DP
        SinDel             = 0.0_DP
        PlanetLonFromVELV  = 0.0_DP

      else if ( .not. FlagAnnualMean ) then

        ! Set sine of declination and distance between a planet and a central star 
        ! scaled with semi-major axis
        !
        if ( FlagPerpetual ) then
          SinDel             = PerpSinDel
          DistFromStarScldLV = PerpDistFromStarScld
        else
          call ShortIncomCalcOrbParam(                       &
            & SinDel, DistFromStarScldLV, PlanetLonFromVELV  & ! (out) optional
            & )
          if ( present( PlanetLonFromVE ) ) PlanetLonFromVE = PlanetLonFromVELV
        end if


        call DCCalInquire( &
          & hour_in_day      = hour_in_a_day,     & ! (out)
          & min_in_hour      = min_in_a_hour,     & ! (out)
          & sec_in_min       = sec_in_a_min       & ! (out)
          & )
        sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min

        ! This is old version to be deleted, yot, 2010/09/23.
!!$        ClockByDay = mod( TimeN / sec_in_a_day, 1.0_DP )
        !
        ClockByDay = DCCalDateEvalSecOfDay( TimeN, date = InitialDate )
        ClockByDay = ClockByDay / sec_in_a_day


!!$        write( 6, * ) '###', TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
!!$        write( 60, * ) TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
!!$        call flush( 60 )


        do i = 0, imax - 1
          do j = 1, jmax


            if ( FlagDiurnalMean ) then
              HourAngle = 0.0_DP
            else
              HourAngle = ClockByDay * 2.0_DP * PI - PI + x_Lon(i)
            end if

            CosZet = sin( y_Lat(j) ) * SinDel &
              &  + cos( y_Lat(j) ) * sqrt( 1.0_DP - SinDel**2 ) * cos( HourAngle )

            xy_CosZetLV(i,j) = CosZet

            if ( CosZet > 0.0_DP ) then
              xy_InAngleLV(i,j)       = 1.0_DP / CosZet
            else
              xy_InAngleLV(i,j)       = 0.
            end if

          end do
        end do

      else

        ! бƤʤͥ
        ! not implemented insolation type
        !
        call MessageNotify( 'E', module_name, 'This type of insolation is not impremented' )

      end if

    else

      ! û () ׻ޤ.
      ! ƱžꤷƤ,
      ! ˷ 90 ٤Ǻ,  180-360 ٤ͥȤʤäƤޤ.
      !
      ! Calculate short wave (insolation) incoming radiation.
      ! A planet with synchronized rotation are assumed.
      ! Incoming is max at latitude 90 deg., and zero between 180 and 360 deg. constantly.
      do i = 0, imax - 1
         AngleMaxLon  = - PI / 2.0_DP + x_Lon( i )
         do j = 1, jmax
            CosZet = cos( y_Lat(j) ) * cos( AngleMaxLon )

            xy_CosZetLV(i,j) = CosZet

            if ( CosZet > 0.0_DP ) then
               xy_InAngleLV(i,j) = 1.0_DP / CosZet
            else
               xy_InAngleLV(i,j) = 0.0_DP
            end if

            DistFromStarScldLV = 1.0_DP
         end do
      end do

    end if


    if ( present( xy_InAngle ) ) then
      xy_InAngle = xy_InAngleLV
    end if
    if ( present( xy_CosZet ) ) then
      xy_CosZet = xy_CosZetLV
    end if
    if ( present( DistFromStarScld ) ) then
      DistFromStarScld = DistFromStarScldLV
    end if

    ! ҥȥǡ
    ! History data output
    !
    if ( present( FlagOutput ) ) then
      if ( FlagOutput ) then
        call HistoryAutoPut( TimeN, 'Decl'            , asin(SinDel)*180.0_DP/PI      )
        call HistoryAutoPut( TimeN, 'DistFromStarScld', DistFromStarScldLV            )
        call HistoryAutoPut( TimeN, 'PlanetLonFromVE' , PlanetLonFromVELV*180.0_DP/PI )
      end if
    else
      call HistoryAutoPut( TimeN, 'Decl'            , asin(SinDel)*180.0_DP/PI      )
      call HistoryAutoPut( TimeN, 'DistFromStarScld', DistFromStarScldLV            )
      call HistoryAutoPut( TimeN, 'PlanetLonFromVE' , PlanetLonFromVELV*180.0_DP/PI )
    end if


  end subroutine RadShortIncome

  !--------------------------------------------------------------------------------------

  subroutine ShortIncomCalcOrbParam(             &
    & SinDel, DistFromStarScld, PlanetLonFromVE  & ! (out)
    & )
    !
    ! û () ׻ޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateChkLeapYear

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: SinDel
                              ! ְ
                              ! Declination
    real(DP), intent(out) :: DistFromStarScld
                              ! ƻĹȾ¤ǥ󥰤εΥ
                              ! Distance from the star scaled
                              ! by semimajor axis of the planet's orbit
    real(DP), intent(out) :: PlanetLonFromVE
                              ! 濴濴Ȥɸˤʬ¬äη
                              ! Longitude of the planet measured from the vernal equinox
                              ! in the coordinate that the central star is located on 
                              ! the origin.

    ! ѿ
    ! Work variables
    !
    integer:: itr              ! ƥ졼˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in iteration direction

    real(DP):: MeanAnomaly     ! ʿѶ
                               ! Mean anomaly
    real(DP):: EccAnomaly      ! Υ
                               ! eccentric anomaly
    real(DP):: EccAnomalyError ! ˥塼ȥˡˤΥѤθ
                               ! error of eccentric anomaly in Newton method
    real(DP):: TrueAnomaly     ! Υ
                               ! true anomaly

    integer         :: hour_in_a_day, min_in_a_hour, day_in_a_year
    integer, pointer:: day_in_month_ptr(:) => null()
    real(DP)        :: sec_in_a_min, sec_in_a_day, sec_in_a_year



    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_short_income_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Ѳ, Ѳη׻
    ! Calculate with seasonal change and diurnal change
    !
    call DCCalInquire( &
      & day_in_month_ptr = day_in_month_ptr , & ! (out)
      & hour_in_day      = hour_in_a_day,     & ! (out)
      & min_in_hour      = min_in_a_hour,     & ! (out)
      & sec_in_min       = sec_in_a_min       & ! (out)
      & )
    ! Add 1 to day_in_month_ptr(2) if it is leap year.
    !
    if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
      day_in_month_ptr(2) = day_in_month_ptr(2) + 1
    end if

    day_in_a_year = sum( day_in_month_ptr )
    deallocate( day_in_month_ptr )
    sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
    sec_in_a_year = day_in_a_year * sec_in_a_day

    MeanAnomaly  =                                               &
      &   2.0_DP * PI * ( TimeN - TimeAtEpoch ) / sec_in_a_year  &
      & + ( LonFromVEAtEpoch - PerLonFromVE ) * PI / 180.0_DP
    MeanAnomaly  = mod( MeanAnomaly, 2.0_DP * PI )


    ! ˥塼ȥˡѤʿѶѤΥѤ.
    ! Calculate eccentric anomaly from mean anomaly by using Newton method.

    EccAnomaly = MeanAnomaly
    do itr = 1, MaxItrEccAnomaly
      EccAnomalyError = EccAnomaly                                        &
        & - Eccentricity * sin(EccAnomaly) - MeanAnomaly
      if ( abs(EccAnomalyError) <= ThreEccAnomalyError ) exit
      EccAnomaly      = EccAnomaly                                        &
        & - EccAnomalyError / ( 1.0_DP - Eccentricity * cos(EccAnomaly) )
      EccAnomaly      = mod( EccAnomaly, 2.0 * PI )
    end do
    if ( itr > MaxItrEccAnomaly ) then
      call MessageNotify( 'E', module_name,                        &
        & 'Calculation for eccentric anomaly does not converge.' )
    end if

    DistFromStarScld = 1.0_DP - Eccentricity * cos( EccAnomaly )

    TrueAnomaly = 2.0_DP                                                    &
      & * atan(                                                             &
      &         sqrt( ( 1.0d0 + Eccentricity ) / ( 1.0d0 - Eccentricity ) ) &
      &           * tan( EccAnomaly / 2.0_DP )                              &
      &       )

    PlanetLonFromVE = TrueAnomaly + PerLonFromVE * PI / 180.0_DP
    PlanetLonFromVE = mod( PlanetLonFromVE, 2.0_DP * PI )

    SinDel = sin( EpsOrb * PI / 180.0_DP ) * sin( PlanetLonFromVE )


        ! code for debug
!!$        write( 60, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
!!$        write(  6, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
!!$        call flush( 60 )


!!$        write( 60, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
!!$        write(  6, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
!!$        call flush( 60 )


  end subroutine ShortIncomCalcOrbParam

  !--------------------------------------------------------------------------------------

  subroutine RadShortIncomeInit
    !
    ! rad_short_income ⥸塼νԤޤ. 
    ! NAMELIST#rad_short_income_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_short_income" module is initialized. 
    ! "NAMELIST#rad_short_income_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DC_CAL_DATE, &          ! ɽǡ.
                                ! Data type for date and time
      & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin
                              !  (ǯʬ).
                              ! "TimeAtEpoch" ξˤ餬Ѥ.
                              !
                              ! Date at epoch (year, month, day, hour, minute)
                              ! These are used when "TimeAtEpoch" is negative.
    real(DP):: EpochSec
                              !  ().
                              ! "TimeAtEpoch" ξˤ餬Ѥ.
                              !
                              ! Date at epoch (second)
                              ! These are used when "TimeAtEpoch" is negative.

    type(DC_CAL_DATE):: EpochDate
                              ! 
                              ! Date at epoch

    real(DP)         :: PerpDelDeg
                              ! Declination angle in degree used for perpetual experiment

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    logical         :: FlagUseOfEpochDate
    character(TOKEN):: date_print


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_short_income_nml/                                     &
      & FlagRadSynchronous,                                             &
      & FlagAnnualMean, FlagDiurnalMean, FlagPerpetual,                 &
      & PerpDelDeg, PerpDistFromStarScld,                               &
      & EpsOrb,                                                         &
      & PerLonFromVE,                                                   &
      & LonFromVEAtEpoch,                                               &
      & Eccentricity,                                                   &
      & TimeAtEpoch,                                                    &
      & EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin, EpochSec, &
      & MaxItrEccAnomaly, ThreEccAnomalyError,                          &
      & IncomAIns, IncomBIns, IncomAZet, IncomBZet
          !
          ! ǥեͤˤĤƤϽ³ "rad_short_income#RadShortIncomeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_short_income#RadShortIncomeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_short_income_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FlagRadSynchronous       = .false.
    FlagAnnualMean           = .true.
    FlagDiurnalMean          = .true.
    FlagPerpetual            = .false.

    !---

    PerpDelDeg               = 0.0_DP
    PerpDistFromStarScld     = 1.0_DP

    !---

    EpsOrb               =   23.5_DP    ! Earth-like value
    PerLonFromVE         =    0.0_DP
    LonFromVEAtEpoch     =  280.0_DP    ! This value results in the fact that the planet
                                        ! is located at the position of vernal equinox 
                                        ! at 80 days after calculation with the use of 
                                        ! "360day" calendar.
    Eccentricity         =    0.0_DP
    TimeAtEpoch          =    0.0_DP
    EpochYear            =   -1
    EpochMonth           =   -1
    EpochDay             =   -1
    EpochHour            =   -1
    EpochMin             =   -1
    EpochSec             =   -1.0_DP

    !---

    ! Sample values for the Earth
    !  References: 
    !    Duffett-Smith, P., Practical astronomy with your calculator Third Edition, 
    !    Cambridge University Press, pp.185, 1988.
    !
!!$    EpsOrb               =   23.44_DP                ! Rika nenpyo (Chronological 
!!$                                                     ! Scientific Tables 2010)
!!$    PerLonFromVE         =  102.768413_DP + 180.0_DP ! Duffett-Smith (1988), p.105
!!$                                                     ! modified (plus 180 degrees)
!!$    LonFromVEAtEpoch     =   99.403308_DP + 180.0_DP ! Duffett-Smith (1988), p.105
!!$                                                     ! modified (plus 180 degrees)
!!$    Eccentricity         =    0.016713_DP            ! Duffett-Smith (1988), p.105
!!$    TimeAtEpoch          =   -1.0_DP                 ! EpochXXX written below are used 
!!$                                                     ! because this is negative.
!!$    EpochYear            = 1990                      ! Duffett-Smith (1988), p.105
!!$    EpochMonth           =    1
!!$    EpochDay             =    1
!!$    EpochHour            =    0
!!$    EpochMin             =    0
!!$    EpochSec             =    0.0_DP
    !---

    ! Sample values for Mars
    !  References: 
    !    Allison, M., Geophys. Res. Lett., 24, 1967-1970, 1997.
    !
!!$    EpsOrb               =   25.19_DP              ! Allison (1997)
!!$    PerLonFromVE         =  250.98_DP              ! Allison (1997) (modified)
!!$    LonFromVEAtEpoch     =  -10.342_DP             ! Arbitrarily set for clarity
!!$                                                   ! This results in Ls ~ 0 at Time = 0
!!$    Eccentricity         =    0.0934_DP            ! Allison (1997), value at epoch J2000
!!$    TimeAtEpoch          =    0.0_DP               ! Arbitrarily set for clarity
!!$    EpochYear            =   -1                    ! not used
!!$    EpochMonth           =   -1
!!$    EpochDay             =   -1
!!$    EpochHour            =   -1
!!$    EpochMin             =   -1
!!$    EpochSec             =   -1.0_DP

    !---

    MaxItrEccAnomaly     = 20
    ThreEccAnomalyError  = 1e-6_DP

    IncomAIns            = 0.127_DP   ! Reference of this value is unknown.
    IncomBIns            = 0.183_DP   ! Reference of this value is unknown.
    IncomAZet            = 0.410_DP   ! Reference of this value is unknown.
    IncomBZet            = 0.590_DP   ! Reference of this value is unknown.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = rad_short_income_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    PerpSinDel = sin( PerpDelDeg * PI / 180.0_DP )


    FlagUseOfEpochDate = .false.

    if ( TimeAtEpoch < 0.0_DP ) then
      call DCCalDateCreate(    &
        & year  = EpochYear,   & ! (in)
        & month = EpochMonth,  & ! (in)
        & day   = EpochDay,    & ! (in)
        & hour  = EpochHour,   & ! (in)
        & min   = EpochMin,    & ! (in)
        & sec   = EpochSec,    & ! (in)
        & date  = EpochDate )    ! (out) optional

      TimeAtEpoch = DCCalDateDifference( &
        &                                 start_date = InitialDate, &  ! (in)
        &                                 end_date   = EpochDate    &  ! (in)
        &                              )

      FlagUseOfEpochDate = .true.
    end if

    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'xxxxx' , &
!!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
!!$      & 'xxxx', 'W m-2' )

    call HistoryAutoAddVariable( 'ISR' , &
      & (/ 'lon ', 'lat ', 'time'/),     &
      & 'incoming shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'Decl' , &
      & (/ 'time'/),                      &
      & 'declination angle', 'degree' )

    call HistoryAutoAddVariable( 'DistFromStarScld' , &
      & (/ 'time'/),                                  &
      & 'distance between the central star and the planet', '1' )

    call HistoryAutoAddVariable( 'PlanetLonFromVE' , &
      & (/ 'time'/),                                 &
      & 'planetary longitude from the vernal equinox', 'degree' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'ShortIncomming:' )
    call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
    call MessageNotify( 'M', module_name, '  FlagAnnualMean           = %b', l = (/ FlagAnnualMean            /) )
    call MessageNotify( 'M', module_name, '  FlagDiurnalMean          = %b', l = (/ FlagDiurnalMean           /) )
    call MessageNotify( 'M', module_name, '  FlagPerpetual            = %b', l = (/ FlagPerpetual             /) )
    call MessageNotify( 'M', module_name, '  PerpDelDeg               = %f', d = (/ PerpDelDeg                /) )
    call MessageNotify( 'M', module_name, '  PerpDistFromStarScld     = %f', d = (/ PerpDistFromStarScld      /) )
    call MessageNotify( 'M', module_name, '  EpsOrb                   = %f', d = (/ EpsOrb                   /) )
    call MessageNotify( 'M', module_name, '  PerLonFromVE             = %f', d = (/ PerLonFromVE             /) )
    call MessageNotify( 'M', module_name, '  Eccentricity             = %f', d = (/ Eccentricity             /) )

    if ( FlagUseOfEpochDate ) then
      call DCCalDateInquire( date_print, date = EpochDate )
      call MessageNotify( 'M', module_name, '  EpochDate  = %c', &
        & c1 = trim(date_print) )
    end if
    call MessageNotify( 'M', module_name, '  TimeAtEpoch              = %f', d = (/ TimeAtEpoch              /) )
    call MessageNotify( 'M', module_name, '  LonFromVEAtEpoch         = %f', d = (/ LonFromVEAtEpoch         /) )

    call MessageNotify( 'M', module_name, '  MaxItrEccAnomaly         = %d', i = (/ MaxItrEccAnomaly         /) )
    call MessageNotify( 'M', module_name, '  ThreEccAnomalyError      = %f', d = (/ ThreEccAnomalyError      /) )
    call MessageNotify( 'M', module_name, '  IncomAIns                = %f', d = (/ IncomAIns                /) )
    call MessageNotify( 'M', module_name, '  IncomBIns                = %f', d = (/ IncomBIns                /) )
    call MessageNotify( 'M', module_name, '  IncomAZet                = %f', d = (/ IncomAZet                /) )
    call MessageNotify( 'M', module_name, '  IncomBZet                = %f', d = (/ IncomBZet                /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_short_income_inited = .true.

  end subroutine RadShortIncomeInit

  !-------------------------------------------------------------------

end module rad_short_income
