!= ꥹȥǡ, ͥǡ
!
!= Restart data, initial data input/output
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: restart_file_io.f90,v 1.24 2011-09-10 18:26:44 yot Exp $
! Tag Name::  $Name: dcpam5-20120226 $
! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module restart_file_io
  !
  != ꥹȥǡ, ͥǡ
  !
  != Restart data, initial data input/output
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ꥹȥǡ⤷ϽͥǡϤԤޤ. 
  ! ϥե, ϥե, ǡνϤδֳ֤
  ! NAMELIST#restart_file_io_nml ꤷޤ. 
  !
  ! ꥹȥǡϥե뤬ꤵʤ, 
  ! initial_data ⥸塼줿ͥǡޤ. 
  !
  ! Restart data or initial data is input/output. 
  ! Settings of input file, output file, and interval of data output 
  ! is configured by "NAMELIST#restart_file_io_nml". 
  !
  ! If input file of restart data is not set, 
  ! initial data is generated in "initial_data" module, and 
  ! obtained data from the module. 
  !
  !== Procedures List
  !
  ! RestartFileOpen   :: ꥹ/ͥեΥץ
  ! RestartFileOutput :: ꥹ/ͥեؤΥǡ
  ! InitialFileOutput :: ͥեؤΥǡ
  ! RestartFileClose  :: ꥹ/ͥեΥ
  ! RestartFileGet    :: ꥹ/ͥե
  ! ------------      :: ------------
  ! RestartFileOpen   :: Open restart/initial file
  ! RestartFileOutput :: Data output to restart/initial file
  ! InitialFileOutput :: Data output to initial file
  ! RestartFileClose  :: Close restart/initial file
  ! RestartFileGet    :: Input restart/initial file
  !
  !== NAMELIST
  !
  ! NAMELIST#restart_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax, &
                              ! ʬο
                              ! Number of composition
    &                    a_QMixName, &
                              ! ʬѿ̾
                              ! Name of variables for composition
    &                    a_QMixLongName, &
                              ! ʬĹѿ̾
                              ! Long name of variables for composition
    &                    IndexH2OVap
                              ! Υǥå
                              ! Index for water vapor


  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gtool_history, only: GT_HISTORY


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RestartFileOpen, RestartFileClose, RestartFileOutPut, InitialFileOutput
  public:: RestartFileGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: restart_file_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  logical, save, public:: restart_file_opened = .false.
                              ! ꥹȥեΥץ˴ؤե饰. 
                              ! Flag of restart file open

  character(STRING), save, public:: InputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of input restart data

  character(STRING), save, public:: OutputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of output restart data
  real(DP), save, public:: IntValue
                              ! ꥹȥǡνϴֳ (). 
                              ! Interval of restart data output (numerical value)
  character(TOKEN), save, public:: IntUnit
                              ! ꥹȥǡνϴֳ (ñ). 
                              ! Interval of restart data output (unit)
  real(DP), save, public:: IntTime
                              ! ꥹȥǡνϴֳ []. 
                              ! Interval of restart data output [sec]

  ! ѿ
  ! Private variables
  !
  logical, save:: flag_init_data_save
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gtool_history#GT_HISTORY ѿ
                              ! "gtool_history#GT_HISTORY" variable for restart data

  real(DP), save:: PrevOutputTime
                              ! νϻ. 
                              ! Previous output time
  logical, save:: flag_output_end
                              ! ׻ǽνϴλΥե饰. 
                              ! Flag for completion of output at the end time of calculation

  character(*), parameter:: module_name = 'restart_file_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20120226 $' // &
    & '$Id: restart_file_io.f90,v 1.24 2011-09-10 18:26:44 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RestartFileOpen( flag_init_data )
    !
    ! ꥹ/ͥե򥪡ץ󤷤ޤ. 
    !
    ! A restart/initial data file is opened. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ. 
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $.
                              ! ߼Ψ. Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & RestartTime, &        ! ꥹȳϻ. 
                              ! Restart time of calculation
      & InitialDate           ! ׻. 
                              ! Start date of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
      & HistoryPut, HistoryAddAttr

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateInquire

    ! ʸ
    ! Character handling
    !
    use dc_string, only: CPrintf, LChar

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    logical, intent(in), optional:: flag_init_data
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

    ! ѿ
    ! Work variables
    !
    character(STRING):: title_msg
                              ! ɽղäå. 
                              ! Message added to title
    real(DP):: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation

    integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
                              ! ׻Ϥǯʬ. 
    real(DP):: InitialSec
                              ! ׻Ϥ. 

    character(TOKEN):: cal_type
                              ! Υ. 
    integer:: month_in_year, hour_in_day, min_in_hour
    integer, pointer:: day_in_month_ptr(:) => null()
    real(DP):: sec_in_min
                              ! ξܺپ

    logical:: flag_mpi_init

    integer :: n


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    flag_init_data_save = present_and_true( flag_init_data )
    if ( .not. restart_file_io_inited ) call RestartFileInit
    if ( restart_file_opened ) return

    ! ɽղäå
    ! Configure message added to title
    !
    if ( .not. flag_init_data_save ) then
      title_msg = ' restart data'
    else
      title_msg = ' initial data'
    end if

    ! μ
    ! Get time information
    !
    if ( .not. flag_init_data_save ) then
      origin_time = RestartTime + IntTime
    else
      origin_time = RestartTime
    end if

    flag_mpi_init = .false.

    ! ꥹȥեΥץ
    ! Open a restart file
    !
    call HistoryCreate( &
      &      file = OutputFile, &                                   ! (in)
      &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
      &    source = FileSource, institution = FileInstitution, &    ! (in)
      &      dims = (/ 'lon    ', 'lat    ', 'sig    ', 'sigm   ', &
      &                'timestr', 'time   ' /), &                   ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, TOKEN, 0 /), &   ! (in)
      & longnames = (/ 'longitude                             ', &
      &                'latitude                              ', &
      &                'sigma at layer midpoints              ', &
      &                'sigma at layer end-points (half level)', &
      &                'number of characters for datetime     ', &    ! (in)
      &                'time                                  ' /), & ! (in)
      &     units = (/ 'degree_east ', 'degree_north', &
      &                '1           ', '1           ', &
      &                '1           ',                 &
      &                'sec         ' /), &                           ! (in)
      & xtypes = (/'double', 'double', 'double', &
      &            'double', 'int   ', 'double'/), &                  ! (in)
      &        origind = origin_time, &       ! (in) optional
      &      intervald = IntTime, &           ! (in) optional
!!$      & flag_mpi_split = flag_mpi_init, &     ! (in) optional
      & flag_mpi_split = .true., &            ! (in) optional
      &        history = gthst_rst )          ! (out) optional


    !  Ʒ׻ǡɤΥåΤΥե饰Ȥ
    !    ΤǤ뤿ᡢ flag_rst 괰λ 
    !    ͽ (morikawa  2010/06/13)
    !
    ! $ \Delta t $ ˴ؤɲ. 
    ! Add information about $ \Delta t $. 
    !
!!$    if ( .not. flag_init_data_save ) then
!!$      call HistoryAddVariable( &
!!$        & varname = 'deltime', &             ! (in)
!!$        & dims = (/''/), &                   ! (in)
!!$        & longname = 'delta time', &         ! (in)
!!$        & units = 'sec', xtype = 'double', & ! (in)
!!$        & history = gthst_rst )              ! (inout)
!!$      call HistoryPut( &
!!$        & varname = 'deltime', &            ! (in)
!!$        & array = (/ DelTime /), &          ! (in)
!!$        & history = gthst_rst )             ! (inout)
!!$    end if

    !  "time" °Ȥ
    ! Set start date information as attributes of "time"
    !
    call DCCalDateInquire( &
      & InitialYear, InitialMonth, InitialDay, & ! (out)
      & InitialHour, InitialMin,   InitialSec, & ! (out)
      & date = InitialDate )               ! (in)

    call HistoryAddAttr( &
      & 'time', attrname = 'origin', &     ! (in)
      & value = 'origin_year origin_month origin_day origin_hour origin_min origin_sec', &
                                           ! (in)
      & history = gthst_rst )              ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_year', & ! (in)
      & value = InitialYear, &                ! (in)
      & history = gthst_rst )               ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_month', & ! (in)
      & value = InitialMonth, &                ! (in)
      & history = gthst_rst )                ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_day', &  ! (in)
      & value = InitialDay, &                 ! (in)
      & history = gthst_rst )               ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_hour', &  ! (in)
      & value = InitialHour, &                 ! (in)
      & history = gthst_rst )                ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_min', &  ! (in)
      & value = InitialMin, &                 ! (in)
      & history = gthst_rst )               ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'origin_sec', &  ! (in)
      & value = InitialSec, &                 ! (in)
      & history = gthst_rst )               ! (inout)

    !  "time" °Ȥ
    ! Set calendar information as attributes of "time"
    !
    call DCCalInquire( &
      & cal_type         = cal_type, &          ! (out)
      & month_in_year    = month_in_year, &     ! (out)
      & day_in_month_ptr = day_in_month_ptr , & ! (out)
      & hour_in_day      = hour_in_day  , &     ! (out)
      & min_in_hour      = min_in_hour  , &     ! (out)
      & sec_in_min       = sec_in_min )         ! (out)

    call HistoryAddAttr( &
      & 'time', attrname = 'calendar', & ! (in)
      & value = cal_type, &              ! (in)
      & history = gthst_rst )            ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'month_in_year', & ! (in)
      & value = month_in_year, &              ! (in)
      & history = gthst_rst )                 ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'day_in_month', & ! (in)
      & value = day_in_month_ptr, &          ! (in)
      & history = gthst_rst )                ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'hour_in_day', & ! (in)
      & value = hour_in_day, &              ! (in)
      & history = gthst_rst )               ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'min_in_hour', & ! (in)
      & value = min_in_hour, &              ! (in)
      & history = gthst_rst )               ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'sec_in_min', & ! (in)
      & value = sec_in_min, &              ! (in)
      & history = gthst_rst )              ! (inout)

    deallocate( day_in_month_ptr )

    ! Ʒ׻ǡѤΥե饰
    ! Set flag for a restart data file. 
    !
    call HistoryAddVariable( &
      & varname = 'flag_rst', &               ! (in)
      & dims = (/''/), &                      ! (in)
      & longname = 'flag for restart data', & ! (in)
      & units = '1', xtype = 'int', &         ! (in)
      & history = gthst_rst )                 ! (inout)
    call HistoryAddAttr( &
      & varname = 'flag_rst', &               ! (in)
      & attrname = 'comment', &               ! (in)
      & value = 'If this value is nonzero, this file provides restart data', &
                                                ! (in)
      & history = gthst_rst )                 ! (inout)

    if ( flag_init_data_save ) then
      call HistoryPut( &
        & varname = 'flag_rst', &               ! (in)
        & array = (/ 0 /), &                    ! (in)
        & history = gthst_rst )                 ! (inout)
    else
      call HistoryPut( &
        & varname = 'flag_rst', &               ! (in)
        & array = (/ 1 /), &                    ! (in)
        & history = gthst_rst )                 ! (inout)
    end if

    ! ǯʬ÷ѿ
    ! Set a date information variable with year-month-day hour:minute:second format
    !
    call HistoryAddVariable( &
      & varname = 'datetime', &                     ! (in)
      & dims =  (/'timestr', 'time   ' /), &        ! (in)
      & longname = 'time represented as strings', & ! (in)
      & units = '1', xtype = 'char', &              ! (in)
      & history = gthst_rst )                       ! (inout) optional

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & 'lon', attrname = 'standard_name', &     ! (in)
      & value = 'longitude', &                   ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'standard_name', &     ! (in)
      & value = 'latitude', &                    ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'standard_name', &     ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'standard_name', &    ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'standard_name', &    ! (in)
      & value = 'time', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'positive', &          ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'positive', &         ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)

    call HistoryPut( &
      & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'sig', z_Sigma, &               ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sigm', r_Sigma, &              ! (in)
      & history = gthst_rst )           ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( 'lon_weight', &               ! (in)
      & (/'lon'/), &                                       ! (in)
      & 'weight for integration in longitude', 'radian', & ! (in)
      & xtype = 'double', &                                ! (in)
      & history = gthst_rst )                              ! (inout)
    call HistoryAddAttr( &
      & 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lon_weight', x_Lon_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'lat_weight', &                      ! (in)
      & (/'lat'/), &                                              ! (in)
      & 'weight for integration in latitude', units = 'radian', & ! (in)
      & xtype = 'double', &                                       ! (in)
      & history = gthst_rst )                                     ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lat_weight', y_Lat_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'sig_weight', &      ! (in)
      & (/'sig'/), &                              ! (in)
      & 'weight for integration in sigma', '1', & ! (in)
      & xtype = 'double', &                       ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'sig_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'sig_weight', z_DelSigma, &               ! (in)
      & history = gthst_rst )                     ! (inout)


    ! ͽѿ
    ! Predictional variables settings
    !
    if ( flag_init_data_save ) then

      ! ǡե
      ! For initial data file
      !
      call HistoryAddVariable( 'U', &                         ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind', 'm s-1', &                         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'V', &                         ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind', 'm s-1', &                        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'Temp', &                      ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature', 'K', &                               ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      do n = 1, ncmax
        call HistoryAddVariable( a_QMixName(n),                & ! (in)
          & (/ 'lon ', 'lat ', 'sig ', 'time' /),              & ! (in)
          & a_QMixLongName(n), 'kg kg-1',                      & ! (in)
          & xtype = 'double',                                  & ! (in)
          & history = gthst_rst                                & ! (inout)
          & )
      end do
      call HistoryAddVariable( 'Ps', &                        ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure', 'Pa', &                         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)

    else

      ! ꥹȥǡե
      ! For restart data file
      !
      call HistoryAddVariable( 'UB', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind (at t-\Delta t)', 'm s-1', &         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'VB', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind (at t-\Delta t)', 'm s-1', &        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'TempB', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature (at t-\Delta t)', 'K', &               ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      do n = 1, ncmax
        call HistoryAddVariable( trim(a_QMixName(n))//'B',    & ! (in)
          & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
          & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
          & xtype = 'double',                                 & ! (in)
          & history = gthst_rst                               & ! (inout)
          & )
      end do
      call HistoryAddVariable( 'PsB', &                       ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure (at t-\Delta t)', 'Pa', &         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)

      call HistoryAddVariable( 'UN', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind (at t)', 'm s-1', &                  ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'VN', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind (at t)', 'm s-1', &                 ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'TempN', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature (at t)', 'K', &                        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      do n = 1, ncmax
        call HistoryAddVariable( trim(a_QMixName(n))//'N',    & ! (in)
          & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
          & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
          & xtype = 'double',                                 & ! (in)
          & history = gthst_rst                               & ! (inout)
          & )
      end do
      call HistoryAddVariable( 'PsN', &                       ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure (at t)', 'Pa', &                  ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
    end if

    restart_file_opened = .true.
  end subroutine RestartFileOpen

  !--------------------------------------------------------------------------------------

  subroutine RestartFileOutput(                      &
    & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
    & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN  &   ! (in)
    & )
    !
    ! ꥹȥǡνϤԤޤ. 
    !
    ! Output restart data

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime, &            ! ׻λ. 
                              ! End time of calculation
      & InitialDate           ! ׻. 
                              ! Start date of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalDateInquire

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_UB     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(in):: xy_PsB     (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_UN     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN     (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    logical:: flag_output
                              ! ϤΥե饰. 
                              ! Flag for output
    character(TOKEN):: date_str         ! ǯʬ÷. 
                                        ! Date with year-month-day hour:minute:second format
    integer :: n


    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) call RestartFileOpen

    ! ꥹȥǡϤǤ뤳ȤΥå
    ! Check restart data output
    !
    if ( flag_init_data_save ) then
      call MessageNotify( 'E', module_name, &
        & 'Now, initial data output mode.' )
    end if

    ! ϥߥ󥰤Υå
    ! Check output timing
    !
    flag_output = TimeN - PrevOutputTime >= IntTime
    if ( TimeN >= EndTime .and. .not. flag_output_end ) then
      flag_output = .true.
      flag_output_end = .true.
    end if
    flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
    flag_output = flag_init_data_save .or. flag_output

    if ( .not. flag_output ) return

    ! Ѥ, ν (˾)  ¸
    ! Save output time (expected) in this time, for next time
    !
    PrevOutputTime = PrevOutputTime + IntTime

    ! 
    ! Set time
    !
    call HistorySetTime( timed = TimeN, history = gthst_rst )

    ! "TimeN" ǯʬɽˤ "datetime" ѿؽ
    ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
    !
    call DCCalDateInquire( &
      & date_str   = date_str, &   ! (out)
      & elapse_sec = TimeN, &      ! (in) optional
      & date       = InitialDate ) ! (in) optional

    call HistoryPut( 'datetime', date_str, &  ! (in)
      &              history = gthst_rst )    ! (inout) optional

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'UB', xyz_UB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VB', xyz_VB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempB', xyz_TempB, history = gthst_rst ) ! (in)
    do n = 1, ncmax
      call HistoryPut( &
        & trim(a_QMixName(n))//'B', xyzf_QMixB(:,:,:,n), history = gthst_rst ) ! (in)
    end do
    call HistoryPut( &
      & 'PsB', xy_PsB, history = gthst_rst ) ! (in)

    call HistoryPut( &
      & 'UN', xyz_UN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VN', xyz_VN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempN', xyz_TempN, history = gthst_rst ) ! (in)
    do n = 1, ncmax
      call HistoryPut( &
        & trim(a_QMixName(n))//'N', xyzf_QMixN(:,:,:,n), history = gthst_rst ) ! (in)
    end do
    call HistoryPut( &
      & 'PsN', xy_PsN, history = gthst_rst ) ! (in)

  end subroutine RestartFileOutput

  !--------------------------------------------------------------------------------------

  subroutine InitialFileOutput(                 &
    & xyz_U, xyz_V, xyz_Temp, xyzf_QMix, xy_Ps  &   ! (in)
    & )
    !
    ! ͥǡνϤԤޤ. 
    !
    ! Output initial data

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime, &            ! ׻λ. 
                              ! End time of calculation
      & InitialDate           ! ׻. 
                              ! Start date of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalDateInquire

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .     ®. Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xy_Ps    (0:imax-1, 1:jmax)
                              ! $ p_s $ .   ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    character(STRING):: date_str        ! ǯʬ÷. 
                                        ! Date with year-month-day hour:minute:second format
    integer          :: n


    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) call RestartFileOpen( flag_init_data = .true. )

    ! ͽϤǤ뤳ȤΥå
    ! Check initial data output
    !
    if ( .not. flag_init_data_save ) then
      call MessageNotify( 'E', module_name, &
        & 'Now, restart data output mode.' )
    end if

    ! 
    ! Set time
    !
    call HistorySetTime( timed = TimeN, history = gthst_rst )

    ! "TimeN" ǯʬɽˤ "datetime" ѿؽ
    ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
    !
    call DCCalDateInquire( &
      & date_str   = date_str, &   ! (out)
      & elapse_sec = TimeN, &      ! (in) optional
      & date       = InitialDate ) ! (in) optional

    call HistoryPut( 'datetime', date_str, &  ! (in)
      &              history = gthst_rst )    ! (inout) optional

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'U', xyz_U, history = gthst_rst )       ! (in)
    call HistoryPut( &
      & 'V', xyz_V, history = gthst_rst )       ! (in)
    call HistoryPut( &
      & 'Temp', xyz_Temp, history = gthst_rst ) ! (in)
    do n = 1, ncmax
      call HistoryPut( &
        & a_QMixName(n), xyzf_QMix(:,:,:,n), history = gthst_rst ) ! (in)
    end do
    call HistoryPut( &
      & 'Ps', xy_Ps, history = gthst_rst )      ! (in)


  end subroutine InitialFileOutput

  !--------------------------------------------------------------------------------------

  subroutine RestartFileClose
    !
    ! ꥹȥǡեϤνλԤޤ. 
    !
    ! Terminate restart data files output. 

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) return

    call HistoryClose( history = gthst_rst ) ! (inout)

    restart_file_opened = .false.
  end subroutine RestartFileClose

  !--------------------------------------------------------------------------------------

  subroutine RestartFileGet( &
    & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, & ! (out)
    & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, & ! (out)
    & flag_initial                                   & ! (out) optional
    & )
    !
    ! ꥹ/ͥǡϤԤޤ. 
    ! ꥹ/ͥǡե뤬¸ߤʤˤ, 
    ! initial_data ⥸塼Ѥ, Ԥޤ. 
    !
    ! Input restart/initial data. 
    ! If a restart/initial data file is not exist, 
    ! initial data is created by "initial_data". 


    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime               ! $ \Delta t $ [s]

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    use initial_data, only: SetInitData

    ! 
    ! Time control
    !
    use timeset, only: TimesetSetInitialDate, TimesetSetTimeN, TimesetSetCalendar, &
      & RestartTime           ! ꥹȳϻ. 
                              ! Restart time of calculation

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet, HistoryGetAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_UB      (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_VB      (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(out):: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(out):: xyzf_QMixB  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(out):: xy_PsB      (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(out):: xyz_UN      (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(out):: xyz_VN      (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(out):: xyz_TempN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(out):: xyzf_QMixN  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(out):: xy_PsN      (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
    logical , intent(out), optional:: flag_initial
                              ! ꥹȥǡɤ߹ˤ, 
                              ! .false. , ͥǡɤ߹ˤ
                              ! .true. ֤ޤ. 
                              ! 
                              ! If restart data is loaded, .false. is returned.
                              ! On the other hand, if initial data is loaded, 
                              ! .true. is returned. 

    ! ѿ
    ! Work variables
    !
    integer:: flag_rst        ! ͥǡϻ 0, 
                              ! ꥹȥǡϻ 1. 
                              ! 
                              ! If initial data is input, this value is 0. 
                              ! If restart data is input, this value is 1.

    character(STRING):: time_range
                              ! λ. 
                              ! Specification of time
    character(TOKEN):: dummy_str
                              ! ϥåѤΥߡѿ
                              ! Dummy variable for check of input
    logical:: get_err
                              ! ϻΥ顼ե饰. 
                              ! Error flag for input
    real(DP):: returned_time
                              ! ϥǡλ. 
                              ! Time of input data.
    logical:: flag_time_exist
                              ! ϥǡλѤΥե饰. 
                              ! Flag for time of input data.

    integer:: origin_year, origin_month, origin_day, origin_hour, origin_min
                              ! ׻Ϥǯʬ. 
    real(DP):: origin_sec
                              ! ׻Ϥ. 
    character(TOKEN):: cal_type
                              ! Υ. 
    integer:: month_in_year, hour_in_day, min_in_hour
    integer, pointer:: day_in_month_ptr(:) => null()
    real(DP):: sec_in_min
                              ! ξܺپ
    real(DP):: rst_time
                              ! ꥹȥǡե뤫ѿ
                              ! Time variable from a restart data file

    logical:: flag_mpi_init

    integer :: n


    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_file_io_inited ) call RestartFileInit

    ! ǡ initial_data ⥸塼뤫
    ! Data is input from "initial_data" module
    ! 
    if ( trim(InputFile) == '' ) then
      call SetInitData( &
        & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xy_PsB )   ! (out)

      ! The variables below are initialized here, temporarily. 
      !
      xyzf_QMixB(:,:,:,1:IndexH2OVap-1)     = 0.0_DP
      xyzf_QMixB(:,:,:,IndexH2OVap+1:ncmax) = 0.0_DP

      call MessageNotify( 'M', module_name, &
        & 'Initial data (not restart data) is input ' // &
        & 'from a module "initial_data". ' // &
        & '*B (t-dt) and *N (t) are same.' )

      xyz_UN     = xyz_UB
      xyz_VN     = xyz_VB
      xyz_TempN  = xyz_TempB
      xyzf_QMixN = xyzf_QMixB
      xy_PsN     = xy_PsB

      if ( present(flag_initial) ) flag_initial = .true.

    ! ǡ InputFile 
    ! Data is input from InputFile
    ! 
    else

!!$      flag_mpi_init = .false.
      flag_mpi_init = .true.

      ! ե̵ͭǧ
      ! Conform an existence of an input file
      ! 
      call HistoryGetAttr( InputFile, 'lon', 'units', & ! (in)
        & dummy_str, &                                  ! (out)
        & flag_mpi_split = flag_mpi_init, &             ! (in) optional
        & err = get_err )                               ! (out)

      if ( get_err ) then
        call MessageNotify( 'E', module_name, &
          & 'restart/initial data file "%c" is not found.', &
          & c1 = trim(InputFile) )
      end if

      ! μ
      ! Get time information
      !
      time_range = 'time=' // toChar( RestartTime )

      ! ͥǡꥹȥǡΥå
      ! Check whether input data is initial data or restart data
      ! 
      call HistoryGet( &
        & InputFile, 'flag_rst', &                ! (in)
        & flag_rst, &                             ! (out)
        & err = get_err, &                        ! (out) optional
        & quiet = .true., &                       ! (in) optional
        & flag_mpi_split = flag_mpi_init )        ! (in) optional

      if ( get_err ) then
        ! flag_rst ѿɤ߹ʤ硢Ȥꤢͥǡȸʤ
        !
        flag_rst = 0
        if ( present(flag_initial) ) flag_initial = .true.

      else if ( flag_rst == 0 ) then
        if ( present(flag_initial) ) flag_initial = .true.

      else
        if ( present(flag_initial) ) flag_initial = .false.
      end if

      ! ʪ̥ǡ̵ͭΥå ("U", "UB" Τ)
      ! Check existence or nonexistence of physical data (only "U", "UB")
      ! 
      if ( flag_rst == 0 ) then
        call HistoryGet( &
          & InputFile, 'U', &                       ! (in)
          & xyz_UB, &                               ! (out)
          & err = get_err, &                        ! (out) optional
          & quiet = .true., &                       ! (in) optional
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        if ( get_err ) then
          call MessageNotify( 'E', module_name, &
            & 'One of necessary variables "U" for start of calculation ' // &
            & 'cannot be read from "%c"', &
            & c1 = trim(InputFile) )
        end if

      else

        call HistoryGet( &
          & InputFile, 'UB', &                      ! (in)
          & xyz_UB, &                               ! (out)
          & range = time_range, &                   ! (in) optional
          & quiet = .true., &                       ! (in) optional
          & err = get_err, &                        ! (out) optional
          & returned_time = returned_time, &        ! (out) optional
          & flag_time_exist = flag_time_exist, &    ! (out) optional
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        if ( get_err ) then
          call MessageNotify( 'E', module_name, &
            & 'One of necessary variables "UB" for restart ' // &
            & 'cannot be read from "%c"', &
            & c1 = trim(InputFile) )
        end if
      end if

      ! ͥǡϤ硢в֤ 0 
      ! Set 0 to elapsed time, when initial data is input
      !
      if ( flag_rst == 0 ) then
        call TimesetSetTimeN( 0.0_DP )
      end if

      ! 񡢳вɤ߹ߤȾ
      ! Input and overwrite calendar, start date, and elapsed time
      !
      if ( flag_rst /= 0 ) then

        ! ɤ߹
        ! Input calendar
        !
        call HistoryGetAttr( &
          & InputFile, 'time', 'calendar', &          ! (in)
          & cal_type, &                               ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'month_in_year', &     ! (in)
          & month_in_year, &                          ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        allocate( day_in_month_ptr(month_in_year) )
        call HistoryGetAttr( &
          & InputFile, 'time', 'day_in_month', &      ! (in)
          & day_in_month_ptr, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'hour_in_day', &       ! (in)
          & hour_in_day, &                            ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'min_in_hour', &       ! (in)
          & min_in_hour, &                            ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'sec_in_min', &        ! (in)
          & sec_in_min, &                             ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        ! ξ
        ! Overwrite calendar
        !
        call TimesetSetCalendar( cal_type, &       ! (in)
          & month_in_year, day_in_month_ptr, &     ! (in)
          & hour_in_day, min_in_hour, sec_in_min ) ! (in)

        deallocate( day_in_month_ptr )

        ! ɤ߹
        ! Input start date
        !
        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_year', &     ! (in)
          & origin_year, &                          ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_month', &    ! (in)
          & origin_month, &                         ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_day', &      ! (in)
          & origin_day, &                           ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_hour', &     ! (in)
          & origin_hour, &                          ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_min', &      ! (in)
          & origin_min, &                           ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        call HistoryGetAttr( &
          & InputFile, 'time', 'origin_sec', &      ! (in)
          & origin_sec, &                           ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        ! ξ
        ! Overwrite start date
        !
        call TimesetSetInitialDate( &
          & origin_year, origin_month, origin_day, & ! (in)
          & origin_hour, origin_min,   origin_sec )  ! (in)

        ! в֤ɤ߹
        ! Input elapsed time
        !
        call HistoryGet( &
          & InputFile, 'time', range = time_range, &  ! (in)
          & array = rst_time, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )          ! (in) optional

        call MessageNotify( 'M', module_name, &
          & '  Specified RestartTime from a NAMELIST file            = <%f>, ', &
          & d = (/ RestartTime /) )
        call MessageNotify( 'M', module_name, &
          & '  Actual initial value of TimeN  from a restart file  = <%f>', &
          & d = (/ rst_time /) )

        ! в֤ξ
        ! Overwrite elapsed time
        !
        call TimesetSetTimeN( rst_time )

      end if

      ! ǡ
      ! Data input
      ! 
      if ( flag_rst == 0 ) then
        call HistoryGet( &
          & InputFile, 'U', &                 ! (in)
          & array = xyz_UB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'V', &                 ! (in)
          & array = xyz_VB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'Temp', &              ! (in)
          & array = xyz_TempB, &              ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        do n = 1, ncmax
          call HistoryGet(                           &
            & InputFile, trim(a_QMixName(n)),        &              ! (in)
            & array = xyzf_QMixB(:,:,:,n),           &              ! (out)
            & flag_mpi_split = flag_mpi_init         &              ! (in) optional
            & )
        end do
        call HistoryGet( &
          & InputFile, 'Ps', &                ! (in)
          & array = xy_PsB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional

        call MessageNotify( 'M', module_name, &
          & 'Initial data (not restart data) is input ' // &
          & 'from a data file "%c". ' // &
          & '*B (t-dt) and *N (t) are same.', &
          & c1 = trim(InputFile) )

        xyz_UN     = xyz_UB
        xyz_VN     = xyz_VB
        xyz_TempN  = xyz_TempB
        xyzf_QMixN = xyzf_QMixB
        xy_PsN     = xy_PsB

      else
        call HistoryGet( &
          & InputFile, 'UB', range = time_range, &  ! (in)
          & array = xyz_UB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'VB', range = time_range, &  ! (in)
          & array = xyz_VB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'TempB', range = time_range, &  ! (in)
          & array = xyz_TempB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        do n = 1, ncmax
          call HistoryGet(                                             &
            & InputFile, trim(a_QMixName(n))//'B', range = time_range, & ! (in)
            & array = xyzf_QMixB(:,:,:,n),                             & ! (out)
            & flag_mpi_split = flag_mpi_init                           & ! (in) optional
            & )
        end do
        call HistoryGet( &
          & InputFile, 'PsB', range = time_range, &  ! (in)
          & array = xy_PsB, &                        ! (out)
          & flag_mpi_split = flag_mpi_init )         ! (in) optional

        call HistoryGet( &
          & InputFile, 'UN', range = time_range, &  ! (in)
          & array = xyz_UN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'VN', range = time_range, &  ! (in)
          & array = xyz_VN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'TempN', range = time_range, &  ! (in)
          & array = xyz_TempN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        do n = 1, ncmax
          call HistoryGet(                                             &
            & InputFile, trim(a_QMixName(n))//'N', range = time_range, & ! (in)
            & array = xyzf_QMixN(:,:,:,n),                             & ! (out)
            & flag_mpi_split = flag_mpi_init                           & ! (in) optional
            & )
        end do
        call HistoryGet( &
          & InputFile, 'PsN', range = time_range, &  ! (in)
          & array = xy_PsN, &                        ! (out)
          & flag_mpi_split = flag_mpi_init )         ! (in) optional

        call MessageNotify( 'M', module_name, &
          & 'Restart data (not initial data) is input ' // &
          & 'from a data file "%c". ', &
          & c1 = trim(InputFile) )
      end if

    end if

  end subroutine RestartFileGet

  !--------------------------------------------------------------------------------------

  subroutine RestartFileInit
    !
    ! restart_file_io ⥸塼νԤޤ. 
    ! NAMELIST#restart_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "restart_file_io" module is initialized. 
    ! "NAMELIST#restart_file_io_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime           ! ꥹȳϻ. 
                              ! Restart time of calculation

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /restart_file_io_nml/ &
      & InputFile, &
      & OutputFile, &
      & IntValue, IntUnit
          !
          ! ǥեͤˤĤƤϽ³ "restart_file_io#RestartFileInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "restart_file_io#RestartFileInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( restart_file_io_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    InputFile  = ''
    if ( .not. flag_init_data_save ) then
      OutputFile = 'rst.nc'
    else
      OutputFile = 'init.nc'
    end if
    IntValue   = 365.0d0
    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = restart_file_io_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = restart_file_io_nml )
    end if

    ! ϻֳִ֤
    ! Configure time interval of output
    !
    IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
    PrevOutputTime = RestartTime

    ! ե饰ν
    ! Initialize flag
    !
    flag_output_end = .false.

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    if ( trim(InputFile) /= '' ) then
      call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
    else
      call MessageNotify( 'M', module_name, '  InputFile  = <Non>' )
      call MessageNotify( 'M', module_name, '  ** Initial data is generated in "initial_data" module' )
    end if
    call MessageNotify( 'M', module_name, 'Output:: ' )
    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    restart_file_io_inited = .true.

  end subroutine RestartFileInit

  !--------------------------------------------------------------------------------------

end module restart_file_io
