!= ̤
!
!= Set cloud amount
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_cloud.f90,v 1.4 2011-02-18 04:36:41 yot Exp $
! Tag Name::  $Name: dcpam5-20110225-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_cloud
  !
  != ̤
  !
  != Set cloud amount
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʬۤ.
  !
  ! In this module, the amount of cloud or cloud optical depth are set.
  ! This module is under development and is still a preliminary version. 
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#set_cloud_nml
  !

  ! ⥸塼 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private

  real(DP), save        :: CloudLifeTime

  real(DP), save        :: CloudCover

  logical , save        :: FlagCloud
                           ! A flag for cloud set.
                           ! If FlagCloud is true, the effect of cloud is considered.
                           ! It should be noticed that in principle 

!!$  real(DP), allocatable :: xy_PRCPSave       (:,:)
!!$  real(DP), allocatable :: xyz_DTempDtCumSave(:,:,:)
!!$  real(DP), allocatable :: xyz_DPDtSave      (:,:,:)


  real(DP), allocatable :: xyz_DQCloudWaterDtCumSave(:,:,:)
  real(DP), allocatable :: xyz_DQCloudWaterDtLSCSave(:,:,:)



  ! ѿ
  ! Public variables
  !
  logical, save, public:: set_cloud_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: SetCloudCloudWaterLossRateInOut
  public :: SetCloudRegDQCloudWaterDt

!!$  public :: SetCloudCalcOverlapFactor

  character(*), parameter:: module_name = 'set_cloud'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110225-4 $' // &
    & '$Id: set_cloud.f90,v 1.4 2011-02-18 04:36:41 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SetCloudCloudWaterLossRateInOut(  &
    & xyz_QCloudWater,                         & ! (in   )
    & xyz_DQCloudWaterDt                       & ! (inout)
    & )

    ! USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop


    real(DP), intent(in   ) :: xyz_QCloudWater   ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_DQCloudWaterDt( 0:imax-1, 1:jmax, 1:kmax )


    real(DP) :: xyz_QCloudWaterTentative(0:imax-1, 1:jmax, 1:kmax)


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit



    ! Cloud optical depth
    !
    if ( FlagCloud ) then

!!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt &
!!$        & - xyz_QCloudWater / ( CloudLifeTime + 1.0d-100 )


!!$      ( X_{t+1} - X_{t-1} ) / ( 2 \Delta t ) = Q - X_{t+1} / \tau
!!$
!!$      X_{t+1} / ( 2 \Delta t )  + X_{t+1} / \tau = X_{t-1} / ( 2 \Delta t ) + Q
!!$      ( 1 / ( 2 \Delta t )  + 1 / \tau ) X_{t+1} = X_{t-1} / ( 2 \Delta t ) + Q
!!$      X_{t+1} = ( X_{t-1} / ( 2 \Delta t ) + Q ) / ( 1 / ( 2 \Delta t )  + 1 / \tau ) 

!!$      xyz_QCloudWaterTentative = xyz_QCloudWater &
!!$        & / ( 1.0_DP + 2.0_DP * DelTime / ( CloudLifeTime + 1.0d-100 ) )
!!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt              &
!!$        & + ( xyz_QCloudWaterTentative - xyz_QCloudWater ) &
!!$        &   / ( 2.0_DP * DelTime )

!!$      xyz_QCloudWaterTentative =                                                      &
!!$        &   ( xyz_QCloudWater / ( 2.0_DP * DelTime ) + xyz_DQCloudWaterDt )           &
!!$        &   / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
      xyz_QCloudWaterTentative =                                                      &
        &   ( xyz_QCloudWater / ( 2.0_DP * DelTime )                                  &
        &     + xyz_DQCloudWaterDt                                                    &
        &     + xyz_DQCloudWaterDtCumSave + xyz_DQCloudWaterDtLSCSave                 &
        &   )                                                                         &
        & / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
      xyz_DQCloudWaterDt =                                 &
        & + ( xyz_QCloudWaterTentative - xyz_QCloudWater ) &
        &   / ( 2.0_DP * DelTime )

    end if


  end subroutine SetCloudCloudWaterLossRateInOut

  !--------------------------------------------------------------------------------------

  subroutine SetCloudCalcOverlapFactor(  &
    & Type,                              & ! (in)
    & xyz_TransCloudOneLayer,            & ! (in)
    & xyrr_CloudOverlapFactor            & ! (out)
    & )

    ! USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    character(len=*), intent(in ) :: Type
    real(DP)        , intent(in ) :: xyz_TransCloudOneLayer (0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(out) :: xyrr_CloudOverlapFactor(0:imax-1, 1:jmax, 0:kmax, 0:kmax)


    real(DP) :: xyz_CloudCover(0:imax-1, 1:jmax, 1:kmax)
    integer  :: k
    integer  :: kk


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit



    ! Cloud optical depth
    !
    if ( .not. FlagCloud ) then

      xyrr_CloudOverlapFactor = 1.0_DP

    else

      call SetCloudCalcCloudCover(  &
        & xyz_CloudCover                  & ! (out)
        & )

      if ( Type == 'Random_Overlap' ) then

        do k = 0, kmax
          kk = k
          xyrr_CloudOverlapFactor(:,:,k,kk) = 1.0_DP
          do kk = k+1, kmax
            xyrr_CloudOverlapFactor(:,:,k,kk) =                               &
              &     xyrr_CloudOverlapFactor(:,:,k,kk-1)                       &
              & * ( 1.0_DP - xyz_CloudCover(:,:,kk)                           &
              &              * ( 1.0_DP - xyz_TransCloudOneLayer(:,:,kk) ) )
          end do
        end do

        do k = 0, kmax
          do kk = 0, k-1
            xyrr_CloudOverlapFactor(:,:,k,kk) = xyrr_CloudOverlapFactor(:,:,kk,k)
          end do
        end do

      else
        call MessageNotify( 'E', module_name, 'Type %c is not supported.', c1 = trim( Type ) )
      end if

    end if


  end subroutine SetCloudCalcOverlapFactor

  !--------------------------------------------------------------------------------------

  subroutine SetCloudCalcCloudCover(  &
    & xyz_CloudCover                  & ! (out)
    & )

    ! USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    real(DP), intent(out) :: xyz_CloudCover( 0:imax-1, 1:jmax, 1:kmax )



    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit



    ! Cloud optical depth
    !
    if ( .not. FlagCloud ) then

      xyz_CloudCover = 0.0_DP

    else

      xyz_CloudCover = CloudCover

    end if


  end subroutine SetCloudCalcCloudCover

  !--------------------------------------------------------------------------------------

  subroutine SetCloudRegDQCloudWaterDt( &
    & Spec, xyz_DQCloudWaterDt          & ! (in)
    & )

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    character(len=*), intent(in ) :: Spec
    real(DP)        , intent(in ) :: xyz_DQCloudWaterDt( 0:imax-1, 1:jmax, 1:kmax )


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit


    if ( Spec == 'CUM' ) then
      xyz_DQCloudWaterDtCumSave = xyz_DQCloudWaterDt
    else if ( Spec == 'LSC' ) then
      xyz_DQCloudWaterDtLSCSave = xyz_DQCloudWaterDt
    else
      call MessageNotify( 'E', module_name, '%c is not supported.', c1 = trim( Spec ) )
    end if


  end subroutine SetCloudRegDQCloudWaterDt

  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine SetCloudCalcLWP(                    &
!!$    & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_Height, &
!!$    & xyz_DelLWP   &
!!$    & )
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: &
!!$      & Grav, &
!!$                              ! $ g $ [m s-2].
!!$                              ! ϲ®.
!!$                              ! Gravitational acceleration
!!$      & GasRDry
!!$                              ! $ R $ [J kg-1 K-1].
!!$                              ! 絤ε.
!!$                              ! Gas constant of air
!!$
!!$    ! ҥȥǡ
!!$    ! History data output
!!$    !
!!$    use gtool_historyauto, only: HistoryAutoPut
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: &
!!$      & TimeN, &              ! ƥå $ t $ λ.
!!$                              ! Time of step $ t $.
!!$      & EndTime, &            ! ׻λ.
!!$                              ! End time of calculation
!!$      & TimesetClockStart, TimesetClockStop
!!$
!!$    ! ˰漾λ
!!$    ! Evaluate saturation specific humidity
!!$    !
!!$    use saturate, only: xyz_CalcQVapSat
!!$
!!$
!!$    real(DP), intent(in ) :: xyz_Press ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in ) :: xyr_Press ( 0:imax-1, 1:jmax, 0:kmax )
!!$    real(DP), intent(in ) :: xyz_Temp  ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in ) :: xyz_QVap  ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in ) :: xyz_Height( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(out) :: xyz_DelLWP( 0:imax-1, 1:jmax, 1:kmax )
!!$
!!$
!!$    integer  :: xy_NumCloudLayer      ( 0:imax-1, 1:jmax )
!!$    real(DP) :: xy_CloudCoverTot      ( 0:imax-1, 1:jmax )
!!$    real(DP) :: xy_CloudCoverEachLayer( 0:imax-1, 1:jmax )
!!$    real(DP) :: xyz_CloudCover        ( 0:imax-1, 1:jmax, 1:kmax )
!!$
!!$    real(DP):: xyz_QVapSat            ( 0:imax-1, 1:jmax, 1:kmax )
!!$                              ! ˰漾.
!!$                              ! Saturation specific humidity.
!!$
!!$    real(DP):: xyz_RH                 ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP):: xyz_RHCor              ( 0:imax-1, 1:jmax, 1:kmax )
!!$
!!$    real(DP), parameter :: CloudLiqWatDen0 = 0.18d-3
!!$    real(DP)            :: xy_ColWatVapor           ( 0:imax-1, 1:jmax )
!!$    real(DP)            :: xy_CloudLiqWatScaleHeight( 0:imax-1, 1:jmax )
!!$    real(DP)            :: xyz_CloudLiqWatDen       ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP)            :: xyz_DelCloudLiqWat       ( 0:imax-1, 1:jmax, 1:kmax )
!!$
!!$    integer  :: i
!!$    integer  :: j
!!$    integer  :: k
!!$
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. set_cloud_inited ) call SetCloudInit
!!$
!!$
!!$    ! ˰漾׻
!!$    ! Calculate saturation specific humidity
!!$    !
!!$    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
!!$
!!$    xyz_RH = xyz_QVap / xyz_QVapSat
!!$
!!$
!!$    xy_NumCloudLayer = 0
!!$    do k = 1, kmax
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          if ( xyz_DTempDtCumSave(i,j,k) > 0.0d0 ) then
!!$            xy_NumCloudLayer = xy_NumCloudLayer + 1
!!$          end if
!!$        end do
!!$      end do
!!$    end do
!!$
!!$    xy_CloudCoverTot = 0.0d0
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xy_PRCPSave(i,j) >= 0.0d0 ) then
!!$          xy_CloudCoverTot(i,j) = 0.20d0 &
!!$            & + 0.125d0 * log( 1.0d0 + xy_PRCPSave(i,j) * 86400.0d0 / 1.0d3 * 1.0d3 )
!!$        end if
!!$      end do
!!$    end do
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xy_CloudCoverTot(i,j) > 0.8d0 ) then
!!$          xy_CloudCoverTot(i,j) = 0.8d0
!!$        end if
!!$      end do
!!$    end do
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xy_NumCloudLayer(i,j) == 0 ) then
!!$          xy_CloudCoverEachLayer(i,j) = 0.0d0
!!$        else
!!$          xy_CloudCoverEachLayer(i,j) = &
!!$            & 1.0d0 - ( 1.0d0 - xy_CloudCoverTot(i,j) )**(1.0d0/xy_NumCloudLayer(i,j))
!!$        end if
!!$      end do
!!$    end do
!!$
!!$    do k = 1, kmax
!!$      xyz_RHCor(:,:,k) =                               &
!!$        &   ( xyz_RH(:,:,k) - xy_CloudCoverEachLayer ) &
!!$        & / ( 1.0d0 - xy_CloudCoverEachLayer )
!!$    end do
!!$
!!$
!!$    xyz_CloudCover = 0.0d0
!!$
!!$!    ! Frontal and tropical low-cloud
!!$!    !
!!$!    do k = 1, kmax
!!$!      do j = 1, jmax
!!$!        do i = 0, imax-1
!!$!          if ( xyz_Press(i,j,k) > 750.0d2 .and. xyz_DPDtSave(i,j,k) < 0.0d0 ) then
!!$!            xyz_CloudCover(i,j,k) = ( ( xyz_RHCor(i,j,k) - 0.9d0 ) / 0.1d0 )**2
!!$!          end if
!!$!        end do
!!$!      end do
!!$!    end do
!!$
!!$
!!$    do k = 1, kmax
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          if ( ( xyz_RHCor(i,j,k) > 0.6d0 ) .and. &
!!$            &  ( xyz_DTempDtCumSave(i,j,k) > 0.0d0 ) ) then
!!$            xyz_CloudCover(i,j,k) = xy_CloudCoverEachLayer(i,j)
!!$          else
!!$            xyz_CloudCover(i,j,k) = 0.0d0
!!$          end if
!!$        end do
!!$      end do
!!$    end do
!!$
!!$
!!$
!!$
!!$    xy_ColWatVapor = 0.0d0
!!$    do k = 1, kmax
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          xy_ColWatVapor = xy_ColWatVapor &
!!$            & + xyz_QVap(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
!!$        end do
!!$      end do
!!$    end do
!!$
!!$    xy_CloudLiqWatScaleHeight = &
!!$      &   700.0d0 * log( 1.0d0 + 1.0d0 * xy_ColWatVapor ) &
!!$      & + 1.0d0
!!$
!!$    do k = 1, kmax
!!$      xyz_CloudLiqWatDen(:,:,k) = &
!!$        & CloudLiqWatDen0 * exp( - xyz_Height(:,:,k) / xy_CloudLiqWatScaleHeight )
!!$    end do
!!$
!!$
!!$    do k = 1, kmax
!!$      xyz_DelCloudLiqWat(:,:,k) = xyz_CloudLiqWatDen(:,:,k)              &
!!$        & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) )                    &
!!$        & / ( xyz_Press(:,:,k) / ( GasRDry * xyz_Temp(:,:,k) ) * Grav )
!!$    end do
!!$
!!$    xyz_DelLWP = xyz_CloudCover * xyz_DelCloudLiqWat
!!$
!!$
!!$    call HistoryAutoPut( TimeN, 'CloudCover', xyz_CloudCover )
!!$
!!$
!!$  end subroutine SetCloudCalcLWP
!!$
  !--------------------------------------------------------------------------------------

  subroutine SetCloudInit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_cloud_nml/ &
      & FlagCloud,           &
      & CloudLifeTime,       &
      & CloudCover
          !
          ! ǥեͤˤĤƤϽ³ "set_cloud#setCloudInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "set_cloud#SetCloudInit" for the default values.
          !


    ! ǥեͤ
    ! Default values settings
    !

    FlagCloud           = .true.

    CloudLifeTime       = 3600.0_DP

    CloudCover          = 0.5_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_cloud_nml, & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


!!$    allocate( xy_PRCPSave       ( 0:imax-1, 1:jmax ) )
!!$    allocate( xyz_DTempDtCumSave( 0:imax-1, 1:jmax, 1:kmax ) )
!!$    allocate( xyz_DPDtSave      ( 0:imax-1, 1:jmax, 1:kmax ) )

    allocate( xyz_DQCloudWaterDtCumSave( 0:imax-1, 1:jmax, 1:kmax ) )
    allocate( xyz_DQCloudWaterDtLSCSave( 0:imax-1, 1:jmax, 1:kmax ) )

!!$    xy_PRCPSave        = 0.0d0
!!$    xyz_DTempDtCumSave = 0.0d0
!!$    xyz_DPDtSave       = 0.0d0

    xyz_DQCloudWaterDtCumSave = 0.0_DP
    xyz_DQCloudWaterDtLSCSave = 0.0_DP


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'CloudCover', &
!!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
!!$      & 'cloud cover', '1' )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'FlagCloud           = %b', l = (/ FlagCloud /) )
    call MessageNotify( 'M', module_name, 'CloudLifeTime       = %f', d = (/ CloudLifeTime /) )
    call MessageNotify( 'M', module_name, 'CloudCover          = %f', d = (/ CloudCover /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    set_cloud_inited = .true.

  end subroutine SetCloudInit

  !--------------------------------------------------------------------------------------

end module set_cloud
