!= ʹϢ롼
!
!= Routines for radiation calculation
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. TAKAHASHI
! Version::   $Id: radiation_utils.f90,v 1.6 2011-02-18 04:38:54 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110225-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module radiation_utils
  !
  != ʹϢ롼
  !
  != Routines for radiation calculation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
  ! RadiationFluxOutput     :: ͥեåν
  ! ------------            :: ------------
  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
  ! RadiationFluxOutput     :: Output radiation fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#radiation_utils_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: RadiationRTEQNonScat
  public :: RadiationRTEQNonScatWrapper
  public :: RadiationDTempDt
  public :: RadiationFluxOutput

  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_utils_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  real(DP), save :: DiffFact


  character(*), parameter:: module_name = 'radiation_utils'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110225-4 $' // &
    & '$Id: radiation_utils.f90,v 1.6 2011-02-18 04:38:54 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

!!$  subroutine RadiationRTEQNonScat(                    &
!!$    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in )
!!$    & xyr_RadLFlux, xyra_DelRadLFlux,                 & ! (out)
!!$    & WNs, WNe, NumGaussNode,                         & ! (in ) optional
!!$    & xyrr_Trans                                      & ! (in ) optional
!!$    & )
!!$    !
!!$    ! ʤξãη׻
!!$    !
!!$    ! Integrate radiative transfer equation without scattering
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: &
!!$      & PI, &
!!$                              ! $ \pi $ .
!!$                              ! ߼Ψ.  Circular constant
!!$      & StB
!!$                              ! $ \sigma_{SB} $ .
!!$                              ! ƥեܥĥޥ.
!!$                              ! Stefan-Boltzmann constant
!!$
!!$
!!$    ! ץ󥯴ؿη׻
!!$    ! Calculate Planck function
!!$    !
!!$    use planck_func, only :                            &
!!$      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
!!$      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$
!!$    real(DP), intent(in ):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T $ .     . Temperature
!!$    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
!!$                              ! ɽ̲. 
!!$                              ! Surface temperature
!!$    real(DP), intent(in ):: xy_SurfEmis (0:imax-1, 1:jmax)
!!$                              ! ɽ̼ͽΨ. 
!!$                              ! Surface emissivity
!!$    real(DP), intent(in ):: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! Optical depth
!!$    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! Ĺȥեå. 
!!$                              ! Longwave flux
!!$    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$                              ! ĹɽѲ. 
!!$                              ! Surface temperature tendency with longwave
!!$    real(DP), intent(in ), optional :: WNs
!!$    real(DP), intent(in ), optional :: WNe
!!$    integer , intent(in ), optional :: NumGaussNode
!!$    real(DP), intent(in ), optional :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
!!$                              ! Ʃ᷸. 
!!$                              ! Transmission coefficient
!!$
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: xyr_RadLDoFlux (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP):: xyr_RadLUpFlux (0:imax-1, 1:jmax, 0:kmax)
!!$
!!$    real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: xyrr_TransLV (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
!!$                              ! Ʃ᷸. 
!!$                              ! Transmission coefficient
!!$    real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated Planck function
!!$    real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
!!$                              ! Integrated Planck function with surface temperature
!!$    real(DP):: xyz_IntDPFDT     (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$    real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$                              ! with surface temperature
!!$
!!$    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. radiation_utils_inited ) call RadiationInit
!!$
!!$    ! Check arguments
!!$    !
!!$    if ( present( WNs ) ) then
!!$      if ( ( .not. present( WNe ) ) .or. ( .not. present( NumGaussNode ) ) ) then
!!$        call MessageNotify( 'E', module_name, &
!!$          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
!!$      end if
!!$    else
!!$      if ( present( WNe ) .or. present( NumGaussNode ) ) then
!!$        call MessageNotify( 'E', module_name, &
!!$          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
!!$      end if
!!$    end if
!!$
!!$    if ( present( WNs ) ) then
!!$      ! Case for non-grey atmosphere
!!$      !
!!$
!!$      ! Integrate Planck function and temperature derivative of it
!!$      !
!!$      call Integ_PF_GQ_Array3D( &
!!$        & WNs, WNe, NumGaussNode, &
!!$        & 0, imax-1, 1, jmax, 1, kmax, &
!!$        & xyz_Temp, &
!!$        & xyz_IntPF &
!!$        & )
!!$      call Integ_PF_GQ_Array2D( &
!!$        & WNs, WNe, NumGaussNode, &
!!$        & 0, imax-1, 1, jmax, &
!!$        & xy_SurfTemp, &
!!$        & xy_SurfIntPF &
!!$        & )
!!$      call Integ_DPFDT_GQ_Array3D( &
!!$        & 0, imax-1, 1, jmax, 1, kmax, &
!!$        & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
!!$        & xyz_IntDPFDT          & ! (out)
!!$        & )
!!$      call Integ_DPFDT_GQ_Array2D( &
!!$        & 0, imax-1, 1, jmax, &
!!$        & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
!!$        & xy_SurfIntDPFDT           & ! (out)
!!$        & )
!!$
!!$      xyz_IntPF       = PI * xyz_IntPF
!!$      xy_SurfIntPF    = PI * xy_SurfIntPF
!!$      xyz_IntDPFDT    = PI * xyz_IntDPFDT
!!$      xy_SurfIntDPFDT = PI * xy_SurfIntDPFDT
!!$
!!$    else
!!$
!!$      ! Case for grey atmosphere
!!$      !
!!$      xyz_IntPF       = StB * xyz_Temp**4
!!$      xy_SurfIntPF    = StB * xy_SurfTemp**4
!!$      xyz_IntDPFDT    = 4.0_DP * StB * xyz_Temp**3
!!$      xy_SurfIntDPFDT = 4.0_DP * StB * xy_SurfTemp**3
!!$
!!$    end if
!!$
!!$
!!$    if ( present( xyrr_Trans ) ) then
!!$      do k = 0, kmax
!!$        do kk = k, k
!!$          xyrr_TransLV(:,:,k,kk) = 1.0_DP
!!$        end do
!!$        do kk = k+1, kmax
!!$          xyrr_TransLV(:,:,k,kk) = xyrr_Trans(:,:,k,kk)
!!$        end do
!!$      end do
!!$    else
!!$      ! Ʃؿ׻
!!$      ! Calculate transmission functions
!!$      !
!!$      do k = 1, kmax
!!$        xyz_DelTrans(:,:,k) = &
!!$          & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
!!$      end do
!!$      !
!!$      do k = 0, kmax
!!$        do kk = k, k
!!$          xyrr_TransLV(:,:,k,kk) = 1.0_DP
!!$        end do
!!$        do kk = k+1, kmax
!!$          xyrr_TransLV(:,:,k,kk) = xyrr_TransLV(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
!!$        end do
!!$      end do
!!$    end if
!!$    do k = 0, kmax
!!$      do kk = 0, k-1
!!$        xyrr_TransLV(:,:,k,kk) = xyrr_TransLV(:,:,kk,k)
!!$      end do
!!$    end do
!!$
!!$
!!$    ! ͥեå׻
!!$    ! Calculate radiation flux
!!$    !
!!$!    do k = 0, kmax
!!$!
!!$!      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
!!$!
!!$!      do kk = 0, kmax-1
!!$!        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
!!$!          & - PI * xyz_IntPF(:,:,kk+1)                           &
!!$!          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
!!$!      end do
!!$!
!!$!    end do
!!$
!!$
!!$    !   Initialization
!!$    !
!!$    xyr_RadLDoFlux = 0.0_DP
!!$    xyr_RadLUpFlux = 0.0_DP
!!$    !
!!$    !   Downward flux
!!$    !
!!$    do k = kmax, 0, -1
!!$
!!$      do kk = kmax, k+1, -1
!!$        xyr_RadLDoFlux(:,:,k) = xyr_RadLDoFlux(:,:,k)          &
!!$          & + xyz_IntPF(:,:,kk)                                &
!!$          & * ( xyrr_TransLV(:,:,k,kk-1) - xyrr_TransLV(:,:,k,kk) )
!!$      end do
!!$
!!$    end do
!!$    !
!!$    !   Upward flux
!!$    !
!!$    !     Set upward flux
!!$    !
!!$    do k = 0, kmax
!!$
!!$      xyr_RadLUpFlux(:,:,k) = xy_SurfEmis * xy_SurfIntPF * xyrr_TransLV(:,:,k,0)
!!$
!!$      do kk = 1, k
!!$        xyr_RadLUpFlux(:,:,k) = xyr_RadLUpFlux(:,:,k)          &
!!$          & - xyz_IntPF(:,:,kk)                                &
!!$          & * ( xyrr_TransLV(:,:,k,kk-1) - xyrr_TransLV(:,:,k,kk) )
!!$      end do
!!$
!!$    end do
!!$
!!$    xyr_RadLFlux = xyr_RadLUpFlux - xyr_RadLDoFlux
!!$
!!$
!!$    ! ͥեåѲΨη׻
!!$    ! Calculate rate of change of radiative flux
!!$    !
!!$    do k = 0, kmax
!!$      xyra_DelRadLFlux(:,:,k,0) =                           &
!!$        & xy_SurfEmis * xy_SurfIntDPFDT * xyrr_TransLV(:,:,k,0)
!!$
!!$      xyra_DelRadLFlux(:,:,k,1) =                           &
!!$        & - xyz_IntDPFDT(:,:,1)                             &
!!$        &   * ( xyrr_TransLV(:,:,k,0) - xyrr_TransLV(:,:,k,1) )
!!$    end do
!!$
!!$
!!$  end subroutine RadiationRTEQNonScat

  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine RadiationRTEQNonScat(                    &
!!$    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
!!$    & xyr_RadLFlux, xyra_DelRadLFlux,                 & ! (out)
!!$    & WNs, WNe, NumGaussNode                          & ! (in ) optional
!!$    & )
!!$    !
!!$    ! ʤξãη׻
!!$    !
!!$    ! Integrate radiative transfer equation without scattering
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: &
!!$      & PI, &
!!$                              ! $ \pi $ .
!!$                              ! ߼Ψ.  Circular constant
!!$      & StB
!!$                              ! $ \sigma_{SB} $ .
!!$                              ! ƥեܥĥޥ.
!!$                              ! Stefan-Boltzmann constant
!!$
!!$
!!$    ! ץ󥯴ؿη׻
!!$    ! Calculate Planck function
!!$    !
!!$    use planck_func, only :                            &
!!$      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
!!$      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$
!!$    real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T $ .     . Temperature
!!$    real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
!!$                              ! ɽ̲. 
!!$                              ! Surface temperature
!!$    real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
!!$                              ! ɽ̼ͽΨ. 
!!$                              ! Surface emissivity
!!$    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
!!$                              ! Ʃ᷸. 
!!$                              ! Transmission coefficient
!!$    real(DP), intent(out) :: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! Ĺȥեå. 
!!$                              ! Longwave flux
!!$    real(DP), intent(out) :: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$                              ! ĹɽѲ. 
!!$                              ! Surface temperature tendency with longwave
!!$    real(DP), intent(in ), optional :: WNs
!!$    real(DP), intent(in ), optional :: WNe
!!$    integer , intent(in ), optional :: NumGaussNode
!!$
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: xyr_RadLDoFlux (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP):: xyr_RadLUpFlux (0:imax-1, 1:jmax, 0:kmax)
!!$
!!$    real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated Planck function
!!$    real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
!!$                              ! Integrated Planck function with surface temperature
!!$    real(DP):: xyz_IntDPFDT     (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$    real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$                              ! with surface temperature
!!$
!!$    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. radiation_utils_inited ) call RadiationInit
!!$
!!$    ! Check arguments
!!$    !
!!$    if ( present( WNs ) ) then
!!$      if ( ( .not. present( WNe ) ) .or. ( .not. present( NumGaussNode ) ) ) then
!!$        call MessageNotify( 'E', module_name, &
!!$          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
!!$      end if
!!$    else
!!$      if ( present( WNe ) .or. present( NumGaussNode ) ) then
!!$        call MessageNotify( 'E', module_name, &
!!$          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
!!$      end if
!!$    end if
!!$
!!$    if ( present( WNs ) ) then
!!$      ! Case for non-grey atmosphere
!!$      !
!!$
!!$      ! Integrate Planck function and temperature derivative of it
!!$      !
!!$      call Integ_PF_GQ_Array3D( &
!!$        & WNs, WNe, NumGaussNode, &
!!$        & 0, imax-1, 1, jmax, 1, kmax, &
!!$        & xyz_Temp, &
!!$        & xyz_IntPF &
!!$        & )
!!$      call Integ_PF_GQ_Array2D( &
!!$        & WNs, WNe, NumGaussNode, &
!!$        & 0, imax-1, 1, jmax, &
!!$        & xy_SurfTemp, &
!!$        & xy_SurfIntPF &
!!$        & )
!!$      call Integ_DPFDT_GQ_Array3D( &
!!$        & 0, imax-1, 1, jmax, 1, kmax, &
!!$        & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
!!$        & xyz_IntDPFDT          & ! (out)
!!$        & )
!!$      call Integ_DPFDT_GQ_Array2D( &
!!$        & 0, imax-1, 1, jmax, &
!!$        & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
!!$        & xy_SurfIntDPFDT           & ! (out)
!!$        & )
!!$
!!$      xyz_IntPF       = PI * xyz_IntPF
!!$      xy_SurfIntPF    = PI * xy_SurfIntPF
!!$      xyz_IntDPFDT    = PI * xyz_IntDPFDT
!!$      xy_SurfIntDPFDT = PI * xy_SurfIntDPFDT
!!$
!!$    else
!!$
!!$      ! Case for grey atmosphere
!!$      !
!!$      xyz_IntPF       = StB * xyz_Temp**4
!!$      xy_SurfIntPF    = StB * xy_SurfTemp**4
!!$      xyz_IntDPFDT    = 4.0_DP * StB * xyz_Temp**3
!!$      xy_SurfIntDPFDT = 4.0_DP * StB * xy_SurfTemp**3
!!$
!!$    end if
!!$
!!$
!!$
!!$    ! ͥեå׻
!!$    ! Calculate radiation flux
!!$    !
!!$!    do k = 0, kmax
!!$!
!!$!      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
!!$!
!!$!      do kk = 0, kmax-1
!!$!        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
!!$!          & - PI * xyz_IntPF(:,:,kk+1)                           &
!!$!          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
!!$!      end do
!!$!
!!$!    end do
!!$
!!$
!!$    !   Initialization
!!$    !
!!$    xyr_RadLDoFlux = 0.0_DP
!!$    xyr_RadLUpFlux = 0.0_DP
!!$    !
!!$    !   Downward flux
!!$    !
!!$    do k = kmax, 0, -1
!!$
!!$      do kk = kmax, k+1, -1
!!$        xyr_RadLDoFlux(:,:,k) = xyr_RadLDoFlux(:,:,k)          &
!!$          & + xyz_IntPF(:,:,kk)                                &
!!$          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
!!$      end do
!!$
!!$    end do
!!$    !
!!$    !   Upward flux
!!$    !
!!$    !     Set upward flux
!!$    !
!!$    do k = 0, kmax
!!$
!!$      xyr_RadLUpFlux(:,:,k) = xy_SurfEmis * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
!!$
!!$      do kk = 1, k
!!$        xyr_RadLUpFlux(:,:,k) = xyr_RadLUpFlux(:,:,k)          &
!!$          & - xyz_IntPF(:,:,kk)                                &
!!$          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
!!$      end do
!!$
!!$    end do
!!$
!!$    xyr_RadLFlux = xyr_RadLUpFlux - xyr_RadLDoFlux
!!$
!!$
!!$    ! ͥեåѲΨη׻
!!$    ! Calculate rate of change of radiative flux
!!$    !
!!$    do k = 0, kmax
!!$      xyra_DelRadLFlux(:,:,k,0) =                           &
!!$        & xy_SurfEmis * xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
!!$
!!$      xyra_DelRadLFlux(:,:,k,1) =                           &
!!$        & - xyz_IntDPFDT(:,:,1)                             &
!!$        &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
!!$    end do
!!$
!!$
!!$  end subroutine RadiationRTEQNonScat
!!$
  !--------------------------------------------------------------------------------------

  subroutine RadiationRTEQNonScat(                            &
    & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT, & ! (in)
    & xyrr_Trans,                                             & ! (in)
    & xyr_RadLFlux, xyra_DelRadLFlux                          & ! (out)
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
    real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(out) :: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave


    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_RadLDoFlux (0:imax-1, 1:jmax, 0:kmax)
    real(DP):: xyr_RadLUpFlux (0:imax-1, 1:jmax, 0:kmax)

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. radiation_utils_inited ) call RadiationInit



    ! ͥեå׻
    ! Calculate radiation flux
    !
!!$    do k = 0, kmax
!!$
!!$      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
!!$
!!$      do kk = 0, kmax-1
!!$        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
!!$          & - PI * xyz_IntPF(:,:,kk+1)                           &
!!$          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
!!$      end do
!!$
!!$    end do


    !   Initialization
    !
    xyr_RadLDoFlux = 0.0_DP
    xyr_RadLUpFlux = 0.0_DP
    !
    !   Downward flux
    !
    do k = kmax, 0, -1

      do kk = kmax, k+1, -1
        xyr_RadLDoFlux(:,:,k) = xyr_RadLDoFlux(:,:,k)          &
          & + xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do
    !
    !   Upward flux
    !
    !     Set upward flux
    !
    do k = 0, kmax

      xyr_RadLUpFlux(:,:,k) = xy_SurfIntPF * xyrr_Trans(:,:,k,0)

      do kk = 1, k
        xyr_RadLUpFlux(:,:,k) = xyr_RadLUpFlux(:,:,k)          &
          & - xyz_IntPF(:,:,kk)                                &
          & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
      end do

    end do

    xyr_RadLFlux = xyr_RadLUpFlux - xyr_RadLDoFlux


    ! ͥեåѲΨη׻
    ! Calculate rate of change of radiative flux
    !
    do k = 0, kmax
      xyra_DelRadLFlux(:,:,k,0) =                           &
        & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)

      xyra_DelRadLFlux(:,:,k,1) =                           &
        & - xy_IntDPFDT1(:,:)                               &
        &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
    end do


  end subroutine RadiationRTEQNonScat

  !--------------------------------------------------------------------------------------

  subroutine RadiationRTEQNonScatWrapper(             &
    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
    & xyr_RadLFlux, xyra_DelRadLFlux,                 & ! (out)
    & WNs, WNe, NumGaussNode                          & ! (in ) optional
    & )
    !
    ! ʤξãη׻
    !
    ! Integrate radiative transfer equation without scattering
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & PI, &
                              ! $ \pi $ .
                              ! ߼Ψ.  Circular constant
      & StB
                              ! $ \sigma_{SB} $ .
                              ! ƥեܥĥޥ.
                              ! Stefan-Boltzmann constant


    ! ץ󥯴ؿη׻
    ! Calculate Planck function
    !
    use planck_func, only :                            &
      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
                              ! ɽ̼ͽΨ. 
                              ! Surface emissivity
    real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP), intent(out) :: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(out) :: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP), intent(in ), optional :: WNs
    real(DP), intent(in ), optional :: WNe
    integer , intent(in ), optional :: NumGaussNode


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated Planck function
    real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
                              ! Integrated Planck function with surface temperature
    real(DP):: xyz_IntDPFDT     (0:imax-1, 1:jmax, 1:kmax)
                              ! Integrated temperature derivative of Planck function
    real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
                              ! Integrated temperature derivative of Planck function
                              ! with surface temperature


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. radiation_utils_inited ) call RadiationInit


    ! Check arguments
    !
    if ( present( WNs ) .or. present( WNe ) .or. present( NumGaussNode ) ) then
      if ( .not. ( present( WNs ) .and. present( WNe ) .and. present( NumGaussNode ) ) ) then
        call MessageNotify( 'E', module_name, &
          & 'All of WNs, WNe, and NumGaussNode have to be present.' )
      end if
    end if


    if ( present( WNs ) ) then
      ! Case for non-grey atmosphere
      !

      ! Integrate Planck function and temperature derivative of it
      !
      call Integ_PF_GQ_Array3D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, 1, kmax, &
        & xyz_Temp, &
        & xyz_IntPF &
        & )
      call Integ_PF_GQ_Array2D( &
        & WNs, WNe, NumGaussNode, &
        & 0, imax-1, 1, jmax, &
        & xy_SurfTemp, &
        & xy_SurfIntPF &
        & )
      call Integ_DPFDT_GQ_Array3D( &
        & 0, imax-1, 1, jmax, 1, kmax, &
        & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
        & xyz_IntDPFDT          & ! (out)
        & )
      call Integ_DPFDT_GQ_Array2D( &
        & 0, imax-1, 1, jmax, &
        & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
        & xy_SurfIntDPFDT           & ! (out)
        & )

      xyz_IntPF       = PI * xyz_IntPF
      xy_SurfIntPF    = PI * xy_SurfIntPF
      xyz_IntDPFDT    = PI * xyz_IntDPFDT
      xy_SurfIntDPFDT = PI * xy_SurfIntDPFDT

    else

      ! Case for grey atmosphere
      !
      xyz_IntPF       =                        StB * xyz_Temp**4
      xy_SurfIntPF    = xy_SurfEmis          * StB * xy_SurfTemp**4
      xyz_IntDPFDT    =               4.0_DP * StB * xyz_Temp**3
      xy_SurfIntDPFDT = xy_SurfEmis * 4.0_DP * StB * xy_SurfTemp**3

    end if


    call RadiationRTEQNonScat(                                  &
      & xyz_IntPF, xy_SurfIntPF, xyz_IntDPFDT(:,:,1), xy_SurfIntDPFDT, & ! (in)
      & xyrr_Trans,                                             & ! (in)
      & xyr_RadLFlux, xyra_DelRadLFlux                          & ! (out)
      & )


  end subroutine RadiationRTEQNonScatWrapper

  !--------------------------------------------------------------------------------------

  subroutine RadiationDTempDt( &
    & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
    & xyz_DTempDtRadL, xyz_DTempDtRadS &       ! (out)
    & )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    ! 
    ! Temperature tendency with radiation is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav, &  ! $ g $ [m s-2]. 
                                  ! ϲ®. 
                                  ! Gravitational acceleration
      &                  CpDry    ! $ C_p $ [J kg-1 K-1]. 
                                  ! 絤갵Ǯ. 
                                  ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. radiation_utils_inited ) call RadiationInit

    ! Ψα黻
    ! Calculate radiation cooling rate
    !
    do k = 1, kmax
      xyz_DTempDtRadL(:,:,k) = &
        & (     xyr_RadLFlux(:,:,k-1) - xyr_RadLFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav

      xyz_DTempDtRadS(:,:,k) = &
        & (     xyr_RadSFlux(:,:,k-1) - xyr_RadSFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
    call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadiationDTempDt

  !-------------------------------------------------------------------

  subroutine RadiationFluxOutput(                    &
    & xyr_RadSFlux, xyr_RadLFlux,                    & ! (in)
    & xyra_DelRadLFlux, xy_DSurfTempDt, xyz_DTempDt  & ! (in)
    & )
    !
    ! ͥեå (xyr_RadSFlux, xyr_RadLFlux) 
    ! ˤĤ, ¾ΰѤ, ϤԤ. 
    !
    ! Radiation fluxes (xyr_RadSFlux, xyr_RadLFlux) are
    ! corrected by using other arguments, and the corrected values are output.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP), intent(in):: xy_DSurfTempDt  (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(in):: xyz_DTempDt     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ (K s-1)
                              ! Temperature tendency (K s-1)

    ! ϤΤκѿ
    ! Work variables for output
    !
    real(DP):: xyr_RadLFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! 줿Ĺȥեå. 
                              ! Corrected longwave flux

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. radiation_utils_inited ) call RadiationInit

    ! Ĺȥեå ( ɽեåʬ )
    ! Correct longwave flux ( amount of surface flux )
    !
    ! Lines commented out below will be deleted soon (yot, 2010/10/31).
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor (:,:,k) = &
!!$        &     xyr_RadLFlux (:,:,k) &
!!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * DelTime
!!$    end do
    do k = 0, kmax
      xyr_RadLFluxCor(:,:,k) = &
        &   xyr_RadLFlux(:,:,k) &
        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &   * DelTime
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLR' , xyr_RadLFluxCor(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLR' , xyr_RadLFluxCor(:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSR' , xyr_RadSFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSR' , xyr_RadSFlux   (:,:,0)    )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLRB', xyr_RadLFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLRB', xyr_RadLFlux   (:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSRB', xyr_RadSFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSRB', xyr_RadSFlux   (:,:,0)    )


    ! Ĺȥեå ( ɽեåʬ )
    ! Correct longwave flux ( amount of surface flux )
    !
    ! Lines commented out below will be deleted soon (yot, 2010/10/31).
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor (:,:,k) = &
!!$        &     xyr_RadLFlux (:,:,k) &
!!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * 2.0d0 * DelTime
!!$    end do
    do k = 0, kmax
      xyr_RadLFluxCor(:,:,k) = &
        &   xyr_RadLFlux(:,:,k) &
        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &   * 2.0_DP * DelTime
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLRA', xyr_RadLFluxCor(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLRA', xyr_RadLFluxCor(:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSRA', xyr_RadSFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSRA', xyr_RadSFlux   (:,:,0)    )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadiationFluxOutput

  !-------------------------------------------------------------------

  subroutine RadiationInit
    !
    ! radiation_utils ⥸塼νԤޤ. 
    ! NAMELIST#radiation_utils_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "radiation_utils" module is initialized. 
    ! "NAMELIST#radiation_utils_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /radiation_utils_nml/ &
      & DiffFact
!!$      & DelTimeLongValue, DelTimeLongUnit, &
!!$      & DelTimeShortValue, DelTimeShortUnit, &
!!$!
!!$      & LongBandNum, &
!!$      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
!!$      & LongBandWeight, LongPathLengthFact, &
!!$!
!!$      & ShortBandNum, &
!!$      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
!!$      & ShortBandWeight, ShortSecScat, &
!!$      & ShortAtmosAlbedo, &
!!$!
!!$      & RstInputFile, RstOutputFile
          !
          ! ǥեͤˤĤƤϽ³ "radiation_utils#RadiationInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_utils#RadiationInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( radiation_utils_inited ) return

    ! ǥեͤ
    ! Default values settings
    !
    DiffFact = 1.66_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = radiation_utils_nml,       & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'OLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OLRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SLRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OSRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SSRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OLRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SLRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OSRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SSRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'DTempDtRadL', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'long wave radiative heating rate', 'K s-1' )

    call HistoryAutoAddVariable( 'DTempDtRadS', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'short wave radiative heating rate', 'K s-1' )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'DiffFact = %f', d = (/ DiffFact /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    radiation_utils_inited = .true.

  end subroutine RadiationInit

  !-------------------------------------------------------------------

end module radiation_utils
