!= ϲǮƳǥѤαˡˤʬ
!
!= Time integration by using implicit scheme in case using subsurface thermal diffusion model
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: phy_implicit_sdh.f90,v 1.3 2010-09-28 22:44:23 yot Exp $
! Tag Name::  $Name: dcpam5-20110225-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_implicit_sdh
  !
  != ϲǮƳǥѤαˡˤʬ
  !
  != Time integration by using implicit scheme in case using subsurface thermal diffusion model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplTendency      :: ѲΨη׻
  ! PhyImplEvalRadLFluxA :: Ĺȥեå
  ! ------------         :: ------------
  ! PhyImplTendency      :: Calculate tendency
  ! PhyImplEvalRadLFluxA :: Longwave flux correction
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:   imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
    &                  jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
    &                  kmax, & ! ľؿ. 
                               ! Number of vertical level
    &                  kslmax  ! ϲαľؿ. 
                               ! Number of subsurface vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: ncmax, IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: PhyImplSDHTendency


  ! ѿ
  ! Public variables
  !
  logical, save, public:: phy_implicit_sdh_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'phy_implicit_sdh'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110225-4 $' // &
    & '$Id: phy_implicit_sdh.f90,v 1.3 2010-09-28 22:44:23 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  real(DP), save:: SOHeatCapacity
                              ! Slab ocean heat capacity (J m-2 K-1)


contains

  subroutine PhyImplSDHTendency(                               &
    & FlagPhyImpSoilModelSO,                                   & ! (in)
    & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
    & xyr_SoilHeatFlux,                                        & ! (in)
    & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
    & xy_DeepSubSurfHeatFlux,                                  & ! (in)
    & xy_SurfTemp, xyz_SoilTemp,                               & ! (in)
    & xy_SurfHumidCoef, xy_SurfCond,                           & ! (in)
    & xy_SurfHeatCapacity,                                     & ! (in)
    & xy_SoilHeatCap, xy_SoilHeatDiffCoef,                     & ! (in)
    & xy_SeaIceConc,                                           & ! (in)
    & xyra_DelRadLFlux,                                        & ! (in)
    & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
    & xyr_VelTransCoef, xyr_TempTransCoef,                     & ! (in)
    & xyr_QMixTransCoef,                                       & ! (in)
    & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
    & xy_SurfQVapTransCoef,                                    & ! (in)
    & xyr_SoilTempTransCoef,                                   & ! (in)
    & xy_SurfSnowB,                                            & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (out)
    & xy_DSurfTempDt,                                          & ! (out)
    & xyz_DSoilTempDt,                                         & ! (out)
    & xy_DSoilMoistDt,                                         & ! (out)
    & xy_DSurfSnowDt                                           & ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_SSDepth,   &    ! subsurface grid on interface of layer
      & z_SSDepth         ! subsurface grid at midpoint of layer

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & GasRDry
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & TempCondWater,       &
      & SeaIceVolHeatCap   , &
      & SeaIceThermCondCoef, &
      & SeaIceThreshold,    &
      & SeaIceThickness,    &
      & TempBelowSeaIce

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! Хĥǥ
    ! bucket model
    !
    use Bucket_Model, only: FlagBucketModel, FlagBucketModelSnow

    ! ˡˤʬΤΥ롼
    ! Routines for time integration with implicit scheme
    !
    use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3

    ! ʸ ; Declaration statements
    !
    implicit none

    logical , intent(in):: FlagPhyImpSoilModelSO
                              ! flag for use of slab ocean
    real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Eastward momentum flux
    real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Northward momentum flux
    real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    real(DP), intent(in):: xyr_SoilHeatFlux (0:imax-1, 1:jmax, 0:kslmax)
                              ! ھǮեå (W m-2)
                              ! Heat flux in sub-surface soil (W m-2)

    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux

    real(DP), intent(in):: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! "Deep subsurface heat flux"
                              ! Heat flux at the bottom of surface/soil layer.
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
                              ! ھ (K)
                              ! Soil temperature (K)
    real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(in ):: xy_SoilHeatCap (0:imax-1, 1:jmax)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
    real(DP), intent(in ):: xy_SoilHeatDiffCoef (0:imax-1, 1:jmax)
                              ! ھǮƳ (J m-3 K-1)
                              ! Heat conduction coefficient of soil (J m-3 K-1)
    real(DP), intent(in):: xy_SeaIceConc(0:imax-1,1:jmax)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)

    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    real(DP), intent(in):: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP), intent(in):: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: mass of constituents

    real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

    real(DP), intent(in):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature

    real(DP), intent(in):: xy_SurfSnowB (0:imax-1, 1:jmax)
                              ! .
                              ! Surface snow amount.

    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ . ̺Ѳ. 
                              ! Mass mixing ratio tendency
    real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ (K s-1)
                              ! Surface temperature tendency (K s-1)
    real(DP), intent(out):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
                              ! $ \DP{Tg}{t} $ . ھѲ (K s-1)
                              ! Temperature tendency (K s-1)

    real(DP), intent(out):: xy_DSoilMoistDt (0:imax-1, 1:jmax)
                              ! ھٻѲΨ (kg m-2 s-1)
                              ! Soil temperature tendency (kg m-2 s-1)
    real(DP), intent(out):: xy_DSurfSnowDt (0:imax-1, 1:jmax)
                              ! ΨѲΨ (kg m-2 s-1)
                              ! Surface snow amount tendency (kg m-2 s-1)

    ! ѿ
    ! Work variables
    !
    real(DP):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP):: xyra_TempMtx(0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP):: xyza_QMixMtx(0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ̺汢. 
                              ! Implicit matrix about mass mixing ratio
    real(DP):: xyaa_SurfMtx(0:imax-1, 1:jmax, 0:0, -1:1)
                              ! ɽ̥ͥ륮ѱ
                              ! Implicit matrix for surface energy balance

    real(DP):: xy_SurfRH(0:imax-1,1:jmax)

    real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
                              ! LU . 
                              ! LU matrix

!!$    real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
!!$                              ! LU . 
!!$                              ! LU matrix
!!$    real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
!!$                              ! $ T q $ λѲ. 
!!$                              ! Tendency of $ T q $ 
!!$
!!$    real(DP):: xyza_TempLUMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
!!$                              ! LU .
!!$                              ! LU matrix
!!$    real(DP):: xyz_DelTempLUVec (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! $ T q $ λѲ.
!!$                              ! Tendency of $ T q $
    real(DP):: xyza_QMixLUMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! LU .
                              ! LU matrix
    real(DP):: xyz_DelQMixLUVec (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ λѲ.
                              ! Tendency of $ q $

!!$    real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
!!$                              ! ɽ˰漾. 
!!$                              ! Saturated specific humidity on surface
!!$    real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
!!$                              ! ɽ˰漾Ѳ. 
!!$                              ! Saturated specific humidity tendency on surface

    real(DP):: xyaa_SoilTempMtx (0:imax-1, 1:jmax, 1:kslmax,-1:1)
                              ! ھٳȻι
                              ! Matrix for diffusion equation of soil temperature
    real(DP):: xyaa_TempSoilTempLUMtx (0:imax-1, 1:jmax, -kslmax:kmax, -1:1)
                              ! LU .
                              ! LU matrix
    real(DP):: xya_DelTempSoilTempLUVec (0:imax-1, 1:jmax, -kslmax:kmax)
                              ! $ T, Tg $ λѲ.
                              ! Tendency of $ T $ and $ Tg |

    real(DP):: SurfSnowATentative
                              ! ̤β (kg m-2)
                              ! pseudo value of surface snow amount (kg m-2)


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: l               !  DO 롼Ѻѿ
                              ! Work variables for DO loop of matrices
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_sdh_inited ) call PhyImplInit


!!$    if ( .not. FlagSSModel ) then
!!$      call MessageNotify( 'E', module_name, 'FlagSSModel has to be true.' )
!!$    end if

    ! FlagBucketModel ϴطʤ?
    ! SSModel ˤ, ̤ʬΥ. 
!!$    if ( .not. FlagBucketModel ) then
!!$      call MessageNotify( 'E', module_name, 'FlagBucketModel has to be true.' )
!!$    end if



    ! ˡΤι
    ! Create matrices for implicit scheme
    !

    ! ľȻ͢鱢η׻ (®)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
    !
    k = 1
    xyza_UVMtx  (:,:,k,-1) = 0.0d0
    xyza_UVMtx  (:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xy_SurfVelTransCoef(:,:)                                            &
      & + xyr_VelTransCoef(:,:,k  )
    xyza_UVMtx  (:,:,k, 1) = &
      & - xyr_VelTransCoef(:,:,k)

    do k = 2, kmax-1
      xyza_UVMtx  (:,:,k,-1) = &
        & - xyr_VelTransCoef(:,:,k-1)
      xyza_UVMtx  (:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xyr_VelTransCoef(:,:,k-1)                                           &
        & + xyr_VelTransCoef(:,:,k  )
      xyza_UVMtx  (:,:,k, 1) = &
        & - xyr_VelTransCoef(:,:,k)
    end do

    k = kmax
    xyza_UVMtx  (:,:,k,-1) = &
      & - xyr_VelTransCoef(:,:,k-1)
    xyza_UVMtx  (:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_VelTransCoef(:,:,k-1)
    xyza_UVMtx  (:,:,k, 1) = 0.0d0


    ! ľȻ͢鱢η׻ ()
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
    !
    k = 1
    xyra_TempMtx(:,:,k,-1) = &
      & - CpDry * xy_SurfTempTransCoef(:,:)
    xyra_TempMtx(:,:,k, 0) =                                                          &
      & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
      & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
    xyra_TempMtx(:,:,k, 1) = &
      & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )

    do k = 2, kmax-1
      xyra_TempMtx(:,:,k,-1) = &
        & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
      xyra_TempMtx(:,:,k, 0) =                                                          &
        & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
        & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
      xyra_TempMtx(:,:,k, 1) = &
        & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
    end do

    k = kmax
    xyra_TempMtx(:,:,k,-1) = &
      & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
    xyra_TempMtx(:,:,k, 0) =                                                          &
      & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
    xyra_TempMtx(:,:,k, 1) = 0.0d0




    ! ľȻ͢鱢η׻ (漾)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
    !

    k = 1
    xyza_QMixMtx(:,:,k,-1) =                                                  &
      & 0.0d0
    xyza_QMixMtx(:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_QMixTransCoef(:,:,k  )
    xyza_QMixMtx(:,:,k, 1) =                                                  &
      & - xyr_QMixTransCoef(:,:,k  )

    do k = 2, kmax-1
      xyza_QMixMtx(:,:,k,-1) =                                                  &
        & - xyr_QMixTransCoef(:,:,k-1)
      xyza_QMixMtx(:,:,k, 0) =                                                  &
        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
        & + xyr_QMixTransCoef(:,:,k-1)                                          &
        & + xyr_QMixTransCoef(:,:,k  )
      xyza_QMixMtx(:,:,k, 1) =                                                  &
        & - xyr_QMixTransCoef(:,:,k  )
    end do

    k = kmax
    xyza_QMixMtx(:,:,k,-1) =                                                  &
      & - xyr_QMixTransCoef(:,:,k-1)
    xyza_QMixMtx(:,:,k, 0) =                                                  &
      & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2. * DelTime ) &
      & + xyr_QMixTransCoef(:,:,k-1)
    xyza_QMixMtx(:,:,k, 1) = 0.0d0



    ! ھٷ׻Ѥ͢鱢η׻ (ھ)
    ! Calculate implicit matrices by using transfer coefficient (soil temperature)
    !
    if ( kslmax /= 0 ) then ! xyr_SoilTempMtx is not used when kslmax = 0.

      do k = 1, kslmax-1
        xyaa_SoilTempMtx(:,:,k,-1) =                                                  &
          & - xyr_SoilTempTransCoef(:,:,k-1)
        xyaa_SoilTempMtx(:,:,k, 0) =                                                  &
          &   xy_SoilHeatCap(:,:) * ( r_SSDepth(k) - r_SSDepth(k-1) )                 &
          &     / ( 2. * DelTime )&
          & + xyr_SoilTempTransCoef(:,:,k-1)                                          &
          & + xyr_SoilTempTransCoef(:,:,k  )
        xyaa_SoilTempMtx(:,:,k, 1) =                                                  &
          & - xyr_SoilTempTransCoef(:,:,k  )
      end do

      k = kslmax
      xyaa_SoilTempMtx(:,:,k,-1) =                                   &
        & - xyr_SoilTempTransCoef(:,:,k-1)
      xyaa_SoilTempMtx(:,:,k, 0) =                                   &
        &   xy_SoilheatCap(:,:) * ( r_SSDepth(k) - r_SSDepth(k-1) )  &
        &     / ( 2. * DelTime )                                     &
        & + xyr_SoilTempTransCoef(:,:,k-1)
      xyaa_SoilTempMtx(:,:,k, 1) = 0.0d0

    end if


    ! ɽ̲͢鱢η׻
    ! Calculate implicit matrices from transfer coefficient of surface process
    !
    do i = 0, imax-1
      do j = 1, jmax
        if ( xy_SurfCond(i,j) >= 1 ) then
          ! land
          xyaa_SurfMtx(i,j,0,-1) =                                             &
            &   xyr_SoilTempTransCoef(i,j,0)
          xyaa_SurfMtx(i,j,0, 0) =                                             &
            &   xy_SurfHeatCapacity(i,j) / ( 2. * DelTime )                    &
            & + CpDry * xy_SurfTempTransCoef(i,j)                              &
            & + xyra_DelRadLFlux(i,j,0,0)                                      &
            & - xyr_SoilTempTransCoef(i,j,0)
          xyaa_SurfMtx(i,j,0, 1) =                                             &
            & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
            &   * xy_SurfTempTransCoef(i,j)                                    &
            & + xyra_DelRadLFlux(i,j,0,1)
        else
          ! ocean
          if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            ! sea ice
            xyaa_SurfMtx(i,j,0,-1) = 0.0d0
            xyaa_SurfMtx(i,j,0, 0) =                                &
              &   SeaIceVolHeatCap / ( 2.0d0 * DelTime )            &
              & + CpDry * xy_SurfTempTransCoef(i,j)                 &
              & + xyra_DelRadLFlux(i,j,0,0)                         &
              & + SeaIceThermCondCoef / SeaIceThickness
            xyaa_SurfMtx(i,j,0, 1) = &
              & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
              &   * xy_SurfTempTransCoef(i,j)                                    &
              & + xyra_DelRadLFlux(i,j,0,1)
          else if ( FlagPhyImpSoilModelSO ) then
            ! mixed layer ocean
            xyaa_SurfMtx(i,j,0,-1) =                                             &
              & 0.0d0
            xyaa_SurfMtx(i,j,0, 0) =                                             &
              &   SOHeatCapacity / ( 2. * DelTime )                              &
              & + CpDry * xy_SurfTempTransCoef(i,j)                              &
              & + xyra_DelRadLFlux(i,j,0,0)
            xyaa_SurfMtx(i,j,0, 1) =                                             &
              & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
              &   * xy_SurfTempTransCoef(i,j)                                    &
              & + xyra_DelRadLFlux(i,j,0,1)
          else
            ! open ocean
            xyaa_SurfMtx(i,j,0,-1) = 0.0d0
            xyaa_SurfMtx(i,j,0, 0) = 1.0d0
            xyaa_SurfMtx(i,j,0, 1) = 0.0d0
          end if

        end if
      end do
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          ! land
          xy_SurfRH(i,j) =                                    &
            & - xyr_RadSFlux(i,j,0)                           &
            & - xyr_RadLFlux(i,j,0)                           &
            & - xyr_HeatFlux(i,j,0)                           &
            & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap) &
!            & + xy_DeepSubSurfHeatFlux(i,j)
            & + xyr_SoilHeatFlux(i,j,0)
        else
          ! ocean
          if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            ! sea ice
            xy_SurfRH(i,j) =                                      &
              & - xyr_RadSFlux(i,j,0)                             &
              & - xyr_RadLFlux(i,j,0)                             &
              & - xyr_HeatFlux(i,j,0)                             &
              & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap)   &
!              & + xy_DeepSubSurfHeatFlux(i,j)
!              & + xyr_SoilHeatFlux(i,j,0)
              & - SeaIceThermCondCoef                             &
              &   * ( xy_SurfTemp(i,j) - TempBelowSeaIce ) / SeaIceThickness
          else if ( FlagPhyImpSoilModelSO ) then
            ! mixed layer ocean
            xy_SurfRH(i,j) =                                       &
              & - xyr_RadSFlux(i,j,0)                              &
              & - xyr_RadLFlux(i,j,0)                              &
              & - xyr_HeatFlux(i,j,0)                              &
              & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap) !&
!!$              & + xy_DeepSubSurfHeatFlux(i,j)
          else
            ! open ocean
            xy_SurfRH(i,j) = 0.0d0
          end if
        end if
      end do
    end do



    ! ®, ®η׻
    ! Calculate eastward and northward wind
    !
    xyza_UVLUMtx = xyza_UVMtx

    call PhyImplLUDecomp3( &
      & xyza_UVLUMtx, &     ! (inout)
      & imax * jmax, kmax ) ! (in)

    do k = 1, kmax
      xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
      xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
    end do

    call PhyImplLUSolve3( &
      & xyz_DUDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)

    call PhyImplLUSolve3( &
      & xyz_DVDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)

    do k = 1, kmax
      xyz_DUDt(:,:,k) = xyz_DUDt(:,:,k) / ( 2. * DelTime )
      xyz_DVDt(:,:,k) = xyz_DVDt(:,:,k) / ( 2. * DelTime )
    end do


    ! ٤漾η׻
    ! Calculate temperature and specific humidity
    !

    do l = -1, 1
      do k = 1, kslmax
        xyaa_TempSoilTempLUMtx(:,:,-k,-l) = xyaa_SoilTempMtx(:,:,k,l)
      end do
      k = 0
      xyaa_TempSoilTempLUMtx(:,:, k, l) = xyaa_SurfMtx(:,:,0,l)
      do k = 1, kmax
        xyaa_TempSoilTempLUMtx(:,:, k, l) = xyra_TempMtx(:,:,k,l)
      end do
    end do

    call PhyImplLUDecomp3(              &
      & xyaa_TempSoilTempLUMtx,         & ! (inout)
      & imax * jmax, kmax + 1 + kslmax  & ! (in)
      )

    do k = 1, kslmax
      xya_DelTempSoilTempLUVec(:,:,-k) = &
        - ( xyr_SoilHeatFlux(:,:,k) - xyr_SoilHeatFlux(:,:,k-1) )
    end do
    k = 0
    xya_DelTempSoilTempLUVec(:,:,0) = xy_SurfRH(:,:)
    do k = 1, kmax
      xya_DelTempSoilTempLUVec(:,:,k) = &
        - ( xyr_HeatFlux(:,:,k) - xyr_HeatFlux(:,:,k-1) )
    end do

    call PhyImplLUSolve3(                   &
      & xya_DelTempSoilTempLUVec,           & ! (inout)
      & xyaa_TempSoilTempLUMtx,             & ! (in)
      & 1, imax * jmax , kmax + 1 + kslmax  & ! (in)
      )

    do k = 1, kslmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_SurfCond(i,j) >= 1 ) then
            xyz_DSoilTempDt(i,j,k) = &
              & xya_DelTempSoilTempLUVec(i,j,-k) / ( 2. * DelTime )
          else
            xyz_DSoilTempDt(i,j,k) = 0.0d0
          end if
        end do
      end do
    end do
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          ! land
          xy_DSurfTempDt(i,j) = xya_DelTempSoilTempLUVec(i,j,0) / ( 2. * DelTime )
        else
          ! ocean
          if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            ! sea ice
            xy_DSurfTempDt(i,j) = xya_DelTempSoilTempLUVec(i,j,0) / ( 2. * DelTime )
          else if ( FlagPhyImpSoilModelSO ) then
            ! mixed layer ocean
            xy_DSurfTempDt(i,j) = xya_DelTempSoilTempLUVec(i,j,0) / ( 2. * DelTime )
          else
            ! open ocean
            xy_DSurfTempDt(i,j) = 0.
          end if
        end if
      end do
    end do
    do k = 1, kmax
      xyz_DTempDt(:,:,k) = xya_DelTempSoilTempLUVec(:,:,k) / ( 2. * DelTime )
    end do


    !
    ! Calculation of tendencies of soil moisture and surface snow amount
    !
    if ( FlagBucketModel ) then
      if ( FlagBucketModelSnow ) then
        ! Evaporation is subtracted from surface snow and soil moisture
        !
        xy_DSurfSnowDt = - xyrf_QMixFlux(:,:,0,IndexH2OVap)
        do j = 1, jmax
          do i = 0, imax-1
            SurfSnowATentative = xy_SurfSnowB(i,j) &
              & + xy_DSurfSnowDt(i,j) * 2.0d0 * DelTime
            if ( SurfSnowATentative < 0.0d0 ) then
              xy_DSoilMoistDt(i,j) = SurfSnowATentative / ( 2.0d0 * DelTime )
              xy_DSurfSnowDt (i,j) = - xy_SurfSnowB(i,j) / ( 2.0d0 * DelTime )
            else
              xy_DSoilMoistDt(i,j) = 0.0d0
            end if
          end do
        end do
      else
        ! Evaporation is subtracted from soil moisture
        !
        xy_DSoilMoistDt = - xyrf_QMixFlux(:,:,0,IndexH2OVap)
        xy_DSurfSnowDt  = 0.0d0
      end if
    else
      xy_DSoilMoistDt = 0.0d0
      xy_DSurfSnowDt  = 0.0d0
    end if


    call PhyImplSDHSnowMeltCorrection(                  &
      & xyr_HeatFlux, xyrf_QMixFlux(:,:,:,IndexH2OVap), & ! (in)
      & xyr_SoilHeatFlux,                               & ! (in)
      & xyr_SoilTempTransCoef,                          & ! (in)
      & xyr_RadSFlux, xyr_RadLFlux,                     & ! (in)
      & xy_DeepSubSurfHeatFlux,                              & ! (in)
      & xy_SurfTemp, xyz_SoilTemp,                      & ! (in)
      & xy_SurfSnowB,                                   & ! (in)
      & xy_SurfCond,                                    & ! (in)
      & xy_SurfHeatCapacity,                            & ! (in)
      & xy_SoilHeatCap, xy_SoilHeatDiffCoef,           & ! (in)
      & xyra_DelRadLFlux,                               & ! (in)
      & xyz_Exner, xyr_Exner,                           & ! (in)
      & xy_SurfTempTransCoef,                           & ! (in)
      & xyz_DTempDt,                                    & ! (in)
      & xy_DSurfTempDt,                                 & ! (inout)
      & xyz_DSoilTempDt,                                & ! (inout)
      & xy_DSoilMoistDt, xy_DSurfSnowDt                 & ! (inout)
      & )

    call PhyImplSDHSeaIceCorrection( &
      & xy_SurfCond,                       & ! (in)
      & xy_SeaIceConc,                     & ! (in)
      & xy_SurfTemp,                       & ! (in)
      & xy_DSurfTempDt                     & ! (inout)
      & )


    do l = -1, 1
      do k = 1, kmax
        xyza_QMixLUMtx(:,:,k,l) = xyza_QMixMtx(:,:,k,l)
      end do
    end do

    call PhyImplLUDecomp3( &
      & xyza_QMixLUMtx,    &   ! (inout)
      & imax * jmax, kmax  &   ! (in)
      & )

    do n = 1, ncmax
      do k = 1, kmax
        xyz_DelQMixLUVec(:,:,k) = &
          & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
      end do

      call PhyImplLUSolve3(      &
        & xyz_DelQMixLUVec,      & ! (inout)
        & xyza_QMixLUMtx,        & ! (in)
        & 1, imax * jmax , kmax  & ! (in)
        & )

      do k = 1, kmax
        xyzf_DQMixDt(:,:,k,n) = xyz_DelQMixLUVec(:,:,k) / ( 2. * DelTime )
      end do
    end do


    !#########################################################
!!$    ! code for debug, this will be removed, (Y. O. Takahashi, 2009/04/07)
!!$    i = 1
!!$    j = jmax / 2
!!$    write( 6, * ) &
!!$      & - xyr_RadSFlux(i,j,0),                                                      &
!!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
!!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
!!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) ), &
!!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
!!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
!!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
!!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) ),   &
!!$      & - LatentHeat                                                                &
!!$!      &   * ( xyr_QVapFlux(i,j,0)                                                   &
!!$!      &     - xy_SurfQVapTransCoef(i,j)                                             &
!!$!      &       * ( xyz_DQVapDt(i,j,1)                                                &
!!$!      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
!!$!      &       * ( 2.0d0 * DelTime ) ) !, &
!!$      &   * xyr_QVapFlux(i,j,0) !,                                                    &
!!$!      & + xy_DeepSubSurfHeatFlux(i,j)
!!$
!!$    xy_SurfQVapSat(i,j) =                                                           &
!!$      & - xyr_RadSFlux(i,j,0)                                                       &
!!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
!!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
!!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
!!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
!!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
!!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
!!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
!!$      & - LatentHeat                                                                &
!!$!      &   * ( xyr_QVapFlux(i,j,0)                                                   &
!!$!      &     - xy_SurfQVapTransCoef(i,j)                                             &
!!$!      &       * ( xyz_DQVapDt(i,j,1)                                                &
!!$!      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
!!$!      &       * ( 2.0d0 * DelTime ) )
!!$      &   * xyr_QVapFlux(i,j,0)
!!$    write( 6, * ) '# sum ', xy_SurfQVapSat(i,j)
    !#########################################################



    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplSDHTendency

  !-------------------------------------------------------------------

  subroutine PhyImplSDHSnowMeltCorrection(           &
    & xyr_HeatFlux, xyr_QVapFlux,                    & ! (in)
    & xyr_SoilHeatFlux,                              & ! (in)
    & xyr_SoilTempTransCoef,                         & ! (in)
    & xyr_RadSFlux, xyr_RadLFlux,                    & ! (in)
    & xy_DeepSubSurfHeatFlux,                             & ! (in)
    & xy_SurfTemp, xyz_SoilTemp,                     & ! (in)
    & xy_SurfSnowB,                                  & ! (in)
    & xy_SurfCond,                                   & ! (in)
    & xy_SurfHeatCapacity,                           & ! (in)
    & xy_SoilHeatCap, xy_SoilHeatDiffCoef,           & ! (in)
    & xyra_DelRadLFlux,                              & ! (in)
    & xyz_Exner, xyr_Exner,                          & ! (in)
    & xy_SurfTempTransCoef,                          & ! (in)
    & xyz_DTempDt,                                   & ! (in)
    & xy_DSurfTempDt,                                & ! (inout)
    & xyz_DSoilTempDt,                               & ! (inout)
    & xy_DSoilMoistDt, xy_DSurfSnowDt                & ! (inout)
    & )
    !
    ! ͻˤѲΨνԤޤ. 
    !
    ! Correction of tendencies due to melt of snow. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_SSDepth,   &    ! subsurface grid on interface of layer
      & z_SSDepth         ! subsurface grid at midpoint of layer

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry,      &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] . 
                              ! ͻǮ. 
                              ! Latent heat of fusion

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & TempCondWater

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop


    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! Хĥǥ
    ! bucket model
    !
    use Bucket_Model, only: FlagBucketModel, FlagBucketModelSnow

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP), intent(in):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    real(DP), intent(in):: xyr_SoilHeatFlux (0:imax-1, 1:jmax, 0:kslmax)
                              ! ھǮեå (W m-2)
                              ! Heat flux in sub-surface soil (W m-2)
    real(DP), intent(in):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature


    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux

    real(DP), intent(in):: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! "Deep subsurface heat flux"
                              ! Heat flux at the bottom of surface/soil layer.
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
                              ! ھ (K)
                              ! Soil temperature (K)

    real(DP), intent(in):: xy_SurfSnowB (0:imax-1, 1:jmax)
                              ! .
                              ! Surface snow amount.

    integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(in ):: xy_SoilHeatCap (0:imax-1, 1:jmax)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
    real(DP), intent(in ):: xy_SoilHeatDiffCoef (0:imax-1, 1:jmax)
                              ! ھǮƳ (J m-3 K-1)
                              ! Heat conduction coefficient of soil (J m-3 K-1)

    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature

    real(DP), intent(in ):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(inout):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ (K s-1)
                              ! Surface temperature tendency (K s-1)
    real(DP), intent(inout):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
                              ! $ \DP{Tg}{t} $ . ھѲ (K s-1)
                              ! Temperature tendency (K s-1)

    real(DP), intent(inout):: xy_DSoilMoistDt (0:imax-1, 1:jmax)
                              ! ھٻѲΨ (kg m-2 s-1)
                              ! Soil temperature tendency (kg m-2 s-1)
    real(DP), intent(inout):: xy_DSurfSnowDt (0:imax-1, 1:jmax)
                              ! ΨѲΨ (kg m-2 s-1)
                              ! Surface snow amount tendency (kg m-2 s-1)

    ! ѿ
    ! Work variables
    !
    real(DP):: LatentHeatFluxByMelt
    real(DP):: SenHeatFluxA
    real(DP):: LatHeatFluxA
    real(DP):: CondHeatFluxA
    real(DP):: ValueAlpha
    real(DP):: SurfTempATentative
    real(DP):: SoilTempATentative
    real(DP):: SurfSnowATentative


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

!!$    ! ׻ַ¬
!!$    ! Start measurement of computation time
!!$    !
!!$    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_sdh_inited ) call PhyImplInit

    !
    ! check flag of snow melt
    !
    if ( ( .not. FlagBucketModel ) .or. ( .not. FlagBucketModelSnow ) ) return


    if ( kslmax == 0 ) then

      do j = 1, jmax
        do i = 0, imax-1

          SurfSnowATentative = xy_SurfSnowB(i,j) &
            & + xy_DSurfSnowDt(i,j) * 2.0d0 * DelTime
          SurfTempATentative = xy_SurfTemp(i,j) &
            & + xy_DSurfTempDt(i,j) * 2.0d0 * DelTime

          if ( &
            & ( xy_SurfCond (i,j)  >= 1             ) .and. &
            & ( SurfSnowATentative >  0.0d0         ) .and. &
            & ( SurfTempATentative >  TempCondWater )       &
            & ) then

            ! if all snow is melting, 

            LatentHeatFluxByMelt = &
              &   SurfSnowATentative * LatentHeatFusion / ( 2.0d0 * DelTime )

            SenHeatFluxA =                                                          &
              &   xyr_HeatFlux(i,j,0)                                               &
              & - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)              &
              &   * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                         &
              &     - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime )
            ! NOTICE: LatentHeatFlux^{n+1} = LatentHeatFlux^{n-1} due to mass 
            !         conservation
            LatHeatFluxA = LatentHeat * xyr_QVapFlux(i,j,0)

            CondHeatFluxA = xy_DeepSubSurfHeatFlux(i,j)

            ValueAlpha =                                           &
              &   xyr_RadSFlux(i,j,0)                              &
              & + xyr_RadLFlux(i,j,0)                              &
              &   - xyra_DelRadLFlux(i,j,0,0) * xy_SurfTemp(i,j)   &
              &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) &
              &     * ( 2.0d0 * DelTime )                          &
              & + SenHeatFluxA                                     &
              & + LatHeatFluxA                                     &
              & + LatentHeatFluxByMelt


            SurfTempATentative = &
              & xy_SurfHeatCapacity(i,j) / ( 2.0d0 * DelTime ) &
              &   * xy_SurfTemp(i,j) &
              & - ValueAlpha + CondHeatFluxA
            SurfTempATentative = &
              & SurfTempATentative &
              & / ( &
              &       xy_SurfHeatCapacity(i,j) / ( 2.0d0 * DelTime ) &
              &     + xyra_DelRadLFlux(i,j,0,0) &
              &   )

            if ( SurfTempATentative >= TempCondWater ) then

              xy_DSurfTempDt(i,j) = &
                & ( SurfTempATentative - xy_SurfTemp(i,j) ) / ( 2.0d0 * DelTime )
!!$              xy_SoilMoistA(i,j) = &
!!$                & xy_SoilMoistA(i,j) &
!!$                & + LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
!!$              xy_SurfSnowA(i,j) = &
!!$                & xy_SurfSnowA(i,j) &
!!$                & - LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
              xy_DSoilMoistDt(i,j) = &
                & xy_DSoilMoistDt(i,j) + LatentHeatFluxByMelt / LatentHeatFusion
              xy_DSurfSnowDt(i,j) = &
                & xy_DSurfSnowDt (i,j) - LatentHeatFluxByMelt / LatentHeatFusion

            else

              ! if part of snow is melting, 

              SurfTempATentative = TempCondWater

              ValueAlpha = &
                &   xyr_RadSFlux(i,j,0) &
                & + xyr_RadLFlux(i,j,0) &
                &   + xyra_DelRadLFlux(i,j,0,0) * SurfTempATentative &
                &   - xyra_DelRadLFlux(i,j,0,0) * xy_SurfTemp(i,j)   &
                &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) &
                &     * ( 2.0d0 * DelTime )                          &
                & + SenHeatFluxA &
                & + LatHeatFluxA &
                & - CondHeatFluxA

              LatentHeatFluxByMelt = &
                &   xy_SurfHeatCapacity(i,j) &
                & * ( SurfTempATentative - xy_SurfTemp(i,j) ) &
                & / ( 2.0d0 * DelTime ) &
                & - ValueAlpha

              xy_DSurfTempDt(i,j) = &
                & ( SurfTempATentative - xy_SurfTemp(i,j) ) / ( 2.0d0 * DelTime )
!!$              xy_SoilMoistA(i,j) = &
!!$                & xy_SoilMoistA(i,j) &
!!$                & + LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
!!$              xy_SurfSnowA(i,j) = &
!!$                & xy_SurfSnowA(i,j) &
!!$                & - LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
              xy_DSoilMoistDt(i,j) = &
                & xy_DSoilMoistDt(i,j) + LatentHeatFluxByMelt / LatentHeatFusion
              xy_DSurfSnowDt(i,j) = &
                & xy_DSurfSnowDt (i,j) - LatentHeatFluxByMelt / LatentHeatFusion

            end if

            SurfSnowATentative = xy_SurfSnowB(i,j) &
              & + xy_DSurfSnowDt(i,j) * 2.0d0 * DelTime
            if ( SurfSnowATentative < 0.0d0 ) then
              xy_DSurfSnowDt(i,j) = - xy_SurfSnowB(i,j) / ( 2.0d0 * DelTime )
            end if

          end if

        end do
      end do


    else

      do j = 1, jmax
        do i = 0, imax-1

          SurfSnowATentative = xy_SurfSnowB(i,j) &
            & + xy_DSurfSnowDt(i,j) * 2.0d0 * DelTime
          SoilTempATentative = xyz_SoilTemp(i,j,1) &
            & + xyz_DSoilTempDt(i,j,1) * 2.0d0 * DelTime

          if ( &
            & ( xy_SurfCond (i,j)  >= 1            ) .and. &
            & ( SurfSnowATentative >  0.0d0        ) .and. &
            & ( SoilTempATentative > TempCondWater )       &
            & ) then

            ! if all snow is melting, 

            LatentHeatFluxByMelt &
              & = SurfSnowATentative * LatentHeatFusion &
              &   / ( 2.0d0 * DelTime )

            SenHeatFluxA =                                                          &
              &   xyr_HeatFlux(i,j,0)                                               &
              & - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)              &
              &   * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                         &
              &     - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime )
            ! NOTICE: LatentHeatFlux^{n+1} = LatentHeatFlux^{n-1} due to mass conservation
            LatHeatFluxA = LatentHeat * xyr_QVapFlux(i,j,0)
            CondHeatFluxA = &
              &   xyr_SoilHeatFlux(i,j,1) &
              & - xyr_SoilTempTransCoef(i,j,1) &
              &   * ( xyz_DSoilTempDt(i,j,2) - xyz_DSoilTempDt(i,j,1) ) &
              &   * ( 2.0d0 * DelTime )
            ValueAlpha = &
              &   xyr_RadSFlux(i,j,0) &
              & + xyr_RadLFlux(i,j,0) &
              &   - xyra_DelRadLFlux(i,j,0,0) * xy_SurfTemp(i,j)   &
              &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) &
              &     * ( 2.0d0 * DelTime )                          &
              & + SenHeatFluxA &
              & + LatHeatFluxA &
              & + LatentHeatFluxByMelt
            ValueAlpha = ValueAlpha &
              & * ( r_SSDepth(0) - z_SSDepth(1) ) / xy_SoilHeatDiffCoef(i,j)


            SurfTempATentative = &
              & - ( xy_SoilHeatCap(i,j) / ( 2.0d0 * DelTime ) &
              &   + xy_SoilHeatDiffCoef(i,j)                  &
              &     / ( ( r_SSDepth(0) - r_SSDepth(1) )       &
              &       * ( r_SSDepth(0) - z_SSDepth(1) ) ) )   &
              &   * ValueAlpha                                &
              & + xy_SoilHeatCap(i,j) / ( 2.0d0 * DelTime )   &
              &   * xyz_SoilTemp(i,j,1) &
              & + CondHeatFluxA / ( r_SSDepth(0) - r_SSDepth(1) )
            SurfTempATentative = &
              & SurfTempATentative &
              & / ( xy_SoilHeatCap(i,j) / ( 2.0d0 * DelTime ) &
              &     * ( 1.0d0 &
              &         + ( r_SSDepth(0) - z_SSDepth(1) ) &
              &             / xy_SoilHeatDiffCoef(i,j)      &
              &             * xyra_DelRadLFlux(i,j,0,0) ) &
              &     + xyra_DelRadLFlux(i,j,0,0) / ( r_SSDepth(0) - r_SSDepth(1) ) )

            SoilTempATentative = &
              & ( 1.0d0 &
              &   + ( r_SSDepth(0) - z_SSDepth(1) ) &
              &       / xy_SoilHeatDiffCoef(i,j)   &
              &       * xyra_DelRadLFlux(i,j,0,0) ) &
              & * SurfTempATentative &
              & + ValueAlpha

            if ( SoilTempATentative >= TempCondWater ) then

              xyz_DSoilTempDt(i,j,1) = &
                & ( SoilTempATentative - xyz_SoilTemp(i,j,1) ) / ( 2.0d0 * DelTime )
              xy_DSurfTempDt(i,j) = &
                & ( SurfTempATentative - xy_SurfTemp(i,j) ) / ( 2.0d0 * DelTime )
!!$              xy_SoilMoistA(i,j) = &
!!$                & xy_SoilMoistA(i,j) &
!!$                & + LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
!!$              xy_SurfSnowA(i,j) = &
!!$                & xy_SurfSnowA(i,j) &
!!$                & - LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
              xy_DSoilMoistDt(i,j) = &
                & xy_DSoilMoistDt(i,j) + LatentHeatFluxByMelt / LatentHeatFusion
              xy_DSurfSnowDt(i,j) = &
                & xy_DSurfSnowDt (i,j) - LatentHeatFluxByMelt / LatentHeatFusion

            else

              ! if part of snow is melting, 

              SoilTempATentative = TempCondWater
              SurfTempATentative = &
                & ( r_SSDepth(0) - r_SSDepth(1) ) * ( r_SSDepth(0) - z_SSDepth(1) ) &
                & / xy_SoilHeatDiffCoef(i,j)                                        &
                & * ( &
                &     ( xy_SoilHeatCap(i,j) / ( 2.0d0 * DelTime ) &
                &     + xy_SoilHeatDiffCoef(i,j) &
                &     / ( ( r_SSDepth(0) - r_SSDepth(1) )        &
                &       * ( r_SSDepth(0) - z_SSDepth(1) ) ) )    &
                &     * SoilTempATentative &
                &    - xy_SoilHeatCap(i,j) / ( 2.0d0 * DelTime ) &
                &      * xyz_SoilTemp(i,j,1) &
                &    - CondHeatFluxA / ( r_SSDepth(0) - r_SSDepth(1) ) )

              LatentHeatFluxByMelt = &
                & - xy_SoilHeatDiffCoef(i,j) &
                &   * ( SurfTempATentative - SoilTempATentative ) &
                &   / ( r_SSDepth(0) - z_SSDepth(1) ) &
                & - xyr_RadSFlux(i,j,0) &
                & - ( xyr_RadLFlux(i,j,0) &
                &     + xyra_DelRadLFlux(i,j,0,0) &
                &       * ( SurfTempATentative - xy_SurfTemp(i,j) )   &
                &     + xyra_DelRadLFlux(i,j,0,1) &
                &       * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) ) &
                & - SenHeatFluxA &
                & - LatHeatFluxA

              xyz_DSoilTempDt(i,j,1) = &
                & ( SoilTempATentative - xyz_SoilTemp(i,j,1) ) / ( 2.0d0 * DelTime )
              xy_DSurfTempDt(i,j) = &
                & ( SurfTempATentative - xy_SurfTemp(i,j) ) / ( 2.0d0 * DelTime )
!!$              xy_SoilMoistA(i,j) = &
!!$                & xy_SoilMoistA(i,j) &
!!$                & + LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
!!$              xy_SurfSnowA(i,j) = &
!!$                & xy_SurfSnowA(i,j) &
!!$                & - LatentHeatFluxByMelt * ( 2.0d0 * DelTime ) / LatentHeatFusion
              xy_DSoilMoistDt(i,j) = &
                & xy_DSoilMoistDt(i,j) + LatentHeatFluxByMelt / LatentHeatFusion
              xy_DSurfSnowDt(i,j) = &
                & xy_DSurfSnowDt (i,j) - LatentHeatFluxByMelt / LatentHeatFusion

            end if

            SurfSnowATentative = xy_SurfSnowB(i,j) &
              & + xy_DSurfSnowDt(i,j) * 2.0d0 * DelTime
            if ( SurfSnowATentative < 0.0d0 ) then
              xy_DSurfSnowDt(i,j) = - xy_SurfSnowB(i,j) / ( 2.0d0 * DelTime )
            end if

          end if

        end do
      end do

    end if


!!$    ! ׻ַ¬
!!$    ! Pause measurement of computation time
!!$    !
!!$    call TimesetClockStop( module_name )

  end subroutine PhyImplSDHSnowMeltCorrection

  !-------------------------------------------------------------------

  subroutine PhyImplSDHSeaIceCorrection( &
    & xy_SurfCond,                       & ! (in)
    & xy_SeaIceConc,                     & ! (in)
    & xy_SurfTemp,                       & ! (in)
    & xy_DSurfTempDt                     & ! (inout)
    & )
    !
    ! ͻˤѲΨνԤޤ. 
    !
    ! Correction of tendencies due to melt of snow. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & TempCondWater,       &
      & SeaIceThermCondCoef, &
      & SeaIceThreshold

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop


    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! Хĥǥ
    ! bucket model
    !
    use Bucket_Model, only: FlagBucketModel, FlagBucketModelSnow

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in   ):: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in   ):: xy_SeaIceConc(0:imax-1,1:jmax)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)
    real(DP), intent(in   ):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(inout):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ (K s-1)
                              ! Surface temperature tendency (K s-1)

    ! ѿ
    ! Work variables
    !


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

!!$    ! ׻ַ¬
!!$    ! Start measurement of computation time
!!$    !
!!$    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_sdh_inited ) call PhyImplInit

    !
    ! check flag of snow melt
    !
    if ( ( .not. FlagBucketModel ) .or. ( .not. FlagBucketModelSnow ) ) return


    do j = 1, jmax
      do i = 0, imax-1

        if ( &
          & ( xy_SurfCond  (i,j) == 0               ) .and. &
          & ( xy_SeaIceConc(i,j) >  SeaIceThreshold ) .and. &
          & ( xy_SurfTemp(i,j) + xy_DSurfTempDt(i,j) * DelTime > TempCondWater ) &
          & ) then

          xy_DSurfTempDt(i,j) = ( TempCondWater - xy_SurfTemp(i,j) ) / DelTime

        end if

      end do
    end do


!!$    ! ׻ַ¬
!!$    ! Pause measurement of computation time
!!$    !
!!$    call TimesetClockStop( module_name )


  end subroutine PhyImplSDHSeaIceCorrection

  !-------------------------------------------------------------------

  subroutine PhyImplInit
    !
    ! phy_implicit ⥸塼νԤޤ. 
    ! NAMELIST#phy_implicit_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "phy_implicit" module is initialized. 
    ! "NAMELIST#phy_implicit_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /phy_implicit_sdh_nml/ &
      SOHeatCapacity          ! Slab ocean heat capacity (J m-2 K-1)
          !
          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "phy_implicit#PhyImplInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( phy_implicit_sdh_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

    SOHeatCapacity = 4.187d3 * 1.0d3 * 60.0d0
                         ! 4.187d3 (J (kg K)-1) * 1.0d3 (kg m-3) * 60.0d0 (m)


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                 &  ! (in)
        & nml = phy_implicit_sdh_nml, &  ! (out)
        & iostat = iostat_nml )          ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  SOHeatCapacity = %f', d = (/ SOHeatCapacity /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    phy_implicit_sdh_inited = .true.

  end subroutine PhyImplInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module phy_implicit_sdh
