!= phy_hs94 ⥸塼Υƥȥץ
!
!= Test program for "phy_hs94"
!
! Authors::   unknown
! Version::   $Id: phy_hs94_test.f90,v 1.5 2008-02-20 07:54:21 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_hs94 ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_hs94" module.
! Confirm compilation and execution of this program.
!

program phy_hs94_test
  use phy_hs94, only: PHYHS94, PhyHsCreate, PhyHsClose, &
    & PhyHsPutLine, PhyHsInitialized, PhyHsForcing
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  use gt4_history, only: GT_HISTORY, HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_hs94_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_hs94" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! Number of vertical level

  !---------------------------------------------------------
  !  ʪ
  !  Physical constants
  !---------------------------------------------------------
  real(DP), parameter:: PI = 3.1415926535897930_DP
                              ! $ \pi $ . ߼Ψ. Circular constant
  real(DP):: Cp = 1004.6_DP
  real(DP):: RAir = 287.04_DP

  !---------------------------------------------------------
  !  ɸѿ
  !  Coordinate variables
  !---------------------------------------------------------
  real(DP):: x_Lon (0:imax-1) ! . Longitude
  real(DP):: y_Lat (0:jmax-1) ! . Latitude
  real(DP):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

  !---------------------------------------------------------
  !  PhyHsForcing ؤ
  !  Input/Output values for "PhyHsForcing"
  !---------------------------------------------------------
  real(DP):: xyz_U (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ U $ .     ®. Zonal wind
  real(DP):: xyz_V (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ V $ .     ®. Meridional wind
  real(DP):: xyz_Temp (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xy_Ps (0:imax-1,0:jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure

  real(DP):: xyz_DUDtHS94 (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{U}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Zonal wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP):: xyz_DVDtHS94 (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{V}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Meridional wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP):: xyz_DTempDtHS94 (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{T}{t} $ . 
                              ! Held and Suarez (1994) Υ˥塼ȥѤˤ벹Ѳ. 
                              ! Temperature tendency due to Newtonian relaxation of Held and Suarez (1994)

  !---------------------------------------------------------
  !  PhyHsForcing 碌
  !  Answer values for "PhyHsForcing"
  !---------------------------------------------------------
  real(DP):: xyz_DUDtHS94Ans (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{U}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Zonal wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP):: xyz_DVDtHS94Ans (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{V}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Meridional wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP):: xyz_DTempDtHS94Ans (0:imax-1,0:jmax-1,0:kmax-1)
                              ! $ \DP{T}{t} $ . 
                              ! Held and Suarez (1994) Υ˥塼ȥѤˤ벹Ѳ. 
                              ! Temperature tendency due to Newtonian relaxation of Held and Suarez (1994)


  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line options
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYHS94):: phy_hs00, phy_hs01, phy_hs02, phy_hs03
  logical:: err

  integer:: i                 ! DO 롼Ѻѿ
                              ! Work variables for DO loop

  character(*), parameter:: subname = 'phy_hs94_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !---------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is internal subroutine

  !---------------------------------------------------------
  !  ǡ
  !  Input data
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'lon', & ! (in)
    & array = x_Lon, quiet = .true. )                 ! (out)
    x_Lon = x_Lon * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'lat', & ! (in)
    & array = y_Lat, quiet = .true. )                 ! (out)
    y_Lat = y_Lat * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'sig', & ! (in)
    & array = z_Sigma, quiet = .true. )               ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'U', & ! (in)
    & array = xyz_U, quiet = .true. )               ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'V', & ! (in)
    & array = xyz_V, quiet = .true. )               ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'Temp', & ! (in)
    & array = xyz_Temp, quiet = .true. )               ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test00.nc', varname = 'Ps', & ! (in)
    & array = xy_Ps, quiet = .true. )                ! (out)

  !-------------------------------------------------------------------
  !  ܤν, λƥ
  !  Basic initialization and termination test
  !-------------------------------------------------------------------
  call PhyHsCreate( phy_hs = phy_hs00, &                    ! (inout)
    &    imax = 32,     jmax = 16,       kmax = 12, &       ! (in)
    &   x_Lon = x_Lon, y_Lat = y_Lat, z_Sigma = z_Sigma, &  ! (in)
    &      Cp = Cp,     RAir = RAir, &                      ! (in)
    & DelTime = 1200.0_DP )                                 ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = PhyHsInitialized(phy_hs00) )
  call PhyHsPutLine( phy_hs00 ) ! (in)

  call PhyHsClose( phy_hs = phy_hs00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = PhyHsInitialized(phy_hs00) )
  call PhyHsPutLine( phy_hs = phy_hs00 ) ! (in)

  call PhyHsClose( phy_hs = phy_hs02, & ! (inout)
    & err = err )                    ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

  !-------------------------------------------------------------------
  !  PhyHsForcing Υƥ
  !  Test of "PhyHsForcing"
  !-------------------------------------------------------------------
  call PhyHsCreate( phy_hs = phy_hs00, &                    ! (inout)
    &    imax = 32,     jmax = 16,       kmax = 12, &       ! (in)
    &   x_Lon = x_Lon, y_Lat = y_Lat, z_Sigma = z_Sigma, &  ! (in)
    &      Cp = Cp,     RAir = RAir, &                      ! (in)
    & DelTime = 1200.0_DP, &                                ! (in)
    & current_time_value = 0.0, &                           ! (in)
    & current_time_unit = 'min', &                          ! (in)
    & history_varlist = 'DUDt, DVDt, DTempDt, TempEQ', &    ! (in)
    & history_interval_value = 20.0, &                      ! (in)
    & history_interval_unit = 'min', &                      ! (in)
    & history_precision = 'float', &                        ! (in)
    & history_fileprefix = 'tmp_phy_hs94_test00_' )         ! (in)

  do i = 1, 2
    call PhyHsForcing( phy_hs = phy_hs00, &                      ! (inout)
      &       xyz_U = xyz_U,            xyz_V = xyz_V, &         ! (in)
      &    xyz_Temp = xyz_Temp,         xy_Ps = xy_Ps, &         ! (in)
      &    xyz_DUDt = xyz_DUDtHS94,   xyz_DVDt = xyz_DVDtHS94, & ! (out)
      & xyz_DTempDt = xyz_DTempDtHS94 )                          ! (out)
  end do

  call PhyHsClose( phy_hs = phy_hs00 ) ! (inout)

  !---------------------------
  !  碌
  !  Check returned values
  call HistoryGet ( &
    & file = 'phy_hs94_test01.nc', varname = 'DUDt', & ! (in)
    & array = xyz_DUDtHS94Ans, quiet = .true. )         ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test01.nc', varname = 'DVDt', & ! (in)
    & array = xyz_DVDtHS94Ans, quiet = .true. )        ! (out)

  call HistoryGet ( &
    & file = 'phy_hs94_test01.nc', varname = 'DTempDt', & ! (in)
    & array = xyz_DTempDtHS94Ans, quiet = .true. )        ! (out)

  call AssertEqual( 'DUDt test 1', &
    & answer = xyz_DUDtHS94Ans, check = xyz_DUDtHS94, &
    & significant_digits = 15, ignore_digits = -15 )
  
  call AssertEqual( 'DVDt test 1', &
    & answer = xyz_DVDtHS94Ans, check = xyz_DVDtHS94, &
    & significant_digits = 15, ignore_digits = -15 )
  
  call AssertEqual( 'DTempDt test 1', &
    & answer = xyz_DTempDtHS94Ans, check = xyz_DTempDtHS94, &
    & significant_digits = 15, ignore_digits = -15 )

  !-------------------------------------------------------------------
  !  NAMELIST Ѥǡϥƥ
  !  Data output test with NAMELIST
  !-------------------------------------------------------------------
  call PhyHsCreate( phy_hs = phy_hs00, &                    ! (inout)
    &    imax = 32,     jmax = 16,       kmax = 12, &       ! (in)
    &   x_Lon = x_Lon, y_Lat = y_Lat, z_Sigma = z_Sigma, &  ! (in)
    &      Cp = Cp,     RAir = RAir, &                      ! (in)
    & DelTime = 1200.0_DP, &                                ! (in)
    & current_time_value = 0.0, &                           ! (in)
    & current_time_unit = 'min', &                          ! (in)
    & history_varlist = 'DUDt, DVDt, DTempDt, TempEQ', &    ! (in)
    & history_interval_value = 20.0, &                      ! (in)
    & history_interval_unit = 'min', &                      ! (in)
    & history_precision = 'float', &                        ! (in)
    & history_fileprefix = '', &                            ! (in)
    & nmlfile = VAL_namelist )                              ! (in)

  do i = 1, 7
    call PhyHsForcing( phy_hs = phy_hs00, &                      ! (inout)
      &       xyz_U = xyz_U,            xyz_V = xyz_V, &         ! (in)
      &    xyz_Temp = xyz_Temp,         xy_Ps = xy_Ps, &         ! (in)
      &    xyz_DUDt = xyz_DUDtHS94,   xyz_DVDt = xyz_DVDtHS94, & ! (out)
      & xyz_DTempDt = xyz_DTempDtHS94 )                          ! (out)
  end do


contains

  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program phy_hs94_test
