require 'rbconfig'
require 'find'
require 'ftools'
require 'optparse'

include Config

$ruby = CONFIG['ruby_install_name']

##
# Install a binary file. We patch in on the way through to
# insert a #! line. If this is a Unix install, we name
# the command (for example) 'rdoc' and let the shebang line
# handle running it. Under windows, we add a '.rb' extension
# and let file associations to their stuff
#

def installBIN(from, opfile)

  tmp_dir = nil
  for t in [".", "/tmp", "c:/temp", $bindir]
    stat = File.stat(t) rescue next
    if stat.directory? and stat.writable?
      tmp_dir = t
      break
    end
  end

  fail "Cannot find a temporary directory" unless tmp_dir
  tmp_file = File.join(tmp_dir, "_tmp")
    
    
  File.open(from) do |ip|
    File.open(tmp_file, "w") do |op|
      ruby = File.join($realbindir, $ruby)
#      op.puts "#!#{ruby}"
      op.write ip.read
    end
  end

  opfile += ".rb" if CONFIG["target_os"] =~ /mswin/i
  File::install(tmp_file, File.join($bindir, opfile), 0755, true)
  File::unlink(tmp_file)
end

# Main Program

opt = OptionParser.new
OPTS = {}
opt.on('--help') {|v| OPTS[:help] = v}
opt.on('--bindir=VAL',
       'Directory to which the libraries are installed') \
      {|v| $bindir = v.to_s}
opt.on('--libdir=VAL', 
       'Directory to which the executable file "rdoc" is installed') \
       {|v| $libdir = v.to_s}

opt.parse!(ARGV)

$bindir = File.expand_path($bindir) if $bindir
$libdir = File.expand_path($libdir) if $libdir

install_opt = ""
install_opt = "--libdir=#{$libdir}" if $libdir

if $libdir
  $sitedir = $libdir
else
  $sitedir = CONFIG["sitelibdir"]
  unless $sitedir
    version = CONFIG["MAJOR"]+"."+CONFIG["MINOR"]
    $libdir = File.join(CONFIG["libdir"], "ruby", version)
    $sitedir = $:.find {|x| x =~ /site_ruby/}
    if !$sitedir
      $sitedir = File.join($libdir, "site_ruby")
    elsif $sitedir !~ Regexp.quote(version)
      $sitedir = File.join($sitedir, version)
    end
  end
end

$bindir ||= CONFIG["bindir"]
$realbindir = $bindir

bindir = CONFIG["bindir"]

rdoc_dest = File.join($sitedir, "rdoc")
dot_dest  = File.join(rdoc_dest, "dot")
rdoc_generators = File.join(rdoc_dest, "generators")
rdoc_templates  = File.join(rdoc_generators, "template")
rdoc_parsers    = File.join(rdoc_dest, "parsers")
rdoc_ri         = File.join(rdoc_dest, "ri")

# help message
if ARGV[0] || OPTS[:help]
  print <<-HELP

  This ruby script installs libraries to \"#{rdoc_dest}\",
  and executables to \"#{$bindir}\". (See \"rbconfig.rb\")

  If you want to install other directory, use following options.

  OPTIONS: 

     --libdir  Directory to which the libraries are installed
     --bindir  Directory to which the executable file "rdoc" is installed

HELP
  exit
end

# make directories
File::makedirs(rdoc_dest,
               dot_dest, 
               rdoc_generators, 
               rdoc_templates, 
               rdoc_parsers,
               rdoc_ri,
               true)

File::chmod(0755, rdoc_dest)



# The library files
files = %w{
 code_objects.rb
 generators/*_generator.rb
 options.rb
 parsers/parserfactory.rb  
 parsers/parse_*.rb  
 template.rb
 tokenstream.rb
 diagram.rb
 rdoc.rb
 dot/dot.rb
 ri/ri_*.rb
}.collect {|f| Dir.glob(f)}.flatten

for template in ["chm", "html", "xml"]
  File::makedirs(File.join(rdoc_templates, template), true)
  files.concat Dir.glob("rdoc/generators/template/#{template}/*.rb")
end

for aFile in files
  File::install(aFile, File.join(rdoc_dest, aFile), 0644, true)
end

# and the executable

installBIN("rdoc", "rdoc")

# Temporary - we used to install html_generator in the rdoc
# directory, but now it's moved

File.unlink(File.join(rdoc_dest, "html_generator.rb")) rescue 1;

# and we used to have the templates under html_template
template = File.join(rdoc_dest, "generators", "html_template")
File.unlink(File.join(template, "standard.rb")) rescue 1;
File.unlink(File.join(template, "kilmer.rb")) rescue 1;

# and then they were in template/ ...
template = File.join(rdoc_dest, "generators", "template")
File.unlink(File.join(template, "standard.rb")) rescue 1;
File.unlink(File.join(template, "kilmer.rb")) rescue 1;
File.unlink(File.join(template, "xml.rb")) rescue 1;
File.unlink(File.join(template, "rdf.rb")) rescue 1;


# 'Markup' will eventually be a separate package, but
# for now we'll install it automatically 

Dir.chdir("markup") && system("#$ruby install.rb #{install_opt}")
