require 'rbconfig'
require 'find'
require 'fileutils'
require 'optparse'

include Config

opt = OptionParser.new
libdir = nil
opt.on('--libdir=VAL') {|v| libdir  = v}
opt.parse!(ARGV)

libdir = File.expand_path(libdir) if libdir

if libdir
  sitedir = libdir
else
  sitedir = CONFIG["sitelibdir"]
  unless sitedir
    version = CONFIG["MAJOR"]+"."+CONFIG["MINOR"]
    libdir = File.join(CONFIG["libdir"], "ruby", version)
    sitedir = $:.find {|x| x =~ /site_ruby/}
    if !sitedir
      sitedir = File.join(libdir, "site_ruby")
    elsif sitedir !~ Regexp.quote(version)
      sitedir = File.join(sitedir, version)
    end
  end
end

unless /^\// =~ sitedir.strip
  sitedir = File.join("..", sitedir)
end

if !File.directory?(sitedir)
  $stderr.puts "Cannot find sitedir #{sitedir}"
  exit 1
end

rdoc_dest = File.join(sitedir, "rdoc")

dest = File.join(rdoc_dest, "markup")

FileUtils::makedirs(dest, {:verbose => true})

Find.find("./",
          "sample") do |fname|
  if File.directory?(fname)
    next if fname =~ /CVS/
    FileUtils::makedirs(File.join(dest, fname), {:verbose => true})
  else
    next unless fname =~ /\.rb$/
    next if fname =~ /install.rb$/
    FileUtils::install(fname, File.join(dest, fname), 
                       {:mode => 0444, :verbose => true})
  end
end
