/*
 *    dcl graphic driver for Xlib
 *
 *                         original  M. Shiotani
 *                         93/04/15  A. Numaguti (wait option etc.)
 *                         94/01/28  S. Sakai  ver.5.x
 *                         94/03/15  M. Shiotani
 *                         95/03/18  A. Numaguti
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define BORDWD 2             /* border width */
#define PAD    2.0           /* padding for workstation window */
#define FACTZ  0.03          /* scaling factor */
#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR TRUE          /* line color  capability */
#define LTNATR TRUE          /* hard fill   capability */
#define LIMATR TRUE          /* bit image   capability */
#define LPTATR TRUE          /* mouse point capability */
#define MAXWDI 9             /* maximum number of line index */
#define MAXCLI 255           /* maximum number of line color */
#define MAXBMP 300           /* maximum number of bitmaps */

static int linewidth[MAXWDI] = { 1, 2, 2, 3, 3, 4, 4, 5, 5 };
                             /* initialization for line width */
static int iwdidz, iclidz, iwtroz, lclatrz, iwnd;
static int wsxwd, wsywd, wsxmnz, wsxmxz, wsymnz, wsymxz;
static int ixz, iyz, iwz, ihz, ixxz, iyyz, page;
static int posx, posy, wait, wait0, wait1, keymask, alternate, dump;
static int nbmap, nn1[MAXBMP], nn2[MAXBMP], nx[MAXBMP], ny[MAXBMP];
static unsigned long pl[1], px[MAXCLI];
static float rwxold, rwyold;
static char dmpfile[80], xtitle[80];
static char bmline[MAXBMP][260];

static Display *d;
static Window w, ww[2];
static GC gc, gct;
static XEvent e;

/*------------------------- device ------------------------*/

void zxdopn_(width, height, iposx, iposy,
	     lwait, lwait0, lwait1, lkey, lalt, ldump,
	     clrmap, cbmmap, file, title)
    int *width, *height, *iposx, *iposy, *lwait, *lwait0, *lwait1,
	*lkey, *lalt, *ldump;
    char clrmap[], cbmmap[], file[], title[];
{
    int bordcl, backcl, ncolor, n, m, msk;
    long int rx[MAXCLI], gx[MAXCLI], bx[MAXCLI];
    char c[80], cmapz[80], bmapz[80];

    XSetWindowAttributes att;
    XSizeHints sizehint;
    Colormap cm;
    XColor cx[MAXCLI];
    FILE *stream;
    void cfnchr();

    posx      = *iposx;
    posy      = *iposy;
    wait      = *lwait;
    wait0     = *lwait0;
    wait1     = *lwait1;
    keymask   = *lkey;
    alternate = *lalt;
    dump      = *ldump;

    cfnchr (dmpfile, file, 79);
    cfnchr (xtitle, title, 79);

/* window size */

    wsxwd  = *width  + 2 * PAD;  /* window width */
    wsywd  = *height + 2 * PAD;  /* window height */
    wsxmnz = PAD;                /* lower-left  corner */
    wsymnz = PAD;                /* lower-left  corner */
    wsxmxz = PAD + *width  - 1;  /* upper-right corner */
    wsymxz = PAD + *height - 1;  /* upper-right corner */
    page   = 0;
    iwnd   = 1;
    if (alternate)
	iwnd = 0;

/* read colormap file */

    cfnchr (cmapz, clrmap, 79);

    if ((stream = fopen(cmapz, "r")) == NULL) {
	fprintf (stderr, "*** Error in zxdopn : ");
	fprintf (stderr,
		 "Allocation failed for colormap (%s).\n", cmapz);
	exit (1);
    }

    fscanf (stream, "%d : %s", &ncolor, c);
    for (n = 0; n < ncolor; n++)
	fscanf(stream, "%6ld%6ld%6ld : %s", &rx[n], &gx[n], &bx[n], c);

/* read bitmap file */

    cfnchr (bmapz, cbmmap, 79);

    if ((stream = fopen(bmapz, "r")) == NULL) {
	fprintf (stderr, "*** Error in zxdopn : ");
	fprintf (stderr,
		 "Allocation failed for bitmap (%s).\n", bmapz);
	exit (1);
    }

    fscanf (stream, "%d", &nbmap);
    for (n = 0; n < nbmap; n++)
	fscanf(stream, "%4d%4d%3d%3d%s",
	       &nn1[n], &nn2[n], &nx[n], &ny[n], bmline[n]);

/* open ( and activate ) workstation */

    d = XOpenDisplay (NULL);
    if ( d == NULL ) {
      fprintf (stderr, "*** Error in zxdopn : Can't open display.\n" );
      exit (1);
    }

    cm = DefaultColormap (d, 0);
    lclatrz = (DefaultVisual(d,0) -> class != StaticGray);

    if (lclatrz) {
	for (n = 0; n < MAXCLI; n++) {
	    m = n % ncolor;
	    cx[n].red   = rx[m];
	    cx[n].green = gx[m];
	    cx[n].blue  = bx[m];
	    if (XAllocColor(d,cm,&cx[n]))
		px[n] = cx[n].pixel;
	    else
		break;
	}
	if (n < MAXCLI) {
	    fprintf (stderr, "*** Warning in zxdopn : ");
	    fprintf (stderr, "Only %d colors are allocated.\n", n);
	    for ( ; n < MAXCLI; n++)
		px[n] = BlackPixel (d, 0);
	}
    }
    else {
  	px[0] = WhitePixel (d, 0);
  	for (n = 1; n < MAXCLI; n++)
  	    px[n] = BlackPixel (d, 0);
    }

    bordcl = px[1];
    backcl = px[0];

    w = XCreateSimpleWindow (d, DefaultRootWindow(d), posx, posy,
			     wsxwd, wsywd, BORDWD, bordcl, backcl);

    XStoreName (d, w, xtitle);

    if (posx != -999 && posy != -999) {
	sizehint.flags = USPosition;
	sizehint.x = posx;
	sizehint.y = posy;
	XSetNormalHints (d, w, &sizehint);
    }

    msk = ExposureMask | ButtonPressMask;
    if (keymask)
	msk |= KeyPressMask;
    XSelectInput (d, w, msk);

    gc = XCreateGC (d, w, 0, 0);

    XMapWindow (d, w);

    do
	XNextEvent (d, &e);
    while (e.type != Expose);

    ww[0] = XCreateSimpleWindow (d, w, 0, 0,
				 wsxwd, wsywd, 0, bordcl, backcl);
    ww[1] = XCreateSimpleWindow (d, w, 0, 0,
				 wsxwd, wsywd, 0, bordcl, backcl);
    XMapSubwindows (d, w);

    att.backing_store = Always;
    XChangeWindowAttributes (d, ww[0], CWBackingStore, &att);
    XChangeWindowAttributes (d, ww[1], CWBackingStore, &att);

    if (wait0) {
	do
	    XNextEvent (d, &e);
	while (e.type != ButtonPress && e.type != KeyPress);
    }
}

void zxdcls_()
{
    int next;
    char string[2];

    KeySym key;

    if (!wait && wait1) {
	while (1) {
	    XNextEvent (d, &e);
	    if (e.type == KeyPress) {
	        if (XLookupString (&e.xkey, string, 2, &key, NULL) == 1) {
		    switch (key) {
	            case XK_Return:
			next = True;
			break;
	            case XK_space:
			next = True;
			break;
		    default:
			next = False;
		    }
		}
	    }
	    if (e.type == ButtonPress)
		next = True;		
	    if (next)
		break;
	}
    }

    XDestroySubwindows (d, w);
    XDestroyWindow (d, w);
    XCloseDisplay (d);
}

/*------------------------- page --------------------------*/

void zxpopn_()
{

/* open page ( or screen ) */

    ++page;
    iwdidz = 1;
    iclidz = 1;
    XClearWindow (d, ww[iwnd]);
}

void zxpcls_()
{
    int next, dumpz, ixl;
    char cmd[64], string[2];

    KeySym key;

/* close page ( or screen ) */

    if (alternate) {
	XRaiseWindow (d, ww[iwnd]);
	iwnd = 1 - iwnd;
    }

    XFlush (d);
    if (XCheckTypedEvent (d, KeyPress, &e)) {
	ixl = XLookupString (&e.xkey, string, 2, &key, NULL);
	if (key == XK_w)
	    wait = True;
    }

    dumpz = False;

    if (wait) {
	while (1) {
	    XNextEvent (d, &e);
	    if (e.type == KeyPress) {
	        if (XLookupString (&e.xkey, string, 2, &key, NULL) == 1) {
		    switch (key) {
	            case XK_Return:
			next = True;
			break;
	            case XK_space:
			next = True;
			break;
	            case XK_d:
			next  = True;
			dumpz = True;
			break;
	            case XK_s:
			next  = True;
			wait = False;
			break;
	            case XK_q:
			XDestroyWindow (d, w);
			XCloseDisplay (d);
			exit (0);
		    default:
			next = False;
		    }
		}
	    }
	    if (e.type == ButtonPress)
		next = True;		
	    if (next)
		break;
	}
    }
    if ( dump || dumpz ) {
	sprintf (cmd, "xwd -name %s -out %s_%03d.xwd", xtitle, dmpfile, page);
	system (cmd);
    }
}

/*------------------------- object ------------------------*/

void zxoopn_(objname, comment)
    char *objname, *comment;
{

}

void zxocls_(objname)
    char *objname;
{
    XFlush(d);
}

/*------------------------- line --------------------------*/

void zxswdi_(iwdidx)
    int *iwdidx;
{

/* set line width index */

    iwdidz = *iwdidx % 10;
    if (iwdidz == 0)
	iwdidz = 1;
}

void zxscli_(iclidx)
    int *iclidx;
{

/* set line color index */

    iclidz = *iclidx % MAXCLI;
    if (iclidz == 0)
	iclidz = 1;
}

void zxgopn_()
{
    XGCValues gv;

/* open graphic segment */

    gv.cap_style  = CapRound;
    gv.line_width = linewidth[iwdidz-1];
    XSetForeground (d, gc, px[iclidz]);
    XChangeGC (d, gc, GCLineWidth | GCCapStyle, &gv);
}

void zxgmov_(wx, wy)
    float *wx, *wy;
{

/* pen-up move */

    rwxold = *wx;
    rwyold = *wy;
}

void zxgplt_(wx, wy)
    float *wx, *wy;
{
    int iwxold, iwyold, iwx, iwy;
    void zxfint_();

/* pen-down move */

    zxfint_(&rwxold, &rwyold, &iwxold, &iwyold);
    zxfint_( wx,      wy,     &iwx,    &iwy   );

    if (iwxold == iwx && iwyold == iwy)
	XDrawPoint (d, ww[iwnd], gc, iwx, iwy);
    else
	XDrawLine (d, ww[iwnd], gc, iwxold, iwyold, iwx, iwy);
    rwxold = *wx;
    rwyold = *wy;
}

void zxgcls_()
{

/* close graphic segment */

}

/*------------------------- tone --------------------------*/

void zxgton_(np, wpx, wpy, itpat)
    int *np, *itpat;
    float wpx[], wpy[];
{
    static int ltfrst = TRUE, ibitold = -1;
    static XPoint p[256];
    int ipx, ipy, iclr, ibit;
    int i, nb;
    char bitmap[256];

    Pixmap pixmap;
    void zxbmcv_(), zxfint_();

/* hard fill */

    if (ltfrst) {
	gct = XCreateGC (d, w, 0, 0);
	XSetFillRule (d, gct, WindingRule);
	ltfrst = FALSE;
    }

    ibit = *itpat % 1000;
    iclr = (*itpat / 1000) % MAXCLI;
    if (iclr == 0)
	iclr = 1;

    XSetForeground (d, gct, px[iclr]);

    if (ibit != ibitold) {
	ibitold = ibit;
	nb = -1;
	if (iwtroz == 1) {
	    for (i = 0; i < nbmap; i++)
		if (ibit == nn1[i]) {
		    nb = i;
		    break;
		}
	}
	else {
	    for (i = 0; i < nbmap; i++)
		if (ibit == nn2[i]) {
		    nb = i;
		    break;
		}
	}
	if (nb >= 0) {
	    zxbmcv_(&nx[nb], &ny[nb], bmline[nb], bitmap);
	    pixmap = XCreateBitmapFromData (d, w, bitmap, nx[nb], ny[nb]);
	    XSetFillStyle (d, gct, FillStippled);
	    XSetStipple (d, gct, pixmap);
	}
	else
	    return;
    }

    for (i = 0; i < *np; i++) {
	zxfint_(&wpx[i],&wpy[i], &ipx, &ipy);
	p[i].x = ipx;
	p[i].y = ipy;
    }
    XFillPolygon (d, ww[iwnd], gct, p, *np, Complex, CoordModeOrigin);
}

/*------------------------- image -------------------------*/

void zxiopn_(iwx, iwy, iwidth, iheight)
    int *iwx, *iwy, *iwidth, *iheight;
{
    ixz = *iwx;
    iyz = *iwy;
    iwz = *iwidth;
    ihz = *iheight;
    ixxz = ixz;
    iyyz = iyz;
    printf (" *** image ");
}

void zxidat_(image, nlen)
    int *nlen, image[];
{
    int i;

    for (i = 0; i < *nlen; i++) {	
        XSetForeground (d, gc, px[image[i]]);
        XDrawPoint (d, ww[iwnd], gc, ixxz, iyyz);
	ixxz = ixxz + 1;
	if (ixxz >= ixz+iwz) {
	    ixxz = ixz;
	    iyyz = iyyz + 1;
	    if (iyyz % 16 == 0) {
		printf (".");
		fflush (stdout);
	    }
	}
    }
}

void zxicls_()
{
    printf (" end\n");
}

/*------------------------- mouse -------------------------*/

void zxqpnt_(wx, wy, mb)
    float *wx, *wy;
    int *mb;
{
    int ixl;
    unsigned char cc[1];

    XFlush(d);
    do
       XNextEvent (d, &e);
    while (e.type != ButtonPress && e.type != KeyPress);

    if (e.type == ButtonPress) {
	*wx = e.xbutton.x;
	*wy = wsywd - e.xbutton.y;
	switch (e.xbutton.button) {
	case Button1:
	    *mb = 1;
	    break;
	case Button2:
	    *mb = 2;
	    break;
	case Button3:
	    *mb = 3;
	    break;
	default:
	    *mb = 0;
	}
    }
    else {
	*wx = e.xkey.x;
	*wy = wsywd - e.xkey.y;
	ixl = XLookupString (&e.xkey , cc, 1, 0, 0);
	*mb = *cc;
    }
}

/*---------------------- transformation -------------------*/

void zxfint_(wx, wy, iwx, iwy)
    float *wx, *wy;
    int *iwx, *iwy;
{
    *iwx = *wx + 0.5;
    *iwy = wsywd - *wy + 0.5;
}

void zxiint_(iwx, iwy, wx, wy)
    float *wx, *wy;
    int *iwx, *iwy;
{
    *wx = *iwx;
    *wy = wsywd - *iwy;
}

/*------------------------- inquiry -----------------------*/

void zxqwdc_(lwdatr)
    int *lwdatr;
{

/* inquire line width capability */

    *lwdatr = LWDATR;
}

void zxqclc_(lclatr)
    int *lclatr;
{

/* inquire line color capability */

    *lclatr = lclatrz;
}

void zxqtnc_(ltnatr)
    int *ltnatr;
{

/* inquire hard fill capability */

    *ltnatr = LTNATR;
}

void zxqimc_(limatr)
    int *limatr;
{

/* inquire bit image capability */

    *limatr = LIMATR;
}

void zxqptc_(lptatr)
    int *lptatr;
{

/* inquire mouse point capability */

    *lptatr = LPTATR;
}

void zxqrct_(wsxmn, wsxmx, wsymn, wsymx, fact)
    float *wsxmn, *wsxmx, *wsymn, *wsymx, *fact;
{

/* inquire workstation rectangle */

    *wsxmn = wsxmnz;
    *wsxmx = wsxmxz;
    *wsymn = wsymnz;
    *wsymx = wsymxz;
    *fact  = FACTZ;
}

void zxsrot_(iwtrot)
    int *iwtrot;
{

/* set frame rotation flag */

    iwtroz = *iwtrot;
}

/*---------------------internal function ------------------*/

void zxbmcv_(nx, ny, bmline, bitmap)
    int *nx, *ny;
    char bmline[], bitmap[];
{
    static int n8 = 8;
    int n, nb;
    unsigned bx;

    nb = *nx * *ny / n8;
    for (n = 0; n < nb; n++){
	sscanf(&bmline[2*n], "%2x", &bx);
	bitmap[n] = bx;
    }
    bitmap[nb] = '\0';
}
