*-----------------------------------------------------------------------
*     UDPQNP / UDPQID / UDPQCP / UDPQVL / UDPSVL
*-----------------------------------------------------------------------
      SUBROUTINE UDPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=13)
      PARAMETER (IUNDEF=-999)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA      CPARA( 1)/'INDXMJ  '/, IX( 1)/3/
      DATA      CPARA( 2)/'INDXMN  '/, IX( 2)/1/
      DATA      CPARA( 3)/'ISOLID  '/, IX( 3)/1/
      DATA      CPARA( 4)/'IDASH   '/, IX( 4)/3/
      DATA      CPARA( 5)/'LDASH   '/, LX( 5)/.TRUE./
      DATA      CPARA( 6)/'LABEL   '/, LX( 6)/.TRUE./
      DATA      CPARA( 7)/'ICYCLE  '/, IX( 7)/2/
      DATA      CPARA( 8)/'NLEV    '/, IX( 8)/12/
      DATA      CPARA( 9)/'RSIZEL  '/, IX( 9)/IUNDEF/
      DATA      CPARA(10)/'RSIZET  '/, IX(10)/IUNDEF/
      DATA      CPARA(11)/'XTTL    '/, RX(11)/0.0/
      DATA      CPARA(12)/'LMSG    '/, LX(12)/.TRUE./
      DATA      CPARA(13)/'IUNDEF  '/, IX(13)/IUNDEF/

      DATA      LFIRST/.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY UDPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','UDPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UDPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','UDPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UDPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UD:',CPARA,IX,NPARA-1)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
        IF ((IDX.EQ.9 .OR. IDX.EQ.10) .AND. IPARA.EQ.IUNDEF) THEN
          CALL UZPGET('RSIZEL1',IPARA)
        END IF
      ELSE
        CALL MSGDMP('E','UDPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UDPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UD:',CPARA,IX,NPARA-1)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA-1) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','UDPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
