*-----------------------------------------------------------------------
*     INTERNAL CODE CHECK
*-----------------------------------------------------------------------

      INTEGER*4 INT1,  INT2,  INT3,   INT4
      REAL*4    R0,    RIBM1, RIEEE1, RMAX, RMIN, RMIN1, RMIN2
      CHARACTER C0*32, CA*1

*----------------------------- INTEGER*4 -------------------------------

      CALL BITPCI('01111111111111111111111111111111', INT1)
      CALL BITPCI('11111111111111111111111111111111', INT2)
      CALL BITPCI('10000000000000000000000000000000', INT3)
      CALL BITPCI('10000000000000000000000000000001', INT4)

      WRITE(6,*)
      IF(INT2.EQ.-1) THEN
        WRITE(6,'(A)')      '   INTEGER*4: COMPLEMENT NOTATION.'
        WRITE(6,'(A, I11)') '      MAX   :', INT1
        WRITE(6,'(A, I11)') '      MIN   :', INT3

      ELSEIF(INT4.EQ.-1) THEN
        WRITE(6,'(A)')      '   INTEGER*4: ABSOLUTE NOTATION.'
        WRITE(6,'(A, I11)') '      MAX   :', INT1
        WRITE(6,'(A, I11)') '      MIN   :', INT2

      ELSE
        WRITE(6,'(A)') ' ** UNKNOWN INTEGER NOTATION. **'
      ENDIF

*----------------------------- REAL*4 ----------------------------------

*                  01234567012345670123456701234567
      CALL BITPCI('11111111111111111111111111111111', R0)
      CALL BITPCI('11000001000100000000000000000000', RIBM1)
      CALL BITPCI('10111111100000000000000000000000', RIEEE1)
      R0 = 0.
      CALL BITPIC(R0, C0)

      WRITE(6,*)
      IF(RIBM1.EQ.-1.) THEN
        CALL BITPCI('01111111111111111111111111111111', RMAX)
        CALL BITPCI('00000000000100000000000000000000', RMIN)
        WRITE(6,'(A)')        '   REAL*4   : IBM NOTATION. '
        WRITE(6,'(A, E15.8)') '      MAX   :', RMAX
        WRITE(6,'(A, E15.8)') '      MIN   :', RMIN
        WRITE(6,'(A, A)')     '        0   :', C0

      ELSEIF(RIEEE1.EQ.-1.) THEN
        CALL BITPCI('01111111011111111111111111111111', RMAX)
        CALL BITPCI('00000000100000000000000000000000', RMIN1)
        CALL BITPCI('00000000000000000000000000000001', RMIN2)
        WRITE(6,'(A)')           '   REAL*4   : IEEE NOTATION. '
        WRITE(6,'(A, E15.8)')    '      MAX   :', RMAX
        WRITE(6,'(A, E15.8, A)') '      MIN   :', RMIN1, ' (NORMALIZED)'
        WRITE(6,'(A, E15.8, A)') '      MIN   :', RMIN2, 
     #                           ' (UNNORMALIZED)'
        WRITE(6,'(A, A)')        '        0   :', C0

      ELSE
        WRITE(6,'(A)') ' ** UNKNOWN REAL NOTATION. **'
      ENDIF

*----------------------------- CHARACTER -------------------------------

      IA = ICHAR('A')
      I1 = ICHAR('1')
      CA = CHAR(129)

      WRITE(6,*)
      IF(IA.EQ.65 .AND. I1.EQ.49) THEN
        WRITE(6,'(A)')    '   CHARACTER: ASCII CODE. '

      ELSEIF(IA.EQ.193.AND.I1.EQ.241) THEN
        WRITE(6,'(A)')    '   CHARACTER: EBCDIC/EBCDIK CODE. '
        WRITE(6,'(3A)')   '       CHECK THIS CHARACTER -> (', CA, ')'
        WRITE(6,'(A)')    '            LOWER CASE (A) : EBCDIC '
        WRITE(6,'(A)')    '            KATAKANA (A)   : EBCDIK '

      ELSE
        WRITE(6,'(A)') ' ** UNKNOWN CHARACTER CODE. **'
      ENDIF
      WRITE(6,*)

      STOP
      END
*-----------------------------------------------------------------------
*     BITPCI (ISHFT IS REQUIRED.)
*-----------------------------------------------------------------------
      SUBROUTINE BITPCI(CP,IP)
      CHARACTER CP*(*)

      PARAMETER (NB=32)
      INTEGER   MASK(NB)
      LOGICAL   LFST
 
      SAVE
      DATA      LFST/.TRUE./
 
      IF (LFST) THEN
        MASK(1)=1
        DO 10 I=2,NB
          MASK(I)=ISHFT(MASK(I-1),1)
   10   CONTINUE
        LFST=.FALSE.
      END IF
 
      NBC=LEN(CP)
      IP=0
      DO 15 I=1,MIN(NBC,NB)
        II=NBC-I+1
        IF (CP(II:II).NE.'0') THEN
          IP=IP+MASK(I)
        END IF
   15 CONTINUE
 
      END
*-----------------------------------------------------------------------
*     BITPIC (ISHFT & IAND ARE REQUIRED.)
*-----------------------------------------------------------------------
      SUBROUTINE BITPIC(IP,CP)
      CHARACTER CP*(*)
 
      PARAMETER (NB=32)
      INTEGER   MASK(NB)
      LOGICAL   LFST
 
      SAVE
      DATA      LFST/.TRUE./
 
      IF (LFST) THEN
        MASK(1)=1
        DO 10 I=2,NB
          MASK(I)=ISHFT(MASK(I-1),1)
   10   CONTINUE
        LFST=.FALSE.
      END IF
 
      NBC=LEN(CP)
      DO 15 I=1,MIN(NBC,NB)
        II=NBC-I+1
        IF (IAND(MASK(I),IP).EQ.0) THEN
          CP(II:II)='0'
        ELSE
          CP(II:II)='1'
        END IF
   15 CONTINUE
 
      END
