/*
 *    sgks graphic driver for Xlib (color)
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#define BORDWD 2             /* border width */
#define WSXWD  900           /* window width */
#define WSYWD  650           /* window height */
#define PAD    2.0           /* padding for workstation window */
#define IPAD   BORDWD * 2    /* padding for window */
#define WSXMNZ PAD           /* x-coord. of w.s. window lower-left  corner */
#define WSXMXZ WSXWD - PAD   /* y-coord. of w.s. window lower-left  corner */
#define WSYMNZ PAD           /* x-coord. of w.s. window upper-right corner */
#define WSYMXZ WSYWD - PAD   /* y-coord. of w.s. window upper-right corner */
#define FACTZ  0.03          /* scaling factor */
#define TRUE   1             /* numeric value for true  */
#define FALSE  0             /* numeric value for false */
#define LWDATR TRUE          /* line width capability */
#define LCLATR TRUE          /* line color capability */
#define LTNATR TRUE          /* hard fill  capability */
#define MAXWDI 9             /* maximum number of line index */
#define MAXCLI 100           /* maximum number of line color */
#define MAXBMP 300           /* maximum number of bitmaps */

static int linewidth[MAXWDI] = { 1, 2, 2, 3, 3, 4, 4, 5, 5 };
                             /* initialization for line width */
static int iwdidz, iclidz, iwtroz;
static unsigned long pl[1], px[MAXCLI];
static float rwxold, rwyold;
static Display *d;
static Window w;
static GC gc, gct;
static XEvent e;

void zxpack_()
{

/* dummy routine */

}

void zxqwdc_(lwdatr)
    int *lwdatr;
{

/* inquire line width capability */

    *lwdatr = LWDATR;
}

void zxqclc_(lclatr)
    int *lclatr;
{

/* inquire line color capability */

    *lclatr = LCLATR;
}

void zxqtnc_(ltnatr)
    int *ltnatr;
{

/* inquire hard fill capability */

    *ltnatr = LTNATR;
}

void zxqrct_(wsxmn, wsxmx, wsymn, wsymx, fact)
    float *wsxmn, *wsxmx, *wsymn, *wsymx, *fact;
{

/* inquire workstation rectangle */

    *wsxmn = WSXMNZ;
    *wsxmx = WSXMXZ;
    *wsymn = WSYMNZ;
    *wsymx = WSYMXZ;
    *fact  = FACTZ;
}

void zxsrot_(iwtrot)
    int *iwtrot;
{

/* set frame rotation flag */

    iwtroz = *iwtrot;
}

void zxdopn_()
{
    int width, height, bordcl, backcl, wsxorg, wsyorg, ncolor, n, m;
    int flags = DoRed | DoGreen | DoBlue;
    long int rx[MAXCLI], gx[MAXCLI], bx[MAXCLI];
    XSetWindowAttributes att;
    Colormap cm;
    XColor cx[MAXCLI];
    void clrx11_();
 
/* open ( and activate ) workstation */

    d = XOpenDisplay (NULL);

    if (LCLATR){
	cm = DefaultColormap (d, 0);
	if (XAllocColorCells (d, cm, True, pl, 0, px, MAXCLI)){
	    clrx11_(&ncolor, rx, gx, bx);
	    for (n = 0; n < MAXCLI; n++){
		m = n % ncolor;
		cx[n].pixel = px[n];
		cx[n].flags = flags;
		cx[n].red   = rx[m];
		cx[n].green = gx[m];
		cx[n].blue  = bx[m];
		XStoreColor (d, cm, &cx[n]);
	    }
	}
	else{
	    fprintf (stderr, "*** Error in zxdopn : ");
	    fprintf (stderr, "Allocation failed for color cells.\n");
	    exit (1);
	}
    }
    else{
	px[0] = WhitePixel (d, 0);
	for (n = 1; n < MAXCLI; n++)
	    px[n] = BlackPixel (d, 0);
    }

    width  = DisplayWidth  (d, 0);
    height = DisplayHeight (d, 0);

    wsxorg = width  - WSXWD - IPAD;
    wsyorg = height - WSYWD - IPAD;

    bordcl = px[1];
    backcl = px[0];

    w = XCreateSimpleWindow (d, RootWindow (d, 0), wsxorg, wsyorg,
			     WSXWD, WSYWD, BORDWD, bordcl, backcl);

    XStoreName (d, w, "SGKS (Xc)");

    att.backing_store = Always;
    XChangeWindowAttributes (d, w, CWBackingStore, &att);

    XSelectInput (d, w, ExposureMask | ButtonPressMask);

    XMapWindow (d, w);

    gc = XCreateGC (d, w, 0, 0);

    do
	XNextEvent (d, &e);
    while (e.type != ButtonPress);
}
    
void zxpopn_()
{
 
/* open page ( or screen ) */
 
    iwdidz = 1;
    iclidz = 1;
}
 
void zxswdi_(iwdidx)
    int *iwdidx;
{
 
/* set line width index */
 
    iwdidz = *iwdidx % 10;
    if (iwdidz == 0) iwdidz = 1;
}

void zxscli_(iclidx)
    int *iclidx;
{

/* set line color index */

    iclidz = *iclidx % MAXCLI;
    if (iclidz == 0) iclidz = 1;
}

void zxgopn_()
{
    XGCValues gv;

/* open graphic segment */

    gv.line_width = linewidth[iwdidz-1];
    XSetForeground (d, gc, px[iclidz]);
    XChangeGC (d, gc, GCLineWidth, &gv);
}

void zxgmov_(wx, wy)
    float *wx, *wy;
{
 
/* pen-up move */

    rwxold = *wx;
    rwyold = *wy;
}

void zxgplt_(wx, wy)
    float *wx, *wy;
{
    int iwxold, iwyold, iwx, iwy;

/* pen-down move */

    iwxold = rwxold;
    iwyold = WSYWD - rwyold;
    iwx = *wx;
    iwy = WSYWD - *wy;
    if (iwxold == iwx && iwyold == iwy)
	XDrawPoint (d, w, gc, iwx, iwy);
    else
	XDrawLine (d, w, gc, iwxold, iwyold, iwx, iwy);
    rwxold = *wx;
    rwyold = *wy;
}

void zxgcls_()
{
 
/* close graphic segment */

}

void zxgton_(np, wpx, wpy, itpat)
    int *np, *itpat;
    float wpx[], wpy[];
{
    static int ltfrst = TRUE, ibitold = -1;
    static int nbmap, nn1[MAXBMP], nn2[MAXBMP], nx[MAXBMP], ny[MAXBMP];
    static char bmline[MAXBMP][260];
    static XPoint p[256];
    int ipx, ipy, iclr, ibit;
    int i, nb;
    char bitmap[256];
    Pixmap pixmap;
    void bmrx11_(), bmvx11_();
 
/* hard fill */

    if (ltfrst) {
	gct = XCreateGC (d, w, 0, 0);
	XSetFillRule (d, gct, WindingRule);
	bmrx11_(&nbmap, nn1, nn2, nx, ny, bmline);
	ltfrst = FALSE;
    }

    ibit = *itpat % 1000;
    iclr = (*itpat / 1000) % MAXCLI;
    if (iclr == 0) iclr = 1;

    XSetForeground (d, gct, px[iclr]);

    if (ibit != ibitold){
	ibitold = ibit;
	nb = -1;
	if (iwtroz == 1){
	    for (i = 0; i < nbmap; i++)
		if (ibit == nn1[i]){
		    nb = i;
		    break;
		}
	}
	else{
	    for (i = 0; i < nbmap; i++)
		if (ibit == nn2[i]){
		    nb = i;
		    break;
		}
	}
	if (nb >= 0){
	    bmvx11_(&nx[nb], &ny[nb], bmline[nb], bitmap);
	    pixmap = XCreateBitmapFromData (d, w, bitmap, nx[nb], ny[nb]);
	    XSetFillStyle (d, gct, FillStippled);
	    XSetStipple (d, gct, pixmap);
	}
	else
	    return;
    }

    for (i = 0; i < *np; i++){
	ipx = wpx[i];
	ipy = WSYWD - wpy[i];
	p[i].x = ipx;
	p[i].y = ipy;
    }
    XFillPolygon (d, w, gct, p, *np, Complex, CoordModeOrigin);
}

void
zxpcls_()
{
 
/* close page ( or screen ) */

    do
	XNextEvent (d, &e);
    while (e.type != ButtonPress);
    XClearWindow (d, w);
}

void
zxdcls_()
{

/* ( deactivate and ) close workstation */

    XDestroyWindow (d, w);
    XCloseDisplay (d);
} 
