/*-----------------------------------------------------------------------
 *     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
 *----------------------------------------------------------------------*/

#include <stdlib.h>

static float **cxs, **cys;

/*--- PRIVATE ---*/
static float **alloc_2d(n, m)  
     int n, m;
{
    /* Allocate a 2D array of shape [n][m].
     * Use free_2d to free the array */
    float **b;
    int i;
    b = (float **)malloc((size_t) n*sizeof(float*));
    b[0] = (float *)malloc((size_t) n*m*sizeof(float));
    for(i=1;i<n;i++) {b[i] = b[i-1]+m;}
    return(b);
}
static void free_2d(b)
    double **b;
{
    free(b[0]);
    free(b);
}

/*--- PUBLIC ---*/
void g2qgrd_(i, j, cx11, cx21, cx12, cx22, cy11, cy21, cy12, cy22)
     int *i, *j;
     float *cx11, *cx21, *cx12, *cx22;
     float *cy11, *cy21, *cy12, *cy22;
{
    /* NOTE: C indices are 1 smaller than Fortran indices */
    *cx11 = cxs[*j-1][*i-1];
    *cx21 = cxs[*j-1][*i];
    *cx12 = cxs[*j][*i-1];
    *cx22 = cxs[*j][*i];
    *cy11 = cys[*j-1][*i-1];
    *cy21 = cys[*j-1][*i];
    *cy12 = cys[*j][*i-1];
    *cy22 = cys[*j][*i];
}

void g2sgrd_(rundef, iuxinc, iuyinc, nx, ny, cx, cy, uxs, uys)
     float *rundef;
     int *iuxinc, *iuyinc, *nx, *ny;
     float *cx, *cy, *uxs, *uys;
{
    static int first = 1;
    int i,j;
    int cxundef, cyundef;

    /* free if not first time */
    if(!first){
	free_2d(cxs);
	free_2d(cys);
    }

    /* store CX and CY */

    cxs = alloc_2d(*ny, *nx);
    cys = alloc_2d(*ny, *nx);
    first = 0;

    if (cx[0]==(*rundef)) {
	/* Assume cx[j][i] == ux[i] */
	cxundef = 1;
	for(j=0;j<*ny;j++){
	    for(i=0;i<*nx;i++){
		cxs[j][i] = uxs[i];
	    }
	}
    } else {
	cxundef = 0;
    }

    if (cy[0]==(*rundef)) {
	/* Assume cy[j][i] == uy[j] */
	cyundef = 1;
	for(j=0;j<*ny;j++){
	    for(i=0;i<*ny;i++){
		cys[j][i] = uys[j];
	    }
	}
    } else {
	cyundef = 0;
    }

    if((*iuxinc) && (*iuyinc) ){
	for(j=0;j<*ny;j++){
	    for(i=0;i<*nx;i++){
		if(!cxundef) cxs[j][i] = cx[*nx*j+i];
		if(!cyundef) cys[j][i] = cy[*nx*j+i];
	    }
	}
    } else if ( !(*iuxinc) && (*iuyinc) ) {
	for(j=0;j<*ny;j++){
	    for(i=0;i<*nx;i++){
		if(!cxundef) cxs[j][*nx-1-i] = cx[*nx*j+i];
		if(!cyundef) cys[j][*nx-1-i] = cy[*nx*j+i];
	    }
	}
    } else if ( (*iuxinc) && !(*iuyinc) ) {
	for(j=0;j<*ny;j++){
	    for(i=0;i<*nx;i++){
		if(!cxundef) cxs[*ny-1-j][i] = cx[*nx*j+i];
		if(!cyundef) cys[*ny-1-j][i] = cy[*nx*j+i];
	    }
	}
    } else {
	for(j=0;j<*ny;j++){
	    for(i=0;i<*nx;i++){
		if(!cxundef) cxs[*ny-1-j][*nx-1-i] = cx[*nx*j+i];
		if(!cyundef) cys[*ny-1-j][*nx-1-i] = cy[*nx*j+i];
	    }
	}
    }

}
