*-----------------------------------------------------------------------
*     TMSTLN : THE ROUTINE FOR DRAWING STREAM LINES
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2012 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLN( X, Y, U, V, NX, NY )

      IMPLICIT NONE

      COMMON  /STBLK1/ THRES, SKIP
      COMMON  /STBLK2/ ARROW_THRES

*-- AGREENMENT
      INTEGER NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL    U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL    V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL    X(NX)     !* GRID POINTS OF X-DIRECTION [UNIT:LENGTH]
      REAL    Y(NY)     !* GRID POINTS OF Y-DIRECTION [UNIT:LENGTH]

*-- PARAMETER VALUES OF STPACK
      INTEGER THRES
      INTEGER SKIP
      REAL    ARROW_THRES

*-- INTERNAL VARIABLES
      REAL    TRX(NX*NY,NX*NY)  !* STREAM LINE OF X-COORDINATE
      REAL    TRY(NX*NY,NX*NY)  !* STREAM LINE OF Y-COORDINATE
      INTEGER I, J, K           !* TMP VALUES
      INTEGER COUNTER           !* NUMBER OF STREAM LINE
      INTEGER NM(NX*NY)         !* ARRAY NUMBER IN EACH STREAM LINE
      INTEGER GRID_NUM(NX,NY)
      REAL    DT, DXA, DYA
      REAL    MAXV, MINR
      REAL    VTMP, XTMP
      REAL    ARROW_LENG
      REAL    UNDEF             !* UNDEFINED VALUE FOR DCL
      REAL    TMPX(NX*NY)
      REAL    TMPY(NX*NY)

      CALL GLRGET( 'RMISS', UNDEF )
      CALL TMVGET( THRES, SKIP, ARROW_THRES )  !* STPACK GETTING ROUTINE
      WRITE(*,*) "TMSTLN CHECK", THRES, SKIP, ARROW_THRES, UNDEF

*-- INITIALIZING GRID_NUM (COUNTER FOR PASSING STREAM LINES IN EACH GRID)
*-- ʻ̲ήΥѿ
      DO 11 J=1,NY
         DO 10 I=1,NX
            GRID_NUM(I,J)=0
 10      CONTINUE
 11   CONTINUE

      COUNTER=1

*-- DETERMINING "DT" (DT=DXMIN/VMAX)
*-- ʲή׻κݤʬˤ
*-- CFL Τ褦ʤΤꤹ.
      MAXV=0.0

      DO 31 J=1,NY
         DO 30 I=1,NX
            IF(U(I,J).NE.UNDEF.AND.V(I,J).NE.UNDEF)THEN
               VTMP=SQRT(U(I,J)**2+V(I,J)**2)
               IF(VTMP.GT.MAXV)THEN
                  MAXV=VTMP
               END IF
            END IF
 30      CONTINUE
 31   CONTINUE

      MINR=X(2)-X(1)

      DO 40 I=2,NX
         XTMP=X(I)-X(I-1)
         IF(XTMP.LT.MINR)THEN
            MINR=XTMP
         END IF
 40   CONTINUE

      DO 41 J=2,NY
         XTMP=Y(J)-Y(J-1)
         IF(XTMP.LT.MINR)THEN
            MINR=XTMP
         END IF
 41   CONTINUE

*-- ʾε CFL 狼ʬƥåפ.
      DT=MINR/MAXV

*-- STARTING TO CALCULATE STREAM LINES.
*-- IN 1ST STEP : STARTING POINT IS THE ENDS OF DRAWING REGION.
*-- ʲ, ή׻
*-- ΰüή׻򳫻Ϥ.
      DO 50 I=1,NX
         IF(MOD((I-1),SKIP).EQ.0)THEN
            IF(U(I,1).NE.0.0.OR.V(I,1).NE.0.0)THEN
               CALL TMSLCL( DT, NX*NY, X(I), Y(1), NX, NY, X, Y, U, V,
     &                      UNDEF, TRX(:,COUNTER), TRY(:,COUNTER),
     &                      NM(COUNTER), GRID_NUM, THRES )
               IF(TRX(1,COUNTER).NE.X(I).OR.TRY(1,COUNTER).NE.Y(1))THEN
                  TRX(1,COUNTER)=X(I)
                  TRY(1,COUNTER)=Y(1)
               END IF
            ELSE  !* ʻ®ʤ TMSLCL ʤ.
               TRX(1,COUNTER)=X(I)
               TRY(1,COUNTER)=Y(1)
               NM(COUNTER)=1
            END IF
            COUNTER=COUNTER+1
         END IF
 50   CONTINUE

      DO 52 I=1,NX
         IF(MOD((I-1),SKIP).EQ.0)THEN
            IF(U(I,1).NE.0.0.OR.V(I,1).NE.0.0)THEN
!               CALL TMSLCL( DT, NX*NY, X(I), Y(NY)-(Y(NY)-Y(NY-1))*0.5,
               CALL TMSLCL( DT, NX*NY, X(I), Y(NY), NX, NY, X, Y, U, V,
     &                      UNDEF, TRX(:,COUNTER), TRY(:,COUNTER),
     &                      NM(COUNTER), GRID_NUM, THRES )
!               IF(TRX(1,COUNTER).NE.X(I).OR.
!     &            TRY(1,COUNTER).NE.Y(NY)-(Y(NY)-Y(NY-1))*0.5)THEN
               IF(TRX(1,COUNTER).NE.X(I).OR.
     &            TRY(1,COUNTER).NE.Y(NY))THEN
                  TRX(1,COUNTER)=X(I)
!                  TRY(1,COUNTER)=Y(NY)-(Y(NY)-Y(NY-1))*0.5
                  TRY(1,COUNTER)=Y(NY)
               END IF
*               WRITE(*,*) X(I), Y(NY), TRX(1,COUNTER), TRY(1,COUNTER)
            ELSE  !* ʻ®ʤ TMSLCL ʤ.
               TRX(1,COUNTER)=X(I)
               TRY(1,COUNTER)=Y(1)
               NM(COUNTER)=1
            END IF
            COUNTER=COUNTER+1
         END IF
 52   CONTINUE

      DO 54 J=1,NY
         IF(MOD((J-1),SKIP).EQ.0)THEN
            IF(U(1,J).NE.0.0.OR.V(1,J).NE.0.0)THEN
               CALL TMSLCL( DT, NX*NY, X(1), Y(J), NX, NY, X, Y, U, V,
     &                      UNDEF, TRX(:,COUNTER), TRY(:,COUNTER),
     &                      NM(COUNTER), GRID_NUM, THRES )
               IF(TRX(1,COUNTER).NE.X(1).OR.TRY(1,COUNTER).NE.Y(J))THEN
                  TRX(1,COUNTER)=X(1)
                  TRY(1,COUNTER)=Y(J)
               END IF
            ELSE  !* ʻ®ʤ TMSLCL ʤ.
               TRX(1,COUNTER)=X(1)
               TRY(1,COUNTER)=Y(J)
               NM(COUNTER)=1
            END IF
            COUNTER=COUNTER+1
         END IF
 54   CONTINUE

      DO 56 J=1,NY
         IF(MOD((J-1),SKIP).EQ.0)THEN
            IF(U(NX,J).NE.0.0.OR.V(NX,J).NE.0.0)THEN
!               CALL TMSLCL( DT, NX*NY, X(NX)-(X(NX)-X(NX-1))*0.5, Y(I),
               CALL TMSLCL( DT, NX*NY, X(NX), Y(J),
     &                      NX, NY, X, Y, U, V, UNDEF,
     &                      TRX(:,COUNTER), TRY(:,COUNTER), NM(COUNTER),
     &                      GRID_NUM, THRES )
!               IF(TRX(1,COUNTER).NE.X(NX)-(X(NX)-X(NX-1))*0.5.OR.
               IF(TRX(1,COUNTER).NE.X(NX).OR.
     &            TRY(1,COUNTER).NE.Y(J))THEN
!                  TRX(1,COUNTER)=X(NX)-(X(NX)-X(NX-1))*0.5
                  TRX(1,COUNTER)=X(NX)
                  TRY(1,COUNTER)=Y(J)
               END IF
            ELSE  !* ʻ®ʤ TMSLCL ʤ.
               TRX(1,COUNTER)=X(NX)
               TRY(1,COUNTER)=Y(J)
               NM(COUNTER)=1
            END IF
            COUNTER=COUNTER+1
         END IF
 56   CONTINUE

*-- 2ND STEP : STARTING POINT IS THE INNER DRAWING REGION.
*-- DETERMINING STARTING POINT BY USING A PARAMETER VALUE "SKIP".
*-- ΰζή׻Ԥ.
*-- GRID_NUM ˤä, ̲ᤷƤʤʻҤϸƤΤ, 
*-- γʻҤˤĤ SKIP ֳ֤ή׻Ԥ.
      DO 61 J=2,NY-1
         IF(MOD((J-1),SKIP).EQ.0)THEN
            DO 60 I=2,NX-1
               IF(MOD((I-1),SKIP).EQ.0)THEN
                  IF(U(I,J).NE.0.0.OR.V(I,J).NE.0.0)THEN
                     IF(GRID_NUM(I,J).LE.THRES)THEN
                        CALL TMSLCL( DT, NX*NY, X(I), Y(J), NX, NY, 
     &                               X, Y, U, V, UNDEF, TRX(:,COUNTER),
     &                               TRY(:,COUNTER), NM(COUNTER),
     &                               GRID_NUM, THRES )
                        IF(TRX(1,COUNTER).NE.X(I).OR.
     &                     TRY(1,COUNTER).NE.Y(J))THEN
                           TRX(1,COUNTER)=X(I)
                           TRY(1,COUNTER)=Y(J)
                        END IF
                    
                        COUNTER=COUNTER+1

*-- CALCULATING INVERSE DIRECTION.
*-- "TMSLCL" CAN CALCULATE FORWARD DIRECTION FOR "DT>0",
*-- BACKWARD DIRECTION FOR "DT<0".
*-- ήΰǳϤƤΤ, ոˤ׻.
*-- DT ĤƵõ.
*-- GRID_NUM(I,J) ׻ǥȤƤΤ, ΥȤ򳰤Ƥ
                        GRID_NUM(I,J)=GRID_NUM(I,J)-1

                        CALL TMSLCL( -DT, NX*NY, X(I), Y(J), NX, NY,
     &                               X, Y, U, V, UNDEF, TMPX(:),
     &                               TMPY(:), NM(COUNTER),
     &                               GRID_NUM, THRES )

                        IF(TMPX(1).NE.X(I).OR.
     &                     TMPY(1).NE.Y(J))THEN
                           TMPX(1)=X(I)
                           TMPY(1)=Y(J)
                        END IF

*-- շ׻ʬ TRX, TRY ˳Ǽ.
*-- , ո׻ʤΤ, ϵդ.
                        IF(NM(COUNTER).GT.1)THEN
                           DO 62 K=1,NM(COUNTER)
                              TRX(K,COUNTER)=TMPX(NM(COUNTER)-K+1)
                              TRY(K,COUNTER)=TMPY(NM(COUNTER)-K+1)
 62                        CONTINUE
                        END IF
                     END IF

                  ELSE  !* ʻ®ʤ TMSLCL ʤ.
                     TRX(1,COUNTER)=X(I)
                     TRY(1,COUNTER)=Y(J)
                     NM(COUNTER)=1
                  END IF
                  COUNTER=COUNTER+1
               END IF
 60         CONTINUE
         END IF
 61   CONTINUE

*-- SETTING PARAMETER FOR ARROW. (NOW, CONSTANT VALUES)
      CALL SGLSET('LPROP',.FALSE.)
      CALL SGRSET('CONST',0.01)

*-- DRAWING STREAM LINES
      DO 81 I=1,COUNTER
         IF(NM(I).GT.1)THEN
            CALL UULIN( NM(I), TRX(1:NM(I),I), TRY(1:NM(I),I) )
         END IF

*-- CALCULATING THE INTERVAL LENGTH OF DRAWING ARROWS.
         ARROW_LENG=0.0
         DO 80 J=2,NM(I)
            DXA=TRX(J,I)-TRX(J-1,I)
            DYA=TRY(J,I)-TRY(J-1,I)
            ARROW_LENG=ARROW_LENG+SQRT(DXA*DXA+DYA*DYA)
            IF(ARROW_LENG.GE.ARROW_THRES)THEN
               CALL SGLAU( TRX(J-1,I), TRY(J-1,I), TRX(J,I), TRY(J,I) )
               ARROW_LENG=0.0
            END IF
 80      CONTINUE
 81   CONTINUE

      END SUBROUTINE TMSTLN


*      SUBROUTINE PSSCHK( NX, NY, NT, X, Y, TRX, TRY, SKIP, FLAG )
*      IMPLICIT NONE
*      INTEGER NX
*      INTEGER NY
*      INTEGER NT
*      REAL X(NX)
*      REAL Y(NY)
*      REAL TRX(NT)
*      REAL TRY(NT)
*      INTEGER SKIP
*      LOGICAL FLAG(NX,NY)
*      INTEGER I, J, K, L
*      REAL INTVX(2), INTVY(2)
*    
*      DO 12 J=2,NY-1
*         IF(MOD((J-1),SKIP).EQ.0)THEN
*            INTVY(1)=Y(J-1)+(Y(J)-Y(J-1))*0.5
*            INTVY(2)=Y(J)+(Y(J+1)-Y(J))*0.5
*            DO 11 I=2,NX-1
*               IF(MOD((J-1),SKIP).EQ.0)THEN
*                  INTVX(1)=X(I-1)+(X(I)-X(I-1))*0.5
*                  INTVX(2)=X(I)+(X(I+1)-X(I))*0.5
*                  IF(FLAG(I,J).EQV..FALSE.)THEN
*                     DO 10 L=1,NT
*                        IF(INTVX(1).LE.TRX(L).AND.INTVX(2).GT.TRX(L).AND.
*     &                     INTVY(1).LE.TRY(L).AND.INTVY(2).GT.TRY(L))THEN
*                           FLAG(I,J)=.TRUE.
*                           EXIT
*                        END IF
* 10                  CONTINUE
*                  END IF
*               END IF
* 11         CONTINUE
*         END IF
* 12   CONTINUE
*
*      END SUBROUTINE PSSCHK

