program benard
  use analy
  use alge_solv
  use dcl
  use Dcl_Automatic
  implicit none
!-- namelist values
  integer :: nx, nz, nt
  real :: xmin, zmin, dx, dz, dt
  character(80) :: fname

!-- scale parameter
  real :: length, time, 

!-- predictive values
  real, allocatable, dimension(:,:) :: u, w, temp, temppt, tempbar, rho,  &
  &     rhobar, rhopt, omega, momega, psi
  real, allocatable, dimension(:,:) :: new_u, new_w, new_temp, new_tempbar,  &
  &     new_temppt, new_rho, new_rhobar, new_rhopt, new_omega, new_momega
  real, allocatable, dimension(:,:) :: grad_tx, grad_tz, grad_ox, grad_oz,  &
  &     grad2_o, grad2_t
  real :: kappa, g, alpha, beta, nu, pr, r
  integer :: i, j, k

  namelist /input /nx, nz, nt, xmin, dx, dz, dt, fname
  read(5,nml=input)

  allocate(x(nx))
  allocate(z(nz))
  allocate(u(nx,nz))
  allocate(w(nx,nz))
  allocate(temp(nx,nz))
  allocate(temppt(nx,nz))
  allocate(tempbar(nx,nz))
  allocate(rho(nx,nz))
  allocate(rhobar(nx,nz))
  allocate(rhopt(nx,nz))
  allocate(omega(nx,nz))
  allocate(momega(nx,nz))
  allocate(psi(nx,nz))
  allocate(new_u(nx,nz))
  allocate(new_w(nx,nz))
  allocate(new_temp(nx,nz))
  allocate(new_tempbar(nx,nz))
  allocate(new_temppt(nx,nz))
  allocate(new_rho(nx,nz))
  allocate(new_rhobar(nx,nz))
  allocate(new_rhopt(nx,nz))
  allocate(new_omega(nx,nz))
  allocate(new_momega(nx,nz))
  allocate(grad_tx(nx,nz))
  allocate(grad_tz(nx,nz))
  allocate(grad_ox(nx,nz))
  allocate(grad_oz(nx,nz))
  allocate(grad2_t(nx,nz))
  allocate(grad2_o(nx,nz))

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  z=(/((-dz*(nz-i)),i=1,nz)/)

!-- initial condition

  omega=0.0
  psi=0.0
  u=0.0
  v=0.0

  call curl( x, z, u, v, omega )
  call Poisson_Jacobi( )

  call read_file( 'fname', nx, nz, 1, temp )

  call DclOpenGraphics(4)

!-- step count
  do k=1,nt
!-- x direction gradient
     do j=1,nz
        grad_1d( x, pres(:,j), grad_px(:,j) )
        grad_1d( x, u(:,j), grad_ux(:,j) )
        grad_1d( x, w(:,j), grad_wx(:,j) )
        grad_1d( x, temp(:,j), grad_tx(:,j) )
     end do

!-- z direction gradient
!-- each term calc
!-- 1. u\nabla T
     call grad_2d( x, z, temppt, grad_tx, grad_tz )
     do j=1,nz-1
        do i=1,nx-1
           udT(i,j)=(0.5*(u(i,j)+u(i+1,j)))*grad_tx(i,j)
           wdT(i,j)=(0.5*(w(i,j)+w(i,j+1)))*grad_tz(i,j)
        end do
     end do

!-- 2. \nabla ^2T
     call laplacian_2d( x, z, temppt, grad2_t )

!-- 3. u\nabla \omega
     call grad_2d( x, z, omega, grad_ox, grad_oz )
     do j=1,nz-1
        do i=1,nx-1
           udo(i,j)=(0.5*(u(i,j)+u(i+1,j)))*grad_ox(i,j)
           wdo(i,j)=(0.5*(w(i,j)+w(i,j+1)))*grad_oz(i,j)
        end do
     end do

!-- 4. \nabla ^2T
     call laplacian_2d( x, z, omega, grad2_o )

!-- 5. time step calc
     do j=1,nz-1
        do i=1,nx-1
           new_temppt(i,j)=temppt(i,j)-udT(i,j)-wdT(i,j)+grad2_t(i,j)
           new_omega(i,j)=omega(i,j)-udo(i,j)-wdo(i,j)+pr*grad2_o(i,j)  &
  &                       +pr*r*grad_tx(i,j)
        end do
     end do

!-- 6. omega to psi
     momega=-omega
     call Poisson_Jacobi( x, z, momega, 1.e-7, 1, bound_opt=boundary_val,  &
  &                       psi )

!-- 7. u, v calc
     call grad_1d( z, psi, u )
     call grad_1d( x, psi, w )

     w=-w



  end do

  end DclCloseGraphics

end program
