module force_solv
! ׻⥸塼
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use complex_initialize
  use mpi

contains

subroutine force()

  implicit none

  integer :: i, j

  !-- ν
  call complex_init( forceu )
  call complex_init( forcev )
  call complex_init( forceh )
!     do j=1,hnt+1
!        do i=1,nr
!           forceu(i,j)=(0.0,0.0)
!           forcev(i,j)=(0.0,0.0)
!           forceh(i,j)=(0.0,0.0)
!        end do
!     end do

!-- ڥȥѿʬ

!-- ֤ν°ѿζʬ׻

  call grad_1d( rv, ub, dubdr )
  call grad_1d( rs, hb, dhbdr )
  call grad_1d( rv, vb, dvbdr )

  !-- ܾΰή

  do i=1,nr
     ubdub(i)=ub(i)*dubdr(i)
     ubdvb(i)=ub(i)*dvbdr(i)
     ubdhb(i)=ub(i)*dhbdr(i)
     vbdub(i)=vb(i)*dubdr(i)
     vbdvb(i)=vb(i)*dvbdr(i)
     vbdhb(i)=vb(i)*dhbdr(i)
     hbdub(i)=hb(i)*dubdr(i)
     hbdvb(i)=hb(i)*dvbdr(i)
     hbdhb(i)=hb(i)*dhbdr(i)
  end do

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,hnt+1

     call complex_grad_1d( rs, hcp_old(:,j), dhcpdr(:,j) )
     call complex_grad_1d( rv, ucp_old(:,j), ducpdr(:,j) )
     call complex_grad_1d( rv, vcp_old(:,j), dvcpdr(:,j) )

     !-- ήη׻ (Τ)

     do i=1,nr
        updub(i,j)=ucp_old(i,j)*dubdr(i)
        vpdub(i,j)=vcp_old(i,j)*dubdr(i)
        hpdub(i,j)=hcp_old(i,j)*dubdr(i)
        updvb(i,j)=ucp_old(i,j)*dvbdr(i)
        vpdvb(i,j)=vcp_old(i,j)*dvbdr(i)
        hpdvb(i,j)=hcp_old(i,j)*dvbdr(i)
        updhb(i,j)=ucp_old(i,j)*dhbdr(i)
        vpdhb(i,j)=vcp_old(i,j)*dhbdr(i)
        hpdhb(i,j)=hcp_old(i,j)*dhbdr(i)
        ubdup(i,j)=ub(i)*ducpdr(i,j)
        ubdvp(i,j)=ub(i)*dvcpdr(i,j)
        ubdhp(i,j)=ub(i)*dhcpdr(i,j)
        vbdup(i,j)=vb(i)*ducpdr(i,j)
        vbdvp(i,j)=vb(i)*dvcpdr(i,j)
        vbdhp(i,j)=vb(i)*dhcpdr(i,j)
        hbdup(i,j)=hb(i)*ducpdr(i,j)
        hbdvp(i,j)=hb(i)*dvcpdr(i,j)
        hbdhp(i,j)=hb(i)*dhcpdr(i,j)
     end do

     !-- ꥪη׻

     do i=1,nr
        corilu(i,j)=coril(i,j)*(ub(i)+ucp_old(i,j))
        corilv(i,j)=coril(i,j)*vcp_old(i,j)
     end do

     !-- 쥤꡼ԥ󥰹η׻

     do i=1,nr
        eup(i,j)=-epsu(i)*ucp_old(i,j)
        evp(i,j)=-epsv(i)*vcp_old(i,j)
        ehp(i,j)=-epsh(i)*hcp_old(i,j)
     end do

     !-- ѷη׻

     do i=1,nr
        ubup(i,j)=ub(i)*ucp_old(i,j)
        ubvp(i,j)=ub(i)*vcp_old(i,j)
        ubhp(i,j)=ub(i)*hcp_old(i,j)
        vbup(i,j)=vb(i)*ucp_old(i,j)
        vbvp(i,j)=vb(i)*vcp_old(i,j)
        vbhp(i,j)=vb(i)*hcp_old(i,j)
        hbup(i,j)=hb(i)*ucp_old(i,j)
        hbvp(i,j)=hb(i)*vcp_old(i,j)
        hbhp(i,j)=hb(i)*hcp_old(i,j)
     end do
  end do
!$omp end do
!$omp end parallel

  !-- ήη׻
  !-- ιη׻˻֤뤿, flag Ƿ׻ʤʤ餹äȤФ.

  if(force_flag(5:5)=='o')then  ! 
     !-- ɾ
     call complex_init( fup )
     call complex_init( fvp )
     call complex_init( fhp )
     call complex_init( fdupdr )
     call complex_init( fdvpdr )
     call complex_init( fdhpdr )
     call complex_init( fdupdt )
     call complex_init( fdvpdt )
     call complex_init( fdhpdt )
     call complex_init( frup )
     call complex_init( frvp )
     call complex_init( frhp )
     call complex_init( frdupdr )
     call complex_init( frdvpdr )
     call complex_init( frdhpdr )
     call complex_init( frdupdt )
     call complex_init( frdvpdt )
     call complex_init( frdhpdt )
     call complex_init( fupvp )
     call complex_init( fuphp )
     call complex_init( fvpvp )
     call complex_init( fupdup )
     call complex_init( fupdvp )
     call complex_init( fupdhp )
     call complex_init( fvpdup )
     call complex_init( fvpdvp )
     call complex_init( fvpdhp )
     call complex_init( fhpdup )
     call complex_init( fhpdvp )
     call complex_init( fhpdhp )
     call complex_init( fiupvp )
     call complex_init( fiuphp )
     call complex_init( fivpvp )
     call complex_init( fiupdup )
     call complex_init( fiupdvp )
     call complex_init( fiupdhp )
     call complex_init( fivpdup )
     call complex_init( fivpdvp )
     call complex_init( fivpdhp )
     call complex_init( fihpdup )
     call complex_init( fihpdvp )

     !-- ڥȥѿѴˡѤγĥ֤
     do i=2,nr-1  ! j=1 ̽
        fup(i,1)=ucp_old(i,1)  ! ȾʬѴˡȾʬ
        fvp(i,1)=vcp_old(i,1)
        fhp(i,1)=hcp_old(i,1)
        fdupdr(i,1)=ducpdr(i,1)
        fdvpdr(i,1)=dvcpdr(i,1)
        fdhpdr(i,1)=dhcpdr(i,1)
        fdupdt(i,1)=(0.0,0.0)  ! theta ʬˤĤȿϥ.
        fdvpdt(i,1)=(0.0,0.0)
        fdhpdt(i,1)=(0.0,0.0)
     end do

     do j=2,hnt+1
        do i=2,nr-1
           fup(i,j)=ucp_old(i,j)  ! ȾʬѴˡȾʬ
           fvp(i,j)=vcp_old(i,j)
           fhp(i,j)=hcp_old(i,j)
!           fdupdr(i,j)=ducpdr(i,j)
!           fdvpdr(i,j)=dvcpdr(i,j)
!           fdhpdr(i,j)=dhcpdr(i,j)
           fdupdt(i,j)=img*real(j-1)*ucp_old(i,j)
           fdvpdt(i,j)=img*real(j-1)*vcp_old(i,j)
           fdhpdt(i,j)=img*real(j-1)*hcp_old(i,j)
           fup(i,jnt-j+2)=conjg(ucp_old(i,j))   ! ȾʬѴˡ
                          ! θȾȾʬ, ξüϤޤ
           fvp(i,jnt-j+2)=conjg(vcp_old(i,j))
           fhp(i,jnt-j+2)=conjg(hcp_old(i,j))
!           fdupdr(i,jnt-j+2)=conjg(fdupdr(i,j))
!           fdvpdr(i,jnt-j+2)=conjg(fdvpdr(i,j))
!           fdhpdr(i,jnt-j+2)=conjg(fdhpdr(i,j))
           fdupdt(i,jnt-j+2)=conjg(fdupdt(i,j))
           fdvpdt(i,jnt-j+2)=conjg(fdvpdt(i,j))
           fdhpdt(i,jnt-j+2)=conjg(fdhpdt(i,j))
        end do
     end do

     !-- ڥȥѿ¶֤֤
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i)
     do i=2,nr-1
        call ffttp_1d( jnt, fup(i,:), frup(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fvp(i,:), frvp(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fhp(i,:), frhp(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
! ʲ,  fr?p ưʬȤ뤳Ȥ FFT 򤹤.
!        call ffttp_1d( jnt, fdupdr(i,:), frdupdr(i,:), 'i', prim='o' )
!        call ffttp_1d( jnt, fdvpdr(i,:), frdvpdr(i,:), 'i', prim='o' )
!        call ffttp_1d( jnt, fdhpdr(i,:), frdhpdr(i,:), 'i', prim='o' )
        call ffttp_1d( jnt, fdupdt(i,:), frdupdt(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fdvpdt(i,:), frdvpdt(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fdhpdt(i,:), frdhpdt(i,:), 'i', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_ni(0:jnt-1,0:jnt-1) )
     end do
!$omp end do
!$omp end parallel

     !-- 
     !-- ѿ̾Ȥ, vpd?? Ϥ٤ theta ʬɽΤ,
     !-- ѿȤƤ ik * ?? ȤǷ׻.
     !-- , upd?? Ϥ٤ r ʬɽΤ, Τޤ޳ݤ.
     !-- ʤ, theta ʬ 1/r ϳƹ׻ΤȤ˳ݤ
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
     do j=1,jnt
        call complex_grad_1d( rv, frup(:,j), frdupdr(:,j) )
        call complex_grad_1d( rv, frvp(:,j), frdvpdr(:,j) )
        call complex_grad_1d( rs, frhp(:,j), frdhpdr(:,j) )
        do i=2,nr-1
           fupdup(i,j)=frup(i,j)*frdupdr(i,j)
           fupdvp(i,j)=frup(i,j)*frdvpdr(i,j)
           fupdhp(i,j)=frup(i,j)*frdhpdr(i,j)
           fvpdup(i,j)=frvp(i,j)*frdupdt(i,j)
           fvpdvp(i,j)=frvp(i,j)*frdvpdt(i,j)
           fvpdhp(i,j)=frvp(i,j)*frdhpdt(i,j)
           fhpdup(i,j)=frhp(i,j)*frdupdr(i,j)
           fhpdvp(i,j)=frhp(i,j)*frdvpdt(i,j)  ! ι theta ʬʤ
!           fhpdhp(i,j)=frhp(i,j)*frdhpdr(i,j)
           fupvp(i,j)=frup(i,j)*frvp(i,j)
           fuphp(i,j)=frup(i,j)*frhp(i,j)
           fvpvp(i,j)=frvp(i,j)*frvp(i,j)
        end do
     end do
!$omp end do
!$omp end parallel

     !-- ڥȥ֤֤ľ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i)
     do i=2,nr-1
        call ffttp_1d( jnt, fupdup(i,:), fiupdup(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fupdvp(i,:), fiupdvp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fupdhp(i,:), fiupdhp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fvpdup(i,:), fivpdup(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fvpdvp(i,:), fivpdvp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fvpdhp(i,:), fivpdhp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fhpdup(i,:), fihpdup(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fhpdvp(i,:), fihpdvp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fupvp(i,:), fiupvp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fuphp(i,:), fiuphp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
        call ffttp_1d( jnt, fvpvp(i,:), fivpvp(i,:), 'r', prim='o',  &
  &                    prim_fact=pfact,  &
  &                    omega_fix=omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                    omegan_fix=omega_nr(0:jnt-1,0:jnt-1) )
     end do
!$omp end do
!$omp end parallel

     !-- ѴˡѴ줿ڥȥ force سǼ

     do j=1,hnt+1
        do i=2,nr-1
           updup(i,j)=fiupdup(i,j)
           updvp(i,j)=fiupdvp(i,j)
           updhp(i,j)=fiupdhp(i,j)
           vpdup(i,j)=fivpdup(i,j)
           vpdvp(i,j)=fivpdvp(i,j)
           vpdhp(i,j)=fivpdhp(i,j)
           hpdup(i,j)=fihpdup(i,j)
           hpdvp(i,j)=fihpdvp(i,j)
           upvp(i,j)=fiupvp(i,j)
           uphp(i,j)=fiuphp(i,j)
           vpvp(i,j)=fivpvp(i,j)
        end do
     end do

  end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,hnt+1

!-- ƹ׻
   !-- ؤޤȤ
   !-- ΤȤ, j=1 ϼ¿ʬȿ, ʬȿ nt/2 ʤΤ,
   !-- Ѥ˽ʬ.
     if(force_flag(1:1)=='o')then  ! ή

        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    -ubdub(i)  &
  &                    -ubdup(i,j)  &
  &                    -updub(i,j)  &
  &                    -img*(real(j-1))*vbup(i,j)/rv(i)  !&
           forcev(i,j)=forcev(i,j)  &
  &                    -ubdvb(i)  &
  &                    -ubdvp(i,j)  &
  &                    -updvb(i,j)  &
  &                    -img*(real(j-1))*vbvp(i,j)/rv(i)  !&
           forceh(i,j)=forceh(i,j)  &
  &                    -ubdhb(i)  &
  &                    -ubdhp(i,j)  &
  &                    -updhb(i,j)  &
  &                    -img*(real(j-1))*vbhp(i,j)/rs(i)  !&
        end do
     end if

     if(force_flag(2:2)=='o')then  ! ꥪ
        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    +corilv(i,j)
           forcev(i,j)=forcev(i,j)  &
  &                    -corilu(i,j)
        end do
     end if

     if(force_flag(3:3)=='o')then  ! Ȼ
        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    -diff_t*(real(j-1))**2*ucp_old(i,j)/rv(i)/rv(i)  &
  &                    +diff_r*((ucp_old(i+1,j)+ucp_old(i-1,j)-2.0*ucp_old(i,j))  &
  &                    *(2.0/(rv(i+1)-rv(i-1)))**2  &
  &                    +ducpdr(i,j)/rv(i))
           forcev(i,j)=forcev(i,j)  &
  &                    -diff_t*(real(j-1))**2*vcp_old(i,j)/rv(i)/rv(i)  &
  &                    +diff_r*((vcp_old(i+1,j)+vcp_old(i-1,j)-2.0*vcp_old(i,j))  &
  &                    *(2.0/(rv(i+1)-rv(i-1)))**2  &
  &                    +dvcpdr(i,j)/rv(i))
           forceh(i,j)=forceh(i,j)  &
  &                    -diff_t*(real(j-1))**2*hcp_old(i,j)/rs(i)/rs(i)  &
  &                    +diff_r*((hcp_old(i+1,j)+hcp_old(i-1,j)-2.0*hcp_old(i,j))  &
  &                    *(2.0/(rs(i+1)-rs(i-1)))**2  &
  &                    +dhcpdr(i,j)/rs(i))
        end do
     end if
 
     if(force_flag(4:4)=='o')then  ! 쥤꡼ԥ󥰹

        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    +eup(i,j)
           forcev(i,j)=forcev(i,j)  &
  &                    +evp(i,j)
           forceh(i,j)=forceh(i,j)  &
  &                    +ehp(i,j)
        end do
     end if

     if(force_flag(5:5)=='o')then  ! ή

        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    -updup(i,j)  &
  &                    -vpdup(i,j)/rv(i)
           forcev(i,j)=forcev(i,j)  &
  &                    -updvp(i,j)  &
  &                    -vpdvp(i,j)/rv(i)
           forceh(i,j)=forceh(i,j)  &
  &                    -updhp(i,j)  &
  &                    -vpdhp(i,j)/rs(i)
        end do
     end if

     if(force_flag(6:6)=='o')then  ! Ϲ

        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    +2.0*vbvp(i,j)/rv(i)  &
  &                    +vpvp(i,j)/rv(i)
           forcev(i,j)=forcev(i,j)  &
  &                    -ub(i)*vb(i)/rv(i)  &
  &                    -vbup(i,j)/rv(i)  &
  &                    -ubvp(i,j)/rv(i)  &
  &                    -upvp(i,j)/rv(i)
        end do
     end if

     if(force_flag(7:7)=='o')then  ! Ϣ³μȯ

        do i=2,nr-1
           forceh(i,j)=forceh(i,j)  &
  &                    -hbdub(i)  &
  &                    -hb(i)*ub(i)/rs(i)  &
  &                    -hbdup(i,j)  &
  &                    -hpdub(i,j)  &
  &                    -(hbup(i,j)+ubhp(i,j))/rs(i)  &
  &                    -img*(real(j-1))*hbvp(i,j)/rs(i)  &
  &                    -hpdup(i,j)  &
  &                    -uphp(i,j)/rs(i)  &
  &                    -hpdvp(i,j)/rs(i)
        end do
     end if

     if(force_flag(8:8)=='o')then  ! Ϸٹ
        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    -(dhcpdr(i,j))
           forcev(i,j)=forcev(i,j)  &
  &                    -img*(real(j-1))*hcp_old(i,j)/rs(i)
        end do
     end if

  end do

!$omp end do
!$omp end parallel

end subroutine

end module
