program thermo  ! thermo طδؿǧ
  use Thermo_Function
  implicit none
  integer, parameter :: dl=2
  real :: temp, pres, rh, rho, es, qv, tmpv, pt, sh, tv, ptv

  write(*,*) "pressure [hPa]"
  read(*,*) pres
  write(*,*) "temperature [K]"
  read(*,*) temp
  write(*,*) "Relative Humidity [%]"
  read(*,*) rh

  pres=pres*100.0
  es=RHT_2_e(rh,temp,dl=dl)
  qv=eP_2_qv(es,pres,dl=dl)
  rho=TP_2_rho(temp,pres,dl=dl)
  pt=theta_dry(temp,pres,dl=dl)
  sh=qv_2_sh(qv,dl=dl)

  tmpv=tetens(temp,dl=dl)
  tmpv=goff_gratch(temp,dl=dl)
  tmpv=goff_gratch_i(temp,dl=dl)
  tmpv=es_Bolton(temp,dl=dl)
  tmpv=es_TD(es,dl=dl)
  tmpv=LH(temp,dl=dl)
  tmpv=eP_2_qv(es,pres,dl=dl)
  tmpv=eP_2_sh(es,pres,dl=dl)
  tmpv=TP_2_qvs(temp,pres,dl=dl)
  tmpv=TP_2_shs(temp,pres,dl=dl)
  tmpv=qvP_2_e(qv,pres,dl=dl)
  tmpv=theta_dry(temp,pres,dl=dl)
  tmpv=theta_moist(temp,pres,qv,dl=dl)
  tmpv=thetaP_2_T(temp,pres,dl=dl)
  tmpv=thetaT_2_P(pt,temp,dl=dl)
  tmpv=TqvP_2_TLCL(temp,qv,pres,dl=dl)
  tmpv=thetae_Bolton(temp,qv,pres,dl=dl)
  tmpv=thetaes_Bolton(temp,pres,dl=dl)
  tmpv=TqvP_2_thetae(temp,qv,pres,dl=dl)
  tmpv=TqvP_2_thetaes(temp,pres,dl=dl)
  tmpv=RHT_2_e(rh,temp,dl=dl)
  tmpv=eT_2_RH(es,temp,dl=dl)
  tmpv=RHTP_2_qv(rh,temp,pres,dl=dl)
  tmpv=qvTP_2_RH(qv,temp,pres,dl=dl)
  tv=qvT_2_Tv(qv,temp,dl=dl)
  tmpv=qvTv_2_T(qv,tv,dl=dl)
  tmpv=TvT_2_qv(tv,temp,dl=dl)
  ptv=TqvP_2_thetav(temp,qv,pres,dl=dl)
  tmpv=thetavqvP_2_T(ptv,qv,pres,dl=dl)
  tmpv=TthetavP_2_qv(temp,ptv,pres,dl=dl)
  tmpv=exner_func_dry(pres,dl=dl)
  tmpv=hypsometric_form(pres, 0.0, temp, 100.0,dl=dl)
  tmpv=z_hypsometric_form(pres, 0.0, temp, 900.0e2,dl=dl)
  tmpv=rhoT_2_P(rho,temp,dl=dl)
  tmpv=rhoP_2_T(rho,pres,dl=dl)
  tmpv=TP_2_rho(temp,pres,dl=dl)
  tmpv=get_gamma_d(dl)
  tmpv=sh_2_qv(qv,dl=dl)
  tmpv=Cefp(qv,dl=dl)
  tmpv=Cl(temp,dl=dl)
  tmpv=Tq_2_Trho(temp,qv,dl=dl)
  tmpv=esi_Emanuel(temp,dl=dl)
  tmpv=thetae_Emanuel(temp,qv,pres,dl=dl)
  tmpv=thetaw_Emanuel(temp,qv,pres,dl=dl)
  tmpv=moist_laps_temp(pres,temp,pres-10000.0,dl=dl)

end program
