program Thorpe
  use gtool_history
  use Ellip_Slv
  use Derivation
  use geometry

  implicit none
  integer :: i, j
  integer :: nx, ny
  integer, parameter :: nl=200  ! سβ
  real :: dx, dy
  real, parameter :: xc=0.5, yc=0.5  ! 濴
  real, parameter :: sr=0.1  ! Ⱦ
  real, allocatable :: x(:), y(:)
  real, allocatable :: rho(:,:)
  real, allocatable :: psi(:,:), pt0(:,:), dpsi(:,:), vg(:,:)
  integer :: method
  character(4) :: tp
  real, parameter :: ptmin=280.0, ptmax=380.0
  real :: xd(nl,1), yd(nl,1)

 namelist /input /nx,ny,tp,method
 read(5,input)

  allocate(x(nx))
  allocate(y(ny))
  allocate(psi(nx,ny))
  allocate(rho(nx,ny))
  allocate(pt0(nx,ny))
  allocate(dpsi(nx,ny))
  allocate(vg(nx,ny))

!-- ʻֳ֤
  dx=1.0/real(nx-1)
  dy=1.0/real(ny-1)

!-- ɸѿ

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)

!-- ܾ첹̤

  do j=1,ny
     do i=1,nx
        pt0(i,j)=ptmin+(ptmax-ptmin)/(y(ny)-y(1))*y(j)
     end do
  end do

!-- Υޥ꡼γԤس

  call product_circle( xc, yc, sr, nl, xd(:,1), yd(:,1) )

  open(unit=10,file='Thorpe.dat',status='unknown')
     do i=1,nl
        write(10,*) xd(i,1), yd(i,1)
     end do
  close(unit=10,status='keep')

!-- Υޥ꡼

  rho=0.0
  do i=1,nx
     do j=1,ny
!        rho(i,j)=(2.0e4/8.85)*exp(-((x(i)-xc)**2+(y(j)-yc)**2)/sr/sr)
        if(((x(i)-xc)**2+(y(j)-yc)**2)<sr*sr)then
           rho(i,j)=2.0e4/8.85
        end if
     end do
  end do
 
!-- ݥ᥽åɤ

  select case (method)
  case(1)
     call Ellip_GauSei_2d(x,y,rho,1.0e-6,tp,psi)
  case(2)
     call Ellip_Jacobi_2d(x,y,rho,1.0e-6,tp,psi)
  end select

!-- ݥƥ󥷥륢Υޥ꡼Ϲη׻

  do j=1,ny
     call grad_1d( x, psi(:,j), vg(:,j) )
     do i=1,nx
        vg(i,j)=vg(i,j)*0.25
     end do
  end do

!-- ݥƥ󥷥륢Υޥ꡼αľۤ򲹰̤δܾ­碌

  do i=1,nx
     call grad_1d( y, psi(i,:), dpsi(i,:) )
     do j=1,ny
        pt0(i,j)=pt0(i,j)+0.1*dpsi(i,j)
     end do
  end do

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='Thorpe.nc', title='Thorpe model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','z'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Z-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )

  call HistoryPut( 'x', x )                            ! ѿ
  call HistoryPut( 'z', y )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='SF', dims=(/'x','z'/), &
    & longname='stream function', units='1', xtype='float')

  call HistoryPut('SF',psi)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='pt', dims=(/'x','z'/), &
    & longname='potential temperature', units='K', xtype='float')

  call HistoryPut('pt',pt0)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='Vg', dims=(/'x','z'/), &
    & longname='geostrophic V', units='m/s', xtype='float')

  call HistoryPut('Vg',vg)                         ! ѿ
  call HistoryClose

end program
