program advection_non
  use ffts
  use Math_Const
  use Algebra
  use gtool_history
  implicit none
  integer :: nx  ! x ȿ
  real :: dt  ! ׻ֳִ
  integer :: nt  ! ׻ƥå׿
  real :: xmin  ! x ɸü
  real :: dx  ! x ɸʻҴֳ
  integer :: j, k, l, m, n
  real, allocatable, dimension(:) :: x  ! x ɸ
  real, allocatable, dimension(:) :: y  ! 顼ѿ
  complex, allocatable, dimension(:) :: fx  ! y ѿѴ
  complex, allocatable, dimension(:) :: fm1  ! ڥȥ
  complex, allocatable, dimension(:) :: fm2  ! ڥȥ
  complex, allocatable, dimension(:) :: fm_tmp  ! ׽
  complex, parameter :: i=(0.0,1.0)

  namelist /input /nx,dt,nt,xmin,dx
  read(5,input)

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

  allocate(x(0:2*nx))
  allocate(y(0:2*nx))
  allocate(fm1(0:2*nx))
  allocate(fm2(0:2*nx))
  allocate(fm_tmp(0:2*nx))

  x=(/((xmin+dx*real(j)),j=0,2*nx)/)

  do j=0,2*nx
     y(j)=sin(x(j))
!     y(j)=exp(-(x(j)-0.5*real(2*nx+1)*dx)**2)
     fm_tmp(j)=y(j)
  end do

  call ffttp_1d( 2*nx+1, fm_tmp, fm1, 'r', 'o' )

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='advection_non.nc', title='spectral advecting model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/2*nx+1,0/),               &
    & longnames=(/'X-coordinate','Z-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=real(nt*dt) )

  call HistoryPut( 'x', x )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='amp', dims=(/'x','t'/), &
    & longname='amplitude', units='1', xtype='float')

  call HistoryPut('amp',y)                         ! ѿ

!-- ʬ
  do j=1,nt
!-- CR ˡǻʬ
     fm2(0)=fm1(0)
     do k=1,nx
        fm2(k)=((1.0-0.25*(dt*real(k))**2-i*dt*real(k))/  &
  &            (1.0+0.25*(dt*real(k))**2))*fm1(k)
        fm1(k)=fm2(k)  ! ƥåפϤ
        fm2(nx+k)=conjg(fm2(nx-k+1))  ! ׻פ˷̤Ϥ
     end do

     call ffttp_1d( 2*nx+1, fm2, fm_tmp, 'i', 'o' )

     do k=0,2*nx  ! ¿ؤѴ
        y(k)=real(fm_tmp(k))
     end do

     call HistoryPut( 'amp', y )                         ! ѿ

  end do

  call HistoryClose

end program
